/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RetrohuntName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE_RULE_RETROHUNT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;
    private final String rule;
    private final String retrohunt;

    @Deprecated
    protected RetrohuntName() {
        this.project = null;
        this.location = null;
        this.instance = null;
        this.rule = null;
        this.retrohunt = null;
    }

    private RetrohuntName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.rule = (String)Preconditions.checkNotNull((Object)builder.getRule());
        this.retrohunt = (String)Preconditions.checkNotNull((Object)builder.getRetrohunt());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getRule() {
        return this.rule;
    }

    public String getRetrohunt() {
        return this.retrohunt;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RetrohuntName of(String project, String location, String instance, String rule, String retrohunt) {
        return RetrohuntName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setRule(rule).setRetrohunt(retrohunt).build();
    }

    public static String format(String project, String location, String instance, String rule, String retrohunt) {
        return RetrohuntName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setRule(rule).setRetrohunt(retrohunt).build().toString();
    }

    public static RetrohuntName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE_RULE_RETROHUNT.validatedMatch(formattedString, "RetrohuntName.parse: formattedString not in valid format");
        return RetrohuntName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("rule"), (String)matchMap.get("retrohunt"));
    }

    public static List<RetrohuntName> parseList(List<String> formattedStrings) {
        ArrayList<RetrohuntName> list = new ArrayList<RetrohuntName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RetrohuntName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RetrohuntName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RetrohuntName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE_RULE_RETROHUNT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RetrohuntName retrohuntName = this;
            synchronized (retrohuntName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.rule != null) {
                        fieldMapBuilder.put((Object)"rule", (Object)this.rule);
                    }
                    if (this.retrohunt != null) {
                        fieldMapBuilder.put((Object)"retrohunt", (Object)this.retrohunt);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE_RULE_RETROHUNT.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance, "rule", this.rule, "retrohunt", this.retrohunt});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RetrohuntName that = (RetrohuntName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.rule, that.rule) && Objects.equals(this.retrohunt, that.retrohunt);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        h ^= Objects.hashCode(this.rule);
        h *= 1000003;
        return h ^= Objects.hashCode(this.retrohunt);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;
        private String rule;
        private String retrohunt;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getRule() {
            return this.rule;
        }

        public String getRetrohunt() {
            return this.retrohunt;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setRule(String rule) {
            this.rule = rule;
            return this;
        }

        public Builder setRetrohunt(String retrohunt) {
            this.retrohunt = retrohunt;
            return this;
        }

        private Builder(RetrohuntName retrohuntName) {
            this.project = retrohuntName.project;
            this.location = retrohuntName.location;
            this.instance = retrohuntName.instance;
            this.rule = retrohuntName.rule;
            this.retrohunt = retrohuntName.retrohunt;
        }

        public RetrohuntName build() {
            return new RetrohuntName(this);
        }
    }
}

