/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpaceReadStateName
implements ResourceName {
    private static final PathTemplate USER_SPACE = PathTemplate.createWithoutUrlEncoding((String)"users/{user}/spaces/{space}/spaceReadState");
    private volatile Map<String, String> fieldValuesMap;
    private final String user;
    private final String space;

    @Deprecated
    protected SpaceReadStateName() {
        this.user = null;
        this.space = null;
    }

    private SpaceReadStateName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
    }

    public String getUser() {
        return this.user;
    }

    public String getSpace() {
        return this.space;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SpaceReadStateName of(String user, String space) {
        return SpaceReadStateName.newBuilder().setUser(user).setSpace(space).build();
    }

    public static String format(String user, String space) {
        return SpaceReadStateName.newBuilder().setUser(user).setSpace(space).build().toString();
    }

    public static SpaceReadStateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = USER_SPACE.validatedMatch(formattedString, "SpaceReadStateName.parse: formattedString not in valid format");
        return SpaceReadStateName.of((String)matchMap.get("user"), (String)matchMap.get("space"));
    }

    public static List<SpaceReadStateName> parseList(List<String> formattedStrings) {
        ArrayList<SpaceReadStateName> list = new ArrayList<SpaceReadStateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpaceReadStateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpaceReadStateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpaceReadStateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return USER_SPACE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SpaceReadStateName spaceReadStateName = this;
            synchronized (spaceReadStateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return USER_SPACE.instantiate(new String[]{"user", this.user, "space", this.space});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SpaceReadStateName that = (SpaceReadStateName)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.space, that.space);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        return h ^= Objects.hashCode(this.space);
    }

    public static class Builder {
        private String user;
        private String space;

        protected Builder() {
        }

        public String getUser() {
            return this.user;
        }

        public String getSpace() {
            return this.space;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        private Builder(SpaceReadStateName spaceReadStateName) {
            this.user = spaceReadStateName.user;
            this.space = spaceReadStateName.space;
        }

        public SpaceReadStateName build() {
            return new SpaceReadStateName(this);
        }
    }
}

