/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/membership.proto

// Protobuf Java Version: 3.25.2
package com.google.chat.v1;

/** Protobuf type {@code google.chat.v1.CreateMembershipRequest} */
public final class CreateMembershipRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.CreateMembershipRequest)
    CreateMembershipRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateMembershipRequest.newBuilder() to construct.
  private CreateMembershipRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateMembershipRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateMembershipRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.MembershipProto
        .internal_static_google_chat_v1_CreateMembershipRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.MembershipProto
        .internal_static_google_chat_v1_CreateMembershipRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.CreateMembershipRequest.class,
            com.google.chat.v1.CreateMembershipRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the space for which to create the
   * membership.
   *
   * Format: spaces/{space}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the space for which to create the
   * membership.
   *
   * Format: spaces/{space}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MEMBERSHIP_FIELD_NUMBER = 2;
  private com.google.chat.v1.Membership membership_;
  /**
   *
   *
   * <pre>
   * Required. The membership relation to create.
   * The `memberType` field must contain a user with the `user.name` and
   * `user.type` fields populated. The server will assign a resource name
   * and overwrite anything specified.
   * When a Chat app creates a membership relation for a human user, it must use
   * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
   * `user.name` with format `users/{user}`, where `{user}` can be the email
   * address for the user. For users in the same Workspace organization `{user}`
   * can also be the `id` of the
   * [person](https://developers.google.com/people/api/rest/v1/people) from the
   * People API, or the `id` for the user in the Directory API. For example, if
   * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
   * can add the user to the space by setting the `membership.member.name` to
   * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
   * membership relation for itself, it must use the `chat.memberships.app`
   * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
   * </pre>
   *
   * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the membership field is set.
   */
  @java.lang.Override
  public boolean hasMembership() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The membership relation to create.
   * The `memberType` field must contain a user with the `user.name` and
   * `user.type` fields populated. The server will assign a resource name
   * and overwrite anything specified.
   * When a Chat app creates a membership relation for a human user, it must use
   * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
   * `user.name` with format `users/{user}`, where `{user}` can be the email
   * address for the user. For users in the same Workspace organization `{user}`
   * can also be the `id` of the
   * [person](https://developers.google.com/people/api/rest/v1/people) from the
   * People API, or the `id` for the user in the Directory API. For example, if
   * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
   * can add the user to the space by setting the `membership.member.name` to
   * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
   * membership relation for itself, it must use the `chat.memberships.app`
   * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
   * </pre>
   *
   * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The membership.
   */
  @java.lang.Override
  public com.google.chat.v1.Membership getMembership() {
    return membership_ == null ? com.google.chat.v1.Membership.getDefaultInstance() : membership_;
  }
  /**
   *
   *
   * <pre>
   * Required. The membership relation to create.
   * The `memberType` field must contain a user with the `user.name` and
   * `user.type` fields populated. The server will assign a resource name
   * and overwrite anything specified.
   * When a Chat app creates a membership relation for a human user, it must use
   * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
   * `user.name` with format `users/{user}`, where `{user}` can be the email
   * address for the user. For users in the same Workspace organization `{user}`
   * can also be the `id` of the
   * [person](https://developers.google.com/people/api/rest/v1/people) from the
   * People API, or the `id` for the user in the Directory API. For example, if
   * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
   * can add the user to the space by setting the `membership.member.name` to
   * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
   * membership relation for itself, it must use the `chat.memberships.app`
   * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
   * </pre>
   *
   * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipOrBuilder getMembershipOrBuilder() {
    return membership_ == null ? com.google.chat.v1.Membership.getDefaultInstance() : membership_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getMembership());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMembership());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.CreateMembershipRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.CreateMembershipRequest other =
        (com.google.chat.v1.CreateMembershipRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasMembership() != other.hasMembership()) return false;
    if (hasMembership()) {
      if (!getMembership().equals(other.getMembership())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasMembership()) {
      hash = (37 * hash) + MEMBERSHIP_FIELD_NUMBER;
      hash = (53 * hash) + getMembership().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.CreateMembershipRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.CreateMembershipRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.chat.v1.CreateMembershipRequest} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.CreateMembershipRequest)
      com.google.chat.v1.CreateMembershipRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_CreateMembershipRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_CreateMembershipRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.CreateMembershipRequest.class,
              com.google.chat.v1.CreateMembershipRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.CreateMembershipRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMembershipFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      membership_ = null;
      if (membershipBuilder_ != null) {
        membershipBuilder_.dispose();
        membershipBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.MembershipProto
          .internal_static_google_chat_v1_CreateMembershipRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.CreateMembershipRequest getDefaultInstanceForType() {
      return com.google.chat.v1.CreateMembershipRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.CreateMembershipRequest build() {
      com.google.chat.v1.CreateMembershipRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.CreateMembershipRequest buildPartial() {
      com.google.chat.v1.CreateMembershipRequest result =
          new com.google.chat.v1.CreateMembershipRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.CreateMembershipRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.membership_ = membershipBuilder_ == null ? membership_ : membershipBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.CreateMembershipRequest) {
        return mergeFrom((com.google.chat.v1.CreateMembershipRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.CreateMembershipRequest other) {
      if (other == com.google.chat.v1.CreateMembershipRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMembership()) {
        mergeMembership(other.getMembership());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMembershipFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to create the
     * membership.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to create the
     * membership.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to create the
     * membership.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to create the
     * membership.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the space for which to create the
     * membership.
     *
     * Format: spaces/{space}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.chat.v1.Membership membership_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Membership,
            com.google.chat.v1.Membership.Builder,
            com.google.chat.v1.MembershipOrBuilder>
        membershipBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the membership field is set.
     */
    public boolean hasMembership() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The membership.
     */
    public com.google.chat.v1.Membership getMembership() {
      if (membershipBuilder_ == null) {
        return membership_ == null
            ? com.google.chat.v1.Membership.getDefaultInstance()
            : membership_;
      } else {
        return membershipBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMembership(com.google.chat.v1.Membership value) {
      if (membershipBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        membership_ = value;
      } else {
        membershipBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMembership(com.google.chat.v1.Membership.Builder builderForValue) {
      if (membershipBuilder_ == null) {
        membership_ = builderForValue.build();
      } else {
        membershipBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeMembership(com.google.chat.v1.Membership value) {
      if (membershipBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && membership_ != null
            && membership_ != com.google.chat.v1.Membership.getDefaultInstance()) {
          getMembershipBuilder().mergeFrom(value);
        } else {
          membership_ = value;
        }
      } else {
        membershipBuilder_.mergeFrom(value);
      }
      if (membership_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMembership() {
      bitField0_ = (bitField0_ & ~0x00000002);
      membership_ = null;
      if (membershipBuilder_ != null) {
        membershipBuilder_.dispose();
        membershipBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.chat.v1.Membership.Builder getMembershipBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMembershipFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.chat.v1.MembershipOrBuilder getMembershipOrBuilder() {
      if (membershipBuilder_ != null) {
        return membershipBuilder_.getMessageOrBuilder();
      } else {
        return membership_ == null
            ? com.google.chat.v1.Membership.getDefaultInstance()
            : membership_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * </pre>
     *
     * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Membership,
            com.google.chat.v1.Membership.Builder,
            com.google.chat.v1.MembershipOrBuilder>
        getMembershipFieldBuilder() {
      if (membershipBuilder_ == null) {
        membershipBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Membership,
                com.google.chat.v1.Membership.Builder,
                com.google.chat.v1.MembershipOrBuilder>(
                getMembership(), getParentForChildren(), isClean());
        membership_ = null;
      }
      return membershipBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.CreateMembershipRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.CreateMembershipRequest)
  private static final com.google.chat.v1.CreateMembershipRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.CreateMembershipRequest();
  }

  public static com.google.chat.v1.CreateMembershipRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateMembershipRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateMembershipRequest>() {
        @java.lang.Override
        public CreateMembershipRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateMembershipRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateMembershipRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.CreateMembershipRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
