/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/attachment.proto

// Protobuf Java Version: 3.25.2
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * An attachment in Google Chat.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.Attachment}
 */
public final class Attachment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.Attachment)
    AttachmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Attachment.newBuilder() to construct.
  private Attachment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Attachment() {
    name_ = "";
    contentName_ = "";
    contentType_ = "";
    thumbnailUri_ = "";
    downloadUri_ = "";
    source_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Attachment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.AttachmentProto.internal_static_google_chat_v1_Attachment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.AttachmentProto
        .internal_static_google_chat_v1_Attachment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.Attachment.class, com.google.chat.v1.Attachment.Builder.class);
  }

  /** Protobuf enum {@code google.chat.v1.Attachment.Source} */
  public enum Source implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>SOURCE_UNSPECIFIED = 0;</code> */
    SOURCE_UNSPECIFIED(0),
    /** <code>DRIVE_FILE = 1;</code> */
    DRIVE_FILE(1),
    /** <code>UPLOADED_CONTENT = 2;</code> */
    UPLOADED_CONTENT(2),
    UNRECOGNIZED(-1),
    ;

    /** <code>SOURCE_UNSPECIFIED = 0;</code> */
    public static final int SOURCE_UNSPECIFIED_VALUE = 0;
    /** <code>DRIVE_FILE = 1;</code> */
    public static final int DRIVE_FILE_VALUE = 1;
    /** <code>UPLOADED_CONTENT = 2;</code> */
    public static final int UPLOADED_CONTENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Source valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Source forNumber(int value) {
      switch (value) {
        case 0:
          return SOURCE_UNSPECIFIED;
        case 1:
          return DRIVE_FILE;
        case 2:
          return UPLOADED_CONTENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Source> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Source> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Source>() {
          public Source findValueByNumber(int number) {
            return Source.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.Attachment.getDescriptor().getEnumTypes().get(0);
    }

    private static final Source[] VALUES = values();

    public static Source valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Source(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.Attachment.Source)
  }

  private int dataRefCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dataRef_;

  public enum DataRefCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ATTACHMENT_DATA_REF(4),
    DRIVE_DATA_REF(7),
    DATAREF_NOT_SET(0);
    private final int value;

    private DataRefCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataRefCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataRefCase forNumber(int value) {
      switch (value) {
        case 4:
          return ATTACHMENT_DATA_REF;
        case 7:
          return DRIVE_DATA_REF;
        case 0:
          return DATAREF_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataRefCase getDataRefCase() {
    return DataRefCase.forNumber(dataRefCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of the attachment, in the form
   * `spaces/&#42;&#47;messages/&#42;&#47;attachments/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of the attachment, in the form
   * `spaces/&#42;&#47;messages/&#42;&#47;attachments/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object contentName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The original file name for the content, not the full path.
   * </pre>
   *
   * <code>string content_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The contentName.
   */
  @java.lang.Override
  public java.lang.String getContentName() {
    java.lang.Object ref = contentName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      contentName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The original file name for the content, not the full path.
   * </pre>
   *
   * <code>string content_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for contentName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentNameBytes() {
    java.lang.Object ref = contentName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      contentName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object contentType_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The content type (MIME type) of the file.
   * </pre>
   *
   * <code>string content_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The contentType.
   */
  @java.lang.Override
  public java.lang.String getContentType() {
    java.lang.Object ref = contentType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      contentType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The content type (MIME type) of the file.
   * </pre>
   *
   * <code>string content_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for contentType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentTypeBytes() {
    java.lang.Object ref = contentType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      contentType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTACHMENT_DATA_REF_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A reference to the attachment data. This field is used with the media API
   * to download the attachment data.
   * </pre>
   *
   * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
   *
   * @return Whether the attachmentDataRef field is set.
   */
  @java.lang.Override
  public boolean hasAttachmentDataRef() {
    return dataRefCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A reference to the attachment data. This field is used with the media API
   * to download the attachment data.
   * </pre>
   *
   * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
   *
   * @return The attachmentDataRef.
   */
  @java.lang.Override
  public com.google.chat.v1.AttachmentDataRef getAttachmentDataRef() {
    if (dataRefCase_ == 4) {
      return (com.google.chat.v1.AttachmentDataRef) dataRef_;
    }
    return com.google.chat.v1.AttachmentDataRef.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A reference to the attachment data. This field is used with the media API
   * to download the attachment data.
   * </pre>
   *
   * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
   */
  @java.lang.Override
  public com.google.chat.v1.AttachmentDataRefOrBuilder getAttachmentDataRefOrBuilder() {
    if (dataRefCase_ == 4) {
      return (com.google.chat.v1.AttachmentDataRef) dataRef_;
    }
    return com.google.chat.v1.AttachmentDataRef.getDefaultInstance();
  }

  public static final int DRIVE_DATA_REF_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Output only. A reference to the Google Drive attachment. This field is
   * used with the Google Drive API.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the driveDataRef field is set.
   */
  @java.lang.Override
  public boolean hasDriveDataRef() {
    return dataRefCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Output only. A reference to the Google Drive attachment. This field is
   * used with the Google Drive API.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The driveDataRef.
   */
  @java.lang.Override
  public com.google.chat.v1.DriveDataRef getDriveDataRef() {
    if (dataRefCase_ == 7) {
      return (com.google.chat.v1.DriveDataRef) dataRef_;
    }
    return com.google.chat.v1.DriveDataRef.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A reference to the Google Drive attachment. This field is
   * used with the Google Drive API.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.DriveDataRefOrBuilder getDriveDataRefOrBuilder() {
    if (dataRefCase_ == 7) {
      return (com.google.chat.v1.DriveDataRef) dataRef_;
    }
    return com.google.chat.v1.DriveDataRef.getDefaultInstance();
  }

  public static final int THUMBNAIL_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object thumbnailUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The thumbnail URL which should be used to preview the
   * attachment to a human user. Chat apps shouldn't use this URL to download
   * attachment content.
   * </pre>
   *
   * <code>string thumbnail_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The thumbnailUri.
   */
  @java.lang.Override
  public java.lang.String getThumbnailUri() {
    java.lang.Object ref = thumbnailUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      thumbnailUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The thumbnail URL which should be used to preview the
   * attachment to a human user. Chat apps shouldn't use this URL to download
   * attachment content.
   * </pre>
   *
   * <code>string thumbnail_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for thumbnailUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getThumbnailUriBytes() {
    java.lang.Object ref = thumbnailUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      thumbnailUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOWNLOAD_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object downloadUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The download URL which should be used to allow a human user to
   * download the attachment. Chat apps shouldn't use this URL to download
   * attachment content.
   * </pre>
   *
   * <code>string download_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The downloadUri.
   */
  @java.lang.Override
  public java.lang.String getDownloadUri() {
    java.lang.Object ref = downloadUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      downloadUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The download URL which should be used to allow a human user to
   * download the attachment. Chat apps shouldn't use this URL to download
   * attachment content.
   * </pre>
   *
   * <code>string download_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for downloadUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDownloadUriBytes() {
    java.lang.Object ref = downloadUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      downloadUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 9;
  private int source_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The source of the attachment.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Attachment.Source source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for source.
   */
  @java.lang.Override
  public int getSourceValue() {
    return source_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source of the attachment.
   * </pre>
   *
   * <code>
   * .google.chat.v1.Attachment.Source source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.chat.v1.Attachment.Source getSource() {
    com.google.chat.v1.Attachment.Source result =
        com.google.chat.v1.Attachment.Source.forNumber(source_);
    return result == null ? com.google.chat.v1.Attachment.Source.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, contentName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, contentType_);
    }
    if (dataRefCase_ == 4) {
      output.writeMessage(4, (com.google.chat.v1.AttachmentDataRef) dataRef_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(thumbnailUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, thumbnailUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(downloadUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, downloadUri_);
    }
    if (dataRefCase_ == 7) {
      output.writeMessage(7, (com.google.chat.v1.DriveDataRef) dataRef_);
    }
    if (source_ != com.google.chat.v1.Attachment.Source.SOURCE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, contentName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, contentType_);
    }
    if (dataRefCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.chat.v1.AttachmentDataRef) dataRef_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(thumbnailUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, thumbnailUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(downloadUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, downloadUri_);
    }
    if (dataRefCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.chat.v1.DriveDataRef) dataRef_);
    }
    if (source_ != com.google.chat.v1.Attachment.Source.SOURCE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.Attachment)) {
      return super.equals(obj);
    }
    com.google.chat.v1.Attachment other = (com.google.chat.v1.Attachment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getContentName().equals(other.getContentName())) return false;
    if (!getContentType().equals(other.getContentType())) return false;
    if (!getThumbnailUri().equals(other.getThumbnailUri())) return false;
    if (!getDownloadUri().equals(other.getDownloadUri())) return false;
    if (source_ != other.source_) return false;
    if (!getDataRefCase().equals(other.getDataRefCase())) return false;
    switch (dataRefCase_) {
      case 4:
        if (!getAttachmentDataRef().equals(other.getAttachmentDataRef())) return false;
        break;
      case 7:
        if (!getDriveDataRef().equals(other.getDriveDataRef())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CONTENT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getContentName().hashCode();
    hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getContentType().hashCode();
    hash = (37 * hash) + THUMBNAIL_URI_FIELD_NUMBER;
    hash = (53 * hash) + getThumbnailUri().hashCode();
    hash = (37 * hash) + DOWNLOAD_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDownloadUri().hashCode();
    hash = (37 * hash) + SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + source_;
    switch (dataRefCase_) {
      case 4:
        hash = (37 * hash) + ATTACHMENT_DATA_REF_FIELD_NUMBER;
        hash = (53 * hash) + getAttachmentDataRef().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DRIVE_DATA_REF_FIELD_NUMBER;
        hash = (53 * hash) + getDriveDataRef().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.Attachment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Attachment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Attachment parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Attachment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Attachment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.Attachment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.Attachment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Attachment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Attachment parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Attachment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.Attachment parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.Attachment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.Attachment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An attachment in Google Chat.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.Attachment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.Attachment)
      com.google.chat.v1.AttachmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.AttachmentProto
          .internal_static_google_chat_v1_Attachment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.AttachmentProto
          .internal_static_google_chat_v1_Attachment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.Attachment.class, com.google.chat.v1.Attachment.Builder.class);
    }

    // Construct using com.google.chat.v1.Attachment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      contentName_ = "";
      contentType_ = "";
      if (attachmentDataRefBuilder_ != null) {
        attachmentDataRefBuilder_.clear();
      }
      if (driveDataRefBuilder_ != null) {
        driveDataRefBuilder_.clear();
      }
      thumbnailUri_ = "";
      downloadUri_ = "";
      source_ = 0;
      dataRefCase_ = 0;
      dataRef_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.AttachmentProto
          .internal_static_google_chat_v1_Attachment_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.Attachment getDefaultInstanceForType() {
      return com.google.chat.v1.Attachment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.Attachment build() {
      com.google.chat.v1.Attachment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.Attachment buildPartial() {
      com.google.chat.v1.Attachment result = new com.google.chat.v1.Attachment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.Attachment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.contentName_ = contentName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.contentType_ = contentType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.thumbnailUri_ = thumbnailUri_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.downloadUri_ = downloadUri_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.source_ = source_;
      }
    }

    private void buildPartialOneofs(com.google.chat.v1.Attachment result) {
      result.dataRefCase_ = dataRefCase_;
      result.dataRef_ = this.dataRef_;
      if (dataRefCase_ == 4 && attachmentDataRefBuilder_ != null) {
        result.dataRef_ = attachmentDataRefBuilder_.build();
      }
      if (dataRefCase_ == 7 && driveDataRefBuilder_ != null) {
        result.dataRef_ = driveDataRefBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.Attachment) {
        return mergeFrom((com.google.chat.v1.Attachment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.Attachment other) {
      if (other == com.google.chat.v1.Attachment.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getContentName().isEmpty()) {
        contentName_ = other.contentName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getContentType().isEmpty()) {
        contentType_ = other.contentType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getThumbnailUri().isEmpty()) {
        thumbnailUri_ = other.thumbnailUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDownloadUri().isEmpty()) {
        downloadUri_ = other.downloadUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.source_ != 0) {
        setSourceValue(other.getSourceValue());
      }
      switch (other.getDataRefCase()) {
        case ATTACHMENT_DATA_REF:
          {
            mergeAttachmentDataRef(other.getAttachmentDataRef());
            break;
          }
        case DRIVE_DATA_REF:
          {
            mergeDriveDataRef(other.getDriveDataRef());
            break;
          }
        case DATAREF_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                contentName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                contentType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getAttachmentDataRefFieldBuilder().getBuilder(), extensionRegistry);
                dataRefCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                thumbnailUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                downloadUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDriveDataRefFieldBuilder().getBuilder(), extensionRegistry);
                dataRefCase_ = 7;
                break;
              } // case 58
            case 72:
              {
                source_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataRefCase_ = 0;
    private java.lang.Object dataRef_;

    public DataRefCase getDataRefCase() {
      return DataRefCase.forNumber(dataRefCase_);
    }

    public Builder clearDataRef() {
      dataRefCase_ = 0;
      dataRef_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of the attachment, in the form
     * `spaces/&#42;&#47;messages/&#42;&#47;attachments/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the attachment, in the form
     * `spaces/&#42;&#47;messages/&#42;&#47;attachments/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the attachment, in the form
     * `spaces/&#42;&#47;messages/&#42;&#47;attachments/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the attachment, in the form
     * `spaces/&#42;&#47;messages/&#42;&#47;attachments/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the attachment, in the form
     * `spaces/&#42;&#47;messages/&#42;&#47;attachments/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object contentName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The original file name for the content, not the full path.
     * </pre>
     *
     * <code>string content_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The contentName.
     */
    public java.lang.String getContentName() {
      java.lang.Object ref = contentName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contentName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original file name for the content, not the full path.
     * </pre>
     *
     * <code>string content_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for contentName.
     */
    public com.google.protobuf.ByteString getContentNameBytes() {
      java.lang.Object ref = contentName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contentName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original file name for the content, not the full path.
     * </pre>
     *
     * <code>string content_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The contentName to set.
     * @return This builder for chaining.
     */
    public Builder setContentName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      contentName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original file name for the content, not the full path.
     * </pre>
     *
     * <code>string content_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentName() {
      contentName_ = getDefaultInstance().getContentName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original file name for the content, not the full path.
     * </pre>
     *
     * <code>string content_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for contentName to set.
     * @return This builder for chaining.
     */
    public Builder setContentNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      contentName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object contentType_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The content type (MIME type) of the file.
     * </pre>
     *
     * <code>string content_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The contentType.
     */
    public java.lang.String getContentType() {
      java.lang.Object ref = contentType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contentType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The content type (MIME type) of the file.
     * </pre>
     *
     * <code>string content_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for contentType.
     */
    public com.google.protobuf.ByteString getContentTypeBytes() {
      java.lang.Object ref = contentType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contentType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The content type (MIME type) of the file.
     * </pre>
     *
     * <code>string content_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The contentType to set.
     * @return This builder for chaining.
     */
    public Builder setContentType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      contentType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The content type (MIME type) of the file.
     * </pre>
     *
     * <code>string content_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentType() {
      contentType_ = getDefaultInstance().getContentType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The content type (MIME type) of the file.
     * </pre>
     *
     * <code>string content_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for contentType to set.
     * @return This builder for chaining.
     */
    public Builder setContentTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      contentType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.AttachmentDataRef,
            com.google.chat.v1.AttachmentDataRef.Builder,
            com.google.chat.v1.AttachmentDataRefOrBuilder>
        attachmentDataRefBuilder_;
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     *
     * @return Whether the attachmentDataRef field is set.
     */
    @java.lang.Override
    public boolean hasAttachmentDataRef() {
      return dataRefCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     *
     * @return The attachmentDataRef.
     */
    @java.lang.Override
    public com.google.chat.v1.AttachmentDataRef getAttachmentDataRef() {
      if (attachmentDataRefBuilder_ == null) {
        if (dataRefCase_ == 4) {
          return (com.google.chat.v1.AttachmentDataRef) dataRef_;
        }
        return com.google.chat.v1.AttachmentDataRef.getDefaultInstance();
      } else {
        if (dataRefCase_ == 4) {
          return attachmentDataRefBuilder_.getMessage();
        }
        return com.google.chat.v1.AttachmentDataRef.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     */
    public Builder setAttachmentDataRef(com.google.chat.v1.AttachmentDataRef value) {
      if (attachmentDataRefBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataRef_ = value;
        onChanged();
      } else {
        attachmentDataRefBuilder_.setMessage(value);
      }
      dataRefCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     */
    public Builder setAttachmentDataRef(
        com.google.chat.v1.AttachmentDataRef.Builder builderForValue) {
      if (attachmentDataRefBuilder_ == null) {
        dataRef_ = builderForValue.build();
        onChanged();
      } else {
        attachmentDataRefBuilder_.setMessage(builderForValue.build());
      }
      dataRefCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     */
    public Builder mergeAttachmentDataRef(com.google.chat.v1.AttachmentDataRef value) {
      if (attachmentDataRefBuilder_ == null) {
        if (dataRefCase_ == 4
            && dataRef_ != com.google.chat.v1.AttachmentDataRef.getDefaultInstance()) {
          dataRef_ =
              com.google.chat.v1.AttachmentDataRef.newBuilder(
                      (com.google.chat.v1.AttachmentDataRef) dataRef_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataRef_ = value;
        }
        onChanged();
      } else {
        if (dataRefCase_ == 4) {
          attachmentDataRefBuilder_.mergeFrom(value);
        } else {
          attachmentDataRefBuilder_.setMessage(value);
        }
      }
      dataRefCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     */
    public Builder clearAttachmentDataRef() {
      if (attachmentDataRefBuilder_ == null) {
        if (dataRefCase_ == 4) {
          dataRefCase_ = 0;
          dataRef_ = null;
          onChanged();
        }
      } else {
        if (dataRefCase_ == 4) {
          dataRefCase_ = 0;
          dataRef_ = null;
        }
        attachmentDataRefBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     */
    public com.google.chat.v1.AttachmentDataRef.Builder getAttachmentDataRefBuilder() {
      return getAttachmentDataRefFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.AttachmentDataRefOrBuilder getAttachmentDataRefOrBuilder() {
      if ((dataRefCase_ == 4) && (attachmentDataRefBuilder_ != null)) {
        return attachmentDataRefBuilder_.getMessageOrBuilder();
      } else {
        if (dataRefCase_ == 4) {
          return (com.google.chat.v1.AttachmentDataRef) dataRef_;
        }
        return com.google.chat.v1.AttachmentDataRef.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to the attachment data. This field is used with the media API
     * to download the attachment data.
     * </pre>
     *
     * <code>.google.chat.v1.AttachmentDataRef attachment_data_ref = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.AttachmentDataRef,
            com.google.chat.v1.AttachmentDataRef.Builder,
            com.google.chat.v1.AttachmentDataRefOrBuilder>
        getAttachmentDataRefFieldBuilder() {
      if (attachmentDataRefBuilder_ == null) {
        if (!(dataRefCase_ == 4)) {
          dataRef_ = com.google.chat.v1.AttachmentDataRef.getDefaultInstance();
        }
        attachmentDataRefBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.AttachmentDataRef,
                com.google.chat.v1.AttachmentDataRef.Builder,
                com.google.chat.v1.AttachmentDataRefOrBuilder>(
                (com.google.chat.v1.AttachmentDataRef) dataRef_, getParentForChildren(), isClean());
        dataRef_ = null;
      }
      dataRefCase_ = 4;
      onChanged();
      return attachmentDataRefBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DriveDataRef,
            com.google.chat.v1.DriveDataRef.Builder,
            com.google.chat.v1.DriveDataRefOrBuilder>
        driveDataRefBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the driveDataRef field is set.
     */
    @java.lang.Override
    public boolean hasDriveDataRef() {
      return dataRefCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The driveDataRef.
     */
    @java.lang.Override
    public com.google.chat.v1.DriveDataRef getDriveDataRef() {
      if (driveDataRefBuilder_ == null) {
        if (dataRefCase_ == 7) {
          return (com.google.chat.v1.DriveDataRef) dataRef_;
        }
        return com.google.chat.v1.DriveDataRef.getDefaultInstance();
      } else {
        if (dataRefCase_ == 7) {
          return driveDataRefBuilder_.getMessage();
        }
        return com.google.chat.v1.DriveDataRef.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDriveDataRef(com.google.chat.v1.DriveDataRef value) {
      if (driveDataRefBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataRef_ = value;
        onChanged();
      } else {
        driveDataRefBuilder_.setMessage(value);
      }
      dataRefCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDriveDataRef(com.google.chat.v1.DriveDataRef.Builder builderForValue) {
      if (driveDataRefBuilder_ == null) {
        dataRef_ = builderForValue.build();
        onChanged();
      } else {
        driveDataRefBuilder_.setMessage(builderForValue.build());
      }
      dataRefCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDriveDataRef(com.google.chat.v1.DriveDataRef value) {
      if (driveDataRefBuilder_ == null) {
        if (dataRefCase_ == 7 && dataRef_ != com.google.chat.v1.DriveDataRef.getDefaultInstance()) {
          dataRef_ =
              com.google.chat.v1.DriveDataRef.newBuilder((com.google.chat.v1.DriveDataRef) dataRef_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataRef_ = value;
        }
        onChanged();
      } else {
        if (dataRefCase_ == 7) {
          driveDataRefBuilder_.mergeFrom(value);
        } else {
          driveDataRefBuilder_.setMessage(value);
        }
      }
      dataRefCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDriveDataRef() {
      if (driveDataRefBuilder_ == null) {
        if (dataRefCase_ == 7) {
          dataRefCase_ = 0;
          dataRef_ = null;
          onChanged();
        }
      } else {
        if (dataRefCase_ == 7) {
          dataRefCase_ = 0;
          dataRef_ = null;
        }
        driveDataRefBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.DriveDataRef.Builder getDriveDataRefBuilder() {
      return getDriveDataRefFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.chat.v1.DriveDataRefOrBuilder getDriveDataRefOrBuilder() {
      if ((dataRefCase_ == 7) && (driveDataRefBuilder_ != null)) {
        return driveDataRefBuilder_.getMessageOrBuilder();
      } else {
        if (dataRefCase_ == 7) {
          return (com.google.chat.v1.DriveDataRef) dataRef_;
        }
        return com.google.chat.v1.DriveDataRef.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to the Google Drive attachment. This field is
     * used with the Google Drive API.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DriveDataRef drive_data_ref = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DriveDataRef,
            com.google.chat.v1.DriveDataRef.Builder,
            com.google.chat.v1.DriveDataRefOrBuilder>
        getDriveDataRefFieldBuilder() {
      if (driveDataRefBuilder_ == null) {
        if (!(dataRefCase_ == 7)) {
          dataRef_ = com.google.chat.v1.DriveDataRef.getDefaultInstance();
        }
        driveDataRefBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.DriveDataRef,
                com.google.chat.v1.DriveDataRef.Builder,
                com.google.chat.v1.DriveDataRefOrBuilder>(
                (com.google.chat.v1.DriveDataRef) dataRef_, getParentForChildren(), isClean());
        dataRef_ = null;
      }
      dataRefCase_ = 7;
      onChanged();
      return driveDataRefBuilder_;
    }

    private java.lang.Object thumbnailUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The thumbnail URL which should be used to preview the
     * attachment to a human user. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string thumbnail_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The thumbnailUri.
     */
    public java.lang.String getThumbnailUri() {
      java.lang.Object ref = thumbnailUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        thumbnailUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The thumbnail URL which should be used to preview the
     * attachment to a human user. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string thumbnail_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for thumbnailUri.
     */
    public com.google.protobuf.ByteString getThumbnailUriBytes() {
      java.lang.Object ref = thumbnailUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        thumbnailUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The thumbnail URL which should be used to preview the
     * attachment to a human user. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string thumbnail_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The thumbnailUri to set.
     * @return This builder for chaining.
     */
    public Builder setThumbnailUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      thumbnailUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The thumbnail URL which should be used to preview the
     * attachment to a human user. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string thumbnail_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearThumbnailUri() {
      thumbnailUri_ = getDefaultInstance().getThumbnailUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The thumbnail URL which should be used to preview the
     * attachment to a human user. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string thumbnail_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for thumbnailUri to set.
     * @return This builder for chaining.
     */
    public Builder setThumbnailUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      thumbnailUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object downloadUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The download URL which should be used to allow a human user to
     * download the attachment. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string download_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The downloadUri.
     */
    public java.lang.String getDownloadUri() {
      java.lang.Object ref = downloadUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        downloadUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The download URL which should be used to allow a human user to
     * download the attachment. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string download_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for downloadUri.
     */
    public com.google.protobuf.ByteString getDownloadUriBytes() {
      java.lang.Object ref = downloadUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        downloadUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The download URL which should be used to allow a human user to
     * download the attachment. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string download_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The downloadUri to set.
     * @return This builder for chaining.
     */
    public Builder setDownloadUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      downloadUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The download URL which should be used to allow a human user to
     * download the attachment. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string download_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDownloadUri() {
      downloadUri_ = getDefaultInstance().getDownloadUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The download URL which should be used to allow a human user to
     * download the attachment. Chat apps shouldn't use this URL to download
     * attachment content.
     * </pre>
     *
     * <code>string download_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for downloadUri to set.
     * @return This builder for chaining.
     */
    public Builder setDownloadUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      downloadUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int source_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The source of the attachment.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Attachment.Source source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for source.
     */
    @java.lang.Override
    public int getSourceValue() {
      return source_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the attachment.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Attachment.Source source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceValue(int value) {
      source_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the attachment.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Attachment.Source source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The source.
     */
    @java.lang.Override
    public com.google.chat.v1.Attachment.Source getSource() {
      com.google.chat.v1.Attachment.Source result =
          com.google.chat.v1.Attachment.Source.forNumber(source_);
      return result == null ? com.google.chat.v1.Attachment.Source.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the attachment.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Attachment.Source source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(com.google.chat.v1.Attachment.Source value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      source_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the attachment.
     * </pre>
     *
     * <code>
     * .google.chat.v1.Attachment.Source source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      bitField0_ = (bitField0_ & ~0x00000080);
      source_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.Attachment)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.Attachment)
  private static final com.google.chat.v1.Attachment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.Attachment();
  }

  public static com.google.chat.v1.Attachment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Attachment> PARSER =
      new com.google.protobuf.AbstractParser<Attachment>() {
        @java.lang.Override
        public Attachment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Attachment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Attachment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.Attachment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
