/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductName
implements ResourceName {
    private static final PathTemplate PRODUCT = PathTemplate.createWithoutUrlEncoding((String)"products/{product}");
    private volatile Map<String, String> fieldValuesMap;
    private final String product;

    @Deprecated
    protected ProductName() {
        this.product = null;
    }

    private ProductName(Builder builder) {
        this.product = (String)Preconditions.checkNotNull((Object)builder.getProduct());
    }

    public String getProduct() {
        return this.product;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProductName of(String product) {
        return ProductName.newBuilder().setProduct(product).build();
    }

    public static String format(String product) {
        return ProductName.newBuilder().setProduct(product).build().toString();
    }

    public static ProductName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PRODUCT.validatedMatch(formattedString, "ProductName.parse: formattedString not in valid format");
        return ProductName.of((String)matchMap.get("product"));
    }

    public static List<ProductName> parseList(List<String> formattedStrings) {
        ArrayList<ProductName> list = new ArrayList<ProductName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PRODUCT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductName productName = this;
            synchronized (productName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.product != null) {
                        fieldMapBuilder.put((Object)"product", (Object)this.product);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PRODUCT.instantiate(new String[]{"product", this.product});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProductName that = (ProductName)o;
            return Objects.equals(this.product, that.product);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.product);
    }

    public static class Builder {
        private String product;

        protected Builder() {
        }

        public String getProduct() {
            return this.product;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        private Builder(ProductName productName) {
            this.product = productName.product;
        }

        public ProductName build() {
            return new ProductName(this);
        }
    }
}

