/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.cloud.channel.v1.CloudIdentityInfo;
import com.google.cloud.channel.v1.CustomerConstraintsOrBuilder;
import com.google.cloud.channel.v1.OffersProto;
import com.google.cloud.channel.v1.PromotionalOrderType;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CustomerConstraints
extends GeneratedMessageV3
implements CustomerConstraintsOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ALLOWED_REGIONS_FIELD_NUMBER = 1;
    private LazyStringList allowedRegions_;
    public static final int ALLOWED_CUSTOMER_TYPES_FIELD_NUMBER = 2;
    private List<Integer> allowedCustomerTypes_;
    private static final Internal.ListAdapter.Converter<Integer, CloudIdentityInfo.CustomerType> allowedCustomerTypes_converter_ = new Internal.ListAdapter.Converter<Integer, CloudIdentityInfo.CustomerType>(){

        public CloudIdentityInfo.CustomerType convert(Integer from) {
            CloudIdentityInfo.CustomerType result = CloudIdentityInfo.CustomerType.valueOf(from);
            return result == null ? CloudIdentityInfo.CustomerType.UNRECOGNIZED : result;
        }
    };
    private int allowedCustomerTypesMemoizedSerializedSize;
    public static final int PROMOTIONAL_ORDER_TYPES_FIELD_NUMBER = 3;
    private List<Integer> promotionalOrderTypes_;
    private static final Internal.ListAdapter.Converter<Integer, PromotionalOrderType> promotionalOrderTypes_converter_ = new Internal.ListAdapter.Converter<Integer, PromotionalOrderType>(){

        public PromotionalOrderType convert(Integer from) {
            PromotionalOrderType result = PromotionalOrderType.valueOf(from);
            return result == null ? PromotionalOrderType.UNRECOGNIZED : result;
        }
    };
    private int promotionalOrderTypesMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CustomerConstraints DEFAULT_INSTANCE = new CustomerConstraints();
    private static final Parser<CustomerConstraints> PARSER = new AbstractParser<CustomerConstraints>(){

        public CustomerConstraints parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new CustomerConstraints(input, extensionRegistry);
        }
    };

    private CustomerConstraints(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CustomerConstraints() {
        this.allowedRegions_ = LazyStringArrayList.EMPTY;
        this.allowedCustomerTypes_ = Collections.emptyList();
        this.promotionalOrderTypes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CustomerConstraints();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private CustomerConstraints(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block14: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block14;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.allowedRegions_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 1;
                        }
                        this.allowedRegions_.add((Object)s);
                        continue block14;
                    }
                    case 16: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.allowedCustomerTypes_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 2;
                        }
                        this.allowedCustomerTypes_.add(rawValue);
                        continue block14;
                    }
                    case 18: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 2) == 0) {
                                this.allowedCustomerTypes_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 2;
                            }
                            this.allowedCustomerTypes_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block14;
                    }
                    case 24: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 4) == 0) {
                            this.promotionalOrderTypes_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 4;
                        }
                        this.promotionalOrderTypes_.add(rawValue);
                        continue block14;
                    }
                    case 26: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 4) == 0) {
                                this.promotionalOrderTypes_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 4;
                            }
                            this.promotionalOrderTypes_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block14;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.allowedRegions_ = this.allowedRegions_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.allowedCustomerTypes_ = Collections.unmodifiableList(this.allowedCustomerTypes_);
            }
            if ((mutable_bitField0_ & 4) != 0) {
                this.promotionalOrderTypes_ = Collections.unmodifiableList(this.promotionalOrderTypes_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return OffersProto.internal_static_google_cloud_channel_v1_CustomerConstraints_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return OffersProto.internal_static_google_cloud_channel_v1_CustomerConstraints_fieldAccessorTable.ensureFieldAccessorsInitialized(CustomerConstraints.class, Builder.class);
    }

    public ProtocolStringList getAllowedRegionsList() {
        return this.allowedRegions_;
    }

    @Override
    public int getAllowedRegionsCount() {
        return this.allowedRegions_.size();
    }

    @Override
    public String getAllowedRegions(int index) {
        return (String)this.allowedRegions_.get(index);
    }

    @Override
    public ByteString getAllowedRegionsBytes(int index) {
        return this.allowedRegions_.getByteString(index);
    }

    @Override
    public List<CloudIdentityInfo.CustomerType> getAllowedCustomerTypesList() {
        return new Internal.ListAdapter(this.allowedCustomerTypes_, allowedCustomerTypes_converter_);
    }

    @Override
    public int getAllowedCustomerTypesCount() {
        return this.allowedCustomerTypes_.size();
    }

    @Override
    public CloudIdentityInfo.CustomerType getAllowedCustomerTypes(int index) {
        return (CloudIdentityInfo.CustomerType)((Object)allowedCustomerTypes_converter_.convert((Object)this.allowedCustomerTypes_.get(index)));
    }

    @Override
    public List<Integer> getAllowedCustomerTypesValueList() {
        return this.allowedCustomerTypes_;
    }

    @Override
    public int getAllowedCustomerTypesValue(int index) {
        return this.allowedCustomerTypes_.get(index);
    }

    @Override
    public List<PromotionalOrderType> getPromotionalOrderTypesList() {
        return new Internal.ListAdapter(this.promotionalOrderTypes_, promotionalOrderTypes_converter_);
    }

    @Override
    public int getPromotionalOrderTypesCount() {
        return this.promotionalOrderTypes_.size();
    }

    @Override
    public PromotionalOrderType getPromotionalOrderTypes(int index) {
        return (PromotionalOrderType)((Object)promotionalOrderTypes_converter_.convert((Object)this.promotionalOrderTypes_.get(index)));
    }

    @Override
    public List<Integer> getPromotionalOrderTypesValueList() {
        return this.promotionalOrderTypes_;
    }

    @Override
    public int getPromotionalOrderTypesValue(int index) {
        return this.promotionalOrderTypes_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        for (i = 0; i < this.allowedRegions_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.allowedRegions_.getRaw(i));
        }
        if (this.getAllowedCustomerTypesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.allowedCustomerTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.allowedCustomerTypes_.size(); ++i) {
            output.writeEnumNoTag(this.allowedCustomerTypes_.get(i).intValue());
        }
        if (this.getPromotionalOrderTypesList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.promotionalOrderTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.promotionalOrderTypes_.size(); ++i) {
            output.writeEnumNoTag(this.promotionalOrderTypes_.get(i).intValue());
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        int dataSize = 0;
        for (i = 0; i < this.allowedRegions_.size(); ++i) {
            dataSize += CustomerConstraints.computeStringSizeNoTag((Object)this.allowedRegions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getAllowedRegionsList().size();
        dataSize = 0;
        for (i = 0; i < this.allowedCustomerTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.allowedCustomerTypes_.get(i));
        }
        size += dataSize;
        if (!this.getAllowedCustomerTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.allowedCustomerTypesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.promotionalOrderTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.promotionalOrderTypes_.get(i));
        }
        size += dataSize;
        if (!this.getPromotionalOrderTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.promotionalOrderTypesMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerConstraints)) {
            return super.equals(obj);
        }
        CustomerConstraints other = (CustomerConstraints)obj;
        if (!this.getAllowedRegionsList().equals(other.getAllowedRegionsList())) {
            return false;
        }
        if (!this.allowedCustomerTypes_.equals(other.allowedCustomerTypes_)) {
            return false;
        }
        if (!this.promotionalOrderTypes_.equals(other.promotionalOrderTypes_)) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CustomerConstraints.getDescriptor().hashCode();
        if (this.getAllowedRegionsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getAllowedRegionsList().hashCode();
        }
        if (this.getAllowedCustomerTypesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.allowedCustomerTypes_.hashCode();
        }
        if (this.getPromotionalOrderTypesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.promotionalOrderTypes_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static CustomerConstraints parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CustomerConstraints)PARSER.parseFrom(data);
    }

    public static CustomerConstraints parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerConstraints)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerConstraints parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CustomerConstraints)PARSER.parseFrom(data);
    }

    public static CustomerConstraints parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerConstraints)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerConstraints parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CustomerConstraints)PARSER.parseFrom(data);
    }

    public static CustomerConstraints parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerConstraints)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerConstraints parseFrom(InputStream input) throws IOException {
        return (CustomerConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CustomerConstraints parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CustomerConstraints parseDelimitedFrom(InputStream input) throws IOException {
        return (CustomerConstraints)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CustomerConstraints parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerConstraints)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CustomerConstraints parseFrom(CodedInputStream input) throws IOException {
        return (CustomerConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CustomerConstraints parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CustomerConstraints.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CustomerConstraints prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CustomerConstraints getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CustomerConstraints> parser() {
        return PARSER;
    }

    public Parser<CustomerConstraints> getParserForType() {
        return PARSER;
    }

    public CustomerConstraints getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CustomerConstraintsOrBuilder {
        private int bitField0_;
        private LazyStringList allowedRegions_ = LazyStringArrayList.EMPTY;
        private List<Integer> allowedCustomerTypes_ = Collections.emptyList();
        private List<Integer> promotionalOrderTypes_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return OffersProto.internal_static_google_cloud_channel_v1_CustomerConstraints_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return OffersProto.internal_static_google_cloud_channel_v1_CustomerConstraints_fieldAccessorTable.ensureFieldAccessorsInitialized(CustomerConstraints.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.allowedRegions_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.allowedCustomerTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.promotionalOrderTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return OffersProto.internal_static_google_cloud_channel_v1_CustomerConstraints_descriptor;
        }

        public CustomerConstraints getDefaultInstanceForType() {
            return CustomerConstraints.getDefaultInstance();
        }

        public CustomerConstraints build() {
            CustomerConstraints result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CustomerConstraints buildPartial() {
            CustomerConstraints result = new CustomerConstraints(this);
            int from_bitField0_ = this.bitField0_;
            if ((this.bitField0_ & 1) != 0) {
                this.allowedRegions_ = this.allowedRegions_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.allowedRegions_ = this.allowedRegions_;
            if ((this.bitField0_ & 2) != 0) {
                this.allowedCustomerTypes_ = Collections.unmodifiableList(this.allowedCustomerTypes_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.allowedCustomerTypes_ = this.allowedCustomerTypes_;
            if ((this.bitField0_ & 4) != 0) {
                this.promotionalOrderTypes_ = Collections.unmodifiableList(this.promotionalOrderTypes_);
                this.bitField0_ &= 0xFFFFFFFB;
            }
            result.promotionalOrderTypes_ = this.promotionalOrderTypes_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CustomerConstraints) {
                return this.mergeFrom((CustomerConstraints)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CustomerConstraints other) {
            if (other == CustomerConstraints.getDefaultInstance()) {
                return this;
            }
            if (!other.allowedRegions_.isEmpty()) {
                if (this.allowedRegions_.isEmpty()) {
                    this.allowedRegions_ = other.allowedRegions_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureAllowedRegionsIsMutable();
                    this.allowedRegions_.addAll((Collection)other.allowedRegions_);
                }
                this.onChanged();
            }
            if (!other.allowedCustomerTypes_.isEmpty()) {
                if (this.allowedCustomerTypes_.isEmpty()) {
                    this.allowedCustomerTypes_ = other.allowedCustomerTypes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureAllowedCustomerTypesIsMutable();
                    this.allowedCustomerTypes_.addAll(other.allowedCustomerTypes_);
                }
                this.onChanged();
            }
            if (!other.promotionalOrderTypes_.isEmpty()) {
                if (this.promotionalOrderTypes_.isEmpty()) {
                    this.promotionalOrderTypes_ = other.promotionalOrderTypes_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensurePromotionalOrderTypesIsMutable();
                    this.promotionalOrderTypes_.addAll(other.promotionalOrderTypes_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            CustomerConstraints parsedMessage = null;
            try {
                parsedMessage = (CustomerConstraints)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (CustomerConstraints)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        private void ensureAllowedRegionsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.allowedRegions_ = new LazyStringArrayList(this.allowedRegions_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getAllowedRegionsList() {
            return this.allowedRegions_.getUnmodifiableView();
        }

        @Override
        public int getAllowedRegionsCount() {
            return this.allowedRegions_.size();
        }

        @Override
        public String getAllowedRegions(int index) {
            return (String)this.allowedRegions_.get(index);
        }

        @Override
        public ByteString getAllowedRegionsBytes(int index) {
            return this.allowedRegions_.getByteString(index);
        }

        public Builder setAllowedRegions(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAllowedRegionsIsMutable();
            this.allowedRegions_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllowedRegions(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAllowedRegionsIsMutable();
            this.allowedRegions_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllAllowedRegions(Iterable<String> values) {
            this.ensureAllowedRegionsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.allowedRegions_);
            this.onChanged();
            return this;
        }

        public Builder clearAllowedRegions() {
            this.allowedRegions_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addAllowedRegionsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CustomerConstraints.checkByteStringIsUtf8((ByteString)value);
            this.ensureAllowedRegionsIsMutable();
            this.allowedRegions_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureAllowedCustomerTypesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.allowedCustomerTypes_ = new ArrayList<Integer>(this.allowedCustomerTypes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<CloudIdentityInfo.CustomerType> getAllowedCustomerTypesList() {
            return new Internal.ListAdapter(this.allowedCustomerTypes_, allowedCustomerTypes_converter_);
        }

        @Override
        public int getAllowedCustomerTypesCount() {
            return this.allowedCustomerTypes_.size();
        }

        @Override
        public CloudIdentityInfo.CustomerType getAllowedCustomerTypes(int index) {
            return (CloudIdentityInfo.CustomerType)((Object)allowedCustomerTypes_converter_.convert((Object)this.allowedCustomerTypes_.get(index)));
        }

        public Builder setAllowedCustomerTypes(int index, CloudIdentityInfo.CustomerType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAllowedCustomerTypesIsMutable();
            this.allowedCustomerTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllowedCustomerTypes(CloudIdentityInfo.CustomerType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAllowedCustomerTypesIsMutable();
            this.allowedCustomerTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAllowedCustomerTypes(Iterable<? extends CloudIdentityInfo.CustomerType> values) {
            this.ensureAllowedCustomerTypesIsMutable();
            for (CloudIdentityInfo.CustomerType customerType : values) {
                this.allowedCustomerTypes_.add(customerType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAllowedCustomerTypes() {
            this.allowedCustomerTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAllowedCustomerTypesValueList() {
            return Collections.unmodifiableList(this.allowedCustomerTypes_);
        }

        @Override
        public int getAllowedCustomerTypesValue(int index) {
            return this.allowedCustomerTypes_.get(index);
        }

        public Builder setAllowedCustomerTypesValue(int index, int value) {
            this.ensureAllowedCustomerTypesIsMutable();
            this.allowedCustomerTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAllowedCustomerTypesValue(int value) {
            this.ensureAllowedCustomerTypesIsMutable();
            this.allowedCustomerTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAllowedCustomerTypesValue(Iterable<Integer> values) {
            this.ensureAllowedCustomerTypesIsMutable();
            for (int value : values) {
                this.allowedCustomerTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensurePromotionalOrderTypesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.promotionalOrderTypes_ = new ArrayList<Integer>(this.promotionalOrderTypes_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<PromotionalOrderType> getPromotionalOrderTypesList() {
            return new Internal.ListAdapter(this.promotionalOrderTypes_, promotionalOrderTypes_converter_);
        }

        @Override
        public int getPromotionalOrderTypesCount() {
            return this.promotionalOrderTypes_.size();
        }

        @Override
        public PromotionalOrderType getPromotionalOrderTypes(int index) {
            return (PromotionalOrderType)((Object)promotionalOrderTypes_converter_.convert((Object)this.promotionalOrderTypes_.get(index)));
        }

        public Builder setPromotionalOrderTypes(int index, PromotionalOrderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePromotionalOrderTypesIsMutable();
            this.promotionalOrderTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPromotionalOrderTypes(PromotionalOrderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePromotionalOrderTypesIsMutable();
            this.promotionalOrderTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPromotionalOrderTypes(Iterable<? extends PromotionalOrderType> values) {
            this.ensurePromotionalOrderTypesIsMutable();
            for (PromotionalOrderType promotionalOrderType : values) {
                this.promotionalOrderTypes_.add(promotionalOrderType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPromotionalOrderTypes() {
            this.promotionalOrderTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPromotionalOrderTypesValueList() {
            return Collections.unmodifiableList(this.promotionalOrderTypes_);
        }

        @Override
        public int getPromotionalOrderTypesValue(int index) {
            return this.promotionalOrderTypes_.get(index);
        }

        public Builder setPromotionalOrderTypesValue(int index, int value) {
            this.ensurePromotionalOrderTypesIsMutable();
            this.promotionalOrderTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPromotionalOrderTypesValue(int value) {
            this.ensurePromotionalOrderTypesIsMutable();
            this.promotionalOrderTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPromotionalOrderTypesValue(Iterable<Integer> values) {
            this.ensurePromotionalOrderTypesIsMutable();
            for (int value : values) {
                this.promotionalOrderTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

