/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateMapName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CERTIFICATE_MAP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificateMaps/{certificate_map}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificateMap;

    @Deprecated
    protected CertificateMapName() {
        this.project = null;
        this.location = null;
        this.certificateMap = null;
    }

    private CertificateMapName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificateMap = (String)Preconditions.checkNotNull((Object)builder.getCertificateMap());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificateMap() {
        return this.certificateMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateMapName of(String project, String location, String certificateMap) {
        return CertificateMapName.newBuilder().setProject(project).setLocation(location).setCertificateMap(certificateMap).build();
    }

    public static String format(String project, String location, String certificateMap) {
        return CertificateMapName.newBuilder().setProject(project).setLocation(location).setCertificateMap(certificateMap).build().toString();
    }

    public static CertificateMapName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CERTIFICATE_MAP.validatedMatch(formattedString, "CertificateMapName.parse: formattedString not in valid format");
        return CertificateMapName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate_map"));
    }

    public static List<CertificateMapName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateMapName> list = new ArrayList<CertificateMapName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateMapName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateMapName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateMapName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CERTIFICATE_MAP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateMapName certificateMapName = this;
            synchronized (certificateMapName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.certificateMap != null) {
                        fieldMapBuilder.put((Object)"certificate_map", (Object)this.certificateMap);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CERTIFICATE_MAP.instantiate(new String[]{"project", this.project, "location", this.location, "certificate_map", this.certificateMap});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CertificateMapName that = (CertificateMapName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.certificateMap, that.certificateMap);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.certificateMap);
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificateMap;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificateMap() {
            return this.certificateMap;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificateMap(String certificateMap) {
            this.certificateMap = certificateMap;
            return this;
        }

        private Builder(CertificateMapName certificateMapName) {
            this.project = certificateMapName.project;
            this.location = certificateMapName.location;
            this.certificateMap = certificateMapName.certificateMap;
        }

        public CertificateMapName build() {
            return new CertificateMapName(this);
        }
    }
}

