/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloudbuild.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkerPoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WORKER_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workerPools/{worker_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workerPool;

    @Deprecated
    protected WorkerPoolName() {
        this.project = null;
        this.location = null;
        this.workerPool = null;
    }

    private WorkerPoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workerPool = (String)Preconditions.checkNotNull((Object)builder.getWorkerPool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkerPool() {
        return this.workerPool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkerPoolName of(String project, String location, String workerPool) {
        return WorkerPoolName.newBuilder().setProject(project).setLocation(location).setWorkerPool(workerPool).build();
    }

    public static String format(String project, String location, String workerPool) {
        return WorkerPoolName.newBuilder().setProject(project).setLocation(location).setWorkerPool(workerPool).build().toString();
    }

    public static WorkerPoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WORKER_POOL.validatedMatch(formattedString, "WorkerPoolName.parse: formattedString not in valid format");
        return WorkerPoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("worker_pool"));
    }

    public static List<WorkerPoolName> parseList(List<String> formattedStrings) {
        ArrayList<WorkerPoolName> list = new ArrayList<WorkerPoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkerPoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkerPoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkerPoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WORKER_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkerPoolName workerPoolName = this;
            synchronized (workerPoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workerPool != null) {
                        fieldMapBuilder.put((Object)"worker_pool", (Object)this.workerPool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WORKER_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "worker_pool", this.workerPool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            WorkerPoolName that = (WorkerPoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.workerPool, that.workerPool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workerPool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String workerPool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkerPool() {
            return this.workerPool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkerPool(String workerPool) {
            this.workerPool = workerPool;
            return this;
        }

        private Builder(WorkerPoolName workerPoolName) {
            this.project = workerPoolName.project;
            this.location = workerPoolName.location;
            this.workerPool = workerPoolName.workerPool;
        }

        public WorkerPoolName build() {
            return new WorkerPoolName(this);
        }
    }
}

