/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloudbuild.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BuildTriggerName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/triggers/{trigger}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String trigger;

    public String getProject() {
        return this.project;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BuildTriggerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.trigger = (String)Preconditions.checkNotNull((Object)builder.getTrigger());
    }

    public static BuildTriggerName of(String project, String trigger) {
        return BuildTriggerName.newBuilder().setProject(project).setTrigger(trigger).build();
    }

    public static String format(String project, String trigger) {
        return BuildTriggerName.newBuilder().setProject(project).setTrigger(trigger).build().toString();
    }

    public static BuildTriggerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BuildTriggerName.parse: formattedString not in valid format");
        return BuildTriggerName.of((String)matchMap.get("project"), (String)matchMap.get("trigger"));
    }

    public static List<BuildTriggerName> parseList(List<String> formattedStrings) {
        ArrayList<BuildTriggerName> list = new ArrayList<BuildTriggerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BuildTriggerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BuildTriggerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BuildTriggerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BuildTriggerName buildTriggerName = this;
            synchronized (buildTriggerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"trigger", (Object)this.trigger);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "trigger", this.trigger});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BuildTriggerName) {
            BuildTriggerName that = (BuildTriggerName)o;
            return this.project.equals(that.project) && this.trigger.equals(that.trigger);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.trigger.hashCode();
    }

    public static class Builder {
        private String project;
        private String trigger;

        public String getProject() {
            return this.project;
        }

        public String getTrigger() {
            return this.trigger;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTrigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        private Builder() {
        }

        private Builder(BuildTriggerName buildTriggerName) {
            this.project = buildTriggerName.project;
            this.trigger = buildTriggerName.trigger;
        }

        public BuildTriggerName build() {
            return new BuildTriggerName(this);
        }
    }
}

