/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.binaryauthorization.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttestorName
implements ResourceName {
    private static final PathTemplate PROJECT_ATTESTOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/attestors/{attestor}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String attestor;

    @Deprecated
    protected AttestorName() {
        this.project = null;
        this.attestor = null;
    }

    private AttestorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.attestor = (String)Preconditions.checkNotNull((Object)builder.getAttestor());
    }

    public String getProject() {
        return this.project;
    }

    public String getAttestor() {
        return this.attestor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttestorName of(String project, String attestor) {
        return AttestorName.newBuilder().setProject(project).setAttestor(attestor).build();
    }

    public static String format(String project, String attestor) {
        return AttestorName.newBuilder().setProject(project).setAttestor(attestor).build().toString();
    }

    public static AttestorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_ATTESTOR.validatedMatch(formattedString, "AttestorName.parse: formattedString not in valid format");
        return AttestorName.of((String)matchMap.get("project"), (String)matchMap.get("attestor"));
    }

    public static List<AttestorName> parseList(List<String> formattedStrings) {
        ArrayList<AttestorName> list = new ArrayList<AttestorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttestorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttestorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttestorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ATTESTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttestorName attestorName = this;
            synchronized (attestorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.attestor != null) {
                        fieldMapBuilder.put((Object)"attestor", (Object)this.attestor);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_ATTESTOR.instantiate(new String[]{"project", this.project, "attestor", this.attestor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AttestorName that = (AttestorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.attestor, that.attestor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.attestor);
    }

    public static class Builder {
        private String project;
        private String attestor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAttestor() {
            return this.attestor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAttestor(String attestor) {
            this.attestor = attestor;
            return this;
        }

        private Builder(AttestorName attestorName) {
            this.project = attestorName.project;
            this.attestor = attestorName.attestor;
        }

        public AttestorName build() {
            return new AttestorName(this);
        }
    }
}

