/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceName
implements ResourceName {
    private static final PathTemplate SERVICE = PathTemplate.createWithoutUrlEncoding((String)"services/{service}");
    private volatile Map<String, String> fieldValuesMap;
    private final String service;

    @Deprecated
    protected ServiceName() {
        this.service = null;
    }

    private ServiceName(Builder builder) {
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
    }

    public String getService() {
        return this.service;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceName of(String service) {
        return ServiceName.newBuilder().setService(service).build();
    }

    public static String format(String service) {
        return ServiceName.newBuilder().setService(service).build().toString();
    }

    public static ServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SERVICE.validatedMatch(formattedString, "ServiceName.parse: formattedString not in valid format");
        return ServiceName.of((String)matchMap.get("service"));
    }

    public static List<ServiceName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceName> list = new ArrayList<ServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SERVICE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceName serviceName = this;
            synchronized (serviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SERVICE.instantiate(new String[]{"service", this.service});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ServiceName that = (ServiceName)o;
            return Objects.equals(this.service, that.service);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.service);
    }

    public static class Builder {
        private String service;

        protected Builder() {
        }

        public String getService() {
            return this.service;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        private Builder(ServiceName serviceName) {
            this.service = serviceName.service;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }
}

