/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SkuName
implements ResourceName {
    private static final PathTemplate SERVICE_SKU = PathTemplate.createWithoutUrlEncoding((String)"services/{service}/skus/{sku}");
    private volatile Map<String, String> fieldValuesMap;
    private final String service;
    private final String sku;

    @Deprecated
    protected SkuName() {
        this.service = null;
        this.sku = null;
    }

    private SkuName(Builder builder) {
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.sku = (String)Preconditions.checkNotNull((Object)builder.getSku());
    }

    public String getService() {
        return this.service;
    }

    public String getSku() {
        return this.sku;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SkuName of(String service, String sku) {
        return SkuName.newBuilder().setService(service).setSku(sku).build();
    }

    public static String format(String service, String sku) {
        return SkuName.newBuilder().setService(service).setSku(sku).build().toString();
    }

    public static SkuName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SERVICE_SKU.validatedMatch(formattedString, "SkuName.parse: formattedString not in valid format");
        return SkuName.of((String)matchMap.get("service"), (String)matchMap.get("sku"));
    }

    public static List<SkuName> parseList(List<String> formattedStrings) {
        ArrayList<SkuName> list = new ArrayList<SkuName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SkuName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SkuName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SkuName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SERVICE_SKU.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SkuName skuName = this;
            synchronized (skuName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.sku != null) {
                        fieldMapBuilder.put((Object)"sku", (Object)this.sku);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SERVICE_SKU.instantiate(new String[]{"service", this.service, "sku", this.sku});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SkuName that = (SkuName)o;
            return Objects.equals(this.service, that.service) && Objects.equals(this.sku, that.sku);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        return h ^= Objects.hashCode(this.sku);
    }

    public static class Builder {
        private String service;
        private String sku;

        protected Builder() {
        }

        public String getService() {
            return this.service;
        }

        public String getSku() {
            return this.sku;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setSku(String sku) {
            this.sku = sku;
            return this;
        }

        private Builder(SkuName skuName) {
            this.service = skuName.service;
            this.sku = skuName.sku;
        }

        public SkuName build() {
            return new SkuName(this);
        }
    }
}

