/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchemaBundleName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_TABLE_SCHEMA_BUNDLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String table;
    private final String schemaBundle;

    @Deprecated
    protected SchemaBundleName() {
        this.project = null;
        this.instance = null;
        this.table = null;
        this.schemaBundle = null;
    }

    private SchemaBundleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
        this.schemaBundle = (String)Preconditions.checkNotNull((Object)builder.getSchemaBundle());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getTable() {
        return this.table;
    }

    public String getSchemaBundle() {
        return this.schemaBundle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SchemaBundleName of(String project, String instance, String table, String schemaBundle) {
        return SchemaBundleName.newBuilder().setProject(project).setInstance(instance).setTable(table).setSchemaBundle(schemaBundle).build();
    }

    public static String format(String project, String instance, String table, String schemaBundle) {
        return SchemaBundleName.newBuilder().setProject(project).setInstance(instance).setTable(table).setSchemaBundle(schemaBundle).build().toString();
    }

    public static SchemaBundleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_TABLE_SCHEMA_BUNDLE.validatedMatch(formattedString, "SchemaBundleName.parse: formattedString not in valid format");
        return SchemaBundleName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("table"), (String)matchMap.get("schema_bundle"));
    }

    public static List<SchemaBundleName> parseList(List<String> formattedStrings) {
        ArrayList<SchemaBundleName> list = new ArrayList<SchemaBundleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SchemaBundleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SchemaBundleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SchemaBundleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_TABLE_SCHEMA_BUNDLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SchemaBundleName schemaBundleName = this;
            synchronized (schemaBundleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.table != null) {
                        fieldMapBuilder.put((Object)"table", (Object)this.table);
                    }
                    if (this.schemaBundle != null) {
                        fieldMapBuilder.put((Object)"schema_bundle", (Object)this.schemaBundle);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_TABLE_SCHEMA_BUNDLE.instantiate(new String[]{"project", this.project, "instance", this.instance, "table", this.table, "schema_bundle", this.schemaBundle});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SchemaBundleName that = (SchemaBundleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.table, that.table) && Objects.equals(this.schemaBundle, that.schemaBundle);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        h ^= Objects.hashCode(this.table);
        h *= 1000003;
        return h ^= Objects.hashCode(this.schemaBundle);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String table;
        private String schemaBundle;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getTable() {
            return this.table;
        }

        public String getSchemaBundle() {
            return this.schemaBundle;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setSchemaBundle(String schemaBundle) {
            this.schemaBundle = schemaBundle;
            return this;
        }

        private Builder(SchemaBundleName schemaBundleName) {
            this.project = schemaBundleName.project;
            this.instance = schemaBundleName.instance;
            this.table = schemaBundleName.table;
            this.schemaBundle = schemaBundleName.schemaBundle;
        }

        public SchemaBundleName build() {
            return new SchemaBundleName(this);
        }
    }
}

