/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta2/storage.proto

package com.google.cloud.bigquery.storage.v1beta2;

/**
 *
 *
 * <pre>
 * Response message for `AppendRows`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.AppendRowsResponse}
 */
public final class AppendRowsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse)
    AppendRowsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AppendRowsResponse.newBuilder() to construct.
  private AppendRowsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AppendRowsResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AppendRowsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.class,
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.Builder.class);
  }

  public interface AppendResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred. The offset will not be
     * set if appending using default streams.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 1;</code>
     *
     * @return Whether the offset field is set.
     */
    boolean hasOffset();
    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred. The offset will not be
     * set if appending using default streams.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 1;</code>
     *
     * @return The offset.
     */
    com.google.protobuf.Int64Value getOffset();
    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred. The offset will not be
     * set if appending using default streams.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 1;</code>
     */
    com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * AppendResult is returned for successful append requests.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult}
   */
  public static final class AppendResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
      AppendResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AppendResult.newBuilder() to construct.
    private AppendResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AppendResult() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AppendResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_AppendResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_AppendResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.class,
              com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.Builder
                  .class);
    }

    public static final int OFFSET_FIELD_NUMBER = 1;
    private com.google.protobuf.Int64Value offset_;
    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred. The offset will not be
     * set if appending using default streams.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 1;</code>
     *
     * @return Whether the offset field is set.
     */
    @java.lang.Override
    public boolean hasOffset() {
      return offset_ != null;
    }
    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred. The offset will not be
     * set if appending using default streams.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 1;</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public com.google.protobuf.Int64Value getOffset() {
      return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
    }
    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred. The offset will not be
     * set if appending using default streams.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder() {
      return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (offset_ != null) {
        output.writeMessage(1, getOffset());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (offset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOffset());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult other =
          (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult) obj;

      if (hasOffset() != other.hasOffset()) return false;
      if (hasOffset()) {
        if (!getOffset().equals(other.getOffset())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasOffset()) {
        hash = (37 * hash) + OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getOffset().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * AppendResult is returned for successful append requests.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta2.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_AppendResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta2.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_AppendResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.class,
                com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        offset_ = null;
        if (offsetBuilder_ != null) {
          offsetBuilder_.dispose();
          offsetBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta2.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_AppendResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult build() {
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult result =
            new com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.offset_ = offsetBuilder_ == null ? offset_ : offsetBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
                .getDefaultInstance()) return this;
        if (other.hasOffset()) {
          mergeOffset(other.getOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getOffsetFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Int64Value offset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int64Value,
              com.google.protobuf.Int64Value.Builder,
              com.google.protobuf.Int64ValueOrBuilder>
          offsetBuilder_;
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       *
       * @return Whether the offset field is set.
       */
      public boolean hasOffset() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       *
       * @return The offset.
       */
      public com.google.protobuf.Int64Value getOffset() {
        if (offsetBuilder_ == null) {
          return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
        } else {
          return offsetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       */
      public Builder setOffset(com.google.protobuf.Int64Value value) {
        if (offsetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          offset_ = value;
        } else {
          offsetBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       */
      public Builder setOffset(com.google.protobuf.Int64Value.Builder builderForValue) {
        if (offsetBuilder_ == null) {
          offset_ = builderForValue.build();
        } else {
          offsetBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       */
      public Builder mergeOffset(com.google.protobuf.Int64Value value) {
        if (offsetBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && offset_ != null
              && offset_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
            getOffsetBuilder().mergeFrom(value);
          } else {
            offset_ = value;
          }
        } else {
          offsetBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       */
      public Builder clearOffset() {
        bitField0_ = (bitField0_ & ~0x00000001);
        offset_ = null;
        if (offsetBuilder_ != null) {
          offsetBuilder_.dispose();
          offsetBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       */
      public com.google.protobuf.Int64Value.Builder getOffsetBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getOffsetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       */
      public com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder() {
        if (offsetBuilder_ != null) {
          return offsetBuilder_.getMessageOrBuilder();
        } else {
          return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
        }
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred. The offset will not be
       * set if appending using default streams.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int64Value,
              com.google.protobuf.Int64Value.Builder,
              com.google.protobuf.Int64ValueOrBuilder>
          getOffsetFieldBuilder() {
        if (offsetBuilder_ == null) {
          offsetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Int64Value,
                  com.google.protobuf.Int64Value.Builder,
                  com.google.protobuf.Int64ValueOrBuilder>(
                  getOffset(), getParentForChildren(), isClean());
          offset_ = null;
        }
        return offsetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
    private static final com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult();
    }

    public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AppendResult> PARSER =
        new com.google.protobuf.AbstractParser<AppendResult>() {
          @java.lang.Override
          public AppendResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AppendResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AppendResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int responseCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object response_;

  public enum ResponseCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    APPEND_RESULT(1),
    ERROR(2),
    RESPONSE_NOT_SET(0);
    private final int value;

    private ResponseCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResponseCase forNumber(int value) {
      switch (value) {
        case 1:
          return APPEND_RESULT;
        case 2:
          return ERROR;
        case 0:
          return RESPONSE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResponseCase getResponseCase() {
    return ResponseCase.forNumber(responseCase_);
  }

  public static final int APPEND_RESULT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Result if the append is successful.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
   * </code>
   *
   * @return Whether the appendResult field is set.
   */
  @java.lang.Override
  public boolean hasAppendResult() {
    return responseCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Result if the append is successful.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
   * </code>
   *
   * @return The appendResult.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
      getAppendResult() {
    if (responseCase_ == 1) {
      return (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult) response_;
    }
    return com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result if the append is successful.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResultOrBuilder
      getAppendResultOrBuilder() {
    if (responseCase_ == 1) {
      return (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult) response_;
    }
    return com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        .getDefaultInstance();
  }

  public static final int ERROR_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Error returned when problems were encountered.  If present,
   * it indicates rows were not accepted into the system.
   * Users can retry or continue with other append requests within the
   * same connection.
   *
   * Additional information about error signalling:
   *
   * ALREADY_EXISTS: Happens when an append specified an offset, and the
   * backend already has received data at this offset.  Typically encountered
   * in retry scenarios, and can be ignored.
   *
   * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
   * the current end of the stream.
   *
   * INVALID_ARGUMENT: Indicates a malformed request or data.
   *
   * ABORTED: Request processing is aborted because of prior failures.  The
   * request can be retried if previous failure is addressed.
   *
   * INTERNAL: Indicates server side error(s) that can be retried.
   * </pre>
   *
   * <code>.google.rpc.Status error = 2;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return responseCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Error returned when problems were encountered.  If present,
   * it indicates rows were not accepted into the system.
   * Users can retry or continue with other append requests within the
   * same connection.
   *
   * Additional information about error signalling:
   *
   * ALREADY_EXISTS: Happens when an append specified an offset, and the
   * backend already has received data at this offset.  Typically encountered
   * in retry scenarios, and can be ignored.
   *
   * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
   * the current end of the stream.
   *
   * INVALID_ARGUMENT: Indicates a malformed request or data.
   *
   * ABORTED: Request processing is aborted because of prior failures.  The
   * request can be retried if previous failure is addressed.
   *
   * INTERNAL: Indicates server side error(s) that can be retried.
   * </pre>
   *
   * <code>.google.rpc.Status error = 2;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    if (responseCase_ == 2) {
      return (com.google.rpc.Status) response_;
    }
    return com.google.rpc.Status.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Error returned when problems were encountered.  If present,
   * it indicates rows were not accepted into the system.
   * Users can retry or continue with other append requests within the
   * same connection.
   *
   * Additional information about error signalling:
   *
   * ALREADY_EXISTS: Happens when an append specified an offset, and the
   * backend already has received data at this offset.  Typically encountered
   * in retry scenarios, and can be ignored.
   *
   * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
   * the current end of the stream.
   *
   * INVALID_ARGUMENT: Indicates a malformed request or data.
   *
   * ABORTED: Request processing is aborted because of prior failures.  The
   * request can be retried if previous failure is addressed.
   *
   * INTERNAL: Indicates server side error(s) that can be retried.
   * </pre>
   *
   * <code>.google.rpc.Status error = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    if (responseCase_ == 2) {
      return (com.google.rpc.Status) response_;
    }
    return com.google.rpc.Status.getDefaultInstance();
  }

  public static final int UPDATED_SCHEMA_FIELD_NUMBER = 3;
  private com.google.cloud.bigquery.storage.v1beta2.TableSchema updatedSchema_;
  /**
   *
   *
   * <pre>
   * If backend detects a schema update, pass it to user so that user can
   * use it to input new type of message. It will be empty when no schema
   * updates have occurred.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
   *
   * @return Whether the updatedSchema field is set.
   */
  @java.lang.Override
  public boolean hasUpdatedSchema() {
    return updatedSchema_ != null;
  }
  /**
   *
   *
   * <pre>
   * If backend detects a schema update, pass it to user so that user can
   * use it to input new type of message. It will be empty when no schema
   * updates have occurred.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
   *
   * @return The updatedSchema.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.TableSchema getUpdatedSchema() {
    return updatedSchema_ == null
        ? com.google.cloud.bigquery.storage.v1beta2.TableSchema.getDefaultInstance()
        : updatedSchema_;
  }
  /**
   *
   *
   * <pre>
   * If backend detects a schema update, pass it to user so that user can
   * use it to input new type of message. It will be empty when no schema
   * updates have occurred.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.TableSchemaOrBuilder
      getUpdatedSchemaOrBuilder() {
    return updatedSchema_ == null
        ? com.google.cloud.bigquery.storage.v1beta2.TableSchema.getDefaultInstance()
        : updatedSchema_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (responseCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult) response_);
    }
    if (responseCase_ == 2) {
      output.writeMessage(2, (com.google.rpc.Status) response_);
    }
    if (updatedSchema_ != null) {
      output.writeMessage(3, getUpdatedSchema());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (responseCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
                  response_);
    }
    if (responseCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.rpc.Status) response_);
    }
    if (updatedSchema_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdatedSchema());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse other =
        (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse) obj;

    if (hasUpdatedSchema() != other.hasUpdatedSchema()) return false;
    if (hasUpdatedSchema()) {
      if (!getUpdatedSchema().equals(other.getUpdatedSchema())) return false;
    }
    if (!getResponseCase().equals(other.getResponseCase())) return false;
    switch (responseCase_) {
      case 1:
        if (!getAppendResult().equals(other.getAppendResult())) return false;
        break;
      case 2:
        if (!getError().equals(other.getError())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasUpdatedSchema()) {
      hash = (37 * hash) + UPDATED_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getUpdatedSchema().hashCode();
    }
    switch (responseCase_) {
      case 1:
        hash = (37 * hash) + APPEND_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getAppendResult().hashCode();
        break;
      case 2:
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for `AppendRows`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.AppendRowsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse)
      com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.class,
              com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (appendResultBuilder_ != null) {
        appendResultBuilder_.clear();
      }
      if (errorBuilder_ != null) {
        errorBuilder_.clear();
      }
      updatedSchema_ = null;
      if (updatedSchemaBuilder_ != null) {
        updatedSchemaBuilder_.dispose();
        updatedSchemaBuilder_ = null;
      }
      responseCase_ = 0;
      response_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_AppendRowsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse build() {
      com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse buildPartial() {
      com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse result =
          new com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updatedSchema_ =
            updatedSchemaBuilder_ == null ? updatedSchema_ : updatedSchemaBuilder_.build();
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse result) {
      result.responseCase_ = responseCase_;
      result.response_ = this.response_;
      if (responseCase_ == 1 && appendResultBuilder_ != null) {
        result.response_ = appendResultBuilder_.build();
      }
      if (responseCase_ == 2 && errorBuilder_ != null) {
        result.response_ = errorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse other) {
      if (other
          == com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.getDefaultInstance())
        return this;
      if (other.hasUpdatedSchema()) {
        mergeUpdatedSchema(other.getUpdatedSchema());
      }
      switch (other.getResponseCase()) {
        case APPEND_RESULT:
          {
            mergeAppendResult(other.getAppendResult());
            break;
          }
        case ERROR:
          {
            mergeError(other.getError());
            break;
          }
        case RESPONSE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAppendResultFieldBuilder().getBuilder(), extensionRegistry);
                responseCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                responseCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdatedSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int responseCase_ = 0;
    private java.lang.Object response_;

    public ResponseCase getResponseCase() {
      return ResponseCase.forNumber(responseCase_);
    }

    public Builder clearResponse() {
      responseCase_ = 0;
      response_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult,
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.Builder,
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResultOrBuilder>
        appendResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     *
     * @return Whether the appendResult field is set.
     */
    @java.lang.Override
    public boolean hasAppendResult() {
      return responseCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     *
     * @return The appendResult.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
        getAppendResult() {
      if (appendResultBuilder_ == null) {
        if (responseCase_ == 1) {
          return (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
              response_;
        }
        return com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
            .getDefaultInstance();
      } else {
        if (responseCase_ == 1) {
          return appendResultBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     */
    public Builder setAppendResult(
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult value) {
      if (appendResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        appendResultBuilder_.setMessage(value);
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     */
    public Builder setAppendResult(
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.Builder
            builderForValue) {
      if (appendResultBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        appendResultBuilder_.setMessage(builderForValue.build());
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     */
    public Builder mergeAppendResult(
        com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult value) {
      if (appendResultBuilder_ == null) {
        if (responseCase_ == 1
            && response_
                != com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
                    .getDefaultInstance()) {
          response_ =
              com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.newBuilder(
                      (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
                          response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        if (responseCase_ == 1) {
          appendResultBuilder_.mergeFrom(value);
        } else {
          appendResultBuilder_.setMessage(value);
        }
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     */
    public Builder clearAppendResult() {
      if (appendResultBuilder_ == null) {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
      } else {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
        }
        appendResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.Builder
        getAppendResultBuilder() {
      return getAppendResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResultOrBuilder
        getAppendResultOrBuilder() {
      if ((responseCase_ == 1) && (appendResultBuilder_ != null)) {
        return appendResultBuilder_.getMessageOrBuilder();
      } else {
        if (responseCase_ == 1) {
          return (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
              response_;
        }
        return com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result if the append is successful.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult append_result = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult,
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.Builder,
            com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResultOrBuilder>
        getAppendResultFieldBuilder() {
      if (appendResultBuilder_ == null) {
        if (!(responseCase_ == 1)) {
          response_ =
              com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult
                  .getDefaultInstance();
        }
        appendResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult,
                com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult.Builder,
                com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResultOrBuilder>(
                (com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.AppendResult)
                    response_,
                getParentForChildren(),
                isClean());
        response_ = null;
      }
      responseCase_ = 1;
      onChanged();
      return appendResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return responseCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        if (responseCase_ == 2) {
          return (com.google.rpc.Status) response_;
        }
        return com.google.rpc.Status.getDefaultInstance();
      } else {
        if (responseCase_ == 2) {
          return errorBuilder_.getMessage();
        }
        return com.google.rpc.Status.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (responseCase_ == 2 && response_ != com.google.rpc.Status.getDefaultInstance()) {
          response_ =
              com.google.rpc.Status.newBuilder((com.google.rpc.Status) response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        if (responseCase_ == 2) {
          errorBuilder_.mergeFrom(value);
        } else {
          errorBuilder_.setMessage(value);
        }
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        if (responseCase_ == 2) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
      } else {
        if (responseCase_ == 2) {
          responseCase_ = 0;
          response_ = null;
        }
        errorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if ((responseCase_ == 2) && (errorBuilder_ != null)) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        if (responseCase_ == 2) {
          return (com.google.rpc.Status) response_;
        }
        return com.google.rpc.Status.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Error returned when problems were encountered.  If present,
     * it indicates rows were not accepted into the system.
     * Users can retry or continue with other append requests within the
     * same connection.
     *
     * Additional information about error signalling:
     *
     * ALREADY_EXISTS: Happens when an append specified an offset, and the
     * backend already has received data at this offset.  Typically encountered
     * in retry scenarios, and can be ignored.
     *
     * OUT_OF_RANGE: Returned when the specified offset in the stream is beyond
     * the current end of the stream.
     *
     * INVALID_ARGUMENT: Indicates a malformed request or data.
     *
     * ABORTED: Request processing is aborted because of prior failures.  The
     * request can be retried if previous failure is addressed.
     *
     * INTERNAL: Indicates server side error(s) that can be retried.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        if (!(responseCase_ == 2)) {
          response_ = com.google.rpc.Status.getDefaultInstance();
        }
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                (com.google.rpc.Status) response_, getParentForChildren(), isClean());
        response_ = null;
      }
      responseCase_ = 2;
      onChanged();
      return errorBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1beta2.TableSchema updatedSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.TableSchema,
            com.google.cloud.bigquery.storage.v1beta2.TableSchema.Builder,
            com.google.cloud.bigquery.storage.v1beta2.TableSchemaOrBuilder>
        updatedSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     *
     * @return Whether the updatedSchema field is set.
     */
    public boolean hasUpdatedSchema() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     *
     * @return The updatedSchema.
     */
    public com.google.cloud.bigquery.storage.v1beta2.TableSchema getUpdatedSchema() {
      if (updatedSchemaBuilder_ == null) {
        return updatedSchema_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.TableSchema.getDefaultInstance()
            : updatedSchema_;
      } else {
        return updatedSchemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     */
    public Builder setUpdatedSchema(com.google.cloud.bigquery.storage.v1beta2.TableSchema value) {
      if (updatedSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updatedSchema_ = value;
      } else {
        updatedSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     */
    public Builder setUpdatedSchema(
        com.google.cloud.bigquery.storage.v1beta2.TableSchema.Builder builderForValue) {
      if (updatedSchemaBuilder_ == null) {
        updatedSchema_ = builderForValue.build();
      } else {
        updatedSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     */
    public Builder mergeUpdatedSchema(com.google.cloud.bigquery.storage.v1beta2.TableSchema value) {
      if (updatedSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updatedSchema_ != null
            && updatedSchema_
                != com.google.cloud.bigquery.storage.v1beta2.TableSchema.getDefaultInstance()) {
          getUpdatedSchemaBuilder().mergeFrom(value);
        } else {
          updatedSchema_ = value;
        }
      } else {
        updatedSchemaBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     */
    public Builder clearUpdatedSchema() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updatedSchema_ = null;
      if (updatedSchemaBuilder_ != null) {
        updatedSchemaBuilder_.dispose();
        updatedSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.TableSchema.Builder getUpdatedSchemaBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdatedSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.TableSchemaOrBuilder
        getUpdatedSchemaOrBuilder() {
      if (updatedSchemaBuilder_ != null) {
        return updatedSchemaBuilder_.getMessageOrBuilder();
      } else {
        return updatedSchema_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.TableSchema.getDefaultInstance()
            : updatedSchema_;
      }
    }
    /**
     *
     *
     * <pre>
     * If backend detects a schema update, pass it to user so that user can
     * use it to input new type of message. It will be empty when no schema
     * updates have occurred.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.TableSchema updated_schema = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.TableSchema,
            com.google.cloud.bigquery.storage.v1beta2.TableSchema.Builder,
            com.google.cloud.bigquery.storage.v1beta2.TableSchemaOrBuilder>
        getUpdatedSchemaFieldBuilder() {
      if (updatedSchemaBuilder_ == null) {
        updatedSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.TableSchema,
                com.google.cloud.bigquery.storage.v1beta2.TableSchema.Builder,
                com.google.cloud.bigquery.storage.v1beta2.TableSchemaOrBuilder>(
                getUpdatedSchema(), getParentForChildren(), isClean());
        updatedSchema_ = null;
      }
      return updatedSchemaBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta2.AppendRowsResponse)
  private static final com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse();
  }

  public static com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AppendRowsResponse> PARSER =
      new com.google.protobuf.AbstractParser<AppendRowsResponse>() {
        @java.lang.Override
        public AppendRowsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AppendRowsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AppendRowsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
