/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta1/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.storage.v1beta1;

public final class Storage {
  private Storage() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  /**
   *
   *
   * <pre>
   * Data format for input or output data.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.storage.v1beta1.DataFormat}
   */
  public enum DataFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Data format is unspecified.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    DATA_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Avro is a standard open source row based file format.
     * See https://avro.apache.org/ for more details.
     * </pre>
     *
     * <code>AVRO = 1;</code>
     */
    AVRO(1),
    /**
     *
     *
     * <pre>
     * Arrow is a standard open source column-based message format.
     * See https://arrow.apache.org/ for more details.
     * </pre>
     *
     * <code>ARROW = 3;</code>
     */
    ARROW(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Data format is unspecified.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_FORMAT_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Avro is a standard open source row based file format.
     * See https://avro.apache.org/ for more details.
     * </pre>
     *
     * <code>AVRO = 1;</code>
     */
    public static final int AVRO_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Arrow is a standard open source column-based message format.
     * See https://arrow.apache.org/ for more details.
     * </pre>
     *
     * <code>ARROW = 3;</code>
     */
    public static final int ARROW_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataFormat forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_FORMAT_UNSPECIFIED;
        case 1:
          return AVRO;
        case 3:
          return ARROW;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataFormat>() {
          public DataFormat findValueByNumber(int number) {
            return DataFormat.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DataFormat[] VALUES = values();

    public static DataFormat valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1beta1.DataFormat)
  }

  /**
   *
   *
   * <pre>
   * Strategy for distributing data among multiple streams in a read session.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.storage.v1beta1.ShardingStrategy}
   */
  public enum ShardingStrategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Same as LIQUID.
     * </pre>
     *
     * <code>SHARDING_STRATEGY_UNSPECIFIED = 0;</code>
     */
    SHARDING_STRATEGY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Assigns data to each stream based on the client's read rate. The faster the
     * client reads from a stream, the more data is assigned to the stream. In
     * this strategy, it's possible to read all data from a single stream even if
     * there are other streams present.
     * </pre>
     *
     * <code>LIQUID = 1;</code>
     */
    LIQUID(1),
    /**
     *
     *
     * <pre>
     * Assigns data to each stream such that roughly the same number of rows can
     * be read from each stream. Because the server-side unit for assigning data
     * is collections of rows, the API does not guarantee that each stream will
     * return the same number or rows. Additionally, the limits are enforced based
     * on the number of pre-filtering rows, so some filters can lead to lopsided
     * assignments.
     * </pre>
     *
     * <code>BALANCED = 2;</code>
     */
    BALANCED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Same as LIQUID.
     * </pre>
     *
     * <code>SHARDING_STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int SHARDING_STRATEGY_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Assigns data to each stream based on the client's read rate. The faster the
     * client reads from a stream, the more data is assigned to the stream. In
     * this strategy, it's possible to read all data from a single stream even if
     * there are other streams present.
     * </pre>
     *
     * <code>LIQUID = 1;</code>
     */
    public static final int LIQUID_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Assigns data to each stream such that roughly the same number of rows can
     * be read from each stream. Because the server-side unit for assigning data
     * is collections of rows, the API does not guarantee that each stream will
     * return the same number or rows. Additionally, the limits are enforced based
     * on the number of pre-filtering rows, so some filters can lead to lopsided
     * assignments.
     * </pre>
     *
     * <code>BALANCED = 2;</code>
     */
    public static final int BALANCED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ShardingStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ShardingStrategy forNumber(int value) {
      switch (value) {
        case 0:
          return SHARDING_STRATEGY_UNSPECIFIED;
        case 1:
          return LIQUID;
        case 2:
          return BALANCED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ShardingStrategy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ShardingStrategy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ShardingStrategy>() {
              public ShardingStrategy findValueByNumber(int number) {
                return ShardingStrategy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ShardingStrategy[] VALUES = values();

    public static ShardingStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ShardingStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1beta1.ShardingStrategy)
  }

  public interface StreamOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.Stream)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Name of the stream, in the form
     * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Name of the stream, in the form
     * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }

  /**
   *
   *
   * <pre>
   * Information about a single data stream within a read session.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.Stream}
   */
  public static final class Stream extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.Stream)
      StreamOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Stream.newBuilder() to construct.
    private Stream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Stream() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Stream();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_Stream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_Stream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the stream, in the form
     * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the stream, in the form
     * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.Stream)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.Stream other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.Stream) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.Stream prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information about a single data stream within a read session.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.Stream}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.Stream)
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_Stream_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_Stream_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder.class);
      }

      // Construct using com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_Stream_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.Stream result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.Stream result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.Stream(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.Stream) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1beta1.Storage.Stream) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream other) {
        if (other == com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Name of the stream, in the form
       * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the stream, in the form
       * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the stream, in the form
       * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of the stream, in the form
       * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of the stream, in the form
       * `projects/{project_id}/locations/{location}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.Stream)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.Stream)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.Stream DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.Stream();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Stream> PARSER =
        new com.google.protobuf.AbstractParser<Stream>() {
          @java.lang.Override
          public Stream parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Stream> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Stream> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StreamPositionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.StreamPosition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Identifier for a given Stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
     *
     * @return Whether the stream field is set.
     */
    boolean hasStream();

    /**
     *
     *
     * <pre>
     * Identifier for a given Stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
     *
     * @return The stream.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStream();

    /**
     *
     *
     * <pre>
     * Identifier for a given Stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamOrBuilder();

    /**
     *
     *
     * <pre>
     * Position in the stream.
     * </pre>
     *
     * <code>int64 offset = 2;</code>
     *
     * @return The offset.
     */
    long getOffset();
  }

  /**
   *
   *
   * <pre>
   * Expresses a point within a given stream using an offset position.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.StreamPosition}
   */
  public static final class StreamPosition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.StreamPosition)
      StreamPositionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use StreamPosition.newBuilder() to construct.
    private StreamPosition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StreamPosition() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StreamPosition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.Builder.class);
    }

    private int bitField0_;
    public static final int STREAM_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream stream_;

    /**
     *
     *
     * <pre>
     * Identifier for a given Stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
     *
     * @return Whether the stream field is set.
     */
    @java.lang.Override
    public boolean hasStream() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Identifier for a given Stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
     *
     * @return The stream.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStream() {
      return stream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : stream_;
    }

    /**
     *
     *
     * <pre>
     * Identifier for a given Stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamOrBuilder() {
      return stream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : stream_;
    }

    public static final int OFFSET_FIELD_NUMBER = 2;
    private long offset_ = 0L;

    /**
     *
     *
     * <pre>
     * Position in the stream.
     * </pre>
     *
     * <code>int64 offset = 2;</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public long getOffset() {
      return offset_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getStream());
      }
      if (offset_ != 0L) {
        output.writeInt64(2, offset_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStream());
      }
      if (offset_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, offset_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition) obj;

      if (hasStream() != other.hasStream()) return false;
      if (hasStream()) {
        if (!getStream().equals(other.getStream())) return false;
      }
      if (getOffset() != other.getOffset()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStream()) {
        hash = (37 * hash) + STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getStream().hashCode();
      }
      hash = (37 * hash) + OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOffset());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Expresses a point within a given stream using an offset position.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.StreamPosition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.StreamPosition)
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPositionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStreamFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        stream_ = null;
        if (streamBuilder_ != null) {
          streamBuilder_.dispose();
          streamBuilder_ = null;
        }
        offset_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.stream_ = streamBuilder_ == null ? stream_ : streamBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.offset_ = offset_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
                .getDefaultInstance()) return this;
        if (other.hasStream()) {
          mergeStream(other.getStream());
        }
        if (other.getOffset() != 0L) {
          setOffset(other.getOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStreamFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  offset_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream stream_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          streamBuilder_;

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       *
       * @return Whether the stream field is set.
       */
      public boolean hasStream() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       *
       * @return The stream.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStream() {
        if (streamBuilder_ == null) {
          return stream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : stream_;
        } else {
          return streamBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       */
      public Builder setStream(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stream_ = value;
        } else {
          streamBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       */
      public Builder setStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamBuilder_ == null) {
          stream_ = builderForValue.build();
        } else {
          streamBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       */
      public Builder mergeStream(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && stream_ != null
              && stream_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.Stream
                      .getDefaultInstance()) {
            getStreamBuilder().mergeFrom(value);
          } else {
            stream_ = value;
          }
        } else {
          streamBuilder_.mergeFrom(value);
        }
        if (stream_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       */
      public Builder clearStream() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stream_ = null;
        if (streamBuilder_ != null) {
          streamBuilder_.dispose();
          streamBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder getStreamBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStreamFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
          getStreamOrBuilder() {
        if (streamBuilder_ != null) {
          return streamBuilder_.getMessageOrBuilder();
        } else {
          return stream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : stream_;
        }
      }

      /**
       *
       *
       * <pre>
       * Identifier for a given Stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream stream = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getStreamFieldBuilder() {
        if (streamBuilder_ == null) {
          streamBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>(
                  getStream(), getParentForChildren(), isClean());
          stream_ = null;
        }
        return streamBuilder_;
      }

      private long offset_;

      /**
       *
       *
       * <pre>
       * Position in the stream.
       * </pre>
       *
       * <code>int64 offset = 2;</code>
       *
       * @return The offset.
       */
      @java.lang.Override
      public long getOffset() {
        return offset_;
      }

      /**
       *
       *
       * <pre>
       * Position in the stream.
       * </pre>
       *
       * <code>int64 offset = 2;</code>
       *
       * @param value The offset to set.
       * @return This builder for chaining.
       */
      public Builder setOffset(long value) {

        offset_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Position in the stream.
       * </pre>
       *
       * <code>int64 offset = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOffset() {
        bitField0_ = (bitField0_ & ~0x00000002);
        offset_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.StreamPosition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.StreamPosition)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StreamPosition> PARSER =
        new com.google.protobuf.AbstractParser<StreamPosition>() {
          @java.lang.Override
          public StreamPosition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StreamPosition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StreamPosition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadSessionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.ReadSession)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return Whether the expireTime field is set.
     */
    boolean hasExpireTime();

    /**
     *
     *
     * <pre>
     * Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return The expireTime.
     */
    com.google.protobuf.Timestamp getExpireTime();

    /**
     *
     *
     * <pre>
     * Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Avro schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
     *
     * @return Whether the avroSchema field is set.
     */
    boolean hasAvroSchema();

    /**
     *
     *
     * <pre>
     * Avro schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
     *
     * @return The avroSchema.
     */
    com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema getAvroSchema();

    /**
     *
     *
     * <pre>
     * Avro schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder
        getAvroSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Arrow schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
     *
     * @return Whether the arrowSchema field is set.
     */
    boolean hasArrowSchema();

    /**
     *
     *
     * <pre>
     * Arrow schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
     *
     * @return The arrowSchema.
     */
    com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema getArrowSchema();

    /**
     *
     *
     * <pre>
     * Arrow schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder
        getArrowSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream> getStreamsList();

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStreams(int index);

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    int getStreamsCount();

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    java.util.List<? extends com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
        getStreamsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Table that this ReadSession is reading from.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
     *
     * @return Whether the tableReference field is set.
     */
    boolean hasTableReference();

    /**
     *
     *
     * <pre>
     * Table that this ReadSession is reading from.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
     *
     * @return The tableReference.
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        getTableReference();

    /**
     *
     *
     * <pre>
     * Table that this ReadSession is reading from.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder
        getTableReferenceOrBuilder();

    /**
     *
     *
     * <pre>
     * Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
     *
     * @return Whether the tableModifiers field is set.
     */
    boolean hasTableModifiers();

    /**
     *
     *
     * <pre>
     * Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
     *
     * @return The tableModifiers.
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        getTableModifiers();

    /**
     *
     *
     * <pre>
     * Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder
        getTableModifiersOrBuilder();

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among the streams.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
     *
     * @return The enum numeric value on the wire for shardingStrategy.
     */
    int getShardingStrategyValue();

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among the streams.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
     *
     * @return The shardingStrategy.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy getShardingStrategy();

    com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.SchemaCase getSchemaCase();
  }

  /**
   *
   *
   * <pre>
   * Information returned from a `CreateReadSession` request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ReadSession}
   */
  public static final class ReadSession extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.ReadSession)
      ReadSessionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadSession.newBuilder() to construct.
    private ReadSession(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadSession() {
      name_ = "";
      streams_ = java.util.Collections.emptyList();
      shardingStrategy_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadSession();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.Builder.class);
    }

    private int bitField0_;
    private int schemaCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object schema_;

    public enum SchemaCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      AVRO_SCHEMA(5),
      ARROW_SCHEMA(6),
      SCHEMA_NOT_SET(0);
      private final int value;

      private SchemaCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SchemaCase valueOf(int value) {
        return forNumber(value);
      }

      public static SchemaCase forNumber(int value) {
        switch (value) {
          case 5:
            return AVRO_SCHEMA;
          case 6:
            return ARROW_SCHEMA;
          case 0:
            return SCHEMA_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SchemaCase getSchemaCase() {
      return SchemaCase.forNumber(schemaCase_);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXPIRE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp expireTime_;

    /**
     *
     *
     * <pre>
     * Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
    }

    /**
     *
     *
     * <pre>
     * Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
    }

    public static final int AVRO_SCHEMA_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * Avro schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
     *
     * @return Whether the avroSchema field is set.
     */
    @java.lang.Override
    public boolean hasAvroSchema() {
      return schemaCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Avro schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
     *
     * @return The avroSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema getAvroSchema() {
      if (schemaCase_ == 5) {
        return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Avro schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder
        getAvroSchemaOrBuilder() {
      if (schemaCase_ == 5) {
        return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.getDefaultInstance();
    }

    public static final int ARROW_SCHEMA_FIELD_NUMBER = 6;

    /**
     *
     *
     * <pre>
     * Arrow schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
     *
     * @return Whether the arrowSchema field is set.
     */
    @java.lang.Override
    public boolean hasArrowSchema() {
      return schemaCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Arrow schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
     *
     * @return The arrowSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema getArrowSchema() {
      if (schemaCase_ == 6) {
        return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Arrow schema.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder
        getArrowSchemaOrBuilder() {
      if (schemaCase_ == 6) {
        return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.getDefaultInstance();
    }

    public static final int STREAMS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream> streams_;

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>
        getStreamsList() {
      return streams_;
    }

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
        getStreamsOrBuilderList() {
      return streams_;
    }

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    @java.lang.Override
    public int getStreamsCount() {
      return streams_.size();
    }

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStreams(int index) {
      return streams_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Streams associated with this session.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamsOrBuilder(
        int index) {
      return streams_.get(index);
    }

    public static final int TABLE_REFERENCE_FIELD_NUMBER = 7;
    private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        tableReference_;

    /**
     *
     *
     * <pre>
     * Table that this ReadSession is reading from.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
     *
     * @return Whether the tableReference field is set.
     */
    @java.lang.Override
    public boolean hasTableReference() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Table that this ReadSession is reading from.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
     *
     * @return The tableReference.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        getTableReference() {
      return tableReference_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
              .getDefaultInstance()
          : tableReference_;
    }

    /**
     *
     *
     * <pre>
     * Table that this ReadSession is reading from.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder
        getTableReferenceOrBuilder() {
      return tableReference_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
              .getDefaultInstance()
          : tableReference_;
    }

    public static final int TABLE_MODIFIERS_FIELD_NUMBER = 8;
    private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        tableModifiers_;

    /**
     *
     *
     * <pre>
     * Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
     *
     * @return Whether the tableModifiers field is set.
     */
    @java.lang.Override
    public boolean hasTableModifiers() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
     *
     * @return The tableModifiers.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        getTableModifiers() {
      return tableModifiers_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
              .getDefaultInstance()
          : tableModifiers_;
    }

    /**
     *
     *
     * <pre>
     * Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder
        getTableModifiersOrBuilder() {
      return tableModifiers_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
              .getDefaultInstance()
          : tableModifiers_;
    }

    public static final int SHARDING_STRATEGY_FIELD_NUMBER = 9;
    private int shardingStrategy_ = 0;

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among the streams.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
     *
     * @return The enum numeric value on the wire for shardingStrategy.
     */
    @java.lang.Override
    public int getShardingStrategyValue() {
      return shardingStrategy_;
    }

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among the streams.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
     *
     * @return The shardingStrategy.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
        getShardingStrategy() {
      com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy result =
          com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.forNumber(
              shardingStrategy_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getExpireTime());
      }
      for (int i = 0; i < streams_.size(); i++) {
        output.writeMessage(4, streams_.get(i));
      }
      if (schemaCase_ == 5) {
        output.writeMessage(
            5, (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_);
      }
      if (schemaCase_ == 6) {
        output.writeMessage(
            6, (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(7, getTableReference());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(8, getTableModifiers());
      }
      if (shardingStrategy_
          != com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
              .SHARDING_STRATEGY_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(9, shardingStrategy_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExpireTime());
      }
      for (int i = 0; i < streams_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, streams_.get(i));
      }
      if (schemaCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_);
      }
      if (schemaCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTableReference());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTableModifiers());
      }
      if (shardingStrategy_
          != com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
              .SHARDING_STRATEGY_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, shardingStrategy_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession) obj;

      if (!getName().equals(other.getName())) return false;
      if (hasExpireTime() != other.hasExpireTime()) return false;
      if (hasExpireTime()) {
        if (!getExpireTime().equals(other.getExpireTime())) return false;
      }
      if (!getStreamsList().equals(other.getStreamsList())) return false;
      if (hasTableReference() != other.hasTableReference()) return false;
      if (hasTableReference()) {
        if (!getTableReference().equals(other.getTableReference())) return false;
      }
      if (hasTableModifiers() != other.hasTableModifiers()) return false;
      if (hasTableModifiers()) {
        if (!getTableModifiers().equals(other.getTableModifiers())) return false;
      }
      if (shardingStrategy_ != other.shardingStrategy_) return false;
      if (!getSchemaCase().equals(other.getSchemaCase())) return false;
      switch (schemaCase_) {
        case 5:
          if (!getAvroSchema().equals(other.getAvroSchema())) return false;
          break;
        case 6:
          if (!getArrowSchema().equals(other.getArrowSchema())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasExpireTime()) {
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
      }
      if (getStreamsCount() > 0) {
        hash = (37 * hash) + STREAMS_FIELD_NUMBER;
        hash = (53 * hash) + getStreamsList().hashCode();
      }
      if (hasTableReference()) {
        hash = (37 * hash) + TABLE_REFERENCE_FIELD_NUMBER;
        hash = (53 * hash) + getTableReference().hashCode();
      }
      if (hasTableModifiers()) {
        hash = (37 * hash) + TABLE_MODIFIERS_FIELD_NUMBER;
        hash = (53 * hash) + getTableModifiers().hashCode();
      }
      hash = (37 * hash) + SHARDING_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + shardingStrategy_;
      switch (schemaCase_) {
        case 5:
          hash = (37 * hash) + AVRO_SCHEMA_FIELD_NUMBER;
          hash = (53 * hash) + getAvroSchema().hashCode();
          break;
        case 6:
          hash = (37 * hash) + ARROW_SCHEMA_FIELD_NUMBER;
          hash = (53 * hash) + getArrowSchema().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information returned from a `CreateReadSession` request.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ReadSession}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.ReadSession)
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSessionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.Builder.class);
      }

      // Construct using com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getExpireTimeFieldBuilder();
          getStreamsFieldBuilder();
          getTableReferenceFieldBuilder();
          getTableModifiersFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        expireTime_ = null;
        if (expireTimeBuilder_ != null) {
          expireTimeBuilder_.dispose();
          expireTimeBuilder_ = null;
        }
        if (avroSchemaBuilder_ != null) {
          avroSchemaBuilder_.clear();
        }
        if (arrowSchemaBuilder_ != null) {
          arrowSchemaBuilder_.clear();
        }
        if (streamsBuilder_ == null) {
          streams_ = java.util.Collections.emptyList();
        } else {
          streams_ = null;
          streamsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        tableReference_ = null;
        if (tableReferenceBuilder_ != null) {
          tableReferenceBuilder_.dispose();
          tableReferenceBuilder_ = null;
        }
        tableModifiers_ = null;
        if (tableModifiersBuilder_ != null) {
          tableModifiersBuilder_.dispose();
          tableModifiersBuilder_ = null;
        }
        shardingStrategy_ = 0;
        schemaCase_ = 0;
        schema_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession result) {
        if (streamsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            streams_ = java.util.Collections.unmodifiableList(streams_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.streams_ = streams_;
        } else {
          result.streams_ = streamsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.expireTime_ =
              expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.tableReference_ =
              tableReferenceBuilder_ == null ? tableReference_ : tableReferenceBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.tableModifiers_ =
              tableModifiersBuilder_ == null ? tableModifiers_ : tableModifiersBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.shardingStrategy_ = shardingStrategy_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession result) {
        result.schemaCase_ = schemaCase_;
        result.schema_ = this.schema_;
        if (schemaCase_ == 5 && avroSchemaBuilder_ != null) {
          result.schema_ = avroSchemaBuilder_.build();
        }
        if (schemaCase_ == 6 && arrowSchemaBuilder_ != null) {
          result.schema_ = arrowSchemaBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasExpireTime()) {
          mergeExpireTime(other.getExpireTime());
        }
        if (streamsBuilder_ == null) {
          if (!other.streams_.isEmpty()) {
            if (streams_.isEmpty()) {
              streams_ = other.streams_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureStreamsIsMutable();
              streams_.addAll(other.streams_);
            }
            onChanged();
          }
        } else {
          if (!other.streams_.isEmpty()) {
            if (streamsBuilder_.isEmpty()) {
              streamsBuilder_.dispose();
              streamsBuilder_ = null;
              streams_ = other.streams_;
              bitField0_ = (bitField0_ & ~0x00000010);
              streamsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getStreamsFieldBuilder()
                      : null;
            } else {
              streamsBuilder_.addAllMessages(other.streams_);
            }
          }
        }
        if (other.hasTableReference()) {
          mergeTableReference(other.getTableReference());
        }
        if (other.hasTableModifiers()) {
          mergeTableModifiers(other.getTableModifiers());
        }
        if (other.shardingStrategy_ != 0) {
          setShardingStrategyValue(other.getShardingStrategyValue());
        }
        switch (other.getSchemaCase()) {
          case AVRO_SCHEMA:
            {
              mergeAvroSchema(other.getAvroSchema());
              break;
            }
          case ARROW_SCHEMA:
            {
              mergeArrowSchema(other.getArrowSchema());
              break;
            }
          case SCHEMA_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 34:
                {
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream m =
                      input.readMessage(
                          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.parser(),
                          extensionRegistry);
                  if (streamsBuilder_ == null) {
                    ensureStreamsIsMutable();
                    streams_.add(m);
                  } else {
                    streamsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getAvroSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  schemaCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getArrowSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  schemaCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getTableReferenceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getTableModifiersFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 66
              case 72:
                {
                  shardingStrategy_ = input.readEnum();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 72
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int schemaCase_ = 0;
      private java.lang.Object schema_;

      public SchemaCase getSchemaCase() {
        return SchemaCase.forNumber(schemaCase_);
      }

      public Builder clearSchema() {
        schemaCase_ = 0;
        schema_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Unique identifier for the session, in the form
       * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique identifier for the session, in the form
       * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique identifier for the session, in the form
       * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique identifier for the session, in the form
       * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique identifier for the session, in the form
       * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp expireTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          expireTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       *
       * @return Whether the expireTime field is set.
       */
      public boolean hasExpireTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       *
       * @return The expireTime.
       */
      public com.google.protobuf.Timestamp getExpireTime() {
        if (expireTimeBuilder_ == null) {
          return expireTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : expireTime_;
        } else {
          return expireTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder setExpireTime(com.google.protobuf.Timestamp value) {
        if (expireTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          expireTime_ = value;
        } else {
          expireTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (expireTimeBuilder_ == null) {
          expireTime_ = builderForValue.build();
        } else {
          expireTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
        if (expireTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && expireTime_ != null
              && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getExpireTimeBuilder().mergeFrom(value);
          } else {
            expireTime_ = value;
          }
        } else {
          expireTimeBuilder_.mergeFrom(value);
        }
        if (expireTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder clearExpireTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        expireTime_ = null;
        if (expireTimeBuilder_ != null) {
          expireTimeBuilder_.dispose();
          expireTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getExpireTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
        if (expireTimeBuilder_ != null) {
          return expireTimeBuilder_.getMessageOrBuilder();
        } else {
          return expireTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : expireTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Time at which the session becomes invalid. After this time, subsequent
       * requests to read this Session will return errors.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getExpireTimeFieldBuilder() {
        if (expireTimeBuilder_ == null) {
          expireTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getExpireTime(), getParentForChildren(), isClean());
          expireTime_ = null;
        }
        return expireTimeBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder>
          avroSchemaBuilder_;

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       *
       * @return Whether the avroSchema field is set.
       */
      @java.lang.Override
      public boolean hasAvroSchema() {
        return schemaCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       *
       * @return The avroSchema.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema getAvroSchema() {
        if (avroSchemaBuilder_ == null) {
          if (schemaCase_ == 5) {
            return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
              .getDefaultInstance();
        } else {
          if (schemaCase_ == 5) {
            return avroSchemaBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       */
      public Builder setAvroSchema(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema value) {
        if (avroSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schema_ = value;
          onChanged();
        } else {
          avroSchemaBuilder_.setMessage(value);
        }
        schemaCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       */
      public Builder setAvroSchema(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder builderForValue) {
        if (avroSchemaBuilder_ == null) {
          schema_ = builderForValue.build();
          onChanged();
        } else {
          avroSchemaBuilder_.setMessage(builderForValue.build());
        }
        schemaCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       */
      public Builder mergeAvroSchema(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema value) {
        if (avroSchemaBuilder_ == null) {
          if (schemaCase_ == 5
              && schema_
                  != com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
                      .getDefaultInstance()) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.newBuilder(
                        (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schema_ = value;
          }
          onChanged();
        } else {
          if (schemaCase_ == 5) {
            avroSchemaBuilder_.mergeFrom(value);
          } else {
            avroSchemaBuilder_.setMessage(value);
          }
        }
        schemaCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       */
      public Builder clearAvroSchema() {
        if (avroSchemaBuilder_ == null) {
          if (schemaCase_ == 5) {
            schemaCase_ = 0;
            schema_ = null;
            onChanged();
          }
        } else {
          if (schemaCase_ == 5) {
            schemaCase_ = 0;
            schema_ = null;
          }
          avroSchemaBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder
          getAvroSchemaBuilder() {
        return getAvroSchemaFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder
          getAvroSchemaOrBuilder() {
        if ((schemaCase_ == 5) && (avroSchemaBuilder_ != null)) {
          return avroSchemaBuilder_.getMessageOrBuilder();
        } else {
          if (schemaCase_ == 5) {
            return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Avro schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder>
          getAvroSchemaFieldBuilder() {
        if (avroSchemaBuilder_ == null) {
          if (!(schemaCase_ == 5)) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.getDefaultInstance();
          }
          avroSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema,
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_,
                  getParentForChildren(),
                  isClean());
          schema_ = null;
        }
        schemaCase_ = 5;
        onChanged();
        return avroSchemaBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder>
          arrowSchemaBuilder_;

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       *
       * @return Whether the arrowSchema field is set.
       */
      @java.lang.Override
      public boolean hasArrowSchema() {
        return schemaCase_ == 6;
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       *
       * @return The arrowSchema.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema getArrowSchema() {
        if (arrowSchemaBuilder_ == null) {
          if (schemaCase_ == 6) {
            return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
              .getDefaultInstance();
        } else {
          if (schemaCase_ == 6) {
            return arrowSchemaBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       */
      public Builder setArrowSchema(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema value) {
        if (arrowSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schema_ = value;
          onChanged();
        } else {
          arrowSchemaBuilder_.setMessage(value);
        }
        schemaCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       */
      public Builder setArrowSchema(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder
              builderForValue) {
        if (arrowSchemaBuilder_ == null) {
          schema_ = builderForValue.build();
          onChanged();
        } else {
          arrowSchemaBuilder_.setMessage(builderForValue.build());
        }
        schemaCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       */
      public Builder mergeArrowSchema(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema value) {
        if (arrowSchemaBuilder_ == null) {
          if (schemaCase_ == 6
              && schema_
                  != com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
                      .getDefaultInstance()) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.newBuilder(
                        (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schema_ = value;
          }
          onChanged();
        } else {
          if (schemaCase_ == 6) {
            arrowSchemaBuilder_.mergeFrom(value);
          } else {
            arrowSchemaBuilder_.setMessage(value);
          }
        }
        schemaCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       */
      public Builder clearArrowSchema() {
        if (arrowSchemaBuilder_ == null) {
          if (schemaCase_ == 6) {
            schemaCase_ = 0;
            schema_ = null;
            onChanged();
          }
        } else {
          if (schemaCase_ == 6) {
            schemaCase_ = 0;
            schema_ = null;
          }
          arrowSchemaBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder
          getArrowSchemaBuilder() {
        return getArrowSchemaFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder
          getArrowSchemaOrBuilder() {
        if ((schemaCase_ == 6) && (arrowSchemaBuilder_ != null)) {
          return arrowSchemaBuilder_.getMessageOrBuilder();
        } else {
          if (schemaCase_ == 6) {
            return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Arrow schema.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder>
          getArrowSchemaFieldBuilder() {
        if (arrowSchemaBuilder_ == null) {
          if (!(schemaCase_ == 6)) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
                    .getDefaultInstance();
          }
          arrowSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema,
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_,
                  getParentForChildren(),
                  isClean());
          schema_ = null;
        }
        schemaCase_ = 6;
        onChanged();
        return arrowSchemaBuilder_;
      }

      private java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream> streams_ =
          java.util.Collections.emptyList();

      private void ensureStreamsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          streams_ =
              new java.util.ArrayList<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>(
                  streams_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          streamsBuilder_;

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>
          getStreamsList() {
        if (streamsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(streams_);
        } else {
          return streamsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public int getStreamsCount() {
        if (streamsBuilder_ == null) {
          return streams_.size();
        } else {
          return streamsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStreams(int index) {
        if (streamsBuilder_ == null) {
          return streams_.get(index);
        } else {
          return streamsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder setStreams(
          int index, com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStreamsIsMutable();
          streams_.set(index, value);
          onChanged();
        } else {
          streamsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder setStreams(
          int index,
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.set(index, builderForValue.build());
          onChanged();
        } else {
          streamsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder addStreams(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStreamsIsMutable();
          streams_.add(value);
          onChanged();
        } else {
          streamsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder addStreams(
          int index, com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStreamsIsMutable();
          streams_.add(index, value);
          onChanged();
        } else {
          streamsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder addStreams(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.add(builderForValue.build());
          onChanged();
        } else {
          streamsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder addStreams(
          int index,
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.add(index, builderForValue.build());
          onChanged();
        } else {
          streamsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder addAllStreams(
          java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>
              values) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, streams_);
          onChanged();
        } else {
          streamsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder clearStreams() {
        if (streamsBuilder_ == null) {
          streams_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          streamsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public Builder removeStreams(int index) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.remove(index);
          onChanged();
        } else {
          streamsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder getStreamsBuilder(
          int index) {
        return getStreamsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamsOrBuilder(
          int index) {
        if (streamsBuilder_ == null) {
          return streams_.get(index);
        } else {
          return streamsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getStreamsOrBuilderList() {
        if (streamsBuilder_ != null) {
          return streamsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(streams_);
        }
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder addStreamsBuilder() {
        return getStreamsFieldBuilder()
            .addBuilder(
                com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder addStreamsBuilder(
          int index) {
        return getStreamsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Streams associated with this session.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 4;</code>
       */
      public java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder>
          getStreamsBuilderList() {
        return getStreamsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getStreamsFieldBuilder() {
        if (streamsBuilder_ == null) {
          streamsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>(
                  streams_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
          streams_ = null;
        }
        return streamsBuilder_;
      }

      private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
          tableReference_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder>
          tableReferenceBuilder_;

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       *
       * @return Whether the tableReference field is set.
       */
      public boolean hasTableReference() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       *
       * @return The tableReference.
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
          getTableReference() {
        if (tableReferenceBuilder_ == null) {
          return tableReference_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                  .getDefaultInstance()
              : tableReference_;
        } else {
          return tableReferenceBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       */
      public Builder setTableReference(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference value) {
        if (tableReferenceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableReference_ = value;
        } else {
          tableReferenceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       */
      public Builder setTableReference(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder
              builderForValue) {
        if (tableReferenceBuilder_ == null) {
          tableReference_ = builderForValue.build();
        } else {
          tableReferenceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       */
      public Builder mergeTableReference(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference value) {
        if (tableReferenceBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && tableReference_ != null
              && tableReference_
                  != com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                      .getDefaultInstance()) {
            getTableReferenceBuilder().mergeFrom(value);
          } else {
            tableReference_ = value;
          }
        } else {
          tableReferenceBuilder_.mergeFrom(value);
        }
        if (tableReference_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       */
      public Builder clearTableReference() {
        bitField0_ = (bitField0_ & ~0x00000020);
        tableReference_ = null;
        if (tableReferenceBuilder_ != null) {
          tableReferenceBuilder_.dispose();
          tableReferenceBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder
          getTableReferenceBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getTableReferenceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder
          getTableReferenceOrBuilder() {
        if (tableReferenceBuilder_ != null) {
          return tableReferenceBuilder_.getMessageOrBuilder();
        } else {
          return tableReference_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                  .getDefaultInstance()
              : tableReference_;
        }
      }

      /**
       *
       *
       * <pre>
       * Table that this ReadSession is reading from.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder>
          getTableReferenceFieldBuilder() {
        if (tableReferenceBuilder_ == null) {
          tableReferenceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                      .Builder,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
                      .TableReferenceOrBuilder>(
                  getTableReference(), getParentForChildren(), isClean());
          tableReference_ = null;
        }
        return tableReferenceBuilder_;
      }

      private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
          tableModifiers_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder>
          tableModifiersBuilder_;

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       *
       * @return Whether the tableModifiers field is set.
       */
      public boolean hasTableModifiers() {
        return ((bitField0_ & 0x00000040) != 0);
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       *
       * @return The tableModifiers.
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
          getTableModifiers() {
        if (tableModifiersBuilder_ == null) {
          return tableModifiers_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                  .getDefaultInstance()
              : tableModifiers_;
        } else {
          return tableModifiersBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       */
      public Builder setTableModifiers(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers value) {
        if (tableModifiersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableModifiers_ = value;
        } else {
          tableModifiersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       */
      public Builder setTableModifiers(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder
              builderForValue) {
        if (tableModifiersBuilder_ == null) {
          tableModifiers_ = builderForValue.build();
        } else {
          tableModifiersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       */
      public Builder mergeTableModifiers(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers value) {
        if (tableModifiersBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && tableModifiers_ != null
              && tableModifiers_
                  != com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                      .getDefaultInstance()) {
            getTableModifiersBuilder().mergeFrom(value);
          } else {
            tableModifiers_ = value;
          }
        } else {
          tableModifiersBuilder_.mergeFrom(value);
        }
        if (tableModifiers_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       */
      public Builder clearTableModifiers() {
        bitField0_ = (bitField0_ & ~0x00000040);
        tableModifiers_ = null;
        if (tableModifiersBuilder_ != null) {
          tableModifiersBuilder_.dispose();
          tableModifiersBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder
          getTableModifiersBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getTableModifiersFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder
          getTableModifiersOrBuilder() {
        if (tableModifiersBuilder_ != null) {
          return tableModifiersBuilder_.getMessageOrBuilder();
        } else {
          return tableModifiers_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                  .getDefaultInstance()
              : tableModifiers_;
        }
      }

      /**
       *
       *
       * <pre>
       * Any modifiers which are applied when reading from the specified table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder>
          getTableModifiersFieldBuilder() {
        if (tableModifiersBuilder_ == null) {
          tableModifiersBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                      .Builder,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
                      .TableModifiersOrBuilder>(
                  getTableModifiers(), getParentForChildren(), isClean());
          tableModifiers_ = null;
        }
        return tableModifiersBuilder_;
      }

      private int shardingStrategy_ = 0;

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among the streams.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
       *
       * @return The enum numeric value on the wire for shardingStrategy.
       */
      @java.lang.Override
      public int getShardingStrategyValue() {
        return shardingStrategy_;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among the streams.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
       *
       * @param value The enum numeric value on the wire for shardingStrategy to set.
       * @return This builder for chaining.
       */
      public Builder setShardingStrategyValue(int value) {
        shardingStrategy_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among the streams.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
       *
       * @return The shardingStrategy.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
          getShardingStrategy() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy result =
            com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.forNumber(
                shardingStrategy_);
        return result == null
            ? com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among the streams.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
       *
       * @param value The shardingStrategy to set.
       * @return This builder for chaining.
       */
      public Builder setShardingStrategy(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000080;
        shardingStrategy_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among the streams.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShardingStrategy() {
        bitField0_ = (bitField0_ & ~0x00000080);
        shardingStrategy_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.ReadSession)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.ReadSession)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadSession> PARSER =
        new com.google.protobuf.AbstractParser<ReadSession>() {
          @java.lang.Override
          public ReadSession parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadSession> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadSession> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CreateReadSessionRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.CreateReadSessionRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to read.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the tableReference field is set.
     */
    boolean hasTableReference();

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to read.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The tableReference.
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        getTableReference();

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to read.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder
        getTableReferenceOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. String of the form `projects/{project_id}` indicating the
     * project this ReadSession is associated with. This is the project that will
     * be billed for usage.
     * </pre>
     *
     * <code>
     * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();

    /**
     *
     *
     * <pre>
     * Required. String of the form `projects/{project_id}` indicating the
     * project this ReadSession is associated with. This is the project that will
     * be billed for usage.
     * </pre>
     *
     * <code>
     * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Any modifiers to the Table (e.g. snapshot timestamp).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
     *
     * @return Whether the tableModifiers field is set.
     */
    boolean hasTableModifiers();

    /**
     *
     *
     * <pre>
     * Any modifiers to the Table (e.g. snapshot timestamp).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
     *
     * @return The tableModifiers.
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        getTableModifiers();

    /**
     *
     *
     * <pre>
     * Any modifiers to the Table (e.g. snapshot timestamp).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder
        getTableModifiersOrBuilder();

    /**
     *
     *
     * <pre>
     * Initial number of streams. If unset or 0, we will
     * provide a value of streams so as to produce reasonable throughput. Must be
     * non-negative. The number of streams may be lower than the requested number,
     * depending on the amount parallelism that is reasonable for the table and
     * the maximum amount of parallelism allowed by the system.
     *
     * Streams must be read starting from offset 0.
     * </pre>
     *
     * <code>int32 requested_streams = 3;</code>
     *
     * @return The requestedStreams.
     */
    int getRequestedStreams();

    /**
     *
     *
     * <pre>
     * Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
     *
     * @return Whether the readOptions field is set.
     */
    boolean hasReadOptions();

    /**
     *
     *
     * <pre>
     * Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
     *
     * @return The readOptions.
     */
    com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions getReadOptions();

    /**
     *
     *
     * <pre>
     * Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptionsOrBuilder
        getReadOptionsOrBuilder();

    /**
     *
     *
     * <pre>
     * Data output format. Currently default to Avro.
     * DATA_FORMAT_UNSPECIFIED not supported.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
     *
     * @return The enum numeric value on the wire for format.
     */
    int getFormatValue();

    /**
     *
     *
     * <pre>
     * Data output format. Currently default to Avro.
     * DATA_FORMAT_UNSPECIFIED not supported.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
     *
     * @return The format.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat getFormat();

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among multiple streams. Currently
     * defaults to liquid sharding.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
     *
     * @return The enum numeric value on the wire for shardingStrategy.
     */
    int getShardingStrategyValue();

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among multiple streams. Currently
     * defaults to liquid sharding.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
     *
     * @return The shardingStrategy.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy getShardingStrategy();
  }

  /**
   *
   *
   * <pre>
   * Creates a new read session, which may include additional options such as
   * requested parallelism, projection filters and constraints.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.CreateReadSessionRequest}
   */
  public static final class CreateReadSessionRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.CreateReadSessionRequest)
      CreateReadSessionRequestOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CreateReadSessionRequest.newBuilder() to construct.
    private CreateReadSessionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CreateReadSessionRequest() {
      parent_ = "";
      format_ = 0;
      shardingStrategy_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CreateReadSessionRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest.Builder
                  .class);
    }

    private int bitField0_;
    public static final int TABLE_REFERENCE_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        tableReference_;

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to read.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the tableReference field is set.
     */
    @java.lang.Override
    public boolean hasTableReference() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to read.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The tableReference.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
        getTableReference() {
      return tableReference_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
              .getDefaultInstance()
          : tableReference_;
    }

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to read.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder
        getTableReferenceOrBuilder() {
      return tableReference_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
              .getDefaultInstance()
          : tableReference_;
    }

    public static final int PARENT_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. String of the form `projects/{project_id}` indicating the
     * project this ReadSession is associated with. This is the project that will
     * be billed for usage.
     * </pre>
     *
     * <code>
     * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. String of the form `projects/{project_id}` indicating the
     * project this ReadSession is associated with. This is the project that will
     * be billed for usage.
     * </pre>
     *
     * <code>
     * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_MODIFIERS_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        tableModifiers_;

    /**
     *
     *
     * <pre>
     * Any modifiers to the Table (e.g. snapshot timestamp).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
     *
     * @return Whether the tableModifiers field is set.
     */
    @java.lang.Override
    public boolean hasTableModifiers() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Any modifiers to the Table (e.g. snapshot timestamp).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
     *
     * @return The tableModifiers.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
        getTableModifiers() {
      return tableModifiers_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
              .getDefaultInstance()
          : tableModifiers_;
    }

    /**
     *
     *
     * <pre>
     * Any modifiers to the Table (e.g. snapshot timestamp).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder
        getTableModifiersOrBuilder() {
      return tableModifiers_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
              .getDefaultInstance()
          : tableModifiers_;
    }

    public static final int REQUESTED_STREAMS_FIELD_NUMBER = 3;
    private int requestedStreams_ = 0;

    /**
     *
     *
     * <pre>
     * Initial number of streams. If unset or 0, we will
     * provide a value of streams so as to produce reasonable throughput. Must be
     * non-negative. The number of streams may be lower than the requested number,
     * depending on the amount parallelism that is reasonable for the table and
     * the maximum amount of parallelism allowed by the system.
     *
     * Streams must be read starting from offset 0.
     * </pre>
     *
     * <code>int32 requested_streams = 3;</code>
     *
     * @return The requestedStreams.
     */
    @java.lang.Override
    public int getRequestedStreams() {
      return requestedStreams_;
    }

    public static final int READ_OPTIONS_FIELD_NUMBER = 4;
    private com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions readOptions_;

    /**
     *
     *
     * <pre>
     * Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
     *
     * @return Whether the readOptions field is set.
     */
    @java.lang.Override
    public boolean hasReadOptions() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
     *
     * @return The readOptions.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions getReadOptions() {
      return readOptions_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions
              .getDefaultInstance()
          : readOptions_;
    }

    /**
     *
     *
     * <pre>
     * Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptionsOrBuilder
        getReadOptionsOrBuilder() {
      return readOptions_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions
              .getDefaultInstance()
          : readOptions_;
    }

    public static final int FORMAT_FIELD_NUMBER = 5;
    private int format_ = 0;

    /**
     *
     *
     * <pre>
     * Data output format. Currently default to Avro.
     * DATA_FORMAT_UNSPECIFIED not supported.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
     *
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override
    public int getFormatValue() {
      return format_;
    }

    /**
     *
     *
     * <pre>
     * Data output format. Currently default to Avro.
     * DATA_FORMAT_UNSPECIFIED not supported.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
     *
     * @return The format.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat getFormat() {
      com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat result =
          com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat.forNumber(format_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat.UNRECOGNIZED
          : result;
    }

    public static final int SHARDING_STRATEGY_FIELD_NUMBER = 7;
    private int shardingStrategy_ = 0;

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among multiple streams. Currently
     * defaults to liquid sharding.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
     *
     * @return The enum numeric value on the wire for shardingStrategy.
     */
    @java.lang.Override
    public int getShardingStrategyValue() {
      return shardingStrategy_;
    }

    /**
     *
     *
     * <pre>
     * The strategy to use for distributing data among multiple streams. Currently
     * defaults to liquid sharding.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
     *
     * @return The shardingStrategy.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
        getShardingStrategy() {
      com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy result =
          com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.forNumber(
              shardingStrategy_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getTableReference());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getTableModifiers());
      }
      if (requestedStreams_ != 0) {
        output.writeInt32(3, requestedStreams_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getReadOptions());
      }
      if (format_
          != com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat.DATA_FORMAT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(5, format_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, parent_);
      }
      if (shardingStrategy_
          != com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
              .SHARDING_STRATEGY_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(7, shardingStrategy_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTableReference());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTableModifiers());
      }
      if (requestedStreams_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, requestedStreams_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getReadOptions());
      }
      if (format_
          != com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat.DATA_FORMAT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, format_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, parent_);
      }
      if (shardingStrategy_
          != com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
              .SHARDING_STRATEGY_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, shardingStrategy_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest) obj;

      if (hasTableReference() != other.hasTableReference()) return false;
      if (hasTableReference()) {
        if (!getTableReference().equals(other.getTableReference())) return false;
      }
      if (!getParent().equals(other.getParent())) return false;
      if (hasTableModifiers() != other.hasTableModifiers()) return false;
      if (hasTableModifiers()) {
        if (!getTableModifiers().equals(other.getTableModifiers())) return false;
      }
      if (getRequestedStreams() != other.getRequestedStreams()) return false;
      if (hasReadOptions() != other.hasReadOptions()) return false;
      if (hasReadOptions()) {
        if (!getReadOptions().equals(other.getReadOptions())) return false;
      }
      if (format_ != other.format_) return false;
      if (shardingStrategy_ != other.shardingStrategy_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTableReference()) {
        hash = (37 * hash) + TABLE_REFERENCE_FIELD_NUMBER;
        hash = (53 * hash) + getTableReference().hashCode();
      }
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      if (hasTableModifiers()) {
        hash = (37 * hash) + TABLE_MODIFIERS_FIELD_NUMBER;
        hash = (53 * hash) + getTableModifiers().hashCode();
      }
      hash = (37 * hash) + REQUESTED_STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedStreams();
      if (hasReadOptions()) {
        hash = (37 * hash) + READ_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getReadOptions().hashCode();
      }
      hash = (37 * hash) + FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + format_;
      hash = (37 * hash) + SHARDING_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + shardingStrategy_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Creates a new read session, which may include additional options such as
     * requested parallelism, projection filters and constraints.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.CreateReadSessionRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.CreateReadSessionRequest)
        com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTableReferenceFieldBuilder();
          getTableModifiersFieldBuilder();
          getReadOptionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        tableReference_ = null;
        if (tableReferenceBuilder_ != null) {
          tableReferenceBuilder_.dispose();
          tableReferenceBuilder_ = null;
        }
        parent_ = "";
        tableModifiers_ = null;
        if (tableModifiersBuilder_ != null) {
          tableModifiersBuilder_.dispose();
          tableModifiersBuilder_ = null;
        }
        requestedStreams_ = 0;
        readOptions_ = null;
        if (readOptionsBuilder_ != null) {
          readOptionsBuilder_.dispose();
          readOptionsBuilder_ = null;
        }
        format_ = 0;
        shardingStrategy_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.tableReference_ =
              tableReferenceBuilder_ == null ? tableReference_ : tableReferenceBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.tableModifiers_ =
              tableModifiersBuilder_ == null ? tableModifiers_ : tableModifiersBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.requestedStreams_ = requestedStreams_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.readOptions_ =
              readOptionsBuilder_ == null ? readOptions_ : readOptionsBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.format_ = format_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.shardingStrategy_ = shardingStrategy_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
                .getDefaultInstance()) return this;
        if (other.hasTableReference()) {
          mergeTableReference(other.getTableReference());
        }
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasTableModifiers()) {
          mergeTableModifiers(other.getTableModifiers());
        }
        if (other.getRequestedStreams() != 0) {
          setRequestedStreams(other.getRequestedStreams());
        }
        if (other.hasReadOptions()) {
          mergeReadOptions(other.getReadOptions());
        }
        if (other.format_ != 0) {
          setFormatValue(other.getFormatValue());
        }
        if (other.shardingStrategy_ != 0) {
          setShardingStrategyValue(other.getShardingStrategyValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getTableReferenceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getTableModifiersFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 24:
                {
                  requestedStreams_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getReadOptionsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 34
              case 40:
                {
                  format_ = input.readEnum();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 40
              case 50:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 50
              case 56:
                {
                  shardingStrategy_ = input.readEnum();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 56
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
          tableReference_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder>
          tableReferenceBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the tableReference field is set.
       */
      public boolean hasTableReference() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The tableReference.
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
          getTableReference() {
        if (tableReferenceBuilder_ == null) {
          return tableReference_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                  .getDefaultInstance()
              : tableReference_;
        } else {
          return tableReferenceBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTableReference(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference value) {
        if (tableReferenceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableReference_ = value;
        } else {
          tableReferenceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTableReference(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder
              builderForValue) {
        if (tableReferenceBuilder_ == null) {
          tableReference_ = builderForValue.build();
        } else {
          tableReferenceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeTableReference(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference value) {
        if (tableReferenceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && tableReference_ != null
              && tableReference_
                  != com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                      .getDefaultInstance()) {
            getTableReferenceBuilder().mergeFrom(value);
          } else {
            tableReference_ = value;
          }
        } else {
          tableReferenceBuilder_.mergeFrom(value);
        }
        if (tableReference_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearTableReference() {
        bitField0_ = (bitField0_ & ~0x00000001);
        tableReference_ = null;
        if (tableReferenceBuilder_ != null) {
          tableReferenceBuilder_.dispose();
          tableReferenceBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder
          getTableReferenceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTableReferenceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder
          getTableReferenceOrBuilder() {
        if (tableReferenceBuilder_ != null) {
          return tableReferenceBuilder_.getMessageOrBuilder();
        } else {
          return tableReference_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                  .getDefaultInstance()
              : tableReference_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Reference to the table to read.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.TableReference table_reference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReferenceOrBuilder>
          getTableReferenceFieldBuilder() {
        if (tableReferenceBuilder_ == null) {
          tableReferenceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableReference
                      .Builder,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
                      .TableReferenceOrBuilder>(
                  getTableReference(), getParentForChildren(), isClean());
          tableReference_ = null;
        }
        return tableReferenceBuilder_;
      }

      private java.lang.Object parent_ = "";

      /**
       *
       *
       * <pre>
       * Required. String of the form `projects/{project_id}` indicating the
       * project this ReadSession is associated with. This is the project that will
       * be billed for usage.
       * </pre>
       *
       * <code>
       * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. String of the form `projects/{project_id}` indicating the
       * project this ReadSession is associated with. This is the project that will
       * be billed for usage.
       * </pre>
       *
       * <code>
       * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. String of the form `projects/{project_id}` indicating the
       * project this ReadSession is associated with. This is the project that will
       * be billed for usage.
       * </pre>
       *
       * <code>
       * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. String of the form `projects/{project_id}` indicating the
       * project this ReadSession is associated with. This is the project that will
       * be billed for usage.
       * </pre>
       *
       * <code>
       * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. String of the form `projects/{project_id}` indicating the
       * project this ReadSession is associated with. This is the project that will
       * be billed for usage.
       * </pre>
       *
       * <code>
       * string parent = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
          tableModifiers_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder>
          tableModifiersBuilder_;

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       *
       * @return Whether the tableModifiers field is set.
       */
      public boolean hasTableModifiers() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       *
       * @return The tableModifiers.
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
          getTableModifiers() {
        if (tableModifiersBuilder_ == null) {
          return tableModifiers_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                  .getDefaultInstance()
              : tableModifiers_;
        } else {
          return tableModifiersBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       */
      public Builder setTableModifiers(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers value) {
        if (tableModifiersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableModifiers_ = value;
        } else {
          tableModifiersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       */
      public Builder setTableModifiers(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder
              builderForValue) {
        if (tableModifiersBuilder_ == null) {
          tableModifiers_ = builderForValue.build();
        } else {
          tableModifiersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       */
      public Builder mergeTableModifiers(
          com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers value) {
        if (tableModifiersBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && tableModifiers_ != null
              && tableModifiers_
                  != com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                      .getDefaultInstance()) {
            getTableModifiersBuilder().mergeFrom(value);
          } else {
            tableModifiers_ = value;
          }
        } else {
          tableModifiersBuilder_.mergeFrom(value);
        }
        if (tableModifiers_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       */
      public Builder clearTableModifiers() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tableModifiers_ = null;
        if (tableModifiersBuilder_ != null) {
          tableModifiersBuilder_.dispose();
          tableModifiersBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder
          getTableModifiersBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTableModifiersFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder
          getTableModifiersOrBuilder() {
        if (tableModifiersBuilder_ != null) {
          return tableModifiersBuilder_.getMessageOrBuilder();
        } else {
          return tableModifiers_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                  .getDefaultInstance()
              : tableModifiers_;
        }
      }

      /**
       *
       *
       * <pre>
       * Any modifiers to the Table (e.g. snapshot timestamp).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableModifiers table_modifiers = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers.Builder,
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiersOrBuilder>
          getTableModifiersFieldBuilder() {
        if (tableModifiersBuilder_ == null) {
          tableModifiersBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.TableModifiers
                      .Builder,
                  com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto
                      .TableModifiersOrBuilder>(
                  getTableModifiers(), getParentForChildren(), isClean());
          tableModifiers_ = null;
        }
        return tableModifiersBuilder_;
      }

      private int requestedStreams_;

      /**
       *
       *
       * <pre>
       * Initial number of streams. If unset or 0, we will
       * provide a value of streams so as to produce reasonable throughput. Must be
       * non-negative. The number of streams may be lower than the requested number,
       * depending on the amount parallelism that is reasonable for the table and
       * the maximum amount of parallelism allowed by the system.
       *
       * Streams must be read starting from offset 0.
       * </pre>
       *
       * <code>int32 requested_streams = 3;</code>
       *
       * @return The requestedStreams.
       */
      @java.lang.Override
      public int getRequestedStreams() {
        return requestedStreams_;
      }

      /**
       *
       *
       * <pre>
       * Initial number of streams. If unset or 0, we will
       * provide a value of streams so as to produce reasonable throughput. Must be
       * non-negative. The number of streams may be lower than the requested number,
       * depending on the amount parallelism that is reasonable for the table and
       * the maximum amount of parallelism allowed by the system.
       *
       * Streams must be read starting from offset 0.
       * </pre>
       *
       * <code>int32 requested_streams = 3;</code>
       *
       * @param value The requestedStreams to set.
       * @return This builder for chaining.
       */
      public Builder setRequestedStreams(int value) {

        requestedStreams_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Initial number of streams. If unset or 0, we will
       * provide a value of streams so as to produce reasonable throughput. Must be
       * non-negative. The number of streams may be lower than the requested number,
       * depending on the amount parallelism that is reasonable for the table and
       * the maximum amount of parallelism allowed by the system.
       *
       * Streams must be read starting from offset 0.
       * </pre>
       *
       * <code>int32 requested_streams = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequestedStreams() {
        bitField0_ = (bitField0_ & ~0x00000008);
        requestedStreams_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions readOptions_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions,
              com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptionsOrBuilder>
          readOptionsBuilder_;

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       *
       * @return Whether the readOptions field is set.
       */
      public boolean hasReadOptions() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       *
       * @return The readOptions.
       */
      public com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions
          getReadOptions() {
        if (readOptionsBuilder_ == null) {
          return readOptions_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions
                  .getDefaultInstance()
              : readOptions_;
        } else {
          return readOptionsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       */
      public Builder setReadOptions(
          com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions value) {
        if (readOptionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          readOptions_ = value;
        } else {
          readOptionsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       */
      public Builder setReadOptions(
          com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions.Builder
              builderForValue) {
        if (readOptionsBuilder_ == null) {
          readOptions_ = builderForValue.build();
        } else {
          readOptionsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       */
      public Builder mergeReadOptions(
          com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions value) {
        if (readOptionsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && readOptions_ != null
              && readOptions_
                  != com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions
                      .getDefaultInstance()) {
            getReadOptionsBuilder().mergeFrom(value);
          } else {
            readOptions_ = value;
          }
        } else {
          readOptionsBuilder_.mergeFrom(value);
        }
        if (readOptions_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       */
      public Builder clearReadOptions() {
        bitField0_ = (bitField0_ & ~0x00000010);
        readOptions_ = null;
        if (readOptionsBuilder_ != null) {
          readOptionsBuilder_.dispose();
          readOptionsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions.Builder
          getReadOptionsBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getReadOptionsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptionsOrBuilder
          getReadOptionsOrBuilder() {
        if (readOptionsBuilder_ != null) {
          return readOptionsBuilder_.getMessageOrBuilder();
        } else {
          return readOptions_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions
                  .getDefaultInstance()
              : readOptions_;
        }
      }

      /**
       *
       *
       * <pre>
       * Read options for this session (e.g. column selection, filters).
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.TableReadOptions read_options = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions,
              com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptionsOrBuilder>
          getReadOptionsFieldBuilder() {
        if (readOptionsBuilder_ == null) {
          readOptionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions,
                  com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptions.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.ReadOptions.TableReadOptionsOrBuilder>(
                  getReadOptions(), getParentForChildren(), isClean());
          readOptions_ = null;
        }
        return readOptionsBuilder_;
      }

      private int format_ = 0;

      /**
       *
       *
       * <pre>
       * Data output format. Currently default to Avro.
       * DATA_FORMAT_UNSPECIFIED not supported.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
       *
       * @return The enum numeric value on the wire for format.
       */
      @java.lang.Override
      public int getFormatValue() {
        return format_;
      }

      /**
       *
       *
       * <pre>
       * Data output format. Currently default to Avro.
       * DATA_FORMAT_UNSPECIFIED not supported.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
       *
       * @param value The enum numeric value on the wire for format to set.
       * @return This builder for chaining.
       */
      public Builder setFormatValue(int value) {
        format_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Data output format. Currently default to Avro.
       * DATA_FORMAT_UNSPECIFIED not supported.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
       *
       * @return The format.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat getFormat() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat result =
            com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat.forNumber(format_);
        return result == null
            ? com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Data output format. Currently default to Avro.
       * DATA_FORMAT_UNSPECIFIED not supported.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
       *
       * @param value The format to set.
       * @return This builder for chaining.
       */
      public Builder setFormat(com.google.cloud.bigquery.storage.v1beta1.Storage.DataFormat value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        format_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Data output format. Currently default to Avro.
       * DATA_FORMAT_UNSPECIFIED not supported.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.DataFormat format = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFormat() {
        bitField0_ = (bitField0_ & ~0x00000020);
        format_ = 0;
        onChanged();
        return this;
      }

      private int shardingStrategy_ = 0;

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among multiple streams. Currently
       * defaults to liquid sharding.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
       *
       * @return The enum numeric value on the wire for shardingStrategy.
       */
      @java.lang.Override
      public int getShardingStrategyValue() {
        return shardingStrategy_;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among multiple streams. Currently
       * defaults to liquid sharding.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
       *
       * @param value The enum numeric value on the wire for shardingStrategy to set.
       * @return This builder for chaining.
       */
      public Builder setShardingStrategyValue(int value) {
        shardingStrategy_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among multiple streams. Currently
       * defaults to liquid sharding.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
       *
       * @return The shardingStrategy.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy
          getShardingStrategy() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy result =
            com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.forNumber(
                shardingStrategy_);
        return result == null
            ? com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among multiple streams. Currently
       * defaults to liquid sharding.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
       *
       * @param value The shardingStrategy to set.
       * @return This builder for chaining.
       */
      public Builder setShardingStrategy(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ShardingStrategy value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000040;
        shardingStrategy_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The strategy to use for distributing data among multiple streams. Currently
       * defaults to liquid sharding.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ShardingStrategy sharding_strategy = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShardingStrategy() {
        bitField0_ = (bitField0_ & ~0x00000040);
        shardingStrategy_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.CreateReadSessionRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.CreateReadSessionRequest)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreateReadSessionRequest> PARSER =
        new com.google.protobuf.AbstractParser<CreateReadSessionRequest>() {
          @java.lang.Override
          public CreateReadSessionRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CreateReadSessionRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateReadSessionRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.CreateReadSessionRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadRowsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.ReadRowsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Identifier of the position in the stream to start reading from.
     * The offset requested must be less than the last row read from ReadRows.
     * Requesting a larger offset is undefined.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the readPosition field is set.
     */
    boolean hasReadPosition();

    /**
     *
     *
     * <pre>
     * Required. Identifier of the position in the stream to start reading from.
     * The offset requested must be less than the last row read from ReadRows.
     * Requesting a larger offset is undefined.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The readPosition.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition getReadPosition();

    /**
     *
     *
     * <pre>
     * Required. Identifier of the position in the stream to start reading from.
     * The offset requested must be less than the last row read from ReadRows.
     * Requesting a larger offset is undefined.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPositionOrBuilder
        getReadPositionOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Requesting row data via `ReadRows` must provide Stream position information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ReadRowsRequest}
   */
  public static final class ReadRowsRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.ReadRowsRequest)
      ReadRowsRequestOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadRowsRequest.newBuilder() to construct.
    private ReadRowsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadRowsRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadRowsRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest.Builder.class);
    }

    private int bitField0_;
    public static final int READ_POSITION_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition readPosition_;

    /**
     *
     *
     * <pre>
     * Required. Identifier of the position in the stream to start reading from.
     * The offset requested must be less than the last row read from ReadRows.
     * Requesting a larger offset is undefined.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the readPosition field is set.
     */
    @java.lang.Override
    public boolean hasReadPosition() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Identifier of the position in the stream to start reading from.
     * The offset requested must be less than the last row read from ReadRows.
     * Requesting a larger offset is undefined.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The readPosition.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition getReadPosition() {
      return readPosition_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.getDefaultInstance()
          : readPosition_;
    }

    /**
     *
     *
     * <pre>
     * Required. Identifier of the position in the stream to start reading from.
     * The offset requested must be less than the last row read from ReadRows.
     * Requesting a larger offset is undefined.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPositionOrBuilder
        getReadPositionOrBuilder() {
      return readPosition_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.getDefaultInstance()
          : readPosition_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getReadPosition());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReadPosition());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest) obj;

      if (hasReadPosition() != other.hasReadPosition()) return false;
      if (hasReadPosition()) {
        if (!getReadPosition().equals(other.getReadPosition())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReadPosition()) {
        hash = (37 * hash) + READ_POSITION_FIELD_NUMBER;
        hash = (53 * hash) + getReadPosition().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Requesting row data via `ReadRows` must provide Stream position information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ReadRowsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.ReadRowsRequest)
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getReadPositionFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        readPosition_ = null;
        if (readPositionBuilder_ != null) {
          readPositionBuilder_.dispose();
          readPositionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.readPosition_ =
              readPositionBuilder_ == null ? readPosition_ : readPositionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
                .getDefaultInstance()) return this;
        if (other.hasReadPosition()) {
          mergeReadPosition(other.getReadPosition());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getReadPositionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition readPosition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPositionOrBuilder>
          readPositionBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the readPosition field is set.
       */
      public boolean hasReadPosition() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The readPosition.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition getReadPosition() {
        if (readPositionBuilder_ == null) {
          return readPosition_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
                  .getDefaultInstance()
              : readPosition_;
        } else {
          return readPositionBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReadPosition(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition value) {
        if (readPositionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          readPosition_ = value;
        } else {
          readPositionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReadPosition(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.Builder
              builderForValue) {
        if (readPositionBuilder_ == null) {
          readPosition_ = builderForValue.build();
        } else {
          readPositionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeReadPosition(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition value) {
        if (readPositionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && readPosition_ != null
              && readPosition_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
                      .getDefaultInstance()) {
            getReadPositionBuilder().mergeFrom(value);
          } else {
            readPosition_ = value;
          }
        } else {
          readPositionBuilder_.mergeFrom(value);
        }
        if (readPosition_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearReadPosition() {
        bitField0_ = (bitField0_ & ~0x00000001);
        readPosition_ = null;
        if (readPositionBuilder_ != null) {
          readPositionBuilder_.dispose();
          readPositionBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.Builder
          getReadPositionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getReadPositionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPositionOrBuilder
          getReadPositionOrBuilder() {
        if (readPositionBuilder_ != null) {
          return readPositionBuilder_.getMessageOrBuilder();
        } else {
          return readPosition_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition
                  .getDefaultInstance()
              : readPosition_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Identifier of the position in the stream to start reading from.
       * The offset requested must be less than the last row read from ReadRows.
       * Requesting a larger offset is undefined.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.StreamPosition read_position = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPositionOrBuilder>
          getReadPositionFieldBuilder() {
        if (readPositionBuilder_ == null) {
          readPositionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPosition.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamPositionOrBuilder>(
                  getReadPosition(), getParentForChildren(), isClean());
          readPosition_ = null;
        }
        return readPositionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.ReadRowsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.ReadRowsRequest)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadRowsRequest> PARSER =
        new com.google.protobuf.AbstractParser<ReadRowsRequest>() {
          @java.lang.Override
          public ReadRowsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadRowsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadRowsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StreamStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.StreamStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of estimated rows in the current stream. May change over time as
     * different readers in the stream progress at rates which are relatively fast
     * or slow.
     * </pre>
     *
     * <code>int64 estimated_row_count = 1;</code>
     *
     * @return The estimatedRowCount.
     */
    long getEstimatedRowCount();

    /**
     *
     *
     * <pre>
     * A value in the range [0.0, 1.0] that represents the fraction of rows
     * assigned to this stream that have been processed by the server. In the
     * presence of read filters, the server may process more rows than it returns,
     * so this value reflects progress through the pre-filtering rows.
     *
     * This value is only populated for sessions created through the BALANCED
     * sharding strategy.
     * </pre>
     *
     * <code>float fraction_consumed = 2;</code>
     *
     * @return The fractionConsumed.
     */
    float getFractionConsumed();

    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
     *
     * @return Whether the progress field is set.
     */
    boolean hasProgress();

    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
     *
     * @return The progress.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Progress getProgress();

    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.ProgressOrBuilder getProgressOrBuilder();

    /**
     *
     *
     * <pre>
     * Whether this stream can be split. For sessions that use the LIQUID sharding
     * strategy, this value is always false. For BALANCED sessions, this value is
     * false when enough data have been read such that no more splits are possible
     * at that point or beyond. For small tables or streams that are the result of
     * a chain of splits, this value may never be true.
     * </pre>
     *
     * <code>bool is_splittable = 3;</code>
     *
     * @return The isSplittable.
     */
    boolean getIsSplittable();
  }

  /**
   *
   *
   * <pre>
   * Progress information for a given Stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.StreamStatus}
   */
  public static final class StreamStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.StreamStatus)
      StreamStatusOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use StreamStatus.newBuilder() to construct.
    private StreamStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StreamStatus() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StreamStatus();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.Builder.class);
    }

    private int bitField0_;
    public static final int ESTIMATED_ROW_COUNT_FIELD_NUMBER = 1;
    private long estimatedRowCount_ = 0L;

    /**
     *
     *
     * <pre>
     * Number of estimated rows in the current stream. May change over time as
     * different readers in the stream progress at rates which are relatively fast
     * or slow.
     * </pre>
     *
     * <code>int64 estimated_row_count = 1;</code>
     *
     * @return The estimatedRowCount.
     */
    @java.lang.Override
    public long getEstimatedRowCount() {
      return estimatedRowCount_;
    }

    public static final int FRACTION_CONSUMED_FIELD_NUMBER = 2;
    private float fractionConsumed_ = 0F;

    /**
     *
     *
     * <pre>
     * A value in the range [0.0, 1.0] that represents the fraction of rows
     * assigned to this stream that have been processed by the server. In the
     * presence of read filters, the server may process more rows than it returns,
     * so this value reflects progress through the pre-filtering rows.
     *
     * This value is only populated for sessions created through the BALANCED
     * sharding strategy.
     * </pre>
     *
     * <code>float fraction_consumed = 2;</code>
     *
     * @return The fractionConsumed.
     */
    @java.lang.Override
    public float getFractionConsumed() {
      return fractionConsumed_;
    }

    public static final int PROGRESS_FIELD_NUMBER = 4;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.Progress progress_;

    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
     *
     * @return Whether the progress field is set.
     */
    @java.lang.Override
    public boolean hasProgress() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
     *
     * @return The progress.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Progress getProgress() {
      return progress_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.getDefaultInstance()
          : progress_;
    }

    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ProgressOrBuilder
        getProgressOrBuilder() {
      return progress_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.getDefaultInstance()
          : progress_;
    }

    public static final int IS_SPLITTABLE_FIELD_NUMBER = 3;
    private boolean isSplittable_ = false;

    /**
     *
     *
     * <pre>
     * Whether this stream can be split. For sessions that use the LIQUID sharding
     * strategy, this value is always false. For BALANCED sessions, this value is
     * false when enough data have been read such that no more splits are possible
     * at that point or beyond. For small tables or streams that are the result of
     * a chain of splits, this value may never be true.
     * </pre>
     *
     * <code>bool is_splittable = 3;</code>
     *
     * @return The isSplittable.
     */
    @java.lang.Override
    public boolean getIsSplittable() {
      return isSplittable_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (estimatedRowCount_ != 0L) {
        output.writeInt64(1, estimatedRowCount_);
      }
      if (java.lang.Float.floatToRawIntBits(fractionConsumed_) != 0) {
        output.writeFloat(2, fractionConsumed_);
      }
      if (isSplittable_ != false) {
        output.writeBool(3, isSplittable_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getProgress());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (estimatedRowCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, estimatedRowCount_);
      }
      if (java.lang.Float.floatToRawIntBits(fractionConsumed_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, fractionConsumed_);
      }
      if (isSplittable_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isSplittable_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getProgress());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus) obj;

      if (getEstimatedRowCount() != other.getEstimatedRowCount()) return false;
      if (java.lang.Float.floatToIntBits(getFractionConsumed())
          != java.lang.Float.floatToIntBits(other.getFractionConsumed())) return false;
      if (hasProgress() != other.hasProgress()) return false;
      if (hasProgress()) {
        if (!getProgress().equals(other.getProgress())) return false;
      }
      if (getIsSplittable() != other.getIsSplittable()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ESTIMATED_ROW_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEstimatedRowCount());
      hash = (37 * hash) + FRACTION_CONSUMED_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getFractionConsumed());
      if (hasProgress()) {
        hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
        hash = (53 * hash) + getProgress().hashCode();
      }
      hash = (37 * hash) + IS_SPLITTABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsSplittable());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Progress information for a given Stream.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.StreamStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.StreamStatus)
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.Builder.class);
      }

      // Construct using com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getProgressFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        estimatedRowCount_ = 0L;
        fractionConsumed_ = 0F;
        progress_ = null;
        if (progressBuilder_ != null) {
          progressBuilder_.dispose();
          progressBuilder_ = null;
        }
        isSplittable_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.estimatedRowCount_ = estimatedRowCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fractionConsumed_ = fractionConsumed_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.progress_ = progressBuilder_ == null ? progress_ : progressBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.isSplittable_ = isSplittable_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.getDefaultInstance())
          return this;
        if (other.getEstimatedRowCount() != 0L) {
          setEstimatedRowCount(other.getEstimatedRowCount());
        }
        if (other.getFractionConsumed() != 0F) {
          setFractionConsumed(other.getFractionConsumed());
        }
        if (other.hasProgress()) {
          mergeProgress(other.getProgress());
        }
        if (other.getIsSplittable() != false) {
          setIsSplittable(other.getIsSplittable());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  estimatedRowCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 21:
                {
                  fractionConsumed_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 24:
                {
                  isSplittable_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getProgressFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long estimatedRowCount_;

      /**
       *
       *
       * <pre>
       * Number of estimated rows in the current stream. May change over time as
       * different readers in the stream progress at rates which are relatively fast
       * or slow.
       * </pre>
       *
       * <code>int64 estimated_row_count = 1;</code>
       *
       * @return The estimatedRowCount.
       */
      @java.lang.Override
      public long getEstimatedRowCount() {
        return estimatedRowCount_;
      }

      /**
       *
       *
       * <pre>
       * Number of estimated rows in the current stream. May change over time as
       * different readers in the stream progress at rates which are relatively fast
       * or slow.
       * </pre>
       *
       * <code>int64 estimated_row_count = 1;</code>
       *
       * @param value The estimatedRowCount to set.
       * @return This builder for chaining.
       */
      public Builder setEstimatedRowCount(long value) {

        estimatedRowCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Number of estimated rows in the current stream. May change over time as
       * different readers in the stream progress at rates which are relatively fast
       * or slow.
       * </pre>
       *
       * <code>int64 estimated_row_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEstimatedRowCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        estimatedRowCount_ = 0L;
        onChanged();
        return this;
      }

      private float fractionConsumed_;

      /**
       *
       *
       * <pre>
       * A value in the range [0.0, 1.0] that represents the fraction of rows
       * assigned to this stream that have been processed by the server. In the
       * presence of read filters, the server may process more rows than it returns,
       * so this value reflects progress through the pre-filtering rows.
       *
       * This value is only populated for sessions created through the BALANCED
       * sharding strategy.
       * </pre>
       *
       * <code>float fraction_consumed = 2;</code>
       *
       * @return The fractionConsumed.
       */
      @java.lang.Override
      public float getFractionConsumed() {
        return fractionConsumed_;
      }

      /**
       *
       *
       * <pre>
       * A value in the range [0.0, 1.0] that represents the fraction of rows
       * assigned to this stream that have been processed by the server. In the
       * presence of read filters, the server may process more rows than it returns,
       * so this value reflects progress through the pre-filtering rows.
       *
       * This value is only populated for sessions created through the BALANCED
       * sharding strategy.
       * </pre>
       *
       * <code>float fraction_consumed = 2;</code>
       *
       * @param value The fractionConsumed to set.
       * @return This builder for chaining.
       */
      public Builder setFractionConsumed(float value) {

        fractionConsumed_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A value in the range [0.0, 1.0] that represents the fraction of rows
       * assigned to this stream that have been processed by the server. In the
       * presence of read filters, the server may process more rows than it returns,
       * so this value reflects progress through the pre-filtering rows.
       *
       * This value is only populated for sessions created through the BALANCED
       * sharding strategy.
       * </pre>
       *
       * <code>float fraction_consumed = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFractionConsumed() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fractionConsumed_ = 0F;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.storage.v1beta1.Storage.Progress progress_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Progress,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ProgressOrBuilder>
          progressBuilder_;

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       *
       * @return Whether the progress field is set.
       */
      public boolean hasProgress() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       *
       * @return The progress.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Progress getProgress() {
        if (progressBuilder_ == null) {
          return progress_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.getDefaultInstance()
              : progress_;
        } else {
          return progressBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       */
      public Builder setProgress(com.google.cloud.bigquery.storage.v1beta1.Storage.Progress value) {
        if (progressBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          progress_ = value;
        } else {
          progressBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       */
      public Builder setProgress(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.Builder builderForValue) {
        if (progressBuilder_ == null) {
          progress_ = builderForValue.build();
        } else {
          progressBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       */
      public Builder mergeProgress(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Progress value) {
        if (progressBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && progress_ != null
              && progress_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.Progress
                      .getDefaultInstance()) {
            getProgressBuilder().mergeFrom(value);
          } else {
            progress_ = value;
          }
        } else {
          progressBuilder_.mergeFrom(value);
        }
        if (progress_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       */
      public Builder clearProgress() {
        bitField0_ = (bitField0_ & ~0x00000004);
        progress_ = null;
        if (progressBuilder_ != null) {
          progressBuilder_.dispose();
          progressBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.Builder
          getProgressBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getProgressFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ProgressOrBuilder
          getProgressOrBuilder() {
        if (progressBuilder_ != null) {
          return progressBuilder_.getMessageOrBuilder();
        } else {
          return progress_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.getDefaultInstance()
              : progress_;
        }
      }

      /**
       *
       *
       * <pre>
       * Represents the progress of the current stream.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Progress progress = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Progress,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ProgressOrBuilder>
          getProgressFieldBuilder() {
        if (progressBuilder_ == null) {
          progressBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Progress,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.ProgressOrBuilder>(
                  getProgress(), getParentForChildren(), isClean());
          progress_ = null;
        }
        return progressBuilder_;
      }

      private boolean isSplittable_;

      /**
       *
       *
       * <pre>
       * Whether this stream can be split. For sessions that use the LIQUID sharding
       * strategy, this value is always false. For BALANCED sessions, this value is
       * false when enough data have been read such that no more splits are possible
       * at that point or beyond. For small tables or streams that are the result of
       * a chain of splits, this value may never be true.
       * </pre>
       *
       * <code>bool is_splittable = 3;</code>
       *
       * @return The isSplittable.
       */
      @java.lang.Override
      public boolean getIsSplittable() {
        return isSplittable_;
      }

      /**
       *
       *
       * <pre>
       * Whether this stream can be split. For sessions that use the LIQUID sharding
       * strategy, this value is always false. For BALANCED sessions, this value is
       * false when enough data have been read such that no more splits are possible
       * at that point or beyond. For small tables or streams that are the result of
       * a chain of splits, this value may never be true.
       * </pre>
       *
       * <code>bool is_splittable = 3;</code>
       *
       * @param value The isSplittable to set.
       * @return This builder for chaining.
       */
      public Builder setIsSplittable(boolean value) {

        isSplittable_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether this stream can be split. For sessions that use the LIQUID sharding
       * strategy, this value is always false. For BALANCED sessions, this value is
       * false when enough data have been read such that no more splits are possible
       * at that point or beyond. For small tables or streams that are the result of
       * a chain of splits, this value may never be true.
       * </pre>
       *
       * <code>bool is_splittable = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsSplittable() {
        bitField0_ = (bitField0_ & ~0x00000008);
        isSplittable_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.StreamStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.StreamStatus)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StreamStatus> PARSER =
        new com.google.protobuf.AbstractParser<StreamStatus>() {
          @java.lang.Override
          public StreamStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StreamStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StreamStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ProgressOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.Progress)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The fraction of rows assigned to the stream that have been processed by the
     * server so far, not including the rows in the current response message.
     *
     * This value, along with `at_response_end`, can be used to interpolate the
     * progress made as the rows in the message are being processed using the
     * following formula: `at_response_start + (at_response_end -
     * at_response_start) * rows_processed_from_response / rows_in_response`.
     *
     * Note that if a filter is provided, the `at_response_end` value of the
     * previous response may not necessarily be equal to the `at_response_start`
     * value of the current response.
     * </pre>
     *
     * <code>float at_response_start = 1;</code>
     *
     * @return The atResponseStart.
     */
    float getAtResponseStart();

    /**
     *
     *
     * <pre>
     * Similar to `at_response_start`, except that this value includes the rows in
     * the current response.
     * </pre>
     *
     * <code>float at_response_end = 2;</code>
     *
     * @return The atResponseEnd.
     */
    float getAtResponseEnd();
  }

  /** Protobuf type {@code google.cloud.bigquery.storage.v1beta1.Progress} */
  public static final class Progress extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.Progress)
      ProgressOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Progress.newBuilder() to construct.
    private Progress(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Progress() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Progress();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_Progress_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_Progress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.Builder.class);
    }

    public static final int AT_RESPONSE_START_FIELD_NUMBER = 1;
    private float atResponseStart_ = 0F;

    /**
     *
     *
     * <pre>
     * The fraction of rows assigned to the stream that have been processed by the
     * server so far, not including the rows in the current response message.
     *
     * This value, along with `at_response_end`, can be used to interpolate the
     * progress made as the rows in the message are being processed using the
     * following formula: `at_response_start + (at_response_end -
     * at_response_start) * rows_processed_from_response / rows_in_response`.
     *
     * Note that if a filter is provided, the `at_response_end` value of the
     * previous response may not necessarily be equal to the `at_response_start`
     * value of the current response.
     * </pre>
     *
     * <code>float at_response_start = 1;</code>
     *
     * @return The atResponseStart.
     */
    @java.lang.Override
    public float getAtResponseStart() {
      return atResponseStart_;
    }

    public static final int AT_RESPONSE_END_FIELD_NUMBER = 2;
    private float atResponseEnd_ = 0F;

    /**
     *
     *
     * <pre>
     * Similar to `at_response_start`, except that this value includes the rows in
     * the current response.
     * </pre>
     *
     * <code>float at_response_end = 2;</code>
     *
     * @return The atResponseEnd.
     */
    @java.lang.Override
    public float getAtResponseEnd() {
      return atResponseEnd_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(atResponseStart_) != 0) {
        output.writeFloat(1, atResponseStart_);
      }
      if (java.lang.Float.floatToRawIntBits(atResponseEnd_) != 0) {
        output.writeFloat(2, atResponseEnd_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(atResponseStart_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, atResponseStart_);
      }
      if (java.lang.Float.floatToRawIntBits(atResponseEnd_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, atResponseEnd_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.Progress)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.Progress other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.Progress) obj;

      if (java.lang.Float.floatToIntBits(getAtResponseStart())
          != java.lang.Float.floatToIntBits(other.getAtResponseStart())) return false;
      if (java.lang.Float.floatToIntBits(getAtResponseEnd())
          != java.lang.Float.floatToIntBits(other.getAtResponseEnd())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AT_RESPONSE_START_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAtResponseStart());
      hash = (37 * hash) + AT_RESPONSE_END_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAtResponseEnd());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.Progress prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /** Protobuf type {@code google.cloud.bigquery.storage.v1beta1.Progress} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.Progress)
        com.google.cloud.bigquery.storage.v1beta1.Storage.ProgressOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_Progress_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_Progress_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.Builder.class);
      }

      // Construct using com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        atResponseStart_ = 0F;
        atResponseEnd_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_Progress_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Progress
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Progress build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.Progress result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Progress buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.Progress result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.Progress(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Progress result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.atResponseStart_ = atResponseStart_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.atResponseEnd_ = atResponseEnd_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.Progress) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1beta1.Storage.Progress) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.bigquery.storage.v1beta1.Storage.Progress other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.Progress.getDefaultInstance())
          return this;
        if (other.getAtResponseStart() != 0F) {
          setAtResponseStart(other.getAtResponseStart());
        }
        if (other.getAtResponseEnd() != 0F) {
          setAtResponseEnd(other.getAtResponseEnd());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  atResponseStart_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 21:
                {
                  atResponseEnd_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float atResponseStart_;

      /**
       *
       *
       * <pre>
       * The fraction of rows assigned to the stream that have been processed by the
       * server so far, not including the rows in the current response message.
       *
       * This value, along with `at_response_end`, can be used to interpolate the
       * progress made as the rows in the message are being processed using the
       * following formula: `at_response_start + (at_response_end -
       * at_response_start) * rows_processed_from_response / rows_in_response`.
       *
       * Note that if a filter is provided, the `at_response_end` value of the
       * previous response may not necessarily be equal to the `at_response_start`
       * value of the current response.
       * </pre>
       *
       * <code>float at_response_start = 1;</code>
       *
       * @return The atResponseStart.
       */
      @java.lang.Override
      public float getAtResponseStart() {
        return atResponseStart_;
      }

      /**
       *
       *
       * <pre>
       * The fraction of rows assigned to the stream that have been processed by the
       * server so far, not including the rows in the current response message.
       *
       * This value, along with `at_response_end`, can be used to interpolate the
       * progress made as the rows in the message are being processed using the
       * following formula: `at_response_start + (at_response_end -
       * at_response_start) * rows_processed_from_response / rows_in_response`.
       *
       * Note that if a filter is provided, the `at_response_end` value of the
       * previous response may not necessarily be equal to the `at_response_start`
       * value of the current response.
       * </pre>
       *
       * <code>float at_response_start = 1;</code>
       *
       * @param value The atResponseStart to set.
       * @return This builder for chaining.
       */
      public Builder setAtResponseStart(float value) {

        atResponseStart_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The fraction of rows assigned to the stream that have been processed by the
       * server so far, not including the rows in the current response message.
       *
       * This value, along with `at_response_end`, can be used to interpolate the
       * progress made as the rows in the message are being processed using the
       * following formula: `at_response_start + (at_response_end -
       * at_response_start) * rows_processed_from_response / rows_in_response`.
       *
       * Note that if a filter is provided, the `at_response_end` value of the
       * previous response may not necessarily be equal to the `at_response_start`
       * value of the current response.
       * </pre>
       *
       * <code>float at_response_start = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAtResponseStart() {
        bitField0_ = (bitField0_ & ~0x00000001);
        atResponseStart_ = 0F;
        onChanged();
        return this;
      }

      private float atResponseEnd_;

      /**
       *
       *
       * <pre>
       * Similar to `at_response_start`, except that this value includes the rows in
       * the current response.
       * </pre>
       *
       * <code>float at_response_end = 2;</code>
       *
       * @return The atResponseEnd.
       */
      @java.lang.Override
      public float getAtResponseEnd() {
        return atResponseEnd_;
      }

      /**
       *
       *
       * <pre>
       * Similar to `at_response_start`, except that this value includes the rows in
       * the current response.
       * </pre>
       *
       * <code>float at_response_end = 2;</code>
       *
       * @param value The atResponseEnd to set.
       * @return This builder for chaining.
       */
      public Builder setAtResponseEnd(float value) {

        atResponseEnd_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Similar to `at_response_start`, except that this value includes the rows in
       * the current response.
       * </pre>
       *
       * <code>float at_response_end = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAtResponseEnd() {
        bitField0_ = (bitField0_ & ~0x00000002);
        atResponseEnd_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.Progress)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.Progress)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.Progress
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.Progress();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.Progress getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Progress> PARSER =
        new com.google.protobuf.AbstractParser<Progress>() {
          @java.lang.Override
          public Progress parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Progress> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Progress> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Progress getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ThrottleStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.ThrottleStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * How much this connection is being throttled.
     * 0 is no throttling, 100 is completely throttled.
     * </pre>
     *
     * <code>int32 throttle_percent = 1;</code>
     *
     * @return The throttlePercent.
     */
    int getThrottlePercent();
  }

  /**
   *
   *
   * <pre>
   * Information on if the current connection is being throttled.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ThrottleStatus}
   */
  public static final class ThrottleStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.ThrottleStatus)
      ThrottleStatusOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ThrottleStatus.newBuilder() to construct.
    private ThrottleStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ThrottleStatus() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ThrottleStatus();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.Builder.class);
    }

    public static final int THROTTLE_PERCENT_FIELD_NUMBER = 1;
    private int throttlePercent_ = 0;

    /**
     *
     *
     * <pre>
     * How much this connection is being throttled.
     * 0 is no throttling, 100 is completely throttled.
     * </pre>
     *
     * <code>int32 throttle_percent = 1;</code>
     *
     * @return The throttlePercent.
     */
    @java.lang.Override
    public int getThrottlePercent() {
      return throttlePercent_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (throttlePercent_ != 0) {
        output.writeInt32(1, throttlePercent_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (throttlePercent_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, throttlePercent_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus) obj;

      if (getThrottlePercent() != other.getThrottlePercent()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + THROTTLE_PERCENT_FIELD_NUMBER;
      hash = (53 * hash) + getThrottlePercent();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information on if the current connection is being throttled.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ThrottleStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.ThrottleStatus)
        com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        throttlePercent_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.throttlePercent_ = throttlePercent_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
                .getDefaultInstance()) return this;
        if (other.getThrottlePercent() != 0) {
          setThrottlePercent(other.getThrottlePercent());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  throttlePercent_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int throttlePercent_;

      /**
       *
       *
       * <pre>
       * How much this connection is being throttled.
       * 0 is no throttling, 100 is completely throttled.
       * </pre>
       *
       * <code>int32 throttle_percent = 1;</code>
       *
       * @return The throttlePercent.
       */
      @java.lang.Override
      public int getThrottlePercent() {
        return throttlePercent_;
      }

      /**
       *
       *
       * <pre>
       * How much this connection is being throttled.
       * 0 is no throttling, 100 is completely throttled.
       * </pre>
       *
       * <code>int32 throttle_percent = 1;</code>
       *
       * @param value The throttlePercent to set.
       * @return This builder for chaining.
       */
      public Builder setThrottlePercent(int value) {

        throttlePercent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * How much this connection is being throttled.
       * 0 is no throttling, 100 is completely throttled.
       * </pre>
       *
       * <code>int32 throttle_percent = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearThrottlePercent() {
        bitField0_ = (bitField0_ & ~0x00000001);
        throttlePercent_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.ThrottleStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.ThrottleStatus)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ThrottleStatus> PARSER =
        new com.google.protobuf.AbstractParser<ThrottleStatus>() {
          @java.lang.Override
          public ThrottleStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ThrottleStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ThrottleStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadRowsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.ReadRowsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
     *
     * @return Whether the avroRows field is set.
     */
    boolean hasAvroRows();

    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
     *
     * @return The avroRows.
     */
    com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows getAvroRows();

    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRowsOrBuilder getAvroRowsOrBuilder();

    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return Whether the arrowRecordBatch field is set.
     */
    boolean hasArrowRecordBatch();

    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return The arrowRecordBatch.
     */
    com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch getArrowRecordBatch();

    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatchOrBuilder
        getArrowRecordBatchOrBuilder();

    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block. This value is recorded here,
     * in addition to the row_count values in the output-specific messages in
     * `rows`, so that code which needs to record progress through the stream can
     * do so in an output format-independent way.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @return The rowCount.
     */
    long getRowCount();

    /**
     *
     *
     * <pre>
     * Estimated stream statistics.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();

    /**
     *
     *
     * <pre>
     * Estimated stream statistics.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
     *
     * @return The status.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus getStatus();

    /**
     *
     *
     * <pre>
     * Estimated stream statistics.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatusOrBuilder getStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * Throttling status. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
     *
     * @return Whether the throttleStatus field is set.
     */
    boolean hasThrottleStatus();

    /**
     *
     *
     * <pre>
     * Throttling status. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
     *
     * @return The throttleStatus.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus getThrottleStatus();

    /**
     *
     *
     * <pre>
     * Throttling status. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatusOrBuilder
        getThrottleStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the avroSchema field is set.
     */
    boolean hasAvroSchema();

    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The avroSchema.
     */
    com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema getAvroSchema();

    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder
        getAvroSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the arrowSchema field is set.
     */
    boolean hasArrowSchema();

    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The arrowSchema.
     */
    com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema getArrowSchema();

    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder
        getArrowSchemaOrBuilder();

    com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse.RowsCase getRowsCase();

    com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse.SchemaCase getSchemaCase();
  }

  /**
   *
   *
   * <pre>
   * Response from calling `ReadRows` may include row data, progress and
   * throttling information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ReadRowsResponse}
   */
  public static final class ReadRowsResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.ReadRowsResponse)
      ReadRowsResponseOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadRowsResponse.newBuilder() to construct.
    private ReadRowsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadRowsResponse() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadRowsResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse.Builder.class);
    }

    private int bitField0_;
    private int rowsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object rows_;

    public enum RowsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      AVRO_ROWS(3),
      ARROW_RECORD_BATCH(4),
      ROWS_NOT_SET(0);
      private final int value;

      private RowsCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RowsCase valueOf(int value) {
        return forNumber(value);
      }

      public static RowsCase forNumber(int value) {
        switch (value) {
          case 3:
            return AVRO_ROWS;
          case 4:
            return ARROW_RECORD_BATCH;
          case 0:
            return ROWS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public RowsCase getRowsCase() {
      return RowsCase.forNumber(rowsCase_);
    }

    private int schemaCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object schema_;

    public enum SchemaCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      AVRO_SCHEMA(7),
      ARROW_SCHEMA(8),
      SCHEMA_NOT_SET(0);
      private final int value;

      private SchemaCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SchemaCase valueOf(int value) {
        return forNumber(value);
      }

      public static SchemaCase forNumber(int value) {
        switch (value) {
          case 7:
            return AVRO_SCHEMA;
          case 8:
            return ARROW_SCHEMA;
          case 0:
            return SCHEMA_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SchemaCase getSchemaCase() {
      return SchemaCase.forNumber(schemaCase_);
    }

    public static final int AVRO_ROWS_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
     *
     * @return Whether the avroRows field is set.
     */
    @java.lang.Override
    public boolean hasAvroRows() {
      return rowsCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
     *
     * @return The avroRows.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows getAvroRows() {
      if (rowsCase_ == 3) {
        return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRowsOrBuilder
        getAvroRowsOrBuilder() {
      if (rowsCase_ == 3) {
        return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.getDefaultInstance();
    }

    public static final int ARROW_RECORD_BATCH_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return Whether the arrowRecordBatch field is set.
     */
    @java.lang.Override
    public boolean hasArrowRecordBatch() {
      return rowsCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return The arrowRecordBatch.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
        getArrowRecordBatch() {
      if (rowsCase_ == 4) {
        return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch) rows_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatchOrBuilder
        getArrowRecordBatchOrBuilder() {
      if (rowsCase_ == 4) {
        return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch) rows_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
          .getDefaultInstance();
    }

    public static final int ROW_COUNT_FIELD_NUMBER = 6;
    private long rowCount_ = 0L;

    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block. This value is recorded here,
     * in addition to the row_count values in the output-specific messages in
     * `rows`, so that code which needs to record progress through the stream can
     * do so in an output format-independent way.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public long getRowCount() {
      return rowCount_;
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus status_;

    /**
     *
     *
     * <pre>
     * Estimated stream statistics.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Estimated stream statistics.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus getStatus() {
      return status_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.getDefaultInstance()
          : status_;
    }

    /**
     *
     *
     * <pre>
     * Estimated stream statistics.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatusOrBuilder
        getStatusOrBuilder() {
      return status_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.getDefaultInstance()
          : status_;
    }

    public static final int THROTTLE_STATUS_FIELD_NUMBER = 5;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus throttleStatus_;

    /**
     *
     *
     * <pre>
     * Throttling status. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
     *
     * @return Whether the throttleStatus field is set.
     */
    @java.lang.Override
    public boolean hasThrottleStatus() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Throttling status. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
     *
     * @return The throttleStatus.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus getThrottleStatus() {
      return throttleStatus_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.getDefaultInstance()
          : throttleStatus_;
    }

    /**
     *
     *
     * <pre>
     * Throttling status. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatusOrBuilder
        getThrottleStatusOrBuilder() {
      return throttleStatus_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.getDefaultInstance()
          : throttleStatus_;
    }

    public static final int AVRO_SCHEMA_FIELD_NUMBER = 7;

    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the avroSchema field is set.
     */
    @java.lang.Override
    public boolean hasAvroSchema() {
      return schemaCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The avroSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema getAvroSchema() {
      if (schemaCase_ == 7) {
        return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder
        getAvroSchemaOrBuilder() {
      if (schemaCase_ == 7) {
        return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.getDefaultInstance();
    }

    public static final int ARROW_SCHEMA_FIELD_NUMBER = 8;

    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the arrowSchema field is set.
     */
    @java.lang.Override
    public boolean hasArrowSchema() {
      return schemaCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The arrowSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema getArrowSchema() {
      if (schemaCase_ == 8) {
        return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder
        getArrowSchemaOrBuilder() {
      if (schemaCase_ == 8) {
        return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
      }
      return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getStatus());
      }
      if (rowsCase_ == 3) {
        output.writeMessage(
            3, (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_);
      }
      if (rowsCase_ == 4) {
        output.writeMessage(
            4, (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch) rows_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(5, getThrottleStatus());
      }
      if (rowCount_ != 0L) {
        output.writeInt64(6, rowCount_);
      }
      if (schemaCase_ == 7) {
        output.writeMessage(
            7, (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_);
      }
      if (schemaCase_ == 8) {
        output.writeMessage(
            8, (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStatus());
      }
      if (rowsCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_);
      }
      if (rowsCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch) rows_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getThrottleStatus());
      }
      if (rowCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, rowCount_);
      }
      if (schemaCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_);
      }
      if (schemaCase_ == 8) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8, (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse) obj;

      if (getRowCount() != other.getRowCount()) return false;
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (hasThrottleStatus() != other.hasThrottleStatus()) return false;
      if (hasThrottleStatus()) {
        if (!getThrottleStatus().equals(other.getThrottleStatus())) return false;
      }
      if (!getRowsCase().equals(other.getRowsCase())) return false;
      switch (rowsCase_) {
        case 3:
          if (!getAvroRows().equals(other.getAvroRows())) return false;
          break;
        case 4:
          if (!getArrowRecordBatch().equals(other.getArrowRecordBatch())) return false;
          break;
        case 0:
        default:
      }
      if (!getSchemaCase().equals(other.getSchemaCase())) return false;
      switch (schemaCase_) {
        case 7:
          if (!getAvroSchema().equals(other.getAvroSchema())) return false;
          break;
        case 8:
          if (!getArrowSchema().equals(other.getArrowSchema())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowCount());
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (hasThrottleStatus()) {
        hash = (37 * hash) + THROTTLE_STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getThrottleStatus().hashCode();
      }
      switch (rowsCase_) {
        case 3:
          hash = (37 * hash) + AVRO_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getAvroRows().hashCode();
          break;
        case 4:
          hash = (37 * hash) + ARROW_RECORD_BATCH_FIELD_NUMBER;
          hash = (53 * hash) + getArrowRecordBatch().hashCode();
          break;
        case 0:
        default:
      }
      switch (schemaCase_) {
        case 7:
          hash = (37 * hash) + AVRO_SCHEMA_FIELD_NUMBER;
          hash = (53 * hash) + getAvroSchema().hashCode();
          break;
        case 8:
          hash = (37 * hash) + ARROW_SCHEMA_FIELD_NUMBER;
          hash = (53 * hash) + getArrowSchema().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Response from calling `ReadRows` may include row data, progress and
     * throttling information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.ReadRowsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.ReadRowsResponse)
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStatusFieldBuilder();
          getThrottleStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (avroRowsBuilder_ != null) {
          avroRowsBuilder_.clear();
        }
        if (arrowRecordBatchBuilder_ != null) {
          arrowRecordBatchBuilder_.clear();
        }
        rowCount_ = 0L;
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        throttleStatus_ = null;
        if (throttleStatusBuilder_ != null) {
          throttleStatusBuilder_.dispose();
          throttleStatusBuilder_ = null;
        }
        if (avroSchemaBuilder_ != null) {
          avroSchemaBuilder_.clear();
        }
        if (arrowSchemaBuilder_ != null) {
          arrowSchemaBuilder_.clear();
        }
        rowsCase_ = 0;
        rows_ = null;
        schemaCase_ = 0;
        schema_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.rowCount_ = rowCount_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.throttleStatus_ =
              throttleStatusBuilder_ == null ? throttleStatus_ : throttleStatusBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse result) {
        result.rowsCase_ = rowsCase_;
        result.rows_ = this.rows_;
        if (rowsCase_ == 3 && avroRowsBuilder_ != null) {
          result.rows_ = avroRowsBuilder_.build();
        }
        if (rowsCase_ == 4 && arrowRecordBatchBuilder_ != null) {
          result.rows_ = arrowRecordBatchBuilder_.build();
        }
        result.schemaCase_ = schemaCase_;
        result.schema_ = this.schema_;
        if (schemaCase_ == 7 && avroSchemaBuilder_ != null) {
          result.schema_ = avroSchemaBuilder_.build();
        }
        if (schemaCase_ == 8 && arrowSchemaBuilder_ != null) {
          result.schema_ = arrowSchemaBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
                .getDefaultInstance()) return this;
        if (other.getRowCount() != 0L) {
          setRowCount(other.getRowCount());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        if (other.hasThrottleStatus()) {
          mergeThrottleStatus(other.getThrottleStatus());
        }
        switch (other.getRowsCase()) {
          case AVRO_ROWS:
            {
              mergeAvroRows(other.getAvroRows());
              break;
            }
          case ARROW_RECORD_BATCH:
            {
              mergeArrowRecordBatch(other.getArrowRecordBatch());
              break;
            }
          case ROWS_NOT_SET:
            {
              break;
            }
        }
        switch (other.getSchemaCase()) {
          case AVRO_SCHEMA:
            {
              mergeAvroSchema(other.getAvroSchema());
              break;
            }
          case ARROW_SCHEMA:
            {
              mergeArrowSchema(other.getArrowSchema());
              break;
            }
          case SCHEMA_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getAvroRowsFieldBuilder().getBuilder(), extensionRegistry);
                  rowsCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getArrowRecordBatchFieldBuilder().getBuilder(), extensionRegistry);
                  rowsCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getThrottleStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 48:
                {
                  rowCount_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 48
              case 58:
                {
                  input.readMessage(getAvroSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  schemaCase_ = 7;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getArrowSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  schemaCase_ = 8;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int rowsCase_ = 0;
      private java.lang.Object rows_;

      public RowsCase getRowsCase() {
        return RowsCase.forNumber(rowsCase_);
      }

      public Builder clearRows() {
        rowsCase_ = 0;
        rows_ = null;
        onChanged();
        return this;
      }

      private int schemaCase_ = 0;
      private java.lang.Object schema_;

      public SchemaCase getSchemaCase() {
        return SchemaCase.forNumber(schemaCase_);
      }

      public Builder clearSchema() {
        schemaCase_ = 0;
        schema_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.Builder,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRowsOrBuilder>
          avroRowsBuilder_;

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       *
       * @return Whether the avroRows field is set.
       */
      @java.lang.Override
      public boolean hasAvroRows() {
        return rowsCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       *
       * @return The avroRows.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows getAvroRows() {
        if (avroRowsBuilder_ == null) {
          if (rowsCase_ == 3) {
            return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.getDefaultInstance();
        } else {
          if (rowsCase_ == 3) {
            return avroRowsBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       */
      public Builder setAvroRows(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows value) {
        if (avroRowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rows_ = value;
          onChanged();
        } else {
          avroRowsBuilder_.setMessage(value);
        }
        rowsCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       */
      public Builder setAvroRows(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.Builder builderForValue) {
        if (avroRowsBuilder_ == null) {
          rows_ = builderForValue.build();
          onChanged();
        } else {
          avroRowsBuilder_.setMessage(builderForValue.build());
        }
        rowsCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       */
      public Builder mergeAvroRows(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows value) {
        if (avroRowsBuilder_ == null) {
          if (rowsCase_ == 3
              && rows_
                  != com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows
                      .getDefaultInstance()) {
            rows_ =
                com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.newBuilder(
                        (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rows_ = value;
          }
          onChanged();
        } else {
          if (rowsCase_ == 3) {
            avroRowsBuilder_.mergeFrom(value);
          } else {
            avroRowsBuilder_.setMessage(value);
          }
        }
        rowsCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       */
      public Builder clearAvroRows() {
        if (avroRowsBuilder_ == null) {
          if (rowsCase_ == 3) {
            rowsCase_ = 0;
            rows_ = null;
            onChanged();
          }
        } else {
          if (rowsCase_ == 3) {
            rowsCase_ = 0;
            rows_ = null;
          }
          avroRowsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.Builder
          getAvroRowsBuilder() {
        return getAvroRowsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRowsOrBuilder
          getAvroRowsOrBuilder() {
        if ((rowsCase_ == 3) && (avroRowsBuilder_ != null)) {
          return avroRowsBuilder_.getMessageOrBuilder();
        } else {
          if (rowsCase_ == 3) {
            return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in AVRO format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.AvroRows avro_rows = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.Builder,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRowsOrBuilder>
          getAvroRowsFieldBuilder() {
        if (avroRowsBuilder_ == null) {
          if (!(rowsCase_ == 3)) {
            rows_ =
                com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.getDefaultInstance();
          }
          avroRowsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows,
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRowsOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroRows) rows_,
                  getParentForChildren(),
                  isClean());
          rows_ = null;
        }
        rowsCase_ = 3;
        onChanged();
        return avroRowsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatchOrBuilder>
          arrowRecordBatchBuilder_;

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       *
       * @return Whether the arrowRecordBatch field is set.
       */
      @java.lang.Override
      public boolean hasArrowRecordBatch() {
        return rowsCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       *
       * @return The arrowRecordBatch.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
          getArrowRecordBatch() {
        if (arrowRecordBatchBuilder_ == null) {
          if (rowsCase_ == 4) {
            return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch) rows_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
              .getDefaultInstance();
        } else {
          if (rowsCase_ == 4) {
            return arrowRecordBatchBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       */
      public Builder setArrowRecordBatch(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch value) {
        if (arrowRecordBatchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rows_ = value;
          onChanged();
        } else {
          arrowRecordBatchBuilder_.setMessage(value);
        }
        rowsCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       */
      public Builder setArrowRecordBatch(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch.Builder
              builderForValue) {
        if (arrowRecordBatchBuilder_ == null) {
          rows_ = builderForValue.build();
          onChanged();
        } else {
          arrowRecordBatchBuilder_.setMessage(builderForValue.build());
        }
        rowsCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       */
      public Builder mergeArrowRecordBatch(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch value) {
        if (arrowRecordBatchBuilder_ == null) {
          if (rowsCase_ == 4
              && rows_
                  != com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
                      .getDefaultInstance()) {
            rows_ =
                com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch.newBuilder(
                        (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch)
                            rows_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rows_ = value;
          }
          onChanged();
        } else {
          if (rowsCase_ == 4) {
            arrowRecordBatchBuilder_.mergeFrom(value);
          } else {
            arrowRecordBatchBuilder_.setMessage(value);
          }
        }
        rowsCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       */
      public Builder clearArrowRecordBatch() {
        if (arrowRecordBatchBuilder_ == null) {
          if (rowsCase_ == 4) {
            rowsCase_ = 0;
            rows_ = null;
            onChanged();
          }
        } else {
          if (rowsCase_ == 4) {
            rowsCase_ = 0;
            rows_ = null;
          }
          arrowRecordBatchBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch.Builder
          getArrowRecordBatchBuilder() {
        return getArrowRecordBatchFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatchOrBuilder
          getArrowRecordBatchOrBuilder() {
        if ((rowsCase_ == 4) && (arrowRecordBatchBuilder_ != null)) {
          return arrowRecordBatchBuilder_.getMessageOrBuilder();
        } else {
          if (rowsCase_ == 4) {
            return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch) rows_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Serialized row data in Arrow RecordBatch format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ArrowRecordBatch arrow_record_batch = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatchOrBuilder>
          getArrowRecordBatchFieldBuilder() {
        if (arrowRecordBatchBuilder_ == null) {
          if (!(rowsCase_ == 4)) {
            rows_ =
                com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch
                    .getDefaultInstance();
          }
          arrowRecordBatchBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch,
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatchOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowRecordBatch) rows_,
                  getParentForChildren(),
                  isClean());
          rows_ = null;
        }
        rowsCase_ = 4;
        onChanged();
        return arrowRecordBatchBuilder_;
      }

      private long rowCount_;

      /**
       *
       *
       * <pre>
       * Number of serialized rows in the rows block. This value is recorded here,
       * in addition to the row_count values in the output-specific messages in
       * `rows`, so that code which needs to record progress through the stream can
       * do so in an output format-independent way.
       * </pre>
       *
       * <code>int64 row_count = 6;</code>
       *
       * @return The rowCount.
       */
      @java.lang.Override
      public long getRowCount() {
        return rowCount_;
      }

      /**
       *
       *
       * <pre>
       * Number of serialized rows in the rows block. This value is recorded here,
       * in addition to the row_count values in the output-specific messages in
       * `rows`, so that code which needs to record progress through the stream can
       * do so in an output format-independent way.
       * </pre>
       *
       * <code>int64 row_count = 6;</code>
       *
       * @param value The rowCount to set.
       * @return This builder for chaining.
       */
      public Builder setRowCount(long value) {

        rowCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Number of serialized rows in the rows block. This value is recorded here,
       * in addition to the row_count values in the output-specific messages in
       * `rows`, so that code which needs to record progress through the stream can
       * do so in an output format-independent way.
       * </pre>
       *
       * <code>int64 row_count = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        rowCount_ = 0L;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatusOrBuilder>
          statusBuilder_;

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       *
       * @return The status.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       */
      public Builder setStatus(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       */
      public Builder setStatus(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       */
      public Builder mergeStatus(
          com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && status_ != null
              && status_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus
                      .getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        if (status_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000008);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.Builder
          getStatusBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatusOrBuilder
          getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.getDefaultInstance()
              : status_;
        }
      }

      /**
       *
       *
       * <pre>
       * Estimated stream statistics.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.StreamStatus status = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatus.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      private com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus throttleStatus_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatusOrBuilder>
          throttleStatusBuilder_;

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       *
       * @return Whether the throttleStatus field is set.
       */
      public boolean hasThrottleStatus() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       *
       * @return The throttleStatus.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus getThrottleStatus() {
        if (throttleStatusBuilder_ == null) {
          return throttleStatus_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
                  .getDefaultInstance()
              : throttleStatus_;
        } else {
          return throttleStatusBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       */
      public Builder setThrottleStatus(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus value) {
        if (throttleStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          throttleStatus_ = value;
        } else {
          throttleStatusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       */
      public Builder setThrottleStatus(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.Builder
              builderForValue) {
        if (throttleStatusBuilder_ == null) {
          throttleStatus_ = builderForValue.build();
        } else {
          throttleStatusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       */
      public Builder mergeThrottleStatus(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus value) {
        if (throttleStatusBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && throttleStatus_ != null
              && throttleStatus_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
                      .getDefaultInstance()) {
            getThrottleStatusBuilder().mergeFrom(value);
          } else {
            throttleStatus_ = value;
          }
        } else {
          throttleStatusBuilder_.mergeFrom(value);
        }
        if (throttleStatus_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       */
      public Builder clearThrottleStatus() {
        bitField0_ = (bitField0_ & ~0x00000010);
        throttleStatus_ = null;
        if (throttleStatusBuilder_ != null) {
          throttleStatusBuilder_.dispose();
          throttleStatusBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.Builder
          getThrottleStatusBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getThrottleStatusFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatusOrBuilder
          getThrottleStatusOrBuilder() {
        if (throttleStatusBuilder_ != null) {
          return throttleStatusBuilder_.getMessageOrBuilder();
        } else {
          return throttleStatus_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus
                  .getDefaultInstance()
              : throttleStatus_;
        }
      }

      /**
       *
       *
       * <pre>
       * Throttling status. If unset, the latest response still describes
       * the current throttling status.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.ThrottleStatus throttle_status = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatusOrBuilder>
          getThrottleStatusFieldBuilder() {
        if (throttleStatusBuilder_ == null) {
          throttleStatusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatus.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.ThrottleStatusOrBuilder>(
                  getThrottleStatus(), getParentForChildren(), isClean());
          throttleStatus_ = null;
        }
        return throttleStatusBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder>
          avroSchemaBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the avroSchema field is set.
       */
      @java.lang.Override
      public boolean hasAvroSchema() {
        return schemaCase_ == 7;
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The avroSchema.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema getAvroSchema() {
        if (avroSchemaBuilder_ == null) {
          if (schemaCase_ == 7) {
            return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
              .getDefaultInstance();
        } else {
          if (schemaCase_ == 7) {
            return avroSchemaBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setAvroSchema(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema value) {
        if (avroSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schema_ = value;
          onChanged();
        } else {
          avroSchemaBuilder_.setMessage(value);
        }
        schemaCase_ = 7;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setAvroSchema(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder builderForValue) {
        if (avroSchemaBuilder_ == null) {
          schema_ = builderForValue.build();
          onChanged();
        } else {
          avroSchemaBuilder_.setMessage(builderForValue.build());
        }
        schemaCase_ = 7;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeAvroSchema(
          com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema value) {
        if (avroSchemaBuilder_ == null) {
          if (schemaCase_ == 7
              && schema_
                  != com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
                      .getDefaultInstance()) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.newBuilder(
                        (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schema_ = value;
          }
          onChanged();
        } else {
          if (schemaCase_ == 7) {
            avroSchemaBuilder_.mergeFrom(value);
          } else {
            avroSchemaBuilder_.setMessage(value);
          }
        }
        schemaCase_ = 7;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearAvroSchema() {
        if (avroSchemaBuilder_ == null) {
          if (schemaCase_ == 7) {
            schemaCase_ = 0;
            schema_ = null;
            onChanged();
          }
        } else {
          if (schemaCase_ == 7) {
            schemaCase_ = 0;
            schema_ = null;
          }
          avroSchemaBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder
          getAvroSchemaBuilder() {
        return getAvroSchemaFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder
          getAvroSchemaOrBuilder() {
        if ((schemaCase_ == 7) && (avroSchemaBuilder_ != null)) {
          return avroSchemaBuilder_.getMessageOrBuilder();
        } else {
          if (schemaCase_ == 7) {
            return (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Avro schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder>
          getAvroSchemaFieldBuilder() {
        if (avroSchemaBuilder_ == null) {
          if (!(schemaCase_ == 7)) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.getDefaultInstance();
          }
          avroSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema,
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchemaOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1beta1.AvroProto.AvroSchema) schema_,
                  getParentForChildren(),
                  isClean());
          schema_ = null;
        }
        schemaCase_ = 7;
        onChanged();
        return avroSchemaBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder>
          arrowSchemaBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the arrowSchema field is set.
       */
      @java.lang.Override
      public boolean hasArrowSchema() {
        return schemaCase_ == 8;
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The arrowSchema.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema getArrowSchema() {
        if (arrowSchemaBuilder_ == null) {
          if (schemaCase_ == 8) {
            return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
              .getDefaultInstance();
        } else {
          if (schemaCase_ == 8) {
            return arrowSchemaBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setArrowSchema(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema value) {
        if (arrowSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schema_ = value;
          onChanged();
        } else {
          arrowSchemaBuilder_.setMessage(value);
        }
        schemaCase_ = 8;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setArrowSchema(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder
              builderForValue) {
        if (arrowSchemaBuilder_ == null) {
          schema_ = builderForValue.build();
          onChanged();
        } else {
          arrowSchemaBuilder_.setMessage(builderForValue.build());
        }
        schemaCase_ = 8;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeArrowSchema(
          com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema value) {
        if (arrowSchemaBuilder_ == null) {
          if (schemaCase_ == 8
              && schema_
                  != com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
                      .getDefaultInstance()) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.newBuilder(
                        (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schema_ = value;
          }
          onChanged();
        } else {
          if (schemaCase_ == 8) {
            arrowSchemaBuilder_.mergeFrom(value);
          } else {
            arrowSchemaBuilder_.setMessage(value);
          }
        }
        schemaCase_ = 8;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearArrowSchema() {
        if (arrowSchemaBuilder_ == null) {
          if (schemaCase_ == 8) {
            schemaCase_ = 0;
            schema_ = null;
            onChanged();
          }
        } else {
          if (schemaCase_ == 8) {
            schemaCase_ = 0;
            schema_ = null;
          }
          arrowSchemaBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder
          getArrowSchemaBuilder() {
        return getArrowSchemaFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder
          getArrowSchemaOrBuilder() {
        if ((schemaCase_ == 8) && (arrowSchemaBuilder_ != null)) {
          return arrowSchemaBuilder_.getMessageOrBuilder();
        } else {
          if (schemaCase_ == 8) {
            return (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_;
          }
          return com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Arrow schema.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder,
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder>
          getArrowSchemaFieldBuilder() {
        if (arrowSchemaBuilder_ == null) {
          if (!(schemaCase_ == 8)) {
            schema_ =
                com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema
                    .getDefaultInstance();
          }
          arrowSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema,
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchemaOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1beta1.ArrowProto.ArrowSchema) schema_,
                  getParentForChildren(),
                  isClean());
          schema_ = null;
        }
        schemaCase_ = 8;
        onChanged();
        return arrowSchemaBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.ReadRowsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.ReadRowsResponse)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadRowsResponse> PARSER =
        new com.google.protobuf.AbstractParser<ReadRowsResponse>() {
          @java.lang.Override
          public ReadRowsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadRowsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadRowsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadRowsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchCreateReadSessionStreamsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Must be a non-expired session obtained from a call to
     * CreateReadSession. Only the name field needs to be set.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the session field is set.
     */
    boolean hasSession();

    /**
     *
     *
     * <pre>
     * Required. Must be a non-expired session obtained from a call to
     * CreateReadSession. Only the name field needs to be set.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The session.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession getSession();

    /**
     *
     *
     * <pre>
     * Required. Must be a non-expired session obtained from a call to
     * CreateReadSession. Only the name field needs to be set.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSessionOrBuilder getSessionOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Number of new streams requested. Must be positive.
     * Number of added streams may be less than this, see CreateReadSessionRequest
     * for more information.
     * </pre>
     *
     * <code>int32 requested_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The requestedStreams.
     */
    int getRequestedStreams();
  }

  /**
   *
   *
   * <pre>
   * Information needed to request additional streams for an established read
   * session.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsRequest}
   */
  public static final class BatchCreateReadSessionStreamsRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsRequest)
      BatchCreateReadSessionStreamsRequestOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BatchCreateReadSessionStreamsRequest.newBuilder() to construct.
    private BatchCreateReadSessionStreamsRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchCreateReadSessionStreamsRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchCreateReadSessionStreamsRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
                  .class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
                  .Builder.class);
    }

    private int bitField0_;
    public static final int SESSION_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession session_;

    /**
     *
     *
     * <pre>
     * Required. Must be a non-expired session obtained from a call to
     * CreateReadSession. Only the name field needs to be set.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the session field is set.
     */
    @java.lang.Override
    public boolean hasSession() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Must be a non-expired session obtained from a call to
     * CreateReadSession. Only the name field needs to be set.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The session.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession getSession() {
      return session_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.getDefaultInstance()
          : session_;
    }

    /**
     *
     *
     * <pre>
     * Required. Must be a non-expired session obtained from a call to
     * CreateReadSession. Only the name field needs to be set.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSessionOrBuilder
        getSessionOrBuilder() {
      return session_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.getDefaultInstance()
          : session_;
    }

    public static final int REQUESTED_STREAMS_FIELD_NUMBER = 2;
    private int requestedStreams_ = 0;

    /**
     *
     *
     * <pre>
     * Required. Number of new streams requested. Must be positive.
     * Number of added streams may be less than this, see CreateReadSessionRequest
     * for more information.
     * </pre>
     *
     * <code>int32 requested_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The requestedStreams.
     */
    @java.lang.Override
    public int getRequestedStreams() {
      return requestedStreams_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getSession());
      }
      if (requestedStreams_ != 0) {
        output.writeInt32(2, requestedStreams_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSession());
      }
      if (requestedStreams_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, requestedStreams_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest)
              obj;

      if (hasSession() != other.hasSession()) return false;
      if (hasSession()) {
        if (!getSession().equals(other.getSession())) return false;
      }
      if (getRequestedStreams() != other.getRequestedStreams()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSession()) {
        hash = (37 * hash) + SESSION_FIELD_NUMBER;
        hash = (53 * hash) + getSession().hashCode();
      }
      hash = (37 * hash) + REQUESTED_STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedStreams();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information needed to request additional streams for an established read
     * session.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsRequest)
        com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage
                    .BatchCreateReadSessionStreamsRequest.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage
                    .BatchCreateReadSessionStreamsRequest.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSessionFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        session_ = null;
        if (sessionBuilder_ != null) {
          sessionBuilder_.dispose();
          sessionBuilder_ = null;
        }
        requestedStreams_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
          build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
            result =
                new com.google.cloud.bigquery.storage.v1beta1.Storage
                    .BatchCreateReadSessionStreamsRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.session_ = sessionBuilder_ == null ? session_ : sessionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.requestedStreams_ = requestedStreams_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1beta1.Storage
                .BatchCreateReadSessionStreamsRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage
                      .BatchCreateReadSessionStreamsRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
              other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage
                .BatchCreateReadSessionStreamsRequest.getDefaultInstance()) return this;
        if (other.hasSession()) {
          mergeSession(other.getSession());
        }
        if (other.getRequestedStreams() != 0) {
          setRequestedStreams(other.getRequestedStreams());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSessionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  requestedStreams_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession session_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSessionOrBuilder>
          sessionBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the session field is set.
       */
      public boolean hasSession() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The session.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession getSession() {
        if (sessionBuilder_ == null) {
          return session_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.getDefaultInstance()
              : session_;
        } else {
          return sessionBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSession(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession value) {
        if (sessionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          session_ = value;
        } else {
          sessionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSession(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.Builder builderForValue) {
        if (sessionBuilder_ == null) {
          session_ = builderForValue.build();
        } else {
          sessionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeSession(
          com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession value) {
        if (sessionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && session_ != null
              && session_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession
                      .getDefaultInstance()) {
            getSessionBuilder().mergeFrom(value);
          } else {
            session_ = value;
          }
        } else {
          sessionBuilder_.mergeFrom(value);
        }
        if (session_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearSession() {
        bitField0_ = (bitField0_ & ~0x00000001);
        session_ = null;
        if (sessionBuilder_ != null) {
          sessionBuilder_.dispose();
          sessionBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.Builder
          getSessionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSessionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSessionOrBuilder
          getSessionOrBuilder() {
        if (sessionBuilder_ != null) {
          return sessionBuilder_.getMessageOrBuilder();
        } else {
          return session_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.getDefaultInstance()
              : session_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Must be a non-expired session obtained from a call to
       * CreateReadSession. Only the name field needs to be set.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.ReadSession session = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSessionOrBuilder>
          getSessionFieldBuilder() {
        if (sessionBuilder_ == null) {
          sessionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSession.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.ReadSessionOrBuilder>(
                  getSession(), getParentForChildren(), isClean());
          session_ = null;
        }
        return sessionBuilder_;
      }

      private int requestedStreams_;

      /**
       *
       *
       * <pre>
       * Required. Number of new streams requested. Must be positive.
       * Number of added streams may be less than this, see CreateReadSessionRequest
       * for more information.
       * </pre>
       *
       * <code>int32 requested_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The requestedStreams.
       */
      @java.lang.Override
      public int getRequestedStreams() {
        return requestedStreams_;
      }

      /**
       *
       *
       * <pre>
       * Required. Number of new streams requested. Must be positive.
       * Number of added streams may be less than this, see CreateReadSessionRequest
       * for more information.
       * </pre>
       *
       * <code>int32 requested_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The requestedStreams to set.
       * @return This builder for chaining.
       */
      public Builder setRequestedStreams(int value) {

        requestedStreams_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Number of new streams requested. Must be positive.
       * Number of added streams may be less than this, see CreateReadSessionRequest
       * for more information.
       * </pre>
       *
       * <code>int32 requested_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequestedStreams() {
        bitField0_ = (bitField0_ & ~0x00000002);
        requestedStreams_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsRequest)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.Storage
              .BatchCreateReadSessionStreamsRequest();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchCreateReadSessionStreamsRequest> PARSER =
        new com.google.protobuf.AbstractParser<BatchCreateReadSessionStreamsRequest>() {
          @java.lang.Override
          public BatchCreateReadSessionStreamsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BatchCreateReadSessionStreamsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchCreateReadSessionStreamsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchCreateReadSessionStreamsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream> getStreamsList();

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStreams(int index);

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    int getStreamsCount();

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    java.util.List<? extends com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
        getStreamsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamsOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * The response from `BatchCreateReadSessionStreams` returns the stream
   * identifiers for the newly created streams.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsResponse}
   */
  public static final class BatchCreateReadSessionStreamsResponse
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsResponse)
      BatchCreateReadSessionStreamsResponseOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BatchCreateReadSessionStreamsResponse.newBuilder() to construct.
    private BatchCreateReadSessionStreamsResponse(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchCreateReadSessionStreamsResponse() {
      streams_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchCreateReadSessionStreamsResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage
                  .BatchCreateReadSessionStreamsResponse.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage
                  .BatchCreateReadSessionStreamsResponse.Builder.class);
    }

    public static final int STREAMS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream> streams_;

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>
        getStreamsList() {
      return streams_;
    }

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
        getStreamsOrBuilderList() {
      return streams_;
    }

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    @java.lang.Override
    public int getStreamsCount() {
      return streams_.size();
    }

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStreams(int index) {
      return streams_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Newly added streams.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamsOrBuilder(
        int index) {
      return streams_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < streams_.size(); i++) {
        output.writeMessage(1, streams_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < streams_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, streams_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1beta1.Storage
              .BatchCreateReadSessionStreamsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
          other =
              (com.google.cloud.bigquery.storage.v1beta1.Storage
                      .BatchCreateReadSessionStreamsResponse)
                  obj;

      if (!getStreamsList().equals(other.getStreamsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getStreamsCount() > 0) {
        hash = (37 * hash) + STREAMS_FIELD_NUMBER;
        hash = (53 * hash) + getStreamsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The response from `BatchCreateReadSessionStreams` returns the stream
     * identifiers for the newly created streams.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsResponse)
        com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage
                    .BatchCreateReadSessionStreamsResponse.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage
                    .BatchCreateReadSessionStreamsResponse.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (streamsBuilder_ == null) {
          streams_ = java.util.Collections.emptyList();
        } else {
          streams_ = null;
          streamsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
          build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
            result =
                new com.google.cloud.bigquery.storage.v1beta1.Storage
                    .BatchCreateReadSessionStreamsResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
              result) {
        if (streamsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            streams_ = java.util.Collections.unmodifiableList(streams_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.streams_ = streams_;
        } else {
          result.streams_ = streamsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
              result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1beta1.Storage
                .BatchCreateReadSessionStreamsResponse) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage
                      .BatchCreateReadSessionStreamsResponse)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
              other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage
                .BatchCreateReadSessionStreamsResponse.getDefaultInstance()) return this;
        if (streamsBuilder_ == null) {
          if (!other.streams_.isEmpty()) {
            if (streams_.isEmpty()) {
              streams_ = other.streams_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureStreamsIsMutable();
              streams_.addAll(other.streams_);
            }
            onChanged();
          }
        } else {
          if (!other.streams_.isEmpty()) {
            if (streamsBuilder_.isEmpty()) {
              streamsBuilder_.dispose();
              streamsBuilder_ = null;
              streams_ = other.streams_;
              bitField0_ = (bitField0_ & ~0x00000001);
              streamsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getStreamsFieldBuilder()
                      : null;
            } else {
              streamsBuilder_.addAllMessages(other.streams_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream m =
                      input.readMessage(
                          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.parser(),
                          extensionRegistry);
                  if (streamsBuilder_ == null) {
                    ensureStreamsIsMutable();
                    streams_.add(m);
                  } else {
                    streamsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream> streams_ =
          java.util.Collections.emptyList();

      private void ensureStreamsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          streams_ =
              new java.util.ArrayList<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>(
                  streams_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          streamsBuilder_;

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>
          getStreamsList() {
        if (streamsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(streams_);
        } else {
          return streamsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public int getStreamsCount() {
        if (streamsBuilder_ == null) {
          return streams_.size();
        } else {
          return streamsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStreams(int index) {
        if (streamsBuilder_ == null) {
          return streams_.get(index);
        } else {
          return streamsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder setStreams(
          int index, com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStreamsIsMutable();
          streams_.set(index, value);
          onChanged();
        } else {
          streamsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder setStreams(
          int index,
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.set(index, builderForValue.build());
          onChanged();
        } else {
          streamsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder addStreams(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStreamsIsMutable();
          streams_.add(value);
          onChanged();
        } else {
          streamsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder addStreams(
          int index, com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStreamsIsMutable();
          streams_.add(index, value);
          onChanged();
        } else {
          streamsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder addStreams(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.add(builderForValue.build());
          onChanged();
        } else {
          streamsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder addStreams(
          int index,
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.add(index, builderForValue.build());
          onChanged();
        } else {
          streamsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder addAllStreams(
          java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1beta1.Storage.Stream>
              values) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, streams_);
          onChanged();
        } else {
          streamsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder clearStreams() {
        if (streamsBuilder_ == null) {
          streams_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          streamsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public Builder removeStreams(int index) {
        if (streamsBuilder_ == null) {
          ensureStreamsIsMutable();
          streams_.remove(index);
          onChanged();
        } else {
          streamsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder getStreamsBuilder(
          int index) {
        return getStreamsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamsOrBuilder(
          int index) {
        if (streamsBuilder_ == null) {
          return streams_.get(index);
        } else {
          return streamsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getStreamsOrBuilderList() {
        if (streamsBuilder_ != null) {
          return streamsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(streams_);
        }
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder addStreamsBuilder() {
        return getStreamsFieldBuilder()
            .addBuilder(
                com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder addStreamsBuilder(
          int index) {
        return getStreamsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Newly added streams.
       * </pre>
       *
       * <code>repeated .google.cloud.bigquery.storage.v1beta1.Stream streams = 1;</code>
       */
      public java.util.List<com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder>
          getStreamsBuilderList() {
        return getStreamsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getStreamsFieldBuilder() {
        if (streamsBuilder_ == null) {
          streamsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>(
                  streams_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          streams_ = null;
        }
        return streamsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.BatchCreateReadSessionStreamsResponse)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.Storage
              .BatchCreateReadSessionStreamsResponse();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage
            .BatchCreateReadSessionStreamsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchCreateReadSessionStreamsResponse> PARSER =
        new com.google.protobuf.AbstractParser<BatchCreateReadSessionStreamsResponse>() {
          @java.lang.Override
          public BatchCreateReadSessionStreamsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BatchCreateReadSessionStreamsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchCreateReadSessionStreamsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.BatchCreateReadSessionStreamsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FinalizeStreamRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.FinalizeStreamRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Stream to finalize.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the stream field is set.
     */
    boolean hasStream();

    /**
     *
     *
     * <pre>
     * Required. Stream to finalize.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The stream.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStream();

    /**
     *
     *
     * <pre>
     * Required. Stream to finalize.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Request information for invoking `FinalizeStream`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.FinalizeStreamRequest}
   */
  public static final class FinalizeStreamRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.FinalizeStreamRequest)
      FinalizeStreamRequestOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use FinalizeStreamRequest.newBuilder() to construct.
    private FinalizeStreamRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FinalizeStreamRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FinalizeStreamRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest.Builder
                  .class);
    }

    private int bitField0_;
    public static final int STREAM_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream stream_;

    /**
     *
     *
     * <pre>
     * Required. Stream to finalize.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the stream field is set.
     */
    @java.lang.Override
    public boolean hasStream() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Stream to finalize.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The stream.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStream() {
      return stream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : stream_;
    }

    /**
     *
     *
     * <pre>
     * Required. Stream to finalize.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getStreamOrBuilder() {
      return stream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : stream_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getStream());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStream());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest) obj;

      if (hasStream() != other.hasStream()) return false;
      if (hasStream()) {
        if (!getStream().equals(other.getStream())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStream()) {
        hash = (37 * hash) + STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getStream().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Request information for invoking `FinalizeStream`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.FinalizeStreamRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.FinalizeStreamRequest)
        com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStreamFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        stream_ = null;
        if (streamBuilder_ != null) {
          streamBuilder_.dispose();
          streamBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.stream_ = streamBuilder_ == null ? stream_ : streamBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
                .getDefaultInstance()) return this;
        if (other.hasStream()) {
          mergeStream(other.getStream());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  input.readMessage(getStreamFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream stream_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          streamBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the stream field is set.
       */
      public boolean hasStream() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The stream.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getStream() {
        if (streamBuilder_ == null) {
          return stream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : stream_;
        } else {
          return streamBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setStream(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stream_ = value;
        } else {
          streamBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (streamBuilder_ == null) {
          stream_ = builderForValue.build();
        } else {
          streamBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeStream(com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (streamBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && stream_ != null
              && stream_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.Stream
                      .getDefaultInstance()) {
            getStreamBuilder().mergeFrom(value);
          } else {
            stream_ = value;
          }
        } else {
          streamBuilder_.mergeFrom(value);
        }
        if (stream_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearStream() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stream_ = null;
        if (streamBuilder_ != null) {
          streamBuilder_.dispose();
          streamBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder getStreamBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStreamFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
          getStreamOrBuilder() {
        if (streamBuilder_ != null) {
          return streamBuilder_.getMessageOrBuilder();
        } else {
          return stream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : stream_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to finalize.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getStreamFieldBuilder() {
        if (streamBuilder_ == null) {
          streamBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>(
                  getStream(), getParentForChildren(), isClean());
          stream_ = null;
        }
        return streamBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.FinalizeStreamRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.FinalizeStreamRequest)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FinalizeStreamRequest> PARSER =
        new com.google.protobuf.AbstractParser<FinalizeStreamRequest>() {
          @java.lang.Override
          public FinalizeStreamRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FinalizeStreamRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FinalizeStreamRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.FinalizeStreamRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SplitReadStreamRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.SplitReadStreamRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Stream to split.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the originalStream field is set.
     */
    boolean hasOriginalStream();

    /**
     *
     *
     * <pre>
     * Required. Stream to split.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The originalStream.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getOriginalStream();

    /**
     *
     *
     * <pre>
     * Required. Stream to split.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getOriginalStreamOrBuilder();

    /**
     *
     *
     * <pre>
     * A value in the range (0.0, 1.0) that specifies the fractional point at
     * which the original stream should be split. The actual split point is
     * evaluated on pre-filtered rows, so if a filter is provided, then there is
     * no guarantee that the division of the rows between the new child streams
     * will be proportional to this fractional value. Additionally, because the
     * server-side unit for assigning data is collections of rows, this fraction
     * will always map to to a data storage boundary on the server side.
     * </pre>
     *
     * <code>float fraction = 2;</code>
     *
     * @return The fraction.
     */
    float getFraction();
  }

  /**
   *
   *
   * <pre>
   * Request information for `SplitReadStream`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.SplitReadStreamRequest}
   */
  public static final class SplitReadStreamRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.SplitReadStreamRequest)
      SplitReadStreamRequestOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SplitReadStreamRequest.newBuilder() to construct.
    private SplitReadStreamRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SplitReadStreamRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SplitReadStreamRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest.Builder
                  .class);
    }

    private int bitField0_;
    public static final int ORIGINAL_STREAM_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream originalStream_;

    /**
     *
     *
     * <pre>
     * Required. Stream to split.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the originalStream field is set.
     */
    @java.lang.Override
    public boolean hasOriginalStream() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Stream to split.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The originalStream.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getOriginalStream() {
      return originalStream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : originalStream_;
    }

    /**
     *
     *
     * <pre>
     * Required. Stream to split.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
        getOriginalStreamOrBuilder() {
      return originalStream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : originalStream_;
    }

    public static final int FRACTION_FIELD_NUMBER = 2;
    private float fraction_ = 0F;

    /**
     *
     *
     * <pre>
     * A value in the range (0.0, 1.0) that specifies the fractional point at
     * which the original stream should be split. The actual split point is
     * evaluated on pre-filtered rows, so if a filter is provided, then there is
     * no guarantee that the division of the rows between the new child streams
     * will be proportional to this fractional value. Additionally, because the
     * server-side unit for assigning data is collections of rows, this fraction
     * will always map to to a data storage boundary on the server side.
     * </pre>
     *
     * <code>float fraction = 2;</code>
     *
     * @return The fraction.
     */
    @java.lang.Override
    public float getFraction() {
      return fraction_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getOriginalStream());
      }
      if (java.lang.Float.floatToRawIntBits(fraction_) != 0) {
        output.writeFloat(2, fraction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOriginalStream());
      }
      if (java.lang.Float.floatToRawIntBits(fraction_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, fraction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest) obj;

      if (hasOriginalStream() != other.hasOriginalStream()) return false;
      if (hasOriginalStream()) {
        if (!getOriginalStream().equals(other.getOriginalStream())) return false;
      }
      if (java.lang.Float.floatToIntBits(getFraction())
          != java.lang.Float.floatToIntBits(other.getFraction())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasOriginalStream()) {
        hash = (37 * hash) + ORIGINAL_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getOriginalStream().hashCode();
      }
      hash = (37 * hash) + FRACTION_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getFraction());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Request information for `SplitReadStream`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.SplitReadStreamRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.SplitReadStreamRequest)
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getOriginalStreamFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        originalStream_ = null;
        if (originalStreamBuilder_ != null) {
          originalStreamBuilder_.dispose();
          originalStreamBuilder_ = null;
        }
        fraction_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.originalStream_ =
              originalStreamBuilder_ == null ? originalStream_ : originalStreamBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fraction_ = fraction_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
                .getDefaultInstance()) return this;
        if (other.hasOriginalStream()) {
          mergeOriginalStream(other.getOriginalStream());
        }
        if (other.getFraction() != 0F) {
          setFraction(other.getFraction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getOriginalStreamFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 21:
                {
                  fraction_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream originalStream_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          originalStreamBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the originalStream field is set.
       */
      public boolean hasOriginalStream() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The originalStream.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getOriginalStream() {
        if (originalStreamBuilder_ == null) {
          return originalStream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : originalStream_;
        } else {
          return originalStreamBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setOriginalStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (originalStreamBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          originalStream_ = value;
        } else {
          originalStreamBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setOriginalStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (originalStreamBuilder_ == null) {
          originalStream_ = builderForValue.build();
        } else {
          originalStreamBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeOriginalStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (originalStreamBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && originalStream_ != null
              && originalStream_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.Stream
                      .getDefaultInstance()) {
            getOriginalStreamBuilder().mergeFrom(value);
          } else {
            originalStream_ = value;
          }
        } else {
          originalStreamBuilder_.mergeFrom(value);
        }
        if (originalStream_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearOriginalStream() {
        bitField0_ = (bitField0_ & ~0x00000001);
        originalStream_ = null;
        if (originalStreamBuilder_ != null) {
          originalStreamBuilder_.dispose();
          originalStreamBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder
          getOriginalStreamBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getOriginalStreamFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
          getOriginalStreamOrBuilder() {
        if (originalStreamBuilder_ != null) {
          return originalStreamBuilder_.getMessageOrBuilder();
        } else {
          return originalStream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : originalStream_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Stream to split.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1beta1.Stream original_stream = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getOriginalStreamFieldBuilder() {
        if (originalStreamBuilder_ == null) {
          originalStreamBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>(
                  getOriginalStream(), getParentForChildren(), isClean());
          originalStream_ = null;
        }
        return originalStreamBuilder_;
      }

      private float fraction_;

      /**
       *
       *
       * <pre>
       * A value in the range (0.0, 1.0) that specifies the fractional point at
       * which the original stream should be split. The actual split point is
       * evaluated on pre-filtered rows, so if a filter is provided, then there is
       * no guarantee that the division of the rows between the new child streams
       * will be proportional to this fractional value. Additionally, because the
       * server-side unit for assigning data is collections of rows, this fraction
       * will always map to to a data storage boundary on the server side.
       * </pre>
       *
       * <code>float fraction = 2;</code>
       *
       * @return The fraction.
       */
      @java.lang.Override
      public float getFraction() {
        return fraction_;
      }

      /**
       *
       *
       * <pre>
       * A value in the range (0.0, 1.0) that specifies the fractional point at
       * which the original stream should be split. The actual split point is
       * evaluated on pre-filtered rows, so if a filter is provided, then there is
       * no guarantee that the division of the rows between the new child streams
       * will be proportional to this fractional value. Additionally, because the
       * server-side unit for assigning data is collections of rows, this fraction
       * will always map to to a data storage boundary on the server side.
       * </pre>
       *
       * <code>float fraction = 2;</code>
       *
       * @param value The fraction to set.
       * @return This builder for chaining.
       */
      public Builder setFraction(float value) {

        fraction_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A value in the range (0.0, 1.0) that specifies the fractional point at
       * which the original stream should be split. The actual split point is
       * evaluated on pre-filtered rows, so if a filter is provided, then there is
       * no guarantee that the division of the rows between the new child streams
       * will be proportional to this fractional value. Additionally, because the
       * server-side unit for assigning data is collections of rows, this fraction
       * will always map to to a data storage boundary on the server side.
       * </pre>
       *
       * <code>float fraction = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFraction() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fraction_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.SplitReadStreamRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.SplitReadStreamRequest)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SplitReadStreamRequest> PARSER =
        new com.google.protobuf.AbstractParser<SplitReadStreamRequest>() {
          @java.lang.Override
          public SplitReadStreamRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SplitReadStreamRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SplitReadStreamRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SplitReadStreamResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta1.SplitReadStreamResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Primary stream, which contains the beginning portion of
     * |original_stream|. An empty value indicates that the original stream can no
     * longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
     *
     * @return Whether the primaryStream field is set.
     */
    boolean hasPrimaryStream();

    /**
     *
     *
     * <pre>
     * Primary stream, which contains the beginning portion of
     * |original_stream|. An empty value indicates that the original stream can no
     * longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
     *
     * @return The primaryStream.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getPrimaryStream();

    /**
     *
     *
     * <pre>
     * Primary stream, which contains the beginning portion of
     * |original_stream|. An empty value indicates that the original stream can no
     * longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getPrimaryStreamOrBuilder();

    /**
     *
     *
     * <pre>
     * Remainder stream, which contains the tail of |original_stream|. An empty
     * value indicates that the original stream can no longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
     *
     * @return Whether the remainderStream field is set.
     */
    boolean hasRemainderStream();

    /**
     *
     *
     * <pre>
     * Remainder stream, which contains the tail of |original_stream|. An empty
     * value indicates that the original stream can no longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
     *
     * @return The remainderStream.
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getRemainderStream();

    /**
     *
     *
     * <pre>
     * Remainder stream, which contains the tail of |original_stream|. An empty
     * value indicates that the original stream can no longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
     */
    com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder getRemainderStreamOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Response from `SplitReadStream`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.SplitReadStreamResponse}
   */
  public static final class SplitReadStreamResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta1.SplitReadStreamResponse)
      SplitReadStreamResponseOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SplitReadStreamResponse.newBuilder() to construct.
    private SplitReadStreamResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SplitReadStreamResponse() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SplitReadStreamResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta1.Storage
          .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse.class,
              com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse.Builder
                  .class);
    }

    private int bitField0_;
    public static final int PRIMARY_STREAM_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream primaryStream_;

    /**
     *
     *
     * <pre>
     * Primary stream, which contains the beginning portion of
     * |original_stream|. An empty value indicates that the original stream can no
     * longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
     *
     * @return Whether the primaryStream field is set.
     */
    @java.lang.Override
    public boolean hasPrimaryStream() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Primary stream, which contains the beginning portion of
     * |original_stream|. An empty value indicates that the original stream can no
     * longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
     *
     * @return The primaryStream.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getPrimaryStream() {
      return primaryStream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : primaryStream_;
    }

    /**
     *
     *
     * <pre>
     * Primary stream, which contains the beginning portion of
     * |original_stream|. An empty value indicates that the original stream can no
     * longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
        getPrimaryStreamOrBuilder() {
      return primaryStream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : primaryStream_;
    }

    public static final int REMAINDER_STREAM_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream remainderStream_;

    /**
     *
     *
     * <pre>
     * Remainder stream, which contains the tail of |original_stream|. An empty
     * value indicates that the original stream can no longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
     *
     * @return Whether the remainderStream field is set.
     */
    @java.lang.Override
    public boolean hasRemainderStream() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Remainder stream, which contains the tail of |original_stream|. An empty
     * value indicates that the original stream can no longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
     *
     * @return The remainderStream.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getRemainderStream() {
      return remainderStream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : remainderStream_;
    }

    /**
     *
     *
     * <pre>
     * Remainder stream, which contains the tail of |original_stream|. An empty
     * value indicates that the original stream can no longer be split.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
        getRemainderStreamOrBuilder() {
      return remainderStream_ == null
          ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
          : remainderStream_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPrimaryStream());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getRemainderStream());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPrimaryStream());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRemainderStream());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse other =
          (com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse) obj;

      if (hasPrimaryStream() != other.hasPrimaryStream()) return false;
      if (hasPrimaryStream()) {
        if (!getPrimaryStream().equals(other.getPrimaryStream())) return false;
      }
      if (hasRemainderStream() != other.hasRemainderStream()) return false;
      if (hasRemainderStream()) {
        if (!getRemainderStream().equals(other.getRemainderStream())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPrimaryStream()) {
        hash = (37 * hash) + PRIMARY_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getPrimaryStream().hashCode();
      }
      if (hasRemainderStream()) {
        hash = (37 * hash) + REMAINDER_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getRemainderStream().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Response from `SplitReadStream`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1beta1.SplitReadStreamResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta1.SplitReadStreamResponse)
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse.class,
                com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPrimaryStreamFieldBuilder();
          getRemainderStreamFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        primaryStream_ = null;
        if (primaryStreamBuilder_ != null) {
          primaryStreamBuilder_.dispose();
          primaryStreamBuilder_ = null;
        }
        remainderStream_ = null;
        if (remainderStreamBuilder_ != null) {
          remainderStreamBuilder_.dispose();
          remainderStreamBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage
            .internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse build() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
          buildPartial() {
        com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse result =
            new com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.primaryStream_ =
              primaryStreamBuilder_ == null ? primaryStream_ : primaryStreamBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.remainderStream_ =
              remainderStreamBuilder_ == null ? remainderStream_ : remainderStreamBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
                .getDefaultInstance()) return this;
        if (other.hasPrimaryStream()) {
          mergePrimaryStream(other.getPrimaryStream());
        }
        if (other.hasRemainderStream()) {
          mergeRemainderStream(other.getRemainderStream());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getPrimaryStreamFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getRemainderStreamFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream primaryStream_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          primaryStreamBuilder_;

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       *
       * @return Whether the primaryStream field is set.
       */
      public boolean hasPrimaryStream() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       *
       * @return The primaryStream.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getPrimaryStream() {
        if (primaryStreamBuilder_ == null) {
          return primaryStream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : primaryStream_;
        } else {
          return primaryStreamBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       */
      public Builder setPrimaryStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (primaryStreamBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          primaryStream_ = value;
        } else {
          primaryStreamBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       */
      public Builder setPrimaryStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (primaryStreamBuilder_ == null) {
          primaryStream_ = builderForValue.build();
        } else {
          primaryStreamBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       */
      public Builder mergePrimaryStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (primaryStreamBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && primaryStream_ != null
              && primaryStream_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.Stream
                      .getDefaultInstance()) {
            getPrimaryStreamBuilder().mergeFrom(value);
          } else {
            primaryStream_ = value;
          }
        } else {
          primaryStreamBuilder_.mergeFrom(value);
        }
        if (primaryStream_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       */
      public Builder clearPrimaryStream() {
        bitField0_ = (bitField0_ & ~0x00000001);
        primaryStream_ = null;
        if (primaryStreamBuilder_ != null) {
          primaryStreamBuilder_.dispose();
          primaryStreamBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder
          getPrimaryStreamBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPrimaryStreamFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
          getPrimaryStreamOrBuilder() {
        if (primaryStreamBuilder_ != null) {
          return primaryStreamBuilder_.getMessageOrBuilder();
        } else {
          return primaryStream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : primaryStream_;
        }
      }

      /**
       *
       *
       * <pre>
       * Primary stream, which contains the beginning portion of
       * |original_stream|. An empty value indicates that the original stream can no
       * longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream primary_stream = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getPrimaryStreamFieldBuilder() {
        if (primaryStreamBuilder_ == null) {
          primaryStreamBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>(
                  getPrimaryStream(), getParentForChildren(), isClean());
          primaryStream_ = null;
        }
        return primaryStreamBuilder_;
      }

      private com.google.cloud.bigquery.storage.v1beta1.Storage.Stream remainderStream_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          remainderStreamBuilder_;

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       *
       * @return Whether the remainderStream field is set.
       */
      public boolean hasRemainderStream() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       *
       * @return The remainderStream.
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream getRemainderStream() {
        if (remainderStreamBuilder_ == null) {
          return remainderStream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : remainderStream_;
        } else {
          return remainderStreamBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       */
      public Builder setRemainderStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (remainderStreamBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          remainderStream_ = value;
        } else {
          remainderStreamBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       */
      public Builder setRemainderStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder builderForValue) {
        if (remainderStreamBuilder_ == null) {
          remainderStream_ = builderForValue.build();
        } else {
          remainderStreamBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       */
      public Builder mergeRemainderStream(
          com.google.cloud.bigquery.storage.v1beta1.Storage.Stream value) {
        if (remainderStreamBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && remainderStream_ != null
              && remainderStream_
                  != com.google.cloud.bigquery.storage.v1beta1.Storage.Stream
                      .getDefaultInstance()) {
            getRemainderStreamBuilder().mergeFrom(value);
          } else {
            remainderStream_ = value;
          }
        } else {
          remainderStreamBuilder_.mergeFrom(value);
        }
        if (remainderStream_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       */
      public Builder clearRemainderStream() {
        bitField0_ = (bitField0_ & ~0x00000002);
        remainderStream_ = null;
        if (remainderStreamBuilder_ != null) {
          remainderStreamBuilder_.dispose();
          remainderStreamBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder
          getRemainderStreamBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRemainderStreamFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder
          getRemainderStreamOrBuilder() {
        if (remainderStreamBuilder_ != null) {
          return remainderStreamBuilder_.getMessageOrBuilder();
        } else {
          return remainderStream_ == null
              ? com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.getDefaultInstance()
              : remainderStream_;
        }
      }

      /**
       *
       *
       * <pre>
       * Remainder stream, which contains the tail of |original_stream|. An empty
       * value indicates that the original stream can no longer be split.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1beta1.Stream remainder_stream = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
              com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
              com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>
          getRemainderStreamFieldBuilder() {
        if (remainderStreamBuilder_ == null) {
          remainderStreamBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.Stream.Builder,
                  com.google.cloud.bigquery.storage.v1beta1.Storage.StreamOrBuilder>(
                  getRemainderStream(), getParentForChildren(), isClean());
          remainderStream_ = null;
        }
        return remainderStreamBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta1.SplitReadStreamResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta1.SplitReadStreamResponse)
    private static final com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse();
    }

    public static com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SplitReadStreamResponse> PARSER =
        new com.google.protobuf.AbstractParser<SplitReadStreamResponse>() {
          @java.lang.Override
          public SplitReadStreamResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SplitReadStreamResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SplitReadStreamResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta1.Storage.SplitReadStreamResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_Stream_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_Stream_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_Progress_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_Progress_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n3google/cloud/bigquery/storage/v1beta1/"
          + "storage.proto\022%google.cloud.bigquery.sto"
          + "rage.v1beta1\032\034google/api/annotations.pro"
          + "to\032\027google/api/client.proto\032\037google/api/"
          + "field_behavior.proto\032\031google/api/resourc"
          + "e.proto\0321google/cloud/bigquery/storage/v"
          + "1beta1/arrow.proto\0320google/cloud/bigquer"
          + "y/storage/v1beta1/avro.proto\0328google/clo"
          + "ud/bigquery/storage/v1beta1/read_options"
          + ".proto\032;google/cloud/bigquery/storage/v1"
          + "beta1/table_reference.proto\032\033google/prot"
          + "obuf/empty.proto\032\037google/protobuf/timest"
          + "amp.proto\"|\n\006Stream\022\014\n\004name\030\001 \001(\t:d\352Aa\n%"
          + "bigquerystorage.googleapis.com/Stream\0228p"
          + "rojects/{project}/locations/{location}/s"
          + "treams/{stream}\"_\n\016StreamPosition\022=\n\006str"
          + "eam\030\001 \001(\0132-.google.cloud.bigquery.storag"
          + "e.v1beta1.Stream\022\016\n\006offset\030\002 \001(\003\"\215\005\n\013Rea"
          + "dSession\022\014\n\004name\030\001 \001(\t\022/\n\013expire_time\030\002 "
          + "\001(\0132\032.google.protobuf.Timestamp\022H\n\013avro_"
          + "schema\030\005 \001(\01321.google.cloud.bigquery.sto"
          + "rage.v1beta1.AvroSchemaH\000\022J\n\014arrow_schem"
          + "a\030\006 \001(\01322.google.cloud.bigquery.storage."
          + "v1beta1.ArrowSchemaH\000\022>\n\007streams\030\004 \003(\0132-"
          + ".google.cloud.bigquery.storage.v1beta1.S"
          + "tream\022N\n\017table_reference\030\007 \001(\01325.google."
          + "cloud.bigquery.storage.v1beta1.TableRefe"
          + "rence\022N\n\017table_modifiers\030\010 \001(\01325.google."
          + "cloud.bigquery.storage.v1beta1.TableModi"
          + "fiers\022R\n\021sharding_strategy\030\t \001(\01627.googl"
          + "e.cloud.bigquery.storage.v1beta1.Shardin"
          + "gStrategy:k\352Ah\n*bigquerystorage.googleap"
          + "is.com/ReadSession\022:projects/{project}/l"
          + "ocations/{location}/sessions/{session}B\010"
          + "\n\006schema\"\205\004\n\030CreateReadSessionRequest\022S\n"
          + "\017table_reference\030\001 \001(\01325.google.cloud.bi"
          + "gquery.storage.v1beta1.TableReferenceB\003\340"
          + "A\002\022C\n\006parent\030\006 \001(\tB3\340A\002\372A-\n+cloudresourc"
          + "emanager.googleapis.com/Project\022N\n\017table"
          + "_modifiers\030\002 \001(\01325.google.cloud.bigquery"
          + ".storage.v1beta1.TableModifiers\022\031\n\021reque"
          + "sted_streams\030\003 \001(\005\022M\n\014read_options\030\004 \001(\013"
          + "27.google.cloud.bigquery.storage.v1beta1"
          + ".TableReadOptions\022A\n\006format\030\005 \001(\01621.goog"
          + "le.cloud.bigquery.storage.v1beta1.DataFo"
          + "rmat\022R\n\021sharding_strategy\030\007 \001(\01627.google"
          + ".cloud.bigquery.storage.v1beta1.Sharding"
          + "Strategy\"d\n\017ReadRowsRequest\022Q\n\rread_posi"
          + "tion\030\001 \001(\01325.google.cloud.bigquery.stora"
          + "ge.v1beta1.StreamPositionB\003\340A\002\"\240\001\n\014Strea"
          + "mStatus\022\033\n\023estimated_row_count\030\001 \001(\003\022\031\n\021"
          + "fraction_consumed\030\002 \001(\002\022A\n\010progress\030\004 \001("
          + "\0132/.google.cloud.bigquery.storage.v1beta"
          + "1.Progress\022\025\n\ris_splittable\030\003 \001(\010\">\n\010Pro"
          + "gress\022\031\n\021at_response_start\030\001 \001(\002\022\027\n\017at_r"
          + "esponse_end\030\002 \001(\002\"*\n\016ThrottleStatus\022\030\n\020t"
          + "hrottle_percent\030\001 \001(\005\"\211\004\n\020ReadRowsRespon"
          + "se\022D\n\tavro_rows\030\003 \001(\0132/.google.cloud.big"
          + "query.storage.v1beta1.AvroRowsH\000\022U\n\022arro"
          + "w_record_batch\030\004 \001(\01327.google.cloud.bigq"
          + "uery.storage.v1beta1.ArrowRecordBatchH\000\022"
          + "\021\n\trow_count\030\006 \001(\003\022C\n\006status\030\002 \001(\01323.goo"
          + "gle.cloud.bigquery.storage.v1beta1.Strea"
          + "mStatus\022N\n\017throttle_status\030\005 \001(\01325.googl"
          + "e.cloud.bigquery.storage.v1beta1.Throttl"
          + "eStatus\022M\n\013avro_schema\030\007 \001(\01321.google.cl"
          + "oud.bigquery.storage.v1beta1.AvroSchemaB"
          + "\003\340A\003H\001\022O\n\014arrow_schema\030\010 \001(\01322.google.cl"
          + "oud.bigquery.storage.v1beta1.ArrowSchema"
          + "B\003\340A\003H\001B\006\n\004rowsB\010\n\006schema\"\220\001\n$BatchCreat"
          + "eReadSessionStreamsRequest\022H\n\007session\030\001 "
          + "\001(\01322.google.cloud.bigquery.storage.v1be"
          + "ta1.ReadSessionB\003\340A\002\022\036\n\021requested_stream"
          + "s\030\002 \001(\005B\003\340A\002\"g\n%BatchCreateReadSessionSt"
          + "reamsResponse\022>\n\007streams\030\001 \003(\0132-.google."
          + "cloud.bigquery.storage.v1beta1.Stream\"[\n"
          + "\025FinalizeStreamRequest\022B\n\006stream\030\002 \001(\0132-"
          + ".google.cloud.bigquery.storage.v1beta1.S"
          + "treamB\003\340A\002\"w\n\026SplitReadStreamRequest\022K\n\017"
          + "original_stream\030\001 \001(\0132-.google.cloud.big"
          + "query.storage.v1beta1.StreamB\003\340A\002\022\020\n\010fra"
          + "ction\030\002 \001(\002\"\251\001\n\027SplitReadStreamResponse\022"
          + "E\n\016primary_stream\030\001 \001(\0132-.google.cloud.b"
          + "igquery.storage.v1beta1.Stream\022G\n\020remain"
          + "der_stream\030\002 \001(\0132-.google.cloud.bigquery"
          + ".storage.v1beta1.Stream*>\n\nDataFormat\022\033\n"
          + "\027DATA_FORMAT_UNSPECIFIED\020\000\022\010\n\004AVRO\020\001\022\t\n\005"
          + "ARROW\020\003*O\n\020ShardingStrategy\022!\n\035SHARDING_"
          + "STRATEGY_UNSPECIFIED\020\000\022\n\n\006LIQUID\020\001\022\014\n\010BA"
          + "LANCED\020\0022\267\n\n\017BigQueryStorage\022\263\002\n\021CreateR"
          + "eadSession\022?.google.cloud.bigquery.stora"
          + "ge.v1beta1.CreateReadSessionRequest\0322.go"
          + "ogle.cloud.bigquery.storage.v1beta1.Read"
          + "Session\"\250\001\332A(table_reference,parent,requ"
          + "ested_streams\202\323\344\223\002w\"0/v1beta1/{table_ref"
          + "erence.project_id=projects/*}:\001*Z@\";/v1b"
          + "eta1/{table_reference.dataset_id=project"
          + "s/*/datasets/*}:\001*\022\320\001\n\010ReadRows\0226.google"
          + ".cloud.bigquery.storage.v1beta1.ReadRows"
          + "Request\0327.google.cloud.bigquery.storage."
          + "v1beta1.ReadRowsResponse\"Q\332A\rread_positi"
          + "on\202\323\344\223\002;\0229/v1beta1/{read_position.stream"
          + ".name=projects/*/streams/*}0\001\022\220\002\n\035BatchC"
          + "reateReadSessionStreams\022K.google.cloud.b"
          + "igquery.storage.v1beta1.BatchCreateReadS"
          + "essionStreamsRequest\032L.google.cloud.bigq"
          + "uery.storage.v1beta1.BatchCreateReadSess"
          + "ionStreamsResponse\"T\332A\031session,requested"
          + "_streams\202\323\344\223\0022\"-/v1beta1/{session.name=p"
          + "rojects/*/sessions/*}:\001*\022\247\001\n\016FinalizeStr"
          + "eam\022<.google.cloud.bigquery.storage.v1be"
          + "ta1.FinalizeStreamRequest\032\026.google.proto"
          + "buf.Empty\"?\332A\006stream\202\323\344\223\0020\"+/v1beta1/{st"
          + "ream.name=projects/*/streams/*}:\001*\022\340\001\n\017S"
          + "plitReadStream\022=.google.cloud.bigquery.s"
          + "torage.v1beta1.SplitReadStreamRequest\032>."
          + "google.cloud.bigquery.storage.v1beta1.Sp"
          + "litReadStreamResponse\"N\332A\017original_strea"
          + "m\202\323\344\223\0026\0224/v1beta1/{original_stream.name="
          + "projects/*/streams/*}\032{\312A\036bigquerystorag"
          + "e.googleapis.com\322AWhttps://www.googleapi"
          + "s.com/auth/bigquery,https://www.googleap"
          + "is.com/auth/cloud-platformBp\n)com.google"
          + ".cloud.bigquery.storage.v1beta1ZCcloud.g"
          + "oogle.com/go/bigquery/storage/apiv1beta1"
          + "/storagepb;storagepbb\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.AnnotationsProto.getDescriptor(),
              com.google.api.ClientProto.getDescriptor(),
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.api.ResourceProto.getDescriptor(),
              com.google.cloud.bigquery.storage.v1beta1.ArrowProto.getDescriptor(),
              com.google.cloud.bigquery.storage.v1beta1.AvroProto.getDescriptor(),
              com.google.cloud.bigquery.storage.v1beta1.ReadOptions.getDescriptor(),
              com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.getDescriptor(),
              com.google.protobuf.EmptyProto.getDescriptor(),
              com.google.protobuf.TimestampProto.getDescriptor(),
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_Stream_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_bigquery_storage_v1beta1_Stream_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_Stream_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_StreamPosition_descriptor,
            new java.lang.String[] {
              "Stream", "Offset",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_ReadSession_descriptor,
            new java.lang.String[] {
              "Name",
              "ExpireTime",
              "AvroSchema",
              "ArrowSchema",
              "Streams",
              "TableReference",
              "TableModifiers",
              "ShardingStrategy",
              "Schema",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_descriptor =
        getDescriptor().getMessageTypes().get(3);
    internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_CreateReadSessionRequest_descriptor,
            new java.lang.String[] {
              "TableReference",
              "Parent",
              "TableModifiers",
              "RequestedStreams",
              "ReadOptions",
              "Format",
              "ShardingStrategy",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_descriptor =
        getDescriptor().getMessageTypes().get(4);
    internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsRequest_descriptor,
            new java.lang.String[] {
              "ReadPosition",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_descriptor =
        getDescriptor().getMessageTypes().get(5);
    internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_StreamStatus_descriptor,
            new java.lang.String[] {
              "EstimatedRowCount", "FractionConsumed", "Progress", "IsSplittable",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_Progress_descriptor =
        getDescriptor().getMessageTypes().get(6);
    internal_static_google_cloud_bigquery_storage_v1beta1_Progress_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_Progress_descriptor,
            new java.lang.String[] {
              "AtResponseStart", "AtResponseEnd",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_descriptor =
        getDescriptor().getMessageTypes().get(7);
    internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_ThrottleStatus_descriptor,
            new java.lang.String[] {
              "ThrottlePercent",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_descriptor =
        getDescriptor().getMessageTypes().get(8);
    internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_ReadRowsResponse_descriptor,
            new java.lang.String[] {
              "AvroRows",
              "ArrowRecordBatch",
              "RowCount",
              "Status",
              "ThrottleStatus",
              "AvroSchema",
              "ArrowSchema",
              "Rows",
              "Schema",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_descriptor =
        getDescriptor().getMessageTypes().get(9);
    internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsRequest_descriptor,
            new java.lang.String[] {
              "Session", "RequestedStreams",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_descriptor =
        getDescriptor().getMessageTypes().get(10);
    internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_BatchCreateReadSessionStreamsResponse_descriptor,
            new java.lang.String[] {
              "Streams",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_descriptor =
        getDescriptor().getMessageTypes().get(11);
    internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_FinalizeStreamRequest_descriptor,
            new java.lang.String[] {
              "Stream",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_descriptor =
        getDescriptor().getMessageTypes().get(12);
    internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamRequest_descriptor,
            new java.lang.String[] {
              "OriginalStream", "Fraction",
            });
    internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_descriptor =
        getDescriptor().getMessageTypes().get(13);
    internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1beta1_SplitReadStreamResponse_descriptor,
            new java.lang.String[] {
              "PrimaryStream", "RemainderStream",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.ClientProto.defaultHost);
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.AnnotationsProto.http);
    registry.add(com.google.api.ClientProto.methodSignature);
    registry.add(com.google.api.ClientProto.oauthScopes);
    registry.add(com.google.api.ResourceProto.resource);
    registry.add(com.google.api.ResourceProto.resourceReference);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.AnnotationsProto.getDescriptor();
    com.google.api.ClientProto.getDescriptor();
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.api.ResourceProto.getDescriptor();
    com.google.cloud.bigquery.storage.v1beta1.ArrowProto.getDescriptor();
    com.google.cloud.bigquery.storage.v1beta1.AvroProto.getDescriptor();
    com.google.cloud.bigquery.storage.v1beta1.ReadOptions.getDescriptor();
    com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto.getDescriptor();
    com.google.protobuf.EmptyProto.getDescriptor();
    com.google.protobuf.TimestampProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
