/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StreamName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/streams/{stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String stream;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStream() {
        return this.stream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private StreamName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.stream = (String)Preconditions.checkNotNull((Object)builder.getStream());
    }

    public static StreamName of(String project, String location, String stream) {
        return StreamName.newBuilder().setProject(project).setLocation(location).setStream(stream).build();
    }

    public static String format(String project, String location, String stream) {
        return StreamName.newBuilder().setProject(project).setLocation(location).setStream(stream).build().toString();
    }

    public static StreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "StreamName.parse: formattedString not in valid format");
        return StreamName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("stream"));
    }

    public static List<StreamName> parseList(List<String> formattedStrings) {
        ArrayList<StreamName> list = new ArrayList<StreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(StreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<StreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (StreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            StreamName streamName = this;
            synchronized (streamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"stream", (Object)this.stream);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "stream", this.stream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StreamName) {
            StreamName that = (StreamName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.stream.equals(that.stream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.stream.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String stream;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getStream() {
            return this.stream;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        private Builder() {
        }

        private Builder(StreamName streamName) {
            this.project = streamName.project;
            this.location = streamName.location;
            this.stream = streamName.stream;
        }

        public StreamName build() {
            return new StreamName(this);
        }
    }
}

