/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1alpha2/storage.proto

package com.google.cloud.bigquery.storage.v1alpha2;

public final class Storage {
  private Storage() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface CreateWriteStreamRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which the stream belongs, in the format
     * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which the stream belongs, in the format
     * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Required. Stream to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the writeStream field is set.
     */
    boolean hasWriteStream();
    /**
     *
     *
     * <pre>
     * Required. Stream to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The writeStream.
     */
    com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream getWriteStream();
    /**
     *
     *
     * <pre>
     * Required. Stream to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStreamOrBuilder
        getWriteStreamOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Request message for `CreateWriteStream`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest}
   */
  public static final class CreateWriteStreamRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest)
      CreateWriteStreamRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CreateWriteStreamRequest.newBuilder() to construct.
    private CreateWriteStreamRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CreateWriteStreamRequest() {
      parent_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CreateWriteStreamRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CreateWriteStreamRequest(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                parent_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder subBuilder =
                    null;
                if (writeStream_ != null) {
                  subBuilder = writeStream_.toBuilder();
                }
                writeStream_ =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(writeStream_);
                  writeStream_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest.class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest.Builder
                  .class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object parent_;
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which the stream belongs, in the format
     * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which the stream belongs, in the format
     * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int WRITE_STREAM_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream writeStream_;
    /**
     *
     *
     * <pre>
     * Required. Stream to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the writeStream field is set.
     */
    public boolean hasWriteStream() {
      return writeStream_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Stream to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The writeStream.
     */
    public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream getWriteStream() {
      return writeStream_ == null
          ? com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.getDefaultInstance()
          : writeStream_;
    }
    /**
     *
     *
     * <pre>
     * Required. Stream to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStreamOrBuilder
        getWriteStreamOrBuilder() {
      return getWriteStream();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getParentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (writeStream_ != null) {
        output.writeMessage(2, getWriteStream());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getParentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (writeStream_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getWriteStream());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (hasWriteStream() != other.hasWriteStream()) return false;
      if (hasWriteStream()) {
        if (!getWriteStream().equals(other.getWriteStream())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      if (hasWriteStream()) {
        hash = (37 * hash) + WRITE_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getWriteStream().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request message for `CreateWriteStream`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest)
        com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest.class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        parent_ = "";

        if (writeStreamBuilder_ == null) {
          writeStream_ = null;
        } else {
          writeStream_ = null;
          writeStreamBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest(this);
        result.parent_ = parent_;
        if (writeStreamBuilder_ == null) {
          result.writeStream_ = writeStream_;
        } else {
          result.writeStream_ = writeStreamBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
                .getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          onChanged();
        }
        if (other.hasWriteStream()) {
          mergeWriteStream(other.getWriteStream());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. Reference to the table to which the stream belongs, in the format
       * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Reference to the table to which the stream belongs, in the format
       * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Reference to the table to which the stream belongs, in the format
       * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        parent_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Reference to the table to which the stream belongs, in the format
       * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {

        parent_ = getDefaultInstance().getParent();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Reference to the table to which the stream belongs, in the format
       * of `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        parent_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream writeStream_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream,
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder,
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStreamOrBuilder>
          writeStreamBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the writeStream field is set.
       */
      public boolean hasWriteStream() {
        return writeStreamBuilder_ != null || writeStream_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The writeStream.
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream getWriteStream() {
        if (writeStreamBuilder_ == null) {
          return writeStream_ == null
              ? com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.getDefaultInstance()
              : writeStream_;
        } else {
          return writeStreamBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setWriteStream(
          com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream value) {
        if (writeStreamBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          writeStream_ = value;
          onChanged();
        } else {
          writeStreamBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setWriteStream(
          com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder builderForValue) {
        if (writeStreamBuilder_ == null) {
          writeStream_ = builderForValue.build();
          onChanged();
        } else {
          writeStreamBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeWriteStream(
          com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream value) {
        if (writeStreamBuilder_ == null) {
          if (writeStream_ != null) {
            writeStream_ =
                com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.newBuilder(
                        writeStream_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            writeStream_ = value;
          }
          onChanged();
        } else {
          writeStreamBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearWriteStream() {
        if (writeStreamBuilder_ == null) {
          writeStream_ = null;
          onChanged();
        } else {
          writeStream_ = null;
          writeStreamBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder
          getWriteStreamBuilder() {

        onChanged();
        return getWriteStreamFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStreamOrBuilder
          getWriteStreamOrBuilder() {
        if (writeStreamBuilder_ != null) {
          return writeStreamBuilder_.getMessageOrBuilder();
        } else {
          return writeStream_ == null
              ? com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.getDefaultInstance()
              : writeStream_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Stream to be created.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1alpha2.WriteStream write_stream = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream,
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder,
              com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStreamOrBuilder>
          getWriteStreamFieldBuilder() {
        if (writeStreamBuilder_ == null) {
          writeStreamBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream,
                  com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStream.Builder,
                  com.google.cloud.bigquery.storage.v1alpha2.Stream.WriteStreamOrBuilder>(
                  getWriteStream(), getParentForChildren(), isClean());
          writeStream_ = null;
        }
        return writeStreamBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreateWriteStreamRequest> PARSER =
        new com.google.protobuf.AbstractParser<CreateWriteStreamRequest>() {
          @java.lang.Override
          public CreateWriteStreamRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CreateWriteStreamRequest(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CreateWriteStreamRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateWriteStreamRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.CreateWriteStreamRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AppendRowsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The stream that is the target of the append operation. This value must be
     * specified for the initial request. If subsequent requests specify the
     * stream name, it must equal to the value provided in the first request.
     * </pre>
     *
     * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The writeStream.
     */
    java.lang.String getWriteStream();
    /**
     *
     *
     * <pre>
     * Required. The stream that is the target of the append operation. This value must be
     * specified for the initial request. If subsequent requests specify the
     * stream name, it must equal to the value provided in the first request.
     * </pre>
     *
     * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for writeStream.
     */
    com.google.protobuf.ByteString getWriteStreamBytes();

    /**
     *
     *
     * <pre>
     * Optional. If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the offset field is set.
     */
    boolean hasOffset();
    /**
     *
     *
     * <pre>
     * Optional. If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The offset.
     */
    com.google.protobuf.Int64Value getOffset();
    /**
     *
     *
     * <pre>
     * Optional. If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder();

    /**
     * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
     * </code>
     *
     * @return Whether the protoRows field is set.
     */
    boolean hasProtoRows();
    /**
     * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
     * </code>
     *
     * @return The protoRows.
     */
    com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData getProtoRows();
    /**
     * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
     * </code>
     */
    com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoDataOrBuilder
        getProtoRowsOrBuilder();

    public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.RowsCase
        getRowsCase();
  }
  /**
   *
   *
   * <pre>
   * Request message for `AppendRows`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest}
   */
  public static final class AppendRowsRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest)
      AppendRowsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AppendRowsRequest.newBuilder() to construct.
    private AppendRowsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AppendRowsRequest() {
      writeStream_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AppendRowsRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private AppendRowsRequest(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                writeStream_ = s;
                break;
              }
            case 18:
              {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (offset_ != null) {
                  subBuilder = offset_.toBuilder();
                }
                offset_ =
                    input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(offset_);
                  offset_ = subBuilder.buildPartial();
                }

                break;
              }
            case 34:
              {
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                        .Builder
                    subBuilder = null;
                if (rowsCase_ == 4) {
                  subBuilder =
                      ((com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                                  .ProtoData)
                              rows_)
                          .toBuilder();
                }
                rows_ =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                            .ProtoData.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                              .ProtoData)
                          rows_);
                  rows_ = subBuilder.buildPartial();
                }
                rowsCase_ = 4;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.Builder.class);
    }

    public interface ProtoDataOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Proto schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
       *
       * @return Whether the writerSchema field is set.
       */
      boolean hasWriterSchema();
      /**
       *
       *
       * <pre>
       * Proto schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
       *
       * @return The writerSchema.
       */
      com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema getWriterSchema();
      /**
       *
       *
       * <pre>
       * Proto schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
       */
      com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchemaOrBuilder
          getWriterSchemaOrBuilder();

      /**
       *
       *
       * <pre>
       * Serialized row data in protobuf message format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
       *
       * @return Whether the rows field is set.
       */
      boolean hasRows();
      /**
       *
       *
       * <pre>
       * Serialized row data in protobuf message format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
       *
       * @return The rows.
       */
      com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows getRows();
      /**
       *
       *
       * <pre>
       * Serialized row data in protobuf message format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
       */
      com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRowsOrBuilder
          getRowsOrBuilder();
    }
    /** Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData} */
    public static final class ProtoData extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData)
        ProtoDataOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ProtoData.newBuilder() to construct.
      private ProtoData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ProtoData() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ProtoData();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private ProtoData(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema.Builder
                      subBuilder = null;
                  if (writerSchema_ != null) {
                    subBuilder = writerSchema_.toBuilder();
                  }
                  writerSchema_ =
                      input.readMessage(
                          com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema
                              .parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(writerSchema_);
                    writerSchema_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 18:
                {
                  com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows.Builder
                      subBuilder = null;
                  if (rows_ != null) {
                    subBuilder = rows_.toBuilder();
                  }
                  rows_ =
                      input.readMessage(
                          com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows
                              .parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(rows_);
                    rows_ = subBuilder.buildPartial();
                  }

                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                    .class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                    .Builder.class);
      }

      public static final int WRITER_SCHEMA_FIELD_NUMBER = 1;
      private com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema writerSchema_;
      /**
       *
       *
       * <pre>
       * Proto schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
       *
       * @return Whether the writerSchema field is set.
       */
      public boolean hasWriterSchema() {
        return writerSchema_ != null;
      }
      /**
       *
       *
       * <pre>
       * Proto schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
       *
       * @return The writerSchema.
       */
      public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema
          getWriterSchema() {
        return writerSchema_ == null
            ? com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema
                .getDefaultInstance()
            : writerSchema_;
      }
      /**
       *
       *
       * <pre>
       * Proto schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchemaOrBuilder
          getWriterSchemaOrBuilder() {
        return getWriterSchema();
      }

      public static final int ROWS_FIELD_NUMBER = 2;
      private com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows rows_;
      /**
       *
       *
       * <pre>
       * Serialized row data in protobuf message format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
       *
       * @return Whether the rows field is set.
       */
      public boolean hasRows() {
        return rows_ != null;
      }
      /**
       *
       *
       * <pre>
       * Serialized row data in protobuf message format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
       *
       * @return The rows.
       */
      public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows getRows() {
        return rows_ == null
            ? com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows
                .getDefaultInstance()
            : rows_;
      }
      /**
       *
       *
       * <pre>
       * Serialized row data in protobuf message format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRowsOrBuilder
          getRowsOrBuilder() {
        return getRows();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (hasWriterSchema()) {
          if (!getWriterSchema().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (writerSchema_ != null) {
          output.writeMessage(1, getWriterSchema());
        }
        if (rows_ != null) {
          output.writeMessage(2, getRows());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (writerSchema_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getWriterSchema());
        }
        if (rows_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRows());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)) {
          return super.equals(obj);
        }
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData other =
            (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData) obj;

        if (hasWriterSchema() != other.hasWriterSchema()) return false;
        if (hasWriterSchema()) {
          if (!getWriterSchema().equals(other.getWriterSchema())) return false;
        }
        if (hasRows() != other.hasRows()) return false;
        if (hasRows()) {
          if (!getRows().equals(other.getRows())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasWriterSchema()) {
          hash = (37 * hash) + WRITER_SCHEMA_FIELD_NUMBER;
          hash = (53 * hash) + getWriterSchema().hashCode();
        }
        if (hasRows()) {
          hash = (37 * hash) + ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getRows().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData)
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoDataOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.bigquery.storage.v1alpha2.Storage
              .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.bigquery.storage.v1alpha2.Storage
              .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                      .class,
                  com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (writerSchemaBuilder_ == null) {
            writerSchema_ = null;
          } else {
            writerSchema_ = null;
            writerSchemaBuilder_ = null;
          }
          if (rowsBuilder_ == null) {
            rows_ = null;
          } else {
            rows_ = null;
            rowsBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.bigquery.storage.v1alpha2.Storage
              .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
            getDefaultInstanceForType() {
          return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
            build() {
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
            buildPartial() {
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData result =
              new com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData(
                  this);
          if (writerSchemaBuilder_ == null) {
            result.writerSchema_ = writerSchema_;
          } else {
            result.writerSchema_ = writerSchemaBuilder_.build();
          }
          if (rowsBuilder_ == null) {
            result.rows_ = rows_;
          } else {
            result.rows_ = rowsBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData) {
            return mergeFrom(
                (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData other) {
          if (other
              == com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                  .getDefaultInstance()) return this;
          if (other.hasWriterSchema()) {
            mergeWriterSchema(other.getWriterSchema());
          }
          if (other.hasRows()) {
            mergeRows(other.getRows());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (hasWriterSchema()) {
            if (!getWriterSchema().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema writerSchema_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema.Builder,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchemaOrBuilder>
            writerSchemaBuilder_;
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         *
         * @return Whether the writerSchema field is set.
         */
        public boolean hasWriterSchema() {
          return writerSchemaBuilder_ != null || writerSchema_ != null;
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         *
         * @return The writerSchema.
         */
        public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema
            getWriterSchema() {
          if (writerSchemaBuilder_ == null) {
            return writerSchema_ == null
                ? com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema
                    .getDefaultInstance()
                : writerSchema_;
          } else {
            return writerSchemaBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         */
        public Builder setWriterSchema(
            com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema value) {
          if (writerSchemaBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            writerSchema_ = value;
            onChanged();
          } else {
            writerSchemaBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         */
        public Builder setWriterSchema(
            com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema.Builder
                builderForValue) {
          if (writerSchemaBuilder_ == null) {
            writerSchema_ = builderForValue.build();
            onChanged();
          } else {
            writerSchemaBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         */
        public Builder mergeWriterSchema(
            com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema value) {
          if (writerSchemaBuilder_ == null) {
            if (writerSchema_ != null) {
              writerSchema_ =
                  com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema.newBuilder(
                          writerSchema_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              writerSchema_ = value;
            }
            onChanged();
          } else {
            writerSchemaBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         */
        public Builder clearWriterSchema() {
          if (writerSchemaBuilder_ == null) {
            writerSchema_ = null;
            onChanged();
          } else {
            writerSchema_ = null;
            writerSchemaBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         */
        public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema.Builder
            getWriterSchemaBuilder() {

          onChanged();
          return getWriterSchemaFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         */
        public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchemaOrBuilder
            getWriterSchemaOrBuilder() {
          if (writerSchemaBuilder_ != null) {
            return writerSchemaBuilder_.getMessageOrBuilder();
          } else {
            return writerSchema_ == null
                ? com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema
                    .getDefaultInstance()
                : writerSchema_;
          }
        }
        /**
         *
         *
         * <pre>
         * Proto schema used to serialize the data.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoSchema writer_schema = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema.Builder,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchemaOrBuilder>
            getWriterSchemaFieldBuilder() {
          if (writerSchemaBuilder_ == null) {
            writerSchemaBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema,
                    com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchema.Builder,
                    com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoSchemaOrBuilder>(
                    getWriterSchema(), getParentForChildren(), isClean());
            writerSchema_ = null;
          }
          return writerSchemaBuilder_;
        }

        private com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows rows_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows.Builder,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRowsOrBuilder>
            rowsBuilder_;
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         *
         * @return Whether the rows field is set.
         */
        public boolean hasRows() {
          return rowsBuilder_ != null || rows_ != null;
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         *
         * @return The rows.
         */
        public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows getRows() {
          if (rowsBuilder_ == null) {
            return rows_ == null
                ? com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows
                    .getDefaultInstance()
                : rows_;
          } else {
            return rowsBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         */
        public Builder setRows(
            com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows value) {
          if (rowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            rows_ = value;
            onChanged();
          } else {
            rowsBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         */
        public Builder setRows(
            com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows.Builder
                builderForValue) {
          if (rowsBuilder_ == null) {
            rows_ = builderForValue.build();
            onChanged();
          } else {
            rowsBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         */
        public Builder mergeRows(
            com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows value) {
          if (rowsBuilder_ == null) {
            if (rows_ != null) {
              rows_ =
                  com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows.newBuilder(
                          rows_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              rows_ = value;
            }
            onChanged();
          } else {
            rowsBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         */
        public Builder clearRows() {
          if (rowsBuilder_ == null) {
            rows_ = null;
            onChanged();
          } else {
            rows_ = null;
            rowsBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         */
        public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows.Builder
            getRowsBuilder() {

          onChanged();
          return getRowsFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         */
        public com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRowsOrBuilder
            getRowsOrBuilder() {
          if (rowsBuilder_ != null) {
            return rowsBuilder_.getMessageOrBuilder();
          } else {
            return rows_ == null
                ? com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows
                    .getDefaultInstance()
                : rows_;
          }
        }
        /**
         *
         *
         * <pre>
         * Serialized row data in protobuf message format.
         * </pre>
         *
         * <code>.google.cloud.bigquery.storage.v1alpha2.ProtoRows rows = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows.Builder,
                com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRowsOrBuilder>
            getRowsFieldBuilder() {
          if (rowsBuilder_ == null) {
            rowsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows,
                    com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRows.Builder,
                    com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.ProtoRowsOrBuilder>(
                    getRows(), getParentForChildren(), isClean());
            rows_ = null;
          }
          return rowsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData)
      private static final com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
              .ProtoData
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData();
      }

      public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ProtoData> PARSER =
          new com.google.protobuf.AbstractParser<ProtoData>() {
            @java.lang.Override
            public ProtoData parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new ProtoData(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<ProtoData> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ProtoData> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int rowsCase_ = 0;
    private java.lang.Object rows_;

    public enum RowsCase implements com.google.protobuf.Internal.EnumLite {
      PROTO_ROWS(4),
      ROWS_NOT_SET(0);
      private final int value;

      private RowsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RowsCase valueOf(int value) {
        return forNumber(value);
      }

      public static RowsCase forNumber(int value) {
        switch (value) {
          case 4:
            return PROTO_ROWS;
          case 0:
            return ROWS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public RowsCase getRowsCase() {
      return RowsCase.forNumber(rowsCase_);
    }

    public static final int WRITE_STREAM_FIELD_NUMBER = 1;
    private volatile java.lang.Object writeStream_;
    /**
     *
     *
     * <pre>
     * Required. The stream that is the target of the append operation. This value must be
     * specified for the initial request. If subsequent requests specify the
     * stream name, it must equal to the value provided in the first request.
     * </pre>
     *
     * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The writeStream.
     */
    public java.lang.String getWriteStream() {
      java.lang.Object ref = writeStream_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        writeStream_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The stream that is the target of the append operation. This value must be
     * specified for the initial request. If subsequent requests specify the
     * stream name, it must equal to the value provided in the first request.
     * </pre>
     *
     * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for writeStream.
     */
    public com.google.protobuf.ByteString getWriteStreamBytes() {
      java.lang.Object ref = writeStream_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        writeStream_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OFFSET_FIELD_NUMBER = 2;
    private com.google.protobuf.Int64Value offset_;
    /**
     *
     *
     * <pre>
     * Optional. If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the offset field is set.
     */
    public boolean hasOffset() {
      return offset_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The offset.
     */
    public com.google.protobuf.Int64Value getOffset() {
      return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder() {
      return getOffset();
    }

    public static final int PROTO_ROWS_FIELD_NUMBER = 4;
    /**
     * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
     * </code>
     *
     * @return Whether the protoRows field is set.
     */
    public boolean hasProtoRows() {
      return rowsCase_ == 4;
    }
    /**
     * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
     * </code>
     *
     * @return The protoRows.
     */
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
        getProtoRows() {
      if (rowsCase_ == 4) {
        return (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
            rows_;
      }
      return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          .getDefaultInstance();
    }
    /**
     * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoDataOrBuilder
        getProtoRowsOrBuilder() {
      if (rowsCase_ == 4) {
        return (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
            rows_;
      }
      return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (rowsCase_ == 4) {
        if (!getProtoRows().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getWriteStreamBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, writeStream_);
      }
      if (offset_ != null) {
        output.writeMessage(2, getOffset());
      }
      if (rowsCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData) rows_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getWriteStreamBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, writeStream_);
      }
      if (offset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOffset());
      }
      if (rowsCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
                    rows_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest) obj;

      if (!getWriteStream().equals(other.getWriteStream())) return false;
      if (hasOffset() != other.hasOffset()) return false;
      if (hasOffset()) {
        if (!getOffset().equals(other.getOffset())) return false;
      }
      if (!getRowsCase().equals(other.getRowsCase())) return false;
      switch (rowsCase_) {
        case 4:
          if (!getProtoRows().equals(other.getProtoRows())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WRITE_STREAM_FIELD_NUMBER;
      hash = (53 * hash) + getWriteStream().hashCode();
      if (hasOffset()) {
        hash = (37 * hash) + OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getOffset().hashCode();
      }
      switch (rowsCase_) {
        case 4:
          hash = (37 * hash) + PROTO_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getProtoRows().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request message for `AppendRows`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest)
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        writeStream_ = "";

        if (offsetBuilder_ == null) {
          offset_ = null;
        } else {
          offset_ = null;
          offsetBuilder_ = null;
        }
        rowsCase_ = 0;
        rows_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest(this);
        result.writeStream_ = writeStream_;
        if (offsetBuilder_ == null) {
          result.offset_ = offset_;
        } else {
          result.offset_ = offsetBuilder_.build();
        }
        if (rowsCase_ == 4) {
          if (protoRowsBuilder_ == null) {
            result.rows_ = rows_;
          } else {
            result.rows_ = protoRowsBuilder_.build();
          }
        }
        result.rowsCase_ = rowsCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                .getDefaultInstance()) return this;
        if (!other.getWriteStream().isEmpty()) {
          writeStream_ = other.writeStream_;
          onChanged();
        }
        if (other.hasOffset()) {
          mergeOffset(other.getOffset());
        }
        switch (other.getRowsCase()) {
          case PROTO_ROWS:
            {
              mergeProtoRows(other.getProtoRows());
              break;
            }
          case ROWS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (rowsCase_ == 4) {
          if (!getProtoRows().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int rowsCase_ = 0;
      private java.lang.Object rows_;

      public RowsCase getRowsCase() {
        return RowsCase.forNumber(rowsCase_);
      }

      public Builder clearRows() {
        rowsCase_ = 0;
        rows_ = null;
        onChanged();
        return this;
      }

      private java.lang.Object writeStream_ = "";
      /**
       *
       *
       * <pre>
       * Required. The stream that is the target of the append operation. This value must be
       * specified for the initial request. If subsequent requests specify the
       * stream name, it must equal to the value provided in the first request.
       * </pre>
       *
       * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The writeStream.
       */
      public java.lang.String getWriteStream() {
        java.lang.Object ref = writeStream_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          writeStream_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The stream that is the target of the append operation. This value must be
       * specified for the initial request. If subsequent requests specify the
       * stream name, it must equal to the value provided in the first request.
       * </pre>
       *
       * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for writeStream.
       */
      public com.google.protobuf.ByteString getWriteStreamBytes() {
        java.lang.Object ref = writeStream_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          writeStream_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The stream that is the target of the append operation. This value must be
       * specified for the initial request. If subsequent requests specify the
       * stream name, it must equal to the value provided in the first request.
       * </pre>
       *
       * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The writeStream to set.
       * @return This builder for chaining.
       */
      public Builder setWriteStream(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        writeStream_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The stream that is the target of the append operation. This value must be
       * specified for the initial request. If subsequent requests specify the
       * stream name, it must equal to the value provided in the first request.
       * </pre>
       *
       * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWriteStream() {

        writeStream_ = getDefaultInstance().getWriteStream();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The stream that is the target of the append operation. This value must be
       * specified for the initial request. If subsequent requests specify the
       * stream name, it must equal to the value provided in the first request.
       * </pre>
       *
       * <code>string write_stream = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for writeStream to set.
       * @return This builder for chaining.
       */
      public Builder setWriteStreamBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        writeStream_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.Int64Value offset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int64Value,
              com.google.protobuf.Int64Value.Builder,
              com.google.protobuf.Int64ValueOrBuilder>
          offsetBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the offset field is set.
       */
      public boolean hasOffset() {
        return offsetBuilder_ != null || offset_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The offset.
       */
      public com.google.protobuf.Int64Value getOffset() {
        if (offsetBuilder_ == null) {
          return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
        } else {
          return offsetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOffset(com.google.protobuf.Int64Value value) {
        if (offsetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          offset_ = value;
          onChanged();
        } else {
          offsetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOffset(com.google.protobuf.Int64Value.Builder builderForValue) {
        if (offsetBuilder_ == null) {
          offset_ = builderForValue.build();
          onChanged();
        } else {
          offsetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOffset(com.google.protobuf.Int64Value value) {
        if (offsetBuilder_ == null) {
          if (offset_ != null) {
            offset_ =
                com.google.protobuf.Int64Value.newBuilder(offset_).mergeFrom(value).buildPartial();
          } else {
            offset_ = value;
          }
          onChanged();
        } else {
          offsetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOffset() {
        if (offsetBuilder_ == null) {
          offset_ = null;
          onChanged();
        } else {
          offset_ = null;
          offsetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Int64Value.Builder getOffsetBuilder() {

        onChanged();
        return getOffsetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder() {
        if (offsetBuilder_ != null) {
          return offsetBuilder_.getMessageOrBuilder();
        } else {
          return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. If present, the write is only performed if the next append offset is same
       * as the provided value. If not present, the write is performed at the
       * current end of stream.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value offset = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int64Value,
              com.google.protobuf.Int64Value.Builder,
              com.google.protobuf.Int64ValueOrBuilder>
          getOffsetFieldBuilder() {
        if (offsetBuilder_ == null) {
          offsetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Int64Value,
                  com.google.protobuf.Int64Value.Builder,
                  com.google.protobuf.Int64ValueOrBuilder>(
                  getOffset(), getParentForChildren(), isClean());
          offset_ = null;
        }
        return offsetBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                  .Builder,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                  .ProtoDataOrBuilder>
          protoRowsBuilder_;
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       *
       * @return Whether the protoRows field is set.
       */
      public boolean hasProtoRows() {
        return rowsCase_ == 4;
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       *
       * @return The protoRows.
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
          getProtoRows() {
        if (protoRowsBuilder_ == null) {
          if (rowsCase_ == 4) {
            return (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
                rows_;
          }
          return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
              .getDefaultInstance();
        } else {
          if (rowsCase_ == 4) {
            return protoRowsBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
              .getDefaultInstance();
        }
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       */
      public Builder setProtoRows(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData value) {
        if (protoRowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rows_ = value;
          onChanged();
        } else {
          protoRowsBuilder_.setMessage(value);
        }
        rowsCase_ = 4;
        return this;
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       */
      public Builder setProtoRows(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData.Builder
              builderForValue) {
        if (protoRowsBuilder_ == null) {
          rows_ = builderForValue.build();
          onChanged();
        } else {
          protoRowsBuilder_.setMessage(builderForValue.build());
        }
        rowsCase_ = 4;
        return this;
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       */
      public Builder mergeProtoRows(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData value) {
        if (protoRowsBuilder_ == null) {
          if (rowsCase_ == 4
              && rows_
                  != com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                      .getDefaultInstance()) {
            rows_ =
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                    .newBuilder(
                        (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                                .ProtoData)
                            rows_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rows_ = value;
          }
          onChanged();
        } else {
          if (rowsCase_ == 4) {
            protoRowsBuilder_.mergeFrom(value);
          }
          protoRowsBuilder_.setMessage(value);
        }
        rowsCase_ = 4;
        return this;
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       */
      public Builder clearProtoRows() {
        if (protoRowsBuilder_ == null) {
          if (rowsCase_ == 4) {
            rowsCase_ = 0;
            rows_ = null;
            onChanged();
          }
        } else {
          if (rowsCase_ == 4) {
            rowsCase_ = 0;
            rows_ = null;
          }
          protoRowsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData.Builder
          getProtoRowsBuilder() {
        return getProtoRowsFieldBuilder().getBuilder();
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoDataOrBuilder
          getProtoRowsOrBuilder() {
        if ((rowsCase_ == 4) && (protoRowsBuilder_ != null)) {
          return protoRowsBuilder_.getMessageOrBuilder();
        } else {
          if (rowsCase_ == 4) {
            return (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
                rows_;
          }
          return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
              .getDefaultInstance();
        }
      }
      /**
       * <code>.google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData proto_rows = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                  .Builder,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                  .ProtoDataOrBuilder>
          getProtoRowsFieldBuilder() {
        if (protoRowsBuilder_ == null) {
          if (!(rowsCase_ == 4)) {
            rows_ =
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                    .getDefaultInstance();
          }
          protoRowsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData,
                  com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData
                      .Builder,
                  com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
                      .ProtoDataOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest.ProtoData)
                      rows_,
                  getParentForChildren(),
                  isClean());
          rows_ = null;
        }
        rowsCase_ = 4;
        onChanged();
        ;
        return protoRowsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AppendRowsRequest> PARSER =
        new com.google.protobuf.AbstractParser<AppendRowsRequest>() {
          @java.lang.Override
          public AppendRowsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new AppendRowsRequest(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<AppendRowsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AppendRowsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AppendRowsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred.
     * </pre>
     *
     * <code>int64 offset = 1;</code>
     *
     * @return The offset.
     */
    long getOffset();

    /**
     *
     *
     * <pre>
     * Error in case of append failure. If set, it means rows are not accepted
     * into the system. Users can retry within the same connection.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     *
     *
     * <pre>
     * Error in case of append failure. If set, it means rows are not accepted
     * into the system. Users can retry within the same connection.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return The error.
     */
    com.google.rpc.Status getError();
    /**
     *
     *
     * <pre>
     * Error in case of append failure. If set, it means rows are not accepted
     * into the system. Users can retry within the same connection.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    com.google.rpc.StatusOrBuilder getErrorOrBuilder();

    public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse.ResponseCase
        getResponseCase();
  }
  /**
   *
   *
   * <pre>
   * Response message for `AppendRows`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse}
   */
  public static final class AppendRowsResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse)
      AppendRowsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AppendRowsResponse.newBuilder() to construct.
    private AppendRowsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AppendRowsResponse() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AppendRowsResponse();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private AppendRowsResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                responseCase_ = 1;
                response_ = input.readInt64();
                break;
              }
            case 18:
              {
                com.google.rpc.Status.Builder subBuilder = null;
                if (responseCase_ == 2) {
                  subBuilder = ((com.google.rpc.Status) response_).toBuilder();
                }
                response_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.rpc.Status) response_);
                  response_ = subBuilder.buildPartial();
                }
                responseCase_ = 2;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse.class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse.Builder.class);
    }

    private int responseCase_ = 0;
    private java.lang.Object response_;

    public enum ResponseCase implements com.google.protobuf.Internal.EnumLite {
      OFFSET(1),
      ERROR(2),
      RESPONSE_NOT_SET(0);
      private final int value;

      private ResponseCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResponseCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResponseCase forNumber(int value) {
        switch (value) {
          case 1:
            return OFFSET;
          case 2:
            return ERROR;
          case 0:
            return RESPONSE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ResponseCase getResponseCase() {
      return ResponseCase.forNumber(responseCase_);
    }

    public static final int OFFSET_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The row offset at which the last append occurred.
     * </pre>
     *
     * <code>int64 offset = 1;</code>
     *
     * @return The offset.
     */
    public long getOffset() {
      if (responseCase_ == 1) {
        return (java.lang.Long) response_;
      }
      return 0L;
    }

    public static final int ERROR_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Error in case of append failure. If set, it means rows are not accepted
     * into the system. Users can retry within the same connection.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return responseCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Error in case of append failure. If set, it means rows are not accepted
     * into the system. Users can retry within the same connection.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (responseCase_ == 2) {
        return (com.google.rpc.Status) response_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Error in case of append failure. If set, it means rows are not accepted
     * into the system. Users can retry within the same connection.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (responseCase_ == 2) {
        return (com.google.rpc.Status) response_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (responseCase_ == 1) {
        output.writeInt64(1, (long) ((java.lang.Long) response_));
      }
      if (responseCase_ == 2) {
        output.writeMessage(2, (com.google.rpc.Status) response_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (responseCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                1, (long) ((java.lang.Long) response_));
      }
      if (responseCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.rpc.Status) response_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse) obj;

      if (!getResponseCase().equals(other.getResponseCase())) return false;
      switch (responseCase_) {
        case 1:
          if (getOffset() != other.getOffset()) return false;
          break;
        case 2:
          if (!getError().equals(other.getError())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (responseCase_) {
        case 1:
          hash = (37 * hash) + OFFSET_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOffset());
          break;
        case 2:
          hash = (37 * hash) + ERROR_FIELD_NUMBER;
          hash = (53 * hash) + getError().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response message for `AppendRows`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse)
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse.class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        responseCase_ = 0;
        response_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse(this);
        if (responseCase_ == 1) {
          result.response_ = response_;
        }
        if (responseCase_ == 2) {
          if (errorBuilder_ == null) {
            result.response_ = response_;
          } else {
            result.response_ = errorBuilder_.build();
          }
        }
        result.responseCase_ = responseCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
                .getDefaultInstance()) return this;
        switch (other.getResponseCase()) {
          case OFFSET:
            {
              setOffset(other.getOffset());
              break;
            }
          case ERROR:
            {
              mergeError(other.getError());
              break;
            }
          case RESPONSE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int responseCase_ = 0;
      private java.lang.Object response_;

      public ResponseCase getResponseCase() {
        return ResponseCase.forNumber(responseCase_);
      }

      public Builder clearResponse() {
        responseCase_ = 0;
        response_ = null;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred.
       * </pre>
       *
       * <code>int64 offset = 1;</code>
       *
       * @return The offset.
       */
      public long getOffset() {
        if (responseCase_ == 1) {
          return (java.lang.Long) response_;
        }
        return 0L;
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred.
       * </pre>
       *
       * <code>int64 offset = 1;</code>
       *
       * @param value The offset to set.
       * @return This builder for chaining.
       */
      public Builder setOffset(long value) {
        responseCase_ = 1;
        response_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The row offset at which the last append occurred.
       * </pre>
       *
       * <code>int64 offset = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOffset() {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          errorBuilder_;
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       *
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return responseCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       *
       * @return The error.
       */
      public com.google.rpc.Status getError() {
        if (errorBuilder_ == null) {
          if (responseCase_ == 2) {
            return (com.google.rpc.Status) response_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        } else {
          if (responseCase_ == 2) {
            return errorBuilder_.getMessage();
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder setError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        responseCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder setError(com.google.rpc.Status.Builder builderForValue) {
        if (errorBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        responseCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder mergeError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (responseCase_ == 2 && response_ != com.google.rpc.Status.getDefaultInstance()) {
            response_ =
                com.google.rpc.Status.newBuilder((com.google.rpc.Status) response_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          if (responseCase_ == 2) {
            errorBuilder_.mergeFrom(value);
          }
          errorBuilder_.setMessage(value);
        }
        responseCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          if (responseCase_ == 2) {
            responseCase_ = 0;
            response_ = null;
            onChanged();
          }
        } else {
          if (responseCase_ == 2) {
            responseCase_ = 0;
            response_ = null;
          }
          errorBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public com.google.rpc.Status.Builder getErrorBuilder() {
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
        if ((responseCase_ == 2) && (errorBuilder_ != null)) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          if (responseCase_ == 2) {
            return (com.google.rpc.Status) response_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Error in case of append failure. If set, it means rows are not accepted
       * into the system. Users can retry within the same connection.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          if (!(responseCase_ == 2)) {
            response_ = com.google.rpc.Status.getDefaultInstance();
          }
          errorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  (com.google.rpc.Status) response_, getParentForChildren(), isClean());
          response_ = null;
        }
        responseCase_ = 2;
        onChanged();
        ;
        return errorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AppendRowsResponse> PARSER =
        new com.google.protobuf.AbstractParser<AppendRowsResponse>() {
          @java.lang.Override
          public AppendRowsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new AppendRowsResponse(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<AppendRowsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AppendRowsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.AppendRowsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GetWriteStreamRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the stream to get, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the stream to get, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Request message for `GetWriteStreamRequest`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest}
   */
  public static final class GetWriteStreamRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest)
      GetWriteStreamRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GetWriteStreamRequest.newBuilder() to construct.
    private GetWriteStreamRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GetWriteStreamRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GetWriteStreamRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private GetWriteStreamRequest(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest.class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required. Name of the stream to get, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the stream to get, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request message for `GetWriteStreamRequest`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest)
        com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest.class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest(this);
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to get, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to get, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to get, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to get, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to get, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GetWriteStreamRequest> PARSER =
        new com.google.protobuf.AbstractParser<GetWriteStreamRequest>() {
          @java.lang.Override
          public GetWriteStreamRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new GetWriteStreamRequest(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<GetWriteStreamRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetWriteStreamRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.GetWriteStreamRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchCommitWriteStreamsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Parent table that all the streams should belong to, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. Parent table that all the streams should belong to, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the writeStreams.
     */
    java.util.List<java.lang.String> getWriteStreamsList();
    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of writeStreams.
     */
    int getWriteStreamsCount();
    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The writeStreams at the given index.
     */
    java.lang.String getWriteStreams(int index);
    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the writeStreams at the given index.
     */
    com.google.protobuf.ByteString getWriteStreamsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Request message for `BatchCommitWriteStreams`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest}
   */
  public static final class BatchCommitWriteStreamsRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest)
      BatchCommitWriteStreamsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchCommitWriteStreamsRequest.newBuilder() to construct.
    private BatchCommitWriteStreamsRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchCommitWriteStreamsRequest() {
      parent_ = "";
      writeStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchCommitWriteStreamsRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private BatchCommitWriteStreamsRequest(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                parent_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  writeStreams_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                writeStreams_.add(s);
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          writeStreams_ = writeStreams_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
                  .class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
                  .Builder.class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object parent_;
    /**
     *
     *
     * <pre>
     * Required. Parent table that all the streams should belong to, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parent table that all the streams should belong to, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int WRITE_STREAMS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList writeStreams_;
    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the writeStreams.
     */
    public com.google.protobuf.ProtocolStringList getWriteStreamsList() {
      return writeStreams_;
    }
    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of writeStreams.
     */
    public int getWriteStreamsCount() {
      return writeStreams_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The writeStreams at the given index.
     */
    public java.lang.String getWriteStreams(int index) {
      return writeStreams_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The group of streams that will be committed atomically.
     * </pre>
     *
     * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the writeStreams at the given index.
     */
    public com.google.protobuf.ByteString getWriteStreamsBytes(int index) {
      return writeStreams_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getParentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      for (int i = 0; i < writeStreams_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, writeStreams_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getParentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < writeStreams_.size(); i++) {
          dataSize += computeStringSizeNoTag(writeStreams_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getWriteStreamsList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (!getWriteStreamsList().equals(other.getWriteStreamsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      if (getWriteStreamsCount() > 0) {
        hash = (37 * hash) + WRITE_STREAMS_FIELD_NUMBER;
        hash = (53 * hash) + getWriteStreamsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request message for `BatchCommitWriteStreams`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest)
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
                    .class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        parent_ = "";

        writeStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
          build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest(
                this);
        int from_bitField0_ = bitField0_;
        result.parent_ = parent_;
        if (((bitField0_ & 0x00000001) != 0)) {
          writeStreams_ = writeStreams_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.writeStreams_ = writeStreams_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
                .getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          onChanged();
        }
        if (!other.writeStreams_.isEmpty()) {
          if (writeStreams_.isEmpty()) {
            writeStreams_ = other.writeStreams_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWriteStreamsIsMutable();
            writeStreams_.addAll(other.writeStreams_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. Parent table that all the streams should belong to, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Parent table that all the streams should belong to, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Parent table that all the streams should belong to, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        parent_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Parent table that all the streams should belong to, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {

        parent_ = getDefaultInstance().getParent();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Parent table that all the streams should belong to, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`.
       * </pre>
       *
       * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        parent_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList writeStreams_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureWriteStreamsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          writeStreams_ = new com.google.protobuf.LazyStringArrayList(writeStreams_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the writeStreams.
       */
      public com.google.protobuf.ProtocolStringList getWriteStreamsList() {
        return writeStreams_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of writeStreams.
       */
      public int getWriteStreamsCount() {
        return writeStreams_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The writeStreams at the given index.
       */
      public java.lang.String getWriteStreams(int index) {
        return writeStreams_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes of the writeStreams to add.
       */
      public com.google.protobuf.ByteString getWriteStreamsBytes(int index) {
        return writeStreams_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index to set the value at.
       * @param value The writeStreams to set.
       * @return This builder for chaining.
       */
      public Builder setWriteStreams(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteStreamsIsMutable();
        writeStreams_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The writeStreams to add.
       * @return This builder for chaining.
       */
      public Builder addWriteStreams(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteStreamsIsMutable();
        writeStreams_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param values The writeStreams to add.
       * @return This builder for chaining.
       */
      public Builder addAllWriteStreams(java.lang.Iterable<java.lang.String> values) {
        ensureWriteStreamsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, writeStreams_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWriteStreams() {
        writeStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The group of streams that will be committed atomically.
       * </pre>
       *
       * <code>repeated string write_streams = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes of the writeStreams to add.
       * @return This builder for chaining.
       */
      public Builder addWriteStreamsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureWriteStreamsIsMutable();
        writeStreams_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage
            .BatchCommitWriteStreamsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchCommitWriteStreamsRequest> PARSER =
        new com.google.protobuf.AbstractParser<BatchCommitWriteStreamsRequest>() {
          @java.lang.Override
          public BatchCommitWriteStreamsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new BatchCommitWriteStreamsRequest(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<BatchCommitWriteStreamsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchCommitWriteStreamsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchCommitWriteStreamsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     *
     * @return Whether the commitTime field is set.
     */
    boolean hasCommitTime();
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     *
     * @return The commitTime.
     */
    com.google.protobuf.Timestamp getCommitTime();
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Response message for `BatchCommitWriteStreams`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse}
   */
  public static final class BatchCommitWriteStreamsResponse
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse)
      BatchCommitWriteStreamsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchCommitWriteStreamsResponse.newBuilder() to construct.
    private BatchCommitWriteStreamsResponse(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchCommitWriteStreamsResponse() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchCommitWriteStreamsResponse();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private BatchCommitWriteStreamsResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (commitTime_ != null) {
                  subBuilder = commitTime_.toBuilder();
                }
                commitTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(commitTime_);
                  commitTime_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
                  .class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
                  .Builder.class);
    }

    public static final int COMMIT_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp commitTime_;
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     *
     * @return Whether the commitTime field is set.
     */
    public boolean hasCommitTime() {
      return commitTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     *
     * @return The commitTime.
     */
    public com.google.protobuf.Timestamp getCommitTime() {
      return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
      return getCommitTime();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (commitTime_ != null) {
        output.writeMessage(1, getCommitTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (commitTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommitTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse) obj;

      if (hasCommitTime() != other.hasCommitTime()) return false;
      if (hasCommitTime()) {
        if (!getCommitTime().equals(other.getCommitTime())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCommitTime()) {
        hash = (37 * hash) + COMMIT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCommitTime().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response message for `BatchCommitWriteStreams`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse)
        com.google.cloud.bigquery.storage.v1alpha2.Storage
            .BatchCommitWriteStreamsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
                    .class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (commitTimeBuilder_ == null) {
          commitTime_ = null;
        } else {
          commitTime_ = null;
          commitTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
          build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
          buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse(
                this);
        if (commitTimeBuilder_ == null) {
          result.commitTime_ = commitTime_;
        } else {
          result.commitTime_ = commitTimeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
              other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
                .getDefaultInstance()) return this;
        if (other.hasCommitTime()) {
          mergeCommitTime(other.getCommitTime());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.protobuf.Timestamp commitTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          commitTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       *
       * @return Whether the commitTime field is set.
       */
      public boolean hasCommitTime() {
        return commitTimeBuilder_ != null || commitTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       *
       * @return The commitTime.
       */
      public com.google.protobuf.Timestamp getCommitTime() {
        if (commitTimeBuilder_ == null) {
          return commitTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTime_;
        } else {
          return commitTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       */
      public Builder setCommitTime(com.google.protobuf.Timestamp value) {
        if (commitTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          commitTime_ = value;
          onChanged();
        } else {
          commitTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       */
      public Builder setCommitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (commitTimeBuilder_ == null) {
          commitTime_ = builderForValue.build();
          onChanged();
        } else {
          commitTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       */
      public Builder mergeCommitTime(com.google.protobuf.Timestamp value) {
        if (commitTimeBuilder_ == null) {
          if (commitTime_ != null) {
            commitTime_ =
                com.google.protobuf.Timestamp.newBuilder(commitTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            commitTime_ = value;
          }
          onChanged();
        } else {
          commitTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       */
      public Builder clearCommitTime() {
        if (commitTimeBuilder_ == null) {
          commitTime_ = null;
          onChanged();
        } else {
          commitTime_ = null;
          commitTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCommitTimeBuilder() {

        onChanged();
        return getCommitTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
        if (commitTimeBuilder_ != null) {
          return commitTimeBuilder_.getMessageOrBuilder();
        } else {
          return commitTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which streams were committed in microseconds granularity.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCommitTimeFieldBuilder() {
        if (commitTimeBuilder_ == null) {
          commitTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCommitTime(), getParentForChildren(), isClean());
          commitTime_ = null;
        }
        return commitTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage
            .BatchCommitWriteStreamsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchCommitWriteStreamsResponse> PARSER =
        new com.google.protobuf.AbstractParser<BatchCommitWriteStreamsResponse>() {
          @java.lang.Override
          public BatchCommitWriteStreamsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new BatchCommitWriteStreamsResponse(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<BatchCommitWriteStreamsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchCommitWriteStreamsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.BatchCommitWriteStreamsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FinalizeWriteStreamRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the stream to finalize, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the stream to finalize, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Request message for invoking `FinalizeWriteStream`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest}
   */
  public static final class FinalizeWriteStreamRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest)
      FinalizeWriteStreamRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FinalizeWriteStreamRequest.newBuilder() to construct.
    private FinalizeWriteStreamRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FinalizeWriteStreamRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FinalizeWriteStreamRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private FinalizeWriteStreamRequest(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest.class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required. Name of the stream to finalize, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the stream to finalize, in the form of
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request message for invoking `FinalizeWriteStream`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest)
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest.class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
          buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest(this);
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to finalize, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to finalize, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to finalize, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to finalize, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the stream to finalize, in the form of
       * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}/streams/{stream_id}`.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage
            .FinalizeWriteStreamRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FinalizeWriteStreamRequest> PARSER =
        new com.google.protobuf.AbstractParser<FinalizeWriteStreamRequest>() {
          @java.lang.Override
          public FinalizeWriteStreamRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new FinalizeWriteStreamRequest(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<FinalizeWriteStreamRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FinalizeWriteStreamRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FinalizeWriteStreamResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of rows in the finalized stream.
     * </pre>
     *
     * <code>int64 row_count = 1;</code>
     *
     * @return The rowCount.
     */
    long getRowCount();
  }
  /**
   *
   *
   * <pre>
   * Response message for `FinalizeWriteStream`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse}
   */
  public static final class FinalizeWriteStreamResponse
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse)
      FinalizeWriteStreamResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FinalizeWriteStreamResponse.newBuilder() to construct.
    private FinalizeWriteStreamResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FinalizeWriteStreamResponse() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FinalizeWriteStreamResponse();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private FinalizeWriteStreamResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                rowCount_ = input.readInt64();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha2.Storage
          .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse.class,
              com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse.Builder
                  .class);
    }

    public static final int ROW_COUNT_FIELD_NUMBER = 1;
    private long rowCount_;
    /**
     *
     *
     * <pre>
     * Number of rows in the finalized stream.
     * </pre>
     *
     * <code>int64 row_count = 1;</code>
     *
     * @return The rowCount.
     */
    public long getRowCount() {
      return rowCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (rowCount_ != 0L) {
        output.writeInt64(1, rowCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (rowCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, rowCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse other =
          (com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse) obj;

      if (getRowCount() != other.getRowCount()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowCount());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response message for `FinalizeWriteStream`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse)
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
                    .class,
                com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        rowCount_ = 0L;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage
            .internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
          build() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
          buildPartial() {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse result =
            new com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse(
                this);
        result.rowCount_ = rowCount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse other) {
        if (other
            == com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
                .getDefaultInstance()) return this;
        if (other.getRowCount() != 0L) {
          setRowCount(other.getRowCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private long rowCount_;
      /**
       *
       *
       * <pre>
       * Number of rows in the finalized stream.
       * </pre>
       *
       * <code>int64 row_count = 1;</code>
       *
       * @return The rowCount.
       */
      public long getRowCount() {
        return rowCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of rows in the finalized stream.
       * </pre>
       *
       * <code>int64 row_count = 1;</code>
       *
       * @param value The rowCount to set.
       * @return This builder for chaining.
       */
      public Builder setRowCount(long value) {

        rowCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of rows in the finalized stream.
       * </pre>
       *
       * <code>int64 row_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowCount() {

        rowCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse)
    private static final com.google.cloud.bigquery.storage.v1alpha2.Storage
            .FinalizeWriteStreamResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse();
    }

    public static com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FinalizeWriteStreamResponse> PARSER =
        new com.google.protobuf.AbstractParser<FinalizeWriteStreamResponse>() {
          @java.lang.Override
          public FinalizeWriteStreamResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new FinalizeWriteStreamResponse(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<FinalizeWriteStreamResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FinalizeWriteStreamResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha2.Storage.FinalizeWriteStreamResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n4google/cloud/bigquery/storage/v1alpha2"
          + "/storage.proto\022&google.cloud.bigquery.st"
          + "orage.v1alpha2\032\034google/api/annotations.p"
          + "roto\032\027google/api/client.proto\032\037google/ap"
          + "i/field_behavior.proto\0325google/cloud/big"
          + "query/storage/v1alpha2/protobuf.proto\0323g"
          + "oogle/cloud/bigquery/storage/v1alpha2/st"
          + "ream.proto\032\033google/protobuf/empty.proto\032"
          + "\037google/protobuf/timestamp.proto\032\036google"
          + "/protobuf/wrappers.proto\032\027google/rpc/sta"
          + "tus.proto\"\177\n\030CreateWriteStreamRequest\022\023\n"
          + "\006parent\030\001 \001(\tB\003\340A\002\022N\n\014write_stream\030\002 \001(\013"
          + "23.google.cloud.bigquery.storage.v1alpha"
          + "2.WriteStreamB\003\340A\002\"\336\002\n\021AppendRowsRequest"
          + "\022\031\n\014write_stream\030\001 \001(\tB\003\340A\002\0220\n\006offset\030\002 "
          + "\001(\0132\033.google.protobuf.Int64ValueB\003\340A\001\022Y\n"
          + "\nproto_rows\030\004 \001(\0132C.google.cloud.bigquer"
          + "y.storage.v1alpha2.AppendRowsRequest.Pro"
          + "toDataH\000\032\230\001\n\tProtoData\022J\n\rwriter_schema\030"
          + "\001 \001(\01323.google.cloud.bigquery.storage.v1"
          + "alpha2.ProtoSchema\022?\n\004rows\030\002 \001(\01321.googl"
          + "e.cloud.bigquery.storage.v1alpha2.ProtoR"
          + "owsB\006\n\004rows\"W\n\022AppendRowsResponse\022\020\n\006off"
          + "set\030\001 \001(\003H\000\022#\n\005error\030\002 \001(\0132\022.google.rpc."
          + "StatusH\000B\n\n\010response\"*\n\025GetWriteStreamRe"
          + "quest\022\021\n\004name\030\001 \001(\tB\003\340A\002\"Q\n\036BatchCommitW"
          + "riteStreamsRequest\022\023\n\006parent\030\001 \001(\tB\003\340A\002\022"
          + "\032\n\rwrite_streams\030\002 \003(\tB\003\340A\002\"R\n\037BatchComm"
          + "itWriteStreamsResponse\022/\n\013commit_time\030\001 "
          + "\001(\0132\032.google.protobuf.Timestamp\"/\n\032Final"
          + "izeWriteStreamRequest\022\021\n\004name\030\001 \001(\tB\003\340A\002"
          + "\"0\n\033FinalizeWriteStreamResponse\022\021\n\trow_c"
          + "ount\030\001 \001(\0032\201\n\n\rBigQueryWrite\022\310\001\n\021CreateW"
          + "riteStream\022@.google.cloud.bigquery.stora"
          + "ge.v1alpha2.CreateWriteStreamRequest\0323.g"
          + "oogle.cloud.bigquery.storage.v1alpha2.Wr"
          + "iteStream\"<\202\323\344\223\0026\"1/v1alpha2/{parent=pro"
          + "jects/*/datasets/*/tables/*}:\001*\022\325\001\n\nAppe"
          + "ndRows\0229.google.cloud.bigquery.storage.v"
          + "1alpha2.AppendRowsRequest\032:.google.cloud"
          + ".bigquery.storage.v1alpha2.AppendRowsRes"
          + "ponse\"L\202\323\344\223\002F\"A/v1alpha2/{write_stream=p"
          + "rojects/*/datasets/*/tables/*/streams/*}"
          + ":\001*(\0010\001\022\312\001\n\016GetWriteStream\022=.google.clou"
          + "d.bigquery.storage.v1alpha2.GetWriteStre"
          + "amRequest\0323.google.cloud.bigquery.storag"
          + "e.v1alpha2.WriteStream\"D\202\323\344\223\002>\"9/v1alpha"
          + "2/{name=projects/*/datasets/*/tables/*/s"
          + "treams/*}:\001*\022\344\001\n\023FinalizeWriteStream\022B.g"
          + "oogle.cloud.bigquery.storage.v1alpha2.Fi"
          + "nalizeWriteStreamRequest\032C.google.cloud."
          + "bigquery.storage.v1alpha2.FinalizeWriteS"
          + "treamResponse\"D\202\323\344\223\002>\"9/v1alpha2/{name=p"
          + "rojects/*/datasets/*/tables/*/streams/*}"
          + ":\001*\022\345\001\n\027BatchCommitWriteStreams\022F.google"
          + ".cloud.bigquery.storage.v1alpha2.BatchCo"
          + "mmitWriteStreamsRequest\032G.google.cloud.b"
          + "igquery.storage.v1alpha2.BatchCommitWrit"
          + "eStreamsResponse\"9\202\323\344\223\0023\0221/v1alpha2/{par"
          + "ent=projects/*/datasets/*/tables/*}\032\260\001\312A"
          + "\036bigquerystorage.googleapis.com\322A\213\001https"
          + "://www.googleapis.com/auth/bigquery,http"
          + "s://www.googleapis.com/auth/bigquery.ins"
          + "ertdata,https://www.googleapis.com/auth/"
          + "cloud-platformB{\n*com.google.cloud.bigqu"
          + "ery.storage.v1alpha2ZMgoogle.golang.org/"
          + "genproto/googleapis/cloud/bigquery/stora"
          + "ge/v1alpha2;storageb\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.AnnotationsProto.getDescriptor(),
              com.google.api.ClientProto.getDescriptor(),
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.getDescriptor(),
              com.google.cloud.bigquery.storage.v1alpha2.Stream.getDescriptor(),
              com.google.protobuf.EmptyProto.getDescriptor(),
              com.google.protobuf.TimestampProto.getDescriptor(),
              com.google.protobuf.WrappersProto.getDescriptor(),
              com.google.rpc.StatusProto.getDescriptor(),
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_CreateWriteStreamRequest_descriptor,
            new java.lang.String[] {
              "Parent", "WriteStream",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_descriptor,
            new java.lang.String[] {
              "WriteStream", "Offset", "ProtoRows", "Rows",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_descriptor =
        internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_descriptor
            .getNestedTypes()
            .get(0);
    internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsRequest_ProtoData_descriptor,
            new java.lang.String[] {
              "WriterSchema", "Rows",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_AppendRowsResponse_descriptor,
            new java.lang.String[] {
              "Offset", "Error", "Response",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_descriptor =
        getDescriptor().getMessageTypes().get(3);
    internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_GetWriteStreamRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_descriptor =
        getDescriptor().getMessageTypes().get(4);
    internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsRequest_descriptor,
            new java.lang.String[] {
              "Parent", "WriteStreams",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_descriptor =
        getDescriptor().getMessageTypes().get(5);
    internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_BatchCommitWriteStreamsResponse_descriptor,
            new java.lang.String[] {
              "CommitTime",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_descriptor =
        getDescriptor().getMessageTypes().get(6);
    internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_descriptor =
        getDescriptor().getMessageTypes().get(7);
    internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_bigquery_storage_v1alpha2_FinalizeWriteStreamResponse_descriptor,
            new java.lang.String[] {
              "RowCount",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.ClientProto.defaultHost);
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.AnnotationsProto.http);
    registry.add(com.google.api.ClientProto.oauthScopes);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.AnnotationsProto.getDescriptor();
    com.google.api.ClientProto.getDescriptor();
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto.getDescriptor();
    com.google.cloud.bigquery.storage.v1alpha2.Stream.getDescriptor();
    com.google.protobuf.EmptyProto.getDescriptor();
    com.google.protobuf.TimestampProto.getDescriptor();
    com.google.protobuf.WrappersProto.getDescriptor();
    com.google.rpc.StatusProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
