/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/storage.proto

package com.google.cloud.bigquery.storage.v1;

public interface AppendRowsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.AppendRowsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The write_stream identifies the append operation. It must be
   * provided in the following scenarios:
   *
   * * In the first request to an AppendRows connection.
   *
   * * In all subsequent requests to an AppendRows connection, if you use the
   * same connection to write to multiple tables or change the input schema for
   * default streams.
   *
   * For explicitly created write streams, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
   *
   * For the special default stream, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
   *
   * An example of a possible sequence of requests with write_stream fields
   * within a single connection:
   *
   * * r1: {write_stream: stream_name_1}
   *
   * * r2: {write_stream: /&#42;omit*&#47;}
   *
   * * r3: {write_stream: /&#42;omit*&#47;}
   *
   * * r4: {write_stream: stream_name_2}
   *
   * * r5: {write_stream: stream_name_2}
   *
   * The destination changed in request_4, so the write_stream field must be
   * populated in all subsequent requests in this stream.
   * </pre>
   *
   * <code>
   * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The writeStream.
   */
  java.lang.String getWriteStream();
  /**
   *
   *
   * <pre>
   * Required. The write_stream identifies the append operation. It must be
   * provided in the following scenarios:
   *
   * * In the first request to an AppendRows connection.
   *
   * * In all subsequent requests to an AppendRows connection, if you use the
   * same connection to write to multiple tables or change the input schema for
   * default streams.
   *
   * For explicitly created write streams, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
   *
   * For the special default stream, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
   *
   * An example of a possible sequence of requests with write_stream fields
   * within a single connection:
   *
   * * r1: {write_stream: stream_name_1}
   *
   * * r2: {write_stream: /&#42;omit*&#47;}
   *
   * * r3: {write_stream: /&#42;omit*&#47;}
   *
   * * r4: {write_stream: stream_name_2}
   *
   * * r5: {write_stream: stream_name_2}
   *
   * The destination changed in request_4, so the write_stream field must be
   * populated in all subsequent requests in this stream.
   * </pre>
   *
   * <code>
   * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for writeStream.
   */
  com.google.protobuf.ByteString getWriteStreamBytes();

  /**
   *
   *
   * <pre>
   * If present, the write is only performed if the next append offset is same
   * as the provided value. If not present, the write is performed at the
   * current end of stream. Specifying a value for this field is not allowed
   * when calling AppendRows for the '_default' stream.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value offset = 2;</code>
   *
   * @return Whether the offset field is set.
   */
  boolean hasOffset();
  /**
   *
   *
   * <pre>
   * If present, the write is only performed if the next append offset is same
   * as the provided value. If not present, the write is performed at the
   * current end of stream. Specifying a value for this field is not allowed
   * when calling AppendRows for the '_default' stream.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value offset = 2;</code>
   *
   * @return The offset.
   */
  com.google.protobuf.Int64Value getOffset();
  /**
   *
   *
   * <pre>
   * If present, the write is only performed if the next append offset is same
   * as the provided value. If not present, the write is performed at the
   * current end of stream. Specifying a value for this field is not allowed
   * when calling AppendRows for the '_default' stream.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value offset = 2;</code>
   */
  com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder();

  /**
   *
   *
   * <pre>
   * Rows in proto format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
   *
   * @return Whether the protoRows field is set.
   */
  boolean hasProtoRows();
  /**
   *
   *
   * <pre>
   * Rows in proto format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
   *
   * @return The protoRows.
   */
  com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData getProtoRows();
  /**
   *
   *
   * <pre>
   * Rows in proto format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
   */
  com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoDataOrBuilder getProtoRowsOrBuilder();

  /**
   *
   *
   * <pre>
   * Id set by client to annotate its identity. Only initial request setting is
   * respected.
   * </pre>
   *
   * <code>string trace_id = 6;</code>
   *
   * @return The traceId.
   */
  java.lang.String getTraceId();
  /**
   *
   *
   * <pre>
   * Id set by client to annotate its identity. Only initial request setting is
   * respected.
   * </pre>
   *
   * <code>string trace_id = 6;</code>
   *
   * @return The bytes for traceId.
   */
  com.google.protobuf.ByteString getTraceIdBytes();

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  int getMissingValueInterpretationsCount();
  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  boolean containsMissingValueInterpretations(java.lang.String key);
  /** Use {@link #getMissingValueInterpretationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
      getMissingValueInterpretations();
  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
      getMissingValueInterpretationsMap();
  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  /* nullable */
  com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
      getMissingValueInterpretationsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
              defaultValue);
  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
      getMissingValueInterpretationsOrThrow(java.lang.String key);
  /** Use {@link #getMissingValueInterpretationsValueMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.Integer> getMissingValueInterpretationsValue();
  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.Integer> getMissingValueInterpretationsValueMap();
  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  int getMissingValueInterpretationsValueOrDefault(java.lang.String key, int defaultValue);
  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  int getMissingValueInterpretationsValueOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Default missing value interpretation for all columns in the
   * table. When a value is specified on an `AppendRowsRequest`, it is applied
   * to all requests on the connection from that point forward, until a
   * subsequent `AppendRowsRequest` sets it to a different value.
   * `missing_value_interpretation` can override
   * `default_missing_value_interpretation`. For example, if you want to write
   * `NULL` instead of using default values for some columns, you can set
   * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
   * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for defaultMissingValueInterpretation.
   */
  int getDefaultMissingValueInterpretationValue();
  /**
   *
   *
   * <pre>
   * Optional. Default missing value interpretation for all columns in the
   * table. When a value is specified on an `AppendRowsRequest`, it is applied
   * to all requests on the connection from that point forward, until a
   * subsequent `AppendRowsRequest` sets it to a different value.
   * `missing_value_interpretation` can override
   * `default_missing_value_interpretation`. For example, if you want to write
   * `NULL` instead of using default values for some columns, you can set
   * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
   * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The defaultMissingValueInterpretation.
   */
  com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
      getDefaultMissingValueInterpretation();

  com.google.cloud.bigquery.storage.v1.AppendRowsRequest.RowsCase getRowsCase();
}
