/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/table.proto

package com.google.cloud.bigquery.storage.v1;

/**
 *
 *
 * <pre>
 * TableFieldSchema defines a single field/column within a table schema.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1.TableFieldSchema}
 */
public final class TableFieldSchema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.TableFieldSchema)
    TableFieldSchemaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TableFieldSchema.newBuilder() to construct.
  private TableFieldSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TableFieldSchema() {
    name_ = "";
    type_ = 0;
    mode_ = 0;
    fields_ = java.util.Collections.emptyList();
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TableFieldSchema();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TableFieldSchema(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              mode_ = rawValue;
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                fields_ =
                    new java.util.ArrayList<
                        com.google.cloud.bigquery.storage.v1.TableFieldSchema>();
                mutable_bitField0_ |= 0x00000001;
              }
              fields_.add(
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1.TableFieldSchema.parser(),
                      extensionRegistry));
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 56:
            {
              maxLength_ = input.readInt64();
              break;
            }
          case 64:
            {
              precision_ = input.readInt64();
              break;
            }
          case 72:
            {
              scale_ = input.readInt64();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        fields_ = java.util.Collections.unmodifiableList(fields_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1.TableProto
        .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1.TableProto
        .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.class,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder.class);
  }

  /** Protobuf enum {@code google.cloud.bigquery.storage.v1.TableFieldSchema.Type} */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * 64K, UTF8
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    STRING(1),
    /**
     *
     *
     * <pre>
     * 64-bit signed
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    INT64(2),
    /**
     *
     *
     * <pre>
     * 64-bit IEEE floating point
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    DOUBLE(3),
    /**
     *
     *
     * <pre>
     * Aggregate type
     * </pre>
     *
     * <code>STRUCT = 4;</code>
     */
    STRUCT(4),
    /**
     *
     *
     * <pre>
     * 64K, Binary
     * </pre>
     *
     * <code>BYTES = 5;</code>
     */
    BYTES(5),
    /**
     *
     *
     * <pre>
     * 2-valued
     * </pre>
     *
     * <code>BOOL = 6;</code>
     */
    BOOL(6),
    /**
     *
     *
     * <pre>
     * 64-bit signed usec since UTC epoch
     * </pre>
     *
     * <code>TIMESTAMP = 7;</code>
     */
    TIMESTAMP(7),
    /**
     *
     *
     * <pre>
     * Civil date - Year, Month, Day
     * </pre>
     *
     * <code>DATE = 8;</code>
     */
    DATE(8),
    /**
     *
     *
     * <pre>
     * Civil time - Hour, Minute, Second, Microseconds
     * </pre>
     *
     * <code>TIME = 9;</code>
     */
    TIME(9),
    /**
     *
     *
     * <pre>
     * Combination of civil date and civil time
     * </pre>
     *
     * <code>DATETIME = 10;</code>
     */
    DATETIME(10),
    /**
     *
     *
     * <pre>
     * Geography object
     * </pre>
     *
     * <code>GEOGRAPHY = 11;</code>
     */
    GEOGRAPHY(11),
    /**
     *
     *
     * <pre>
     * Numeric value
     * </pre>
     *
     * <code>NUMERIC = 12;</code>
     */
    NUMERIC(12),
    /**
     *
     *
     * <pre>
     * BigNumeric value
     * </pre>
     *
     * <code>BIGNUMERIC = 13;</code>
     */
    BIGNUMERIC(13),
    /**
     *
     *
     * <pre>
     * Interval
     * </pre>
     *
     * <code>INTERVAL = 14;</code>
     */
    INTERVAL(14),
    /**
     *
     *
     * <pre>
     * JSON, String
     * </pre>
     *
     * <code>JSON = 15;</code>
     */
    JSON(15),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * 64K, UTF8
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    public static final int STRING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * 64-bit signed
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    public static final int INT64_VALUE = 2;
    /**
     *
     *
     * <pre>
     * 64-bit IEEE floating point
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    public static final int DOUBLE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Aggregate type
     * </pre>
     *
     * <code>STRUCT = 4;</code>
     */
    public static final int STRUCT_VALUE = 4;
    /**
     *
     *
     * <pre>
     * 64K, Binary
     * </pre>
     *
     * <code>BYTES = 5;</code>
     */
    public static final int BYTES_VALUE = 5;
    /**
     *
     *
     * <pre>
     * 2-valued
     * </pre>
     *
     * <code>BOOL = 6;</code>
     */
    public static final int BOOL_VALUE = 6;
    /**
     *
     *
     * <pre>
     * 64-bit signed usec since UTC epoch
     * </pre>
     *
     * <code>TIMESTAMP = 7;</code>
     */
    public static final int TIMESTAMP_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Civil date - Year, Month, Day
     * </pre>
     *
     * <code>DATE = 8;</code>
     */
    public static final int DATE_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Civil time - Hour, Minute, Second, Microseconds
     * </pre>
     *
     * <code>TIME = 9;</code>
     */
    public static final int TIME_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Combination of civil date and civil time
     * </pre>
     *
     * <code>DATETIME = 10;</code>
     */
    public static final int DATETIME_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Geography object
     * </pre>
     *
     * <code>GEOGRAPHY = 11;</code>
     */
    public static final int GEOGRAPHY_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Numeric value
     * </pre>
     *
     * <code>NUMERIC = 12;</code>
     */
    public static final int NUMERIC_VALUE = 12;
    /**
     *
     *
     * <pre>
     * BigNumeric value
     * </pre>
     *
     * <code>BIGNUMERIC = 13;</code>
     */
    public static final int BIGNUMERIC_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Interval
     * </pre>
     *
     * <code>INTERVAL = 14;</code>
     */
    public static final int INTERVAL_VALUE = 14;
    /**
     *
     *
     * <pre>
     * JSON, String
     * </pre>
     *
     * <code>JSON = 15;</code>
     */
    public static final int JSON_VALUE = 15;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return STRING;
        case 2:
          return INT64;
        case 3:
          return DOUBLE;
        case 4:
          return STRUCT;
        case 5:
          return BYTES;
        case 6:
          return BOOL;
        case 7:
          return TIMESTAMP;
        case 8:
          return DATE;
        case 9:
          return TIME;
        case 10:
          return DATETIME;
        case 11:
          return GEOGRAPHY;
        case 12:
          return NUMERIC;
        case 13:
          return BIGNUMERIC;
        case 14:
          return INTERVAL;
        case 15:
          return JSON;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1.TableFieldSchema.Type)
  }

  /** Protobuf enum {@code google.cloud.bigquery.storage.v1.TableFieldSchema.Mode} */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    MODE_UNSPECIFIED(0),
    /** <code>NULLABLE = 1;</code> */
    NULLABLE(1),
    /** <code>REQUIRED = 2;</code> */
    REQUIRED(2),
    /** <code>REPEATED = 3;</code> */
    REPEATED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MODE_UNSPECIFIED_VALUE = 0;
    /** <code>NULLABLE = 1;</code> */
    public static final int NULLABLE_VALUE = 1;
    /** <code>REQUIRED = 2;</code> */
    public static final int REQUIRED_VALUE = 2;
    /** <code>REPEATED = 3;</code> */
    public static final int REPEATED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return MODE_UNSPECIFIED;
        case 1:
          return NULLABLE;
        case 2:
          return REQUIRED;
        case 3:
          return REPEATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1.TableFieldSchema.Mode)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The field name. The name must contain only letters (a-z, A-Z),
   * numbers (0-9), or underscores (_), and must start with a letter or
   * underscore. The maximum length is 128 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The field name. The name must contain only letters (a-z, A-Z),
   * numbers (0-9), or underscores (_), and must start with a letter or
   * underscore. The maximum length is 128 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_;
  /**
   *
   *
   * <pre>
   * Required. The field data type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Required. The field data type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type getType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type result =
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.valueOf(type_);
    return result == null
        ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.UNRECOGNIZED
        : result;
  }

  public static final int MODE_FIELD_NUMBER = 3;
  private int mode_;
  /**
   *
   *
   * <pre>
   * Optional. The field mode. The default value is NULLABLE.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for mode.
   */
  @java.lang.Override
  public int getModeValue() {
    return mode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The field mode. The default value is NULLABLE.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode getMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode result =
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.valueOf(mode_);
    return result == null
        ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.UNRECOGNIZED
        : result;
  }

  public static final int FIELDS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> fields_;
  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> getFieldsList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema getFields(int index) {
    return fields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder getFieldsOrBuilder(
      int index) {
    return fields_.get(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. The field description. The maximum length is 1,024 characters.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The field description. The maximum length is 1,024 characters.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_LENGTH_FIELD_NUMBER = 7;
  private long maxLength_;
  /**
   *
   *
   * <pre>
   * Optional. Maximum length of values of this field for STRINGS or BYTES.
   * If max_length is not specified, no maximum length constraint is imposed
   * on this field.
   * If type = "STRING", then max_length represents the maximum UTF-8
   * length of strings in this field.
   * If type = "BYTES", then max_length represents the maximum number of
   * bytes in this field.
   * It is invalid to set this field if type is not "STRING" or "BYTES".
   * </pre>
   *
   * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxLength.
   */
  @java.lang.Override
  public long getMaxLength() {
    return maxLength_;
  }

  public static final int PRECISION_FIELD_NUMBER = 8;
  private long precision_;
  /**
   *
   *
   * <pre>
   * Optional. Precision (maximum number of total digits in base 10) and scale
   * (maximum number of digits in the fractional part in base 10) constraints
   * for values of this field for NUMERIC or BIGNUMERIC.
   * It is invalid to set precision or scale if type is not "NUMERIC" or
   * "BIGNUMERIC".
   * If precision and scale are not specified, no value range constraint is
   * imposed on this field insofar as values are permitted by the type.
   * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
   * * Precision (P) and scale (S) are specified:
   *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
   * * Precision (P) is specified but not scale (and thus scale is
   *   interpreted to be equal to zero):
   *   [-10^P + 1, 10^P - 1].
   * Acceptable values for precision and scale if both are specified:
   * * If type = "NUMERIC":
   *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
   * * If type = "BIGNUMERIC":
   *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
   * Acceptable values for precision if only precision is specified but not
   * scale (and thus scale is interpreted to be equal to zero):
   * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
   * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
   * If scale is specified but not precision, then it is invalid.
   * </pre>
   *
   * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The precision.
   */
  @java.lang.Override
  public long getPrecision() {
    return precision_;
  }

  public static final int SCALE_FIELD_NUMBER = 9;
  private long scale_;
  /**
   *
   *
   * <pre>
   * Optional. See documentation for precision.
   * </pre>
   *
   * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The scale.
   */
  @java.lang.Override
  public long getScale() {
    return scale_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, type_);
    }
    if (mode_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, mode_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(4, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (maxLength_ != 0L) {
      output.writeInt64(7, maxLength_);
    }
    if (precision_ != 0L) {
      output.writeInt64(8, precision_);
    }
    if (scale_ != 0L) {
      output.writeInt64(9, scale_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (mode_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, mode_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (maxLength_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, maxLength_);
    }
    if (precision_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, precision_);
    }
    if (scale_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, scale_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1.TableFieldSchema)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1.TableFieldSchema other =
        (com.google.cloud.bigquery.storage.v1.TableFieldSchema) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (mode_ != other.mode_) return false;
    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getMaxLength() != other.getMaxLength()) return false;
    if (getPrecision() != other.getPrecision()) return false;
    if (getScale() != other.getScale()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + MODE_FIELD_NUMBER;
    hash = (53 * hash) + mode_;
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + MAX_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxLength());
    hash = (37 * hash) + PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPrecision());
    hash = (37 * hash) + SCALE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getScale());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1.TableFieldSchema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * TableFieldSchema defines a single field/column within a table schema.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.TableFieldSchema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.TableFieldSchema)
      com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.TableFieldSchema.class,
              com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFieldsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      type_ = 0;

      mode_ = 0;

      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        fieldsBuilder_.clear();
      }
      description_ = "";

      maxLength_ = 0L;

      precision_ = 0L;

      scale_ = 0L;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema build() {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema buildPartial() {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema result =
          new com.google.cloud.bigquery.storage.v1.TableFieldSchema(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.type_ = type_;
      result.mode_ = mode_;
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
      result.description_ = description_;
      result.maxLength_ = maxLength_;
      result.precision_ = precision_;
      result.scale_ = scale_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1.TableFieldSchema) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1.TableFieldSchema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1.TableFieldSchema other) {
      if (other == com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.mode_ != 0) {
        setModeValue(other.getModeValue());
      }
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.getMaxLength() != 0L) {
        setMaxLength(other.getMaxLength());
      }
      if (other.getPrecision() != 0L) {
        setPrecision(other.getPrecision());
      }
      if (other.getScale() != 0L) {
        setScale(other.getScale());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.bigquery.storage.v1.TableFieldSchema) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type result =
          com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.valueOf(type_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = 0;
      onChanged();
      return this;
    }

    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeValue(int value) {

      mode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode getMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode result =
          com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.valueOf(mode_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      mode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {

      mode_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> fields_ =
        java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fields_ =
            new java.util.ArrayList<com.google.cloud.bigquery.storage.v1.TableFieldSchema>(fields_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableFieldSchema,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder,
            com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema getFields(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(com.google.cloud.bigquery.storage.v1.TableFieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFields(
        java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1.TableFieldSchema>
            values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder getFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder getFieldsOrBuilder(
        int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder addFieldsBuilder() {
      return getFieldsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder addFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder>
        getFieldsBuilderList() {
      return getFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableFieldSchema,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder,
            com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.TableFieldSchema,
                com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder,
                com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>(
                fields_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private long maxLength_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum length of values of this field for STRINGS or BYTES.
     * If max_length is not specified, no maximum length constraint is imposed
     * on this field.
     * If type = "STRING", then max_length represents the maximum UTF-8
     * length of strings in this field.
     * If type = "BYTES", then max_length represents the maximum number of
     * bytes in this field.
     * It is invalid to set this field if type is not "STRING" or "BYTES".
     * </pre>
     *
     * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxLength.
     */
    @java.lang.Override
    public long getMaxLength() {
      return maxLength_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum length of values of this field for STRINGS or BYTES.
     * If max_length is not specified, no maximum length constraint is imposed
     * on this field.
     * If type = "STRING", then max_length represents the maximum UTF-8
     * length of strings in this field.
     * If type = "BYTES", then max_length represents the maximum number of
     * bytes in this field.
     * It is invalid to set this field if type is not "STRING" or "BYTES".
     * </pre>
     *
     * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxLength to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLength(long value) {

      maxLength_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum length of values of this field for STRINGS or BYTES.
     * If max_length is not specified, no maximum length constraint is imposed
     * on this field.
     * If type = "STRING", then max_length represents the maximum UTF-8
     * length of strings in this field.
     * If type = "BYTES", then max_length represents the maximum number of
     * bytes in this field.
     * It is invalid to set this field if type is not "STRING" or "BYTES".
     * </pre>
     *
     * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxLength() {

      maxLength_ = 0L;
      onChanged();
      return this;
    }

    private long precision_;
    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) and scale
     * (maximum number of digits in the fractional part in base 10) constraints
     * for values of this field for NUMERIC or BIGNUMERIC.
     * It is invalid to set precision or scale if type is not "NUMERIC" or
     * "BIGNUMERIC".
     * If precision and scale are not specified, no value range constraint is
     * imposed on this field insofar as values are permitted by the type.
     * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
     * * Precision (P) and scale (S) are specified:
     *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
     * * Precision (P) is specified but not scale (and thus scale is
     *   interpreted to be equal to zero):
     *   [-10^P + 1, 10^P - 1].
     * Acceptable values for precision and scale if both are specified:
     * * If type = "NUMERIC":
     *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
     * * If type = "BIGNUMERIC":
     *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
     * Acceptable values for precision if only precision is specified but not
     * scale (and thus scale is interpreted to be equal to zero):
     * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
     * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
     * If scale is specified but not precision, then it is invalid.
     * </pre>
     *
     * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The precision.
     */
    @java.lang.Override
    public long getPrecision() {
      return precision_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) and scale
     * (maximum number of digits in the fractional part in base 10) constraints
     * for values of this field for NUMERIC or BIGNUMERIC.
     * It is invalid to set precision or scale if type is not "NUMERIC" or
     * "BIGNUMERIC".
     * If precision and scale are not specified, no value range constraint is
     * imposed on this field insofar as values are permitted by the type.
     * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
     * * Precision (P) and scale (S) are specified:
     *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
     * * Precision (P) is specified but not scale (and thus scale is
     *   interpreted to be equal to zero):
     *   [-10^P + 1, 10^P - 1].
     * Acceptable values for precision and scale if both are specified:
     * * If type = "NUMERIC":
     *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
     * * If type = "BIGNUMERIC":
     *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
     * Acceptable values for precision if only precision is specified but not
     * scale (and thus scale is interpreted to be equal to zero):
     * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
     * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
     * If scale is specified but not precision, then it is invalid.
     * </pre>
     *
     * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The precision to set.
     * @return This builder for chaining.
     */
    public Builder setPrecision(long value) {

      precision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) and scale
     * (maximum number of digits in the fractional part in base 10) constraints
     * for values of this field for NUMERIC or BIGNUMERIC.
     * It is invalid to set precision or scale if type is not "NUMERIC" or
     * "BIGNUMERIC".
     * If precision and scale are not specified, no value range constraint is
     * imposed on this field insofar as values are permitted by the type.
     * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
     * * Precision (P) and scale (S) are specified:
     *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
     * * Precision (P) is specified but not scale (and thus scale is
     *   interpreted to be equal to zero):
     *   [-10^P + 1, 10^P - 1].
     * Acceptable values for precision and scale if both are specified:
     * * If type = "NUMERIC":
     *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
     * * If type = "BIGNUMERIC":
     *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
     * Acceptable values for precision if only precision is specified but not
     * scale (and thus scale is interpreted to be equal to zero):
     * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
     * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
     * If scale is specified but not precision, then it is invalid.
     * </pre>
     *
     * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrecision() {

      precision_ = 0L;
      onChanged();
      return this;
    }

    private long scale_;
    /**
     *
     *
     * <pre>
     * Optional. See documentation for precision.
     * </pre>
     *
     * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The scale.
     */
    @java.lang.Override
    public long getScale() {
      return scale_;
    }
    /**
     *
     *
     * <pre>
     * Optional. See documentation for precision.
     * </pre>
     *
     * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The scale to set.
     * @return This builder for chaining.
     */
    public Builder setScale(long value) {

      scale_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. See documentation for precision.
     * </pre>
     *
     * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScale() {

      scale_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.TableFieldSchema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.TableFieldSchema)
  private static final com.google.cloud.bigquery.storage.v1.TableFieldSchema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.TableFieldSchema();
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TableFieldSchema> PARSER =
      new com.google.protobuf.AbstractParser<TableFieldSchema>() {
        @java.lang.Override
        public TableFieldSchema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TableFieldSchema(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TableFieldSchema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TableFieldSchema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
