/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/stream.proto

package com.google.cloud.bigquery.storage.v1;

/**
 *
 *
 * <pre>
 * Information about the ReadSession.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession}
 */
public final class ReadSession extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.ReadSession)
    ReadSessionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadSession.newBuilder() to construct.
  private ReadSession(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadSession() {
    name_ = "";
    dataFormat_ = 0;
    table_ = "";
    streams_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadSession();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ReadSession(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (expireTime_ != null) {
                subBuilder = expireTime_.toBuilder();
              }
              expireTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(expireTime_);
                expireTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              dataFormat_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.cloud.bigquery.storage.v1.AvroSchema.Builder subBuilder = null;
              if (schemaCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.bigquery.storage.v1.AvroSchema) schema_).toBuilder();
              }
              schema_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1.AvroSchema.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.bigquery.storage.v1.AvroSchema) schema_);
                schema_ = subBuilder.buildPartial();
              }
              schemaCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder subBuilder = null;
              if (schemaCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_).toBuilder();
              }
              schema_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1.ArrowSchema.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_);
                schema_ = subBuilder.buildPartial();
              }
              schemaCase_ = 5;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              table_ = s;
              break;
            }
          case 58:
            {
              com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder subBuilder =
                  null;
              if (tableModifiers_ != null) {
                subBuilder = tableModifiers_.toBuilder();
              }
              tableModifiers_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tableModifiers_);
                tableModifiers_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder subBuilder =
                  null;
              if (readOptions_ != null) {
                subBuilder = readOptions_.toBuilder();
              }
              readOptions_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(readOptions_);
                readOptions_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                streams_ =
                    new java.util.ArrayList<com.google.cloud.bigquery.storage.v1.ReadStream>();
                mutable_bitField0_ |= 0x00000001;
              }
              streams_.add(
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1.ReadStream.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        streams_ = java.util.Collections.unmodifiableList(streams_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1.StreamProto
        .internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1.StreamProto
        .internal_static_google_cloud_bigquery_storage_v1_ReadSession_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1.ReadSession.class,
            com.google.cloud.bigquery.storage.v1.ReadSession.Builder.class);
  }

  public interface TableModifiersOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    boolean hasSnapshotTime();
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    com.google.protobuf.Timestamp getSnapshotTime();
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Additional attributes when reading a table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableModifiers}
   */
  public static final class TableModifiers extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
      TableModifiersOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableModifiers.newBuilder() to construct.
    private TableModifiers(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableModifiers() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TableModifiers();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TableModifiers(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (snapshotTime_ != null) {
                  subBuilder = snapshotTime_.toBuilder();
                }
                snapshotTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(snapshotTime_);
                  snapshotTime_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.class,
              com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder.class);
    }

    public static final int SNAPSHOT_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp snapshotTime_;
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    public boolean hasSnapshotTime() {
      return snapshotTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    public com.google.protobuf.Timestamp getSnapshotTime() {
      return snapshotTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : snapshotTime_;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      return getSnapshotTime();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (snapshotTime_ != null) {
        output.writeMessage(1, getSnapshotTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (snapshotTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnapshotTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers other =
          (com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers) obj;

      if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
      if (hasSnapshotTime()) {
        if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSnapshotTime()) {
        hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getSnapshotTime().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional attributes when reading a table.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableModifiers}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.class,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = null;
        } else {
          snapshotTime_ = null;
          snapshotTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers build() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers buildPartial() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers result =
            new com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers(this);
        if (snapshotTimeBuilder_ == null) {
          result.snapshotTime_ = snapshotTime_;
        } else {
          result.snapshotTime_ = snapshotTimeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers other) {
        if (other
            == com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance())
          return this;
        if (other.hasSnapshotTime()) {
          mergeSnapshotTime(other.getSnapshotTime());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.protobuf.Timestamp snapshotTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          snapshotTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return Whether the snapshotTime field is set.
       */
      public boolean hasSnapshotTime() {
        return snapshotTimeBuilder_ != null || snapshotTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return The snapshotTime.
       */
      public com.google.protobuf.Timestamp getSnapshotTime() {
        if (snapshotTimeBuilder_ == null) {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        } else {
          return snapshotTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          snapshotTime_ = value;
          onChanged();
        } else {
          snapshotTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = builderForValue.build();
          onChanged();
        } else {
          snapshotTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (snapshotTime_ != null) {
            snapshotTime_ =
                com.google.protobuf.Timestamp.newBuilder(snapshotTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            snapshotTime_ = value;
          }
          onChanged();
        } else {
          snapshotTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder clearSnapshotTime() {
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = null;
          onChanged();
        } else {
          snapshotTime_ = null;
          snapshotTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {

        onChanged();
        return getSnapshotTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
        if (snapshotTimeBuilder_ != null) {
          return snapshotTimeBuilder_.getMessageOrBuilder();
        } else {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getSnapshotTimeFieldBuilder() {
        if (snapshotTimeBuilder_ == null) {
          snapshotTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getSnapshotTime(), getParentForChildren(), isClean());
          snapshotTime_ = null;
        }
        return snapshotTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
    private static final com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers();
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableModifiers> PARSER =
        new com.google.protobuf.AbstractParser<TableModifiers>() {
          @java.lang.Override
          public TableModifiers parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TableModifiers(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TableModifiers> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableModifiers> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TableReadOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return A list containing the selectedFields.
     */
    java.util.List<java.lang.String> getSelectedFieldsList();
    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return The count of selectedFields.
     */
    int getSelectedFieldsCount();
    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The selectedFields at the given index.
     */
    java.lang.String getSelectedFields(int index);
    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the selectedFields at the given index.
     */
    com.google.protobuf.ByteString getSelectedFieldsBytes(int index);

    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Currently, only a single predicate that is a comparison between a column
     * and a constant value is supported. Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The rowRestriction.
     */
    java.lang.String getRowRestriction();
    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Currently, only a single predicate that is a comparison between a column
     * and a constant value is supported. Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The bytes for rowRestriction.
     */
    com.google.protobuf.ByteString getRowRestrictionBytes();
  }
  /**
   *
   *
   * <pre>
   * Options dictating how we read a table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions}
   */
  public static final class TableReadOptions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
      TableReadOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableReadOptions.newBuilder() to construct.
    private TableReadOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableReadOptions() {
      selectedFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      rowRestriction_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TableReadOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TableReadOptions(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  selectedFields_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                selectedFields_.add(s);
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                rowRestriction_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          selectedFields_ = selectedFields_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.class,
              com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder.class);
    }

    public static final int SELECTED_FIELDS_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList selectedFields_;
    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return A list containing the selectedFields.
     */
    public com.google.protobuf.ProtocolStringList getSelectedFieldsList() {
      return selectedFields_;
    }
    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return The count of selectedFields.
     */
    public int getSelectedFieldsCount() {
      return selectedFields_.size();
    }
    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The selectedFields at the given index.
     */
    public java.lang.String getSelectedFields(int index) {
      return selectedFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Names of the fields in the table that should be read. If empty, all
     * fields will be read. If the specified field is a nested field, all
     * the sub-fields in the field will be selected. The output field order is
     * unrelated to the order of fields in selected_fields.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the selectedFields at the given index.
     */
    public com.google.protobuf.ByteString getSelectedFieldsBytes(int index) {
      return selectedFields_.getByteString(index);
    }

    public static final int ROW_RESTRICTION_FIELD_NUMBER = 2;
    private volatile java.lang.Object rowRestriction_;
    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Currently, only a single predicate that is a comparison between a column
     * and a constant value is supported. Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The rowRestriction.
     */
    public java.lang.String getRowRestriction() {
      java.lang.Object ref = rowRestriction_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rowRestriction_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Currently, only a single predicate that is a comparison between a column
     * and a constant value is supported. Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The bytes for rowRestriction.
     */
    public com.google.protobuf.ByteString getRowRestrictionBytes() {
      java.lang.Object ref = rowRestriction_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rowRestriction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < selectedFields_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, selectedFields_.getRaw(i));
      }
      if (!getRowRestrictionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, rowRestriction_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < selectedFields_.size(); i++) {
          dataSize += computeStringSizeNoTag(selectedFields_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSelectedFieldsList().size();
      }
      if (!getRowRestrictionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, rowRestriction_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions other =
          (com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions) obj;

      if (!getSelectedFieldsList().equals(other.getSelectedFieldsList())) return false;
      if (!getRowRestriction().equals(other.getRowRestriction())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSelectedFieldsCount() > 0) {
        hash = (37 * hash) + SELECTED_FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getSelectedFieldsList().hashCode();
      }
      hash = (37 * hash) + ROW_RESTRICTION_FIELD_NUMBER;
      hash = (53 * hash) + getRowRestriction().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Options dictating how we read a table.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.class,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        selectedFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        rowRestriction_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions build() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions buildPartial() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions result =
            new com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          selectedFields_ = selectedFields_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.selectedFields_ = selectedFields_;
        result.rowRestriction_ = rowRestriction_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions other) {
        if (other
            == com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
                .getDefaultInstance()) return this;
        if (!other.selectedFields_.isEmpty()) {
          if (selectedFields_.isEmpty()) {
            selectedFields_ = other.selectedFields_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSelectedFieldsIsMutable();
            selectedFields_.addAll(other.selectedFields_);
          }
          onChanged();
        }
        if (!other.getRowRestriction().isEmpty()) {
          rowRestriction_ = other.rowRestriction_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList selectedFields_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureSelectedFieldsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          selectedFields_ = new com.google.protobuf.LazyStringArrayList(selectedFields_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @return A list containing the selectedFields.
       */
      public com.google.protobuf.ProtocolStringList getSelectedFieldsList() {
        return selectedFields_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @return The count of selectedFields.
       */
      public int getSelectedFieldsCount() {
        return selectedFields_.size();
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The selectedFields at the given index.
       */
      public java.lang.String getSelectedFields(int index) {
        return selectedFields_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param value The bytes of the selectedFields to add.
       */
      public com.google.protobuf.ByteString getSelectedFieldsBytes(int index) {
        return selectedFields_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The selectedFields to set.
       * @return This builder for chaining.
       */
      public Builder setSelectedFields(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectedFieldsIsMutable();
        selectedFields_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param value The selectedFields to add.
       * @return This builder for chaining.
       */
      public Builder addSelectedFields(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectedFieldsIsMutable();
        selectedFields_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param values The selectedFields to add.
       * @return This builder for chaining.
       */
      public Builder addAllSelectedFields(java.lang.Iterable<java.lang.String> values) {
        ensureSelectedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, selectedFields_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSelectedFields() {
        selectedFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the fields in the table that should be read. If empty, all
       * fields will be read. If the specified field is a nested field, all
       * the sub-fields in the field will be selected. The output field order is
       * unrelated to the order of fields in selected_fields.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param value The bytes of the selectedFields to add.
       * @return This builder for chaining.
       */
      public Builder addSelectedFieldsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSelectedFieldsIsMutable();
        selectedFields_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object rowRestriction_ = "";
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Currently, only a single predicate that is a comparison between a column
       * and a constant value is supported. Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @return The rowRestriction.
       */
      public java.lang.String getRowRestriction() {
        java.lang.Object ref = rowRestriction_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rowRestriction_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Currently, only a single predicate that is a comparison between a column
       * and a constant value is supported. Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @return The bytes for rowRestriction.
       */
      public com.google.protobuf.ByteString getRowRestrictionBytes() {
        java.lang.Object ref = rowRestriction_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rowRestriction_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Currently, only a single predicate that is a comparison between a column
       * and a constant value is supported. Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @param value The rowRestriction to set.
       * @return This builder for chaining.
       */
      public Builder setRowRestriction(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rowRestriction_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Currently, only a single predicate that is a comparison between a column
       * and a constant value is supported. Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowRestriction() {

        rowRestriction_ = getDefaultInstance().getRowRestriction();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Currently, only a single predicate that is a comparison between a column
       * and a constant value is supported. Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @param value The bytes for rowRestriction to set.
       * @return This builder for chaining.
       */
      public Builder setRowRestrictionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        rowRestriction_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
    private static final com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions();
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableReadOptions> PARSER =
        new com.google.protobuf.AbstractParser<TableReadOptions>() {
          @java.lang.Override
          public TableReadOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TableReadOptions(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TableReadOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableReadOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int schemaCase_ = 0;
  private java.lang.Object schema_;

  public enum SchemaCase implements com.google.protobuf.Internal.EnumLite {
    AVRO_SCHEMA(4),
    ARROW_SCHEMA(5),
    SCHEMA_NOT_SET(0);
    private final int value;

    private SchemaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchemaCase valueOf(int value) {
      return forNumber(value);
    }

    public static SchemaCase forNumber(int value) {
      switch (value) {
        case 4:
          return AVRO_SCHEMA;
        case 5:
          return ARROW_SCHEMA;
        case 0:
          return SCHEMA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SchemaCase getSchemaCase() {
    return SchemaCase.forNumber(schemaCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the session, in the form
   * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the session, in the form
   * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the session becomes invalid. After this time, subsequent
   * requests to read this Session will return errors. The expire_time is
   * automatically assigned and currently cannot be specified or updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the session becomes invalid. After this time, subsequent
   * requests to read this Session will return errors. The expire_time is
   * automatically assigned and currently cannot be specified or updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the session becomes invalid. After this time, subsequent
   * requests to read this Session will return errors. The expire_time is
   * automatically assigned and currently cannot be specified or updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return getExpireTime();
  }

  public static final int DATA_FORMAT_FIELD_NUMBER = 3;
  private int dataFormat_;
  /**
   *
   *
   * <pre>
   * Immutable. Data format of the output data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for dataFormat.
   */
  public int getDataFormatValue() {
    return dataFormat_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Data format of the output data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The dataFormat.
   */
  public com.google.cloud.bigquery.storage.v1.DataFormat getDataFormat() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.storage.v1.DataFormat result =
        com.google.cloud.bigquery.storage.v1.DataFormat.valueOf(dataFormat_);
    return result == null ? com.google.cloud.bigquery.storage.v1.DataFormat.UNRECOGNIZED : result;
  }

  public static final int AVRO_SCHEMA_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the avroSchema field is set.
   */
  public boolean hasAvroSchema() {
    return schemaCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The avroSchema.
   */
  public com.google.cloud.bigquery.storage.v1.AvroSchema getAvroSchema() {
    if (schemaCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
    if (schemaCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
  }

  public static final int ARROW_SCHEMA_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the arrowSchema field is set.
   */
  public boolean hasArrowSchema() {
    return schemaCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The arrowSchema.
   */
  public com.google.cloud.bigquery.storage.v1.ArrowSchema getArrowSchema() {
    if (schemaCase_ == 5) {
      return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
    if (schemaCase_ == 5) {
      return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
  }

  public static final int TABLE_FIELD_NUMBER = 6;
  private volatile java.lang.Object table_;
  /**
   *
   *
   * <pre>
   * Immutable. Table that this ReadSession is reading from, in the form
   * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
   * </pre>
   *
   * <code>
   * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The table.
   */
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Table that this ReadSession is reading from, in the form
   * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
   * </pre>
   *
   * <code>
   * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for table.
   */
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_MODIFIERS_FIELD_NUMBER = 7;
  private com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers tableModifiers_;
  /**
   *
   *
   * <pre>
   * Optional. Any modifiers which are applied when reading from the specified table.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the tableModifiers field is set.
   */
  public boolean hasTableModifiers() {
    return tableModifiers_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Any modifiers which are applied when reading from the specified table.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The tableModifiers.
   */
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers getTableModifiers() {
    return tableModifiers_ == null
        ? com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance()
        : tableModifiers_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Any modifiers which are applied when reading from the specified table.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder
      getTableModifiersOrBuilder() {
    return getTableModifiers();
  }

  public static final int READ_OPTIONS_FIELD_NUMBER = 8;
  private com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions readOptions_;
  /**
   *
   *
   * <pre>
   * Optional. Read options for this session (e.g. column selection, filters).
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the readOptions field is set.
   */
  public boolean hasReadOptions() {
    return readOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Read options for this session (e.g. column selection, filters).
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The readOptions.
   */
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions getReadOptions() {
    return readOptions_ == null
        ? com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.getDefaultInstance()
        : readOptions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Read options for this session (e.g. column selection, filters).
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder
      getReadOptionsOrBuilder() {
    return getReadOptions();
  }

  public static final int STREAMS_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> streams_;
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> getStreamsList() {
    return streams_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public java.util.List<? extends com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
      getStreamsOrBuilderList() {
    return streams_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public int getStreamsCount() {
    return streams_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.bigquery.storage.v1.ReadStream getStreams(int index) {
    return streams_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder getStreamsOrBuilder(int index) {
    return streams_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (expireTime_ != null) {
      output.writeMessage(2, getExpireTime());
    }
    if (dataFormat_
        != com.google.cloud.bigquery.storage.v1.DataFormat.DATA_FORMAT_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, dataFormat_);
    }
    if (schemaCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_);
    }
    if (schemaCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_);
    }
    if (!getTableBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, table_);
    }
    if (tableModifiers_ != null) {
      output.writeMessage(7, getTableModifiers());
    }
    if (readOptions_ != null) {
      output.writeMessage(8, getReadOptions());
    }
    for (int i = 0; i < streams_.size(); i++) {
      output.writeMessage(10, streams_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExpireTime());
    }
    if (dataFormat_
        != com.google.cloud.bigquery.storage.v1.DataFormat.DATA_FORMAT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, dataFormat_);
    }
    if (schemaCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_);
    }
    if (schemaCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_);
    }
    if (!getTableBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, table_);
    }
    if (tableModifiers_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTableModifiers());
    }
    if (readOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getReadOptions());
    }
    for (int i = 0; i < streams_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, streams_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1.ReadSession)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1.ReadSession other =
        (com.google.cloud.bigquery.storage.v1.ReadSession) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (dataFormat_ != other.dataFormat_) return false;
    if (!getTable().equals(other.getTable())) return false;
    if (hasTableModifiers() != other.hasTableModifiers()) return false;
    if (hasTableModifiers()) {
      if (!getTableModifiers().equals(other.getTableModifiers())) return false;
    }
    if (hasReadOptions() != other.hasReadOptions()) return false;
    if (hasReadOptions()) {
      if (!getReadOptions().equals(other.getReadOptions())) return false;
    }
    if (!getStreamsList().equals(other.getStreamsList())) return false;
    if (!getSchemaCase().equals(other.getSchemaCase())) return false;
    switch (schemaCase_) {
      case 4:
        if (!getAvroSchema().equals(other.getAvroSchema())) return false;
        break;
      case 5:
        if (!getArrowSchema().equals(other.getArrowSchema())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + DATA_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + dataFormat_;
    hash = (37 * hash) + TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTable().hashCode();
    if (hasTableModifiers()) {
      hash = (37 * hash) + TABLE_MODIFIERS_FIELD_NUMBER;
      hash = (53 * hash) + getTableModifiers().hashCode();
    }
    if (hasReadOptions()) {
      hash = (37 * hash) + READ_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getReadOptions().hashCode();
    }
    if (getStreamsCount() > 0) {
      hash = (37 * hash) + STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getStreamsList().hashCode();
    }
    switch (schemaCase_) {
      case 4:
        hash = (37 * hash) + AVRO_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getAvroSchema().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ARROW_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getArrowSchema().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.storage.v1.ReadSession prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about the ReadSession.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.ReadSession)
      com.google.cloud.bigquery.storage.v1.ReadSessionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.ReadSession.class,
              com.google.cloud.bigquery.storage.v1.ReadSession.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1.ReadSession.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStreamsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }
      dataFormat_ = 0;

      table_ = "";

      if (tableModifiersBuilder_ == null) {
        tableModifiers_ = null;
      } else {
        tableModifiers_ = null;
        tableModifiersBuilder_ = null;
      }
      if (readOptionsBuilder_ == null) {
        readOptions_ = null;
      } else {
        readOptions_ = null;
        readOptionsBuilder_ = null;
      }
      if (streamsBuilder_ == null) {
        streams_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        streamsBuilder_.clear();
      }
      schemaCase_ = 0;
      schema_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1.ReadSession.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession build() {
      com.google.cloud.bigquery.storage.v1.ReadSession result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession buildPartial() {
      com.google.cloud.bigquery.storage.v1.ReadSession result =
          new com.google.cloud.bigquery.storage.v1.ReadSession(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (expireTimeBuilder_ == null) {
        result.expireTime_ = expireTime_;
      } else {
        result.expireTime_ = expireTimeBuilder_.build();
      }
      result.dataFormat_ = dataFormat_;
      if (schemaCase_ == 4) {
        if (avroSchemaBuilder_ == null) {
          result.schema_ = schema_;
        } else {
          result.schema_ = avroSchemaBuilder_.build();
        }
      }
      if (schemaCase_ == 5) {
        if (arrowSchemaBuilder_ == null) {
          result.schema_ = schema_;
        } else {
          result.schema_ = arrowSchemaBuilder_.build();
        }
      }
      result.table_ = table_;
      if (tableModifiersBuilder_ == null) {
        result.tableModifiers_ = tableModifiers_;
      } else {
        result.tableModifiers_ = tableModifiersBuilder_.build();
      }
      if (readOptionsBuilder_ == null) {
        result.readOptions_ = readOptions_;
      } else {
        result.readOptions_ = readOptionsBuilder_.build();
      }
      if (streamsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          streams_ = java.util.Collections.unmodifiableList(streams_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.streams_ = streams_;
      } else {
        result.streams_ = streamsBuilder_.build();
      }
      result.schemaCase_ = schemaCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1.ReadSession) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1.ReadSession) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1.ReadSession other) {
      if (other == com.google.cloud.bigquery.storage.v1.ReadSession.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.dataFormat_ != 0) {
        setDataFormatValue(other.getDataFormatValue());
      }
      if (!other.getTable().isEmpty()) {
        table_ = other.table_;
        onChanged();
      }
      if (other.hasTableModifiers()) {
        mergeTableModifiers(other.getTableModifiers());
      }
      if (other.hasReadOptions()) {
        mergeReadOptions(other.getReadOptions());
      }
      if (streamsBuilder_ == null) {
        if (!other.streams_.isEmpty()) {
          if (streams_.isEmpty()) {
            streams_ = other.streams_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureStreamsIsMutable();
            streams_.addAll(other.streams_);
          }
          onChanged();
        }
      } else {
        if (!other.streams_.isEmpty()) {
          if (streamsBuilder_.isEmpty()) {
            streamsBuilder_.dispose();
            streamsBuilder_ = null;
            streams_ = other.streams_;
            bitField0_ = (bitField0_ & ~0x00000001);
            streamsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStreamsFieldBuilder()
                    : null;
          } else {
            streamsBuilder_.addAllMessages(other.streams_);
          }
        }
      }
      switch (other.getSchemaCase()) {
        case AVRO_SCHEMA:
          {
            mergeAvroSchema(other.getAvroSchema());
            break;
          }
        case ARROW_SCHEMA:
          {
            mergeArrowSchema(other.getArrowSchema());
            break;
          }
        case SCHEMA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.bigquery.storage.v1.ReadSession parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.bigquery.storage.v1.ReadSession) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int schemaCase_ = 0;
    private java.lang.Object schema_;

    public SchemaCase getSchemaCase() {
      return SchemaCase.forNumber(schemaCase_);
    }

    public Builder clearSchema() {
      schemaCase_ = 0;
      schema_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return expireTimeBuilder_ != null || expireTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expireTime_ != null) {
          expireTime_ =
              com.google.protobuf.Timestamp.newBuilder(expireTime_).mergeFrom(value).buildPartial();
        } else {
          expireTime_ = value;
        }
        onChanged();
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
        onChanged();
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {

      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time, subsequent
     * requests to read this Session will return errors. The expire_time is
     * automatically assigned and currently cannot be specified or updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private int dataFormat_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for dataFormat.
     */
    public int getDataFormatValue() {
      return dataFormat_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormatValue(int value) {
      dataFormat_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The dataFormat.
     */
    public com.google.cloud.bigquery.storage.v1.DataFormat getDataFormat() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.storage.v1.DataFormat result =
          com.google.cloud.bigquery.storage.v1.DataFormat.valueOf(dataFormat_);
      return result == null ? com.google.cloud.bigquery.storage.v1.DataFormat.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormat(com.google.cloud.bigquery.storage.v1.DataFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dataFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataFormat() {

      dataFormat_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroSchema,
            com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
            com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>
        avroSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the avroSchema field is set.
     */
    public boolean hasAvroSchema() {
      return schemaCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The avroSchema.
     */
    public com.google.cloud.bigquery.storage.v1.AvroSchema getAvroSchema() {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 4) {
          return avroSchemaBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAvroSchema(com.google.cloud.bigquery.storage.v1.AvroSchema value) {
      if (avroSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        avroSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAvroSchema(
        com.google.cloud.bigquery.storage.v1.AvroSchema.Builder builderForValue) {
      if (avroSchemaBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        avroSchemaBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAvroSchema(com.google.cloud.bigquery.storage.v1.AvroSchema value) {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 4
            && schema_ != com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.bigquery.storage.v1.AvroSchema.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 4) {
          avroSchemaBuilder_.mergeFrom(value);
        }
        avroSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAvroSchema() {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 4) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 4) {
          schemaCase_ = 0;
          schema_ = null;
        }
        avroSchemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.AvroSchema.Builder getAvroSchemaBuilder() {
      return getAvroSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
      if ((schemaCase_ == 4) && (avroSchemaBuilder_ != null)) {
        return avroSchemaBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroSchema,
            com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
            com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>
        getAvroSchemaFieldBuilder() {
      if (avroSchemaBuilder_ == null) {
        if (!(schemaCase_ == 4)) {
          schema_ = com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
        }
        avroSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.AvroSchema,
                com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
                com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 4;
      onChanged();
      ;
      return avroSchemaBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowSchema,
            com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
        arrowSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the arrowSchema field is set.
     */
    public boolean hasArrowSchema() {
      return schemaCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The arrowSchema.
     */
    public com.google.cloud.bigquery.storage.v1.ArrowSchema getArrowSchema() {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 5) {
          return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 5) {
          return arrowSchemaBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArrowSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
      if (arrowSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        arrowSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArrowSchema(
        com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder builderForValue) {
      if (arrowSchemaBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        arrowSchemaBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeArrowSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 5
            && schema_ != com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.bigquery.storage.v1.ArrowSchema.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 5) {
          arrowSchemaBuilder_.mergeFrom(value);
        }
        arrowSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearArrowSchema() {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 5) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 5) {
          schemaCase_ = 0;
          schema_ = null;
        }
        arrowSchemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder getArrowSchemaBuilder() {
      return getArrowSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
      if ((schemaCase_ == 5) && (arrowSchemaBuilder_ != null)) {
        return arrowSchemaBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 5) {
          return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowSchema,
            com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
        getArrowSchemaFieldBuilder() {
      if (arrowSchemaBuilder_ == null) {
        if (!(schemaCase_ == 5)) {
          schema_ = com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
        }
        arrowSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ArrowSchema,
                com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
                com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 5;
      onChanged();
      ;
      return arrowSchemaBuilder_;
    }

    private java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      table_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {

      table_ = getDefaultInstance().getTable();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      table_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers tableModifiers_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder>
        tableModifiersBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tableModifiers field is set.
     */
    public boolean hasTableModifiers() {
      return tableModifiersBuilder_ != null || tableModifiers_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tableModifiers.
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers getTableModifiers() {
      if (tableModifiersBuilder_ == null) {
        return tableModifiers_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance()
            : tableModifiers_;
      } else {
        return tableModifiersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTableModifiers(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers value) {
      if (tableModifiersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableModifiers_ = value;
        onChanged();
      } else {
        tableModifiersBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTableModifiers(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder builderForValue) {
      if (tableModifiersBuilder_ == null) {
        tableModifiers_ = builderForValue.build();
        onChanged();
      } else {
        tableModifiersBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTableModifiers(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers value) {
      if (tableModifiersBuilder_ == null) {
        if (tableModifiers_ != null) {
          tableModifiers_ =
              com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.newBuilder(
                      tableModifiers_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tableModifiers_ = value;
        }
        onChanged();
      } else {
        tableModifiersBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTableModifiers() {
      if (tableModifiersBuilder_ == null) {
        tableModifiers_ = null;
        onChanged();
      } else {
        tableModifiers_ = null;
        tableModifiersBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder
        getTableModifiersBuilder() {

      onChanged();
      return getTableModifiersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder
        getTableModifiersOrBuilder() {
      if (tableModifiersBuilder_ != null) {
        return tableModifiersBuilder_.getMessageOrBuilder();
      } else {
        return tableModifiers_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance()
            : tableModifiers_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder>
        getTableModifiersFieldBuilder() {
      if (tableModifiersBuilder_ == null) {
        tableModifiersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder>(
                getTableModifiers(), getParentForChildren(), isClean());
        tableModifiers_ = null;
      }
      return tableModifiersBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions readOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder>
        readOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the readOptions field is set.
     */
    public boolean hasReadOptions() {
      return readOptionsBuilder_ != null || readOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The readOptions.
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions getReadOptions() {
      if (readOptionsBuilder_ == null) {
        return readOptions_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.getDefaultInstance()
            : readOptions_;
      } else {
        return readOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadOptions(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readOptions_ = value;
        onChanged();
      } else {
        readOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadOptions(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder builderForValue) {
      if (readOptionsBuilder_ == null) {
        readOptions_ = builderForValue.build();
        onChanged();
      } else {
        readOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReadOptions(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (readOptions_ != null) {
          readOptions_ =
              com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.newBuilder(
                      readOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          readOptions_ = value;
        }
        onChanged();
      } else {
        readOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReadOptions() {
      if (readOptionsBuilder_ == null) {
        readOptions_ = null;
        onChanged();
      } else {
        readOptions_ = null;
        readOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder
        getReadOptionsBuilder() {

      onChanged();
      return getReadOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder
        getReadOptionsOrBuilder() {
      if (readOptionsBuilder_ != null) {
        return readOptionsBuilder_.getMessageOrBuilder();
      } else {
        return readOptions_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.getDefaultInstance()
            : readOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder>
        getReadOptionsFieldBuilder() {
      if (readOptionsBuilder_ == null) {
        readOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder>(
                getReadOptions(), getParentForChildren(), isClean());
        readOptions_ = null;
      }
      return readOptionsBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> streams_ =
        java.util.Collections.emptyList();

    private void ensureStreamsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        streams_ =
            new java.util.ArrayList<com.google.cloud.bigquery.storage.v1.ReadStream>(streams_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadStream,
            com.google.cloud.bigquery.storage.v1.ReadStream.Builder,
            com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
        streamsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> getStreamsList() {
      if (streamsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(streams_);
      } else {
        return streamsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStreamsCount() {
      if (streamsBuilder_ == null) {
        return streams_.size();
      } else {
        return streamsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream getStreams(int index) {
      if (streamsBuilder_ == null) {
        return streams_.get(index);
      } else {
        return streamsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStreams(int index, com.google.cloud.bigquery.storage.v1.ReadStream value) {
      if (streamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamsIsMutable();
        streams_.set(index, value);
        onChanged();
      } else {
        streamsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStreams(
        int index, com.google.cloud.bigquery.storage.v1.ReadStream.Builder builderForValue) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.set(index, builderForValue.build());
        onChanged();
      } else {
        streamsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(com.google.cloud.bigquery.storage.v1.ReadStream value) {
      if (streamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamsIsMutable();
        streams_.add(value);
        onChanged();
      } else {
        streamsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(int index, com.google.cloud.bigquery.storage.v1.ReadStream value) {
      if (streamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamsIsMutable();
        streams_.add(index, value);
        onChanged();
      } else {
        streamsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(
        com.google.cloud.bigquery.storage.v1.ReadStream.Builder builderForValue) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.add(builderForValue.build());
        onChanged();
      } else {
        streamsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(
        int index, com.google.cloud.bigquery.storage.v1.ReadStream.Builder builderForValue) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.add(index, builderForValue.build());
        onChanged();
      } else {
        streamsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStreams(
        java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1.ReadStream> values) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, streams_);
        onChanged();
      } else {
        streamsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStreams() {
      if (streamsBuilder_ == null) {
        streams_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        streamsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStreams(int index) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.remove(index);
        onChanged();
      } else {
        streamsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream.Builder getStreamsBuilder(int index) {
      return getStreamsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder getStreamsOrBuilder(int index) {
      if (streamsBuilder_ == null) {
        return streams_.get(index);
      } else {
        return streamsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
        getStreamsOrBuilderList() {
      if (streamsBuilder_ != null) {
        return streamsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(streams_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream.Builder addStreamsBuilder() {
      return getStreamsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.storage.v1.ReadStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream.Builder addStreamsBuilder(int index) {
      return getStreamsFieldBuilder()
          .addBuilder(index, com.google.cloud.bigquery.storage.v1.ReadStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream.Builder>
        getStreamsBuilderList() {
      return getStreamsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadStream,
            com.google.cloud.bigquery.storage.v1.ReadStream.Builder,
            com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
        getStreamsFieldBuilder() {
      if (streamsBuilder_ == null) {
        streamsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ReadStream,
                com.google.cloud.bigquery.storage.v1.ReadStream.Builder,
                com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>(
                streams_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        streams_ = null;
      }
      return streamsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.ReadSession)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.ReadSession)
  private static final com.google.cloud.bigquery.storage.v1.ReadSession DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.ReadSession();
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadSession> PARSER =
      new com.google.protobuf.AbstractParser<ReadSession>() {
        @java.lang.Override
        public ReadSession parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ReadSession(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ReadSession> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadSession> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadSession getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
