/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.cloud.bigquery.datatransfer.v1.RunName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UntypedRunName
extends RunName {
    private final String rawValue;
    private Map<String, String> valueMap;

    private UntypedRunName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
        this.valueMap = ImmutableMap.of((Object)"", (Object)rawValue);
    }

    public static UntypedRunName from(ResourceName resourceName) {
        return new UntypedRunName(resourceName.toString());
    }

    public static UntypedRunName parse(String formattedString) {
        return new UntypedRunName(formattedString);
    }

    public static List<UntypedRunName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedRunName> list = new ArrayList<UntypedRunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedRunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedRunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedRunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    public Map<String, String> getFieldValuesMap() {
        return this.valueMap;
    }

    public String getFieldValue(String fieldName) {
        return this.valueMap.get(fieldName);
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedRunName) {
            UntypedRunName that = (UntypedRunName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

