/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.cloud.bigquery.datatransfer.v1.DataSourceName;
import com.google.cloud.bigquery.datatransfer.v1.LocationDataSourceName;
import com.google.common.base.Preconditions;

public class DataSourceNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public LocationDataSourceName getLocationDataSourceName() {
        if (this.resourceName instanceof LocationDataSourceName) {
            return (LocationDataSourceName)this.resourceName;
        }
        return null;
    }

    public DataSourceName getDataSourceName() {
        if (this.resourceName instanceof DataSourceName) {
            return (DataSourceName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private DataSourceNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static DataSourceNameOneof parse(String resourceNameString) {
        if (LocationDataSourceName.isParsableFrom(resourceNameString)) {
            return new DataSourceNameOneof(LocationDataSourceName.parse(resourceNameString));
        }
        if (DataSourceName.isParsableFrom(resourceNameString)) {
            return new DataSourceNameOneof(DataSourceName.parse(resourceNameString));
        }
        return new DataSourceNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static DataSourceNameOneof from(LocationDataSourceName locationDataSourceName) {
        return new DataSourceNameOneof(locationDataSourceName);
    }

    public static DataSourceNameOneof from(DataSourceName dataSourceName) {
        return new DataSourceNameOneof(dataSourceName);
    }

    public static DataSourceNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new DataSourceNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DataSourceNameOneof) {
            DataSourceNameOneof that = (DataSourceNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

