/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.bigquery.datatransfer.v1.RunNameType;
import com.google.common.base.Preconditions;
import java.util.Map;

public class RunName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/transferConfigs/{transfer_config}/runs/{run}");
    private final String project;
    private final String transferConfig;
    private final String run;

    public String getProject() {
        return this.project;
    }

    public String getTransferConfig() {
        return this.transferConfig;
    }

    public String getRun() {
        return this.run;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private RunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
    }

    public static RunName of(String project, String transferConfig, String run) {
        return RunName.newBuilder().setProject(project).setTransferConfig(transferConfig).setRun(run).build();
    }

    @Deprecated
    public static RunName create(String project, String transferConfig, String run) {
        return RunName.of(project, transferConfig, run);
    }

    public static RunName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "RunName.parse: formattedString not in valid format");
        return RunName.of((String)matchMap.get("project"), (String)matchMap.get("transfer_config"), (String)matchMap.get("run"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return RunNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "transfer_config", this.transferConfig, "run", this.run});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RunName) {
            RunName that = (RunName)o;
            return this.project.equals(that.project) && this.transferConfig.equals(that.transferConfig) && this.run.equals(that.run);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.transferConfig.hashCode();
        h *= 1000003;
        return h ^= this.run.hashCode();
    }

    public static class Builder {
        private String project;
        private String transferConfig;
        private String run;

        public String getProject() {
            return this.project;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public String getRun() {
            return this.run;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        private Builder() {
        }

        private Builder(RunName runName) {
            this.project = runName.project;
            this.transferConfig = runName.transferConfig;
            this.run = runName.run;
        }

        public RunName build() {
            return new RunName(this);
        }
    }
}

