/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connection.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConnectionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/connections/{connection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String connection;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConnection() {
        return this.connection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ConnectionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.connection = (String)Preconditions.checkNotNull((Object)builder.getConnection());
    }

    public static ConnectionName of(String project, String location, String connection) {
        return ConnectionName.newBuilder().setProject(project).setLocation(location).setConnection(connection).build();
    }

    public static String format(String project, String location, String connection) {
        return ConnectionName.newBuilder().setProject(project).setLocation(location).setConnection(connection).build().toString();
    }

    public static ConnectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ConnectionName.parse: formattedString not in valid format");
        return ConnectionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("connection"));
    }

    public static List<ConnectionName> parseList(List<String> formattedStrings) {
        ArrayList<ConnectionName> list = new ArrayList<ConnectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConnectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConnectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConnectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConnectionName connectionName = this;
            synchronized (connectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"connection", (Object)this.connection);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "connection", this.connection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConnectionName) {
            ConnectionName that = (ConnectionName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.connection.equals(that.connection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.connection.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String connection;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConnection() {
            return this.connection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConnection(String connection) {
            this.connection = connection;
            return this;
        }

        private Builder() {
        }

        private Builder(ConnectionName connectionName) {
            this.project = connectionName.project;
            this.location = connectionName.location;
            this.connection = connectionName.connection;
        }

        public ConnectionName build() {
            return new ConnectionName(this);
        }
    }
}

