/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceAllowanceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESOURCE_ALLOWANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/resourceAllowances/{resource_allowance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String resourceAllowance;

    @Deprecated
    protected ResourceAllowanceName() {
        this.project = null;
        this.location = null;
        this.resourceAllowance = null;
    }

    private ResourceAllowanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.resourceAllowance = (String)Preconditions.checkNotNull((Object)builder.getResourceAllowance());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getResourceAllowance() {
        return this.resourceAllowance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceAllowanceName of(String project, String location, String resourceAllowance) {
        return ResourceAllowanceName.newBuilder().setProject(project).setLocation(location).setResourceAllowance(resourceAllowance).build();
    }

    public static String format(String project, String location, String resourceAllowance) {
        return ResourceAllowanceName.newBuilder().setProject(project).setLocation(location).setResourceAllowance(resourceAllowance).build().toString();
    }

    public static ResourceAllowanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESOURCE_ALLOWANCE.validatedMatch(formattedString, "ResourceAllowanceName.parse: formattedString not in valid format");
        return ResourceAllowanceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("resource_allowance"));
    }

    public static List<ResourceAllowanceName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceAllowanceName> list = new ArrayList<ResourceAllowanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceAllowanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceAllowanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceAllowanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESOURCE_ALLOWANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceAllowanceName resourceAllowanceName = this;
            synchronized (resourceAllowanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.resourceAllowance != null) {
                        fieldMapBuilder.put((Object)"resource_allowance", (Object)this.resourceAllowance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESOURCE_ALLOWANCE.instantiate(new String[]{"project", this.project, "location", this.location, "resource_allowance", this.resourceAllowance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceAllowanceName that = (ResourceAllowanceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.resourceAllowance, that.resourceAllowance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceAllowance);
    }

    public static class Builder {
        private String project;
        private String location;
        private String resourceAllowance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getResourceAllowance() {
            return this.resourceAllowance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setResourceAllowance(String resourceAllowance) {
            this.resourceAllowance = resourceAllowance;
            return this;
        }

        private Builder(ResourceAllowanceName resourceAllowanceName) {
            this.project = resourceAllowanceName.project;
            this.location = resourceAllowanceName.location;
            this.resourceAllowance = resourceAllowanceName.resourceAllowance;
        }

        public ResourceAllowanceName build() {
            return new ResourceAllowanceName(this);
        }
    }
}

