/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha;

import com.google.cloud.batch.v1alpha.AllocationPolicy;
import com.google.cloud.batch.v1alpha.AllocationPolicyOrBuilder;
import com.google.cloud.batch.v1alpha.Environment;
import com.google.cloud.batch.v1alpha.EnvironmentOrBuilder;
import com.google.cloud.batch.v1alpha.JobProto;
import com.google.cloud.batch.v1alpha.TaskGroupOrBuilder;
import com.google.cloud.batch.v1alpha.TaskSpec;
import com.google.cloud.batch.v1alpha.TaskSpecOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TaskGroup
extends GeneratedMessageV3
implements TaskGroupOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int TASK_SPEC_FIELD_NUMBER = 3;
    private TaskSpec taskSpec_;
    public static final int TASK_COUNT_FIELD_NUMBER = 4;
    private long taskCount_ = 0L;
    public static final int PARALLELISM_FIELD_NUMBER = 5;
    private long parallelism_ = 0L;
    public static final int SCHEDULING_POLICY_FIELD_NUMBER = 6;
    private int schedulingPolicy_ = 0;
    public static final int ALLOCATION_POLICY_FIELD_NUMBER = 7;
    private AllocationPolicy allocationPolicy_;
    public static final int LABELS_FIELD_NUMBER = 8;
    private MapField<String, String> labels_;
    public static final int TASK_ENVIRONMENTS_FIELD_NUMBER = 9;
    private List<Environment> taskEnvironments_;
    public static final int TASK_COUNT_PER_NODE_FIELD_NUMBER = 10;
    private long taskCountPerNode_ = 0L;
    public static final int REQUIRE_HOSTS_FILE_FIELD_NUMBER = 11;
    private boolean requireHostsFile_ = false;
    public static final int PERMISSIVE_SSH_FIELD_NUMBER = 12;
    private boolean permissiveSsh_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final TaskGroup DEFAULT_INSTANCE = new TaskGroup();
    private static final Parser<TaskGroup> PARSER = new AbstractParser<TaskGroup>(){

        public TaskGroup parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = TaskGroup.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private TaskGroup(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private TaskGroup() {
        this.name_ = "";
        this.schedulingPolicy_ = 0;
        this.taskEnvironments_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new TaskGroup();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return JobProto.internal_static_google_cloud_batch_v1alpha_TaskGroup_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 8: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return JobProto.internal_static_google_cloud_batch_v1alpha_TaskGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(TaskGroup.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasTaskSpec() {
        return this.taskSpec_ != null;
    }

    @Override
    public TaskSpec getTaskSpec() {
        return this.taskSpec_ == null ? TaskSpec.getDefaultInstance() : this.taskSpec_;
    }

    @Override
    public TaskSpecOrBuilder getTaskSpecOrBuilder() {
        return this.taskSpec_ == null ? TaskSpec.getDefaultInstance() : this.taskSpec_;
    }

    @Override
    public long getTaskCount() {
        return this.taskCount_;
    }

    @Override
    public long getParallelism() {
        return this.parallelism_;
    }

    @Override
    public int getSchedulingPolicyValue() {
        return this.schedulingPolicy_;
    }

    @Override
    public SchedulingPolicy getSchedulingPolicy() {
        SchedulingPolicy result = SchedulingPolicy.forNumber(this.schedulingPolicy_);
        return result == null ? SchedulingPolicy.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasAllocationPolicy() {
        return this.allocationPolicy_ != null;
    }

    @Override
    public AllocationPolicy getAllocationPolicy() {
        return this.allocationPolicy_ == null ? AllocationPolicy.getDefaultInstance() : this.allocationPolicy_;
    }

    @Override
    public AllocationPolicyOrBuilder getAllocationPolicyOrBuilder() {
        return this.allocationPolicy_ == null ? AllocationPolicy.getDefaultInstance() : this.allocationPolicy_;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public List<Environment> getTaskEnvironmentsList() {
        return this.taskEnvironments_;
    }

    @Override
    public List<? extends EnvironmentOrBuilder> getTaskEnvironmentsOrBuilderList() {
        return this.taskEnvironments_;
    }

    @Override
    public int getTaskEnvironmentsCount() {
        return this.taskEnvironments_.size();
    }

    @Override
    public Environment getTaskEnvironments(int index) {
        return this.taskEnvironments_.get(index);
    }

    @Override
    public EnvironmentOrBuilder getTaskEnvironmentsOrBuilder(int index) {
        return this.taskEnvironments_.get(index);
    }

    @Override
    public long getTaskCountPerNode() {
        return this.taskCountPerNode_;
    }

    @Override
    public boolean getRequireHostsFile() {
        return this.requireHostsFile_;
    }

    @Override
    public boolean getPermissiveSsh() {
        return this.permissiveSsh_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (this.taskSpec_ != null) {
            output.writeMessage(3, (MessageLite)this.getTaskSpec());
        }
        if (this.taskCount_ != 0L) {
            output.writeInt64(4, this.taskCount_);
        }
        if (this.parallelism_ != 0L) {
            output.writeInt64(5, this.parallelism_);
        }
        if (this.schedulingPolicy_ != SchedulingPolicy.SCHEDULING_POLICY_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.schedulingPolicy_);
        }
        if (this.allocationPolicy_ != null) {
            output.writeMessage(7, (MessageLite)this.getAllocationPolicy());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)8);
        for (int i = 0; i < this.taskEnvironments_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.taskEnvironments_.get(i));
        }
        if (this.taskCountPerNode_ != 0L) {
            output.writeInt64(10, this.taskCountPerNode_);
        }
        if (this.requireHostsFile_) {
            output.writeBool(11, this.requireHostsFile_);
        }
        if (this.permissiveSsh_) {
            output.writeBool(12, this.permissiveSsh_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (this.taskSpec_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getTaskSpec());
        }
        if (this.taskCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)4, (long)this.taskCount_);
        }
        if (this.parallelism_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)5, (long)this.parallelism_);
        }
        if (this.schedulingPolicy_ != SchedulingPolicy.SCHEDULING_POLICY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.schedulingPolicy_);
        }
        if (this.allocationPolicy_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getAllocationPolicy());
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)labels__);
        }
        for (int i = 0; i < this.taskEnvironments_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.taskEnvironments_.get(i)));
        }
        if (this.taskCountPerNode_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)10, (long)this.taskCountPerNode_);
        }
        if (this.requireHostsFile_) {
            size += CodedOutputStream.computeBoolSize((int)11, (boolean)this.requireHostsFile_);
        }
        if (this.permissiveSsh_) {
            size += CodedOutputStream.computeBoolSize((int)12, (boolean)this.permissiveSsh_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskGroup)) {
            return super.equals(obj);
        }
        TaskGroup other = (TaskGroup)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.hasTaskSpec() != other.hasTaskSpec()) {
            return false;
        }
        if (this.hasTaskSpec() && !this.getTaskSpec().equals(other.getTaskSpec())) {
            return false;
        }
        if (this.getTaskCount() != other.getTaskCount()) {
            return false;
        }
        if (this.getParallelism() != other.getParallelism()) {
            return false;
        }
        if (this.schedulingPolicy_ != other.schedulingPolicy_) {
            return false;
        }
        if (this.hasAllocationPolicy() != other.hasAllocationPolicy()) {
            return false;
        }
        if (this.hasAllocationPolicy() && !this.getAllocationPolicy().equals(other.getAllocationPolicy())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getTaskEnvironmentsList().equals(other.getTaskEnvironmentsList())) {
            return false;
        }
        if (this.getTaskCountPerNode() != other.getTaskCountPerNode()) {
            return false;
        }
        if (this.getRequireHostsFile() != other.getRequireHostsFile()) {
            return false;
        }
        if (this.getPermissiveSsh() != other.getPermissiveSsh()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + TaskGroup.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.hasTaskSpec()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getTaskSpec().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashLong((long)this.getTaskCount());
        hash = 37 * hash + 5;
        hash = 53 * hash + Internal.hashLong((long)this.getParallelism());
        hash = 37 * hash + 6;
        hash = 53 * hash + this.schedulingPolicy_;
        if (this.hasAllocationPolicy()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getAllocationPolicy().hashCode();
        }
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        if (this.getTaskEnvironmentsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getTaskEnvironmentsList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + Internal.hashLong((long)this.getTaskCountPerNode());
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getRequireHostsFile());
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPermissiveSsh());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static TaskGroup parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (TaskGroup)PARSER.parseFrom(data);
    }

    public static TaskGroup parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskGroup parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (TaskGroup)PARSER.parseFrom(data);
    }

    public static TaskGroup parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskGroup parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (TaskGroup)PARSER.parseFrom(data);
    }

    public static TaskGroup parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskGroup parseFrom(InputStream input) throws IOException {
        return (TaskGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static TaskGroup parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TaskGroup parseDelimitedFrom(InputStream input) throws IOException {
        return (TaskGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static TaskGroup parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TaskGroup parseFrom(CodedInputStream input) throws IOException {
        return (TaskGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static TaskGroup parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return TaskGroup.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TaskGroup prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static TaskGroup getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TaskGroup> parser() {
        return PARSER;
    }

    public Parser<TaskGroup> getParserForType() {
        return PARSER;
    }

    public TaskGroup getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TaskGroupOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private TaskSpec taskSpec_;
        private SingleFieldBuilderV3<TaskSpec, TaskSpec.Builder, TaskSpecOrBuilder> taskSpecBuilder_;
        private long taskCount_;
        private long parallelism_;
        private int schedulingPolicy_ = 0;
        private AllocationPolicy allocationPolicy_;
        private SingleFieldBuilderV3<AllocationPolicy, AllocationPolicy.Builder, AllocationPolicyOrBuilder> allocationPolicyBuilder_;
        private MapField<String, String> labels_;
        private List<Environment> taskEnvironments_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Environment, Environment.Builder, EnvironmentOrBuilder> taskEnvironmentsBuilder_;
        private long taskCountPerNode_;
        private boolean requireHostsFile_;
        private boolean permissiveSsh_;

        public static final Descriptors.Descriptor getDescriptor() {
            return JobProto.internal_static_google_cloud_batch_v1alpha_TaskGroup_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 8: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 8: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return JobProto.internal_static_google_cloud_batch_v1alpha_TaskGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(TaskGroup.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.taskSpec_ = null;
            if (this.taskSpecBuilder_ != null) {
                this.taskSpecBuilder_.dispose();
                this.taskSpecBuilder_ = null;
            }
            this.taskCount_ = 0L;
            this.parallelism_ = 0L;
            this.schedulingPolicy_ = 0;
            this.allocationPolicy_ = null;
            if (this.allocationPolicyBuilder_ != null) {
                this.allocationPolicyBuilder_.dispose();
                this.allocationPolicyBuilder_ = null;
            }
            this.internalGetMutableLabels().clear();
            if (this.taskEnvironmentsBuilder_ == null) {
                this.taskEnvironments_ = Collections.emptyList();
            } else {
                this.taskEnvironments_ = null;
                this.taskEnvironmentsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFF7F;
            this.taskCountPerNode_ = 0L;
            this.requireHostsFile_ = false;
            this.permissiveSsh_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return JobProto.internal_static_google_cloud_batch_v1alpha_TaskGroup_descriptor;
        }

        public TaskGroup getDefaultInstanceForType() {
            return TaskGroup.getDefaultInstance();
        }

        public TaskGroup build() {
            TaskGroup result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public TaskGroup buildPartial() {
            TaskGroup result = new TaskGroup(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(TaskGroup result) {
            if (this.taskEnvironmentsBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0) {
                    this.taskEnvironments_ = Collections.unmodifiableList(this.taskEnvironments_);
                    this.bitField0_ &= 0xFFFFFF7F;
                }
                result.taskEnvironments_ = this.taskEnvironments_;
            } else {
                result.taskEnvironments_ = this.taskEnvironmentsBuilder_.build();
            }
        }

        private void buildPartial0(TaskGroup result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.taskSpec_ = this.taskSpecBuilder_ == null ? this.taskSpec_ : (TaskSpec)this.taskSpecBuilder_.build();
            }
            if ((from_bitField0_ & 4) != 0) {
                result.taskCount_ = this.taskCount_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.parallelism_ = this.parallelism_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.schedulingPolicy_ = this.schedulingPolicy_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.allocationPolicy_ = this.allocationPolicyBuilder_ == null ? this.allocationPolicy_ : (AllocationPolicy)this.allocationPolicyBuilder_.build();
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.taskCountPerNode_ = this.taskCountPerNode_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.requireHostsFile_ = this.requireHostsFile_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.permissiveSsh_ = this.permissiveSsh_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof TaskGroup) {
                return this.mergeFrom((TaskGroup)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(TaskGroup other) {
            if (other == TaskGroup.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasTaskSpec()) {
                this.mergeTaskSpec(other.getTaskSpec());
            }
            if (other.getTaskCount() != 0L) {
                this.setTaskCount(other.getTaskCount());
            }
            if (other.getParallelism() != 0L) {
                this.setParallelism(other.getParallelism());
            }
            if (other.schedulingPolicy_ != 0) {
                this.setSchedulingPolicyValue(other.getSchedulingPolicyValue());
            }
            if (other.hasAllocationPolicy()) {
                this.mergeAllocationPolicy(other.getAllocationPolicy());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 0x40;
            if (this.taskEnvironmentsBuilder_ == null) {
                if (!other.taskEnvironments_.isEmpty()) {
                    if (this.taskEnvironments_.isEmpty()) {
                        this.taskEnvironments_ = other.taskEnvironments_;
                        this.bitField0_ &= 0xFFFFFF7F;
                    } else {
                        this.ensureTaskEnvironmentsIsMutable();
                        this.taskEnvironments_.addAll(other.taskEnvironments_);
                    }
                    this.onChanged();
                }
            } else if (!other.taskEnvironments_.isEmpty()) {
                if (this.taskEnvironmentsBuilder_.isEmpty()) {
                    this.taskEnvironmentsBuilder_.dispose();
                    this.taskEnvironmentsBuilder_ = null;
                    this.taskEnvironments_ = other.taskEnvironments_;
                    this.bitField0_ &= 0xFFFFFF7F;
                    this.taskEnvironmentsBuilder_ = alwaysUseFieldBuilders ? this.getTaskEnvironmentsFieldBuilder() : null;
                } else {
                    this.taskEnvironmentsBuilder_.addAllMessages((Iterable)other.taskEnvironments_);
                }
            }
            if (other.getTaskCountPerNode() != 0L) {
                this.setTaskCountPerNode(other.getTaskCountPerNode());
            }
            if (other.getRequireHostsFile()) {
                this.setRequireHostsFile(other.getRequireHostsFile());
            }
            if (other.getPermissiveSsh()) {
                this.setPermissiveSsh(other.getPermissiveSsh());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block19: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block19;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block19;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getTaskSpecFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block19;
                        }
                        case 32: {
                            this.taskCount_ = input.readInt64();
                            this.bitField0_ |= 4;
                            continue block19;
                        }
                        case 40: {
                            this.parallelism_ = input.readInt64();
                            this.bitField0_ |= 8;
                            continue block19;
                        }
                        case 48: {
                            this.schedulingPolicy_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block19;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getAllocationPolicyFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block19;
                        }
                        case 66: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 0x40;
                            continue block19;
                        }
                        case 74: {
                            Environment m = (Environment)input.readMessage(Environment.parser(), extensionRegistry);
                            if (this.taskEnvironmentsBuilder_ == null) {
                                this.ensureTaskEnvironmentsIsMutable();
                                this.taskEnvironments_.add(m);
                                continue block19;
                            }
                            this.taskEnvironmentsBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 80: {
                            this.taskCountPerNode_ = input.readInt64();
                            this.bitField0_ |= 0x100;
                            continue block19;
                        }
                        case 88: {
                            this.requireHostsFile_ = input.readBool();
                            this.bitField0_ |= 0x200;
                            continue block19;
                        }
                        case 96: {
                            this.permissiveSsh_ = input.readBool();
                            this.bitField0_ |= 0x400;
                            continue block19;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = TaskGroup.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TaskGroup.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTaskSpec() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public TaskSpec getTaskSpec() {
            if (this.taskSpecBuilder_ == null) {
                return this.taskSpec_ == null ? TaskSpec.getDefaultInstance() : this.taskSpec_;
            }
            return (TaskSpec)this.taskSpecBuilder_.getMessage();
        }

        public Builder setTaskSpec(TaskSpec value) {
            if (this.taskSpecBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.taskSpec_ = value;
            } else {
                this.taskSpecBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setTaskSpec(TaskSpec.Builder builderForValue) {
            if (this.taskSpecBuilder_ == null) {
                this.taskSpec_ = builderForValue.build();
            } else {
                this.taskSpecBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeTaskSpec(TaskSpec value) {
            if (this.taskSpecBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.taskSpec_ != null && this.taskSpec_ != TaskSpec.getDefaultInstance()) {
                    this.getTaskSpecBuilder().mergeFrom(value);
                } else {
                    this.taskSpec_ = value;
                }
            } else {
                this.taskSpecBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTaskSpec() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.taskSpec_ = null;
            if (this.taskSpecBuilder_ != null) {
                this.taskSpecBuilder_.dispose();
                this.taskSpecBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TaskSpec.Builder getTaskSpecBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (TaskSpec.Builder)this.getTaskSpecFieldBuilder().getBuilder();
        }

        @Override
        public TaskSpecOrBuilder getTaskSpecOrBuilder() {
            if (this.taskSpecBuilder_ != null) {
                return (TaskSpecOrBuilder)this.taskSpecBuilder_.getMessageOrBuilder();
            }
            return this.taskSpec_ == null ? TaskSpec.getDefaultInstance() : this.taskSpec_;
        }

        private SingleFieldBuilderV3<TaskSpec, TaskSpec.Builder, TaskSpecOrBuilder> getTaskSpecFieldBuilder() {
            if (this.taskSpecBuilder_ == null) {
                this.taskSpecBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTaskSpec(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.taskSpec_ = null;
            }
            return this.taskSpecBuilder_;
        }

        @Override
        public long getTaskCount() {
            return this.taskCount_;
        }

        public Builder setTaskCount(long value) {
            this.taskCount_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearTaskCount() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.taskCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getParallelism() {
            return this.parallelism_;
        }

        public Builder setParallelism(long value) {
            this.parallelism_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearParallelism() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.parallelism_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getSchedulingPolicyValue() {
            return this.schedulingPolicy_;
        }

        public Builder setSchedulingPolicyValue(int value) {
            this.schedulingPolicy_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public SchedulingPolicy getSchedulingPolicy() {
            SchedulingPolicy result = SchedulingPolicy.forNumber(this.schedulingPolicy_);
            return result == null ? SchedulingPolicy.UNRECOGNIZED : result;
        }

        public Builder setSchedulingPolicy(SchedulingPolicy value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.schedulingPolicy_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSchedulingPolicy() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.schedulingPolicy_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAllocationPolicy() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public AllocationPolicy getAllocationPolicy() {
            if (this.allocationPolicyBuilder_ == null) {
                return this.allocationPolicy_ == null ? AllocationPolicy.getDefaultInstance() : this.allocationPolicy_;
            }
            return (AllocationPolicy)this.allocationPolicyBuilder_.getMessage();
        }

        public Builder setAllocationPolicy(AllocationPolicy value) {
            if (this.allocationPolicyBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.allocationPolicy_ = value;
            } else {
                this.allocationPolicyBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setAllocationPolicy(AllocationPolicy.Builder builderForValue) {
            if (this.allocationPolicyBuilder_ == null) {
                this.allocationPolicy_ = builderForValue.build();
            } else {
                this.allocationPolicyBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeAllocationPolicy(AllocationPolicy value) {
            if (this.allocationPolicyBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.allocationPolicy_ != null && this.allocationPolicy_ != AllocationPolicy.getDefaultInstance()) {
                    this.getAllocationPolicyBuilder().mergeFrom(value);
                } else {
                    this.allocationPolicy_ = value;
                }
            } else {
                this.allocationPolicyBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearAllocationPolicy() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.allocationPolicy_ = null;
            if (this.allocationPolicyBuilder_ != null) {
                this.allocationPolicyBuilder_.dispose();
                this.allocationPolicyBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AllocationPolicy.Builder getAllocationPolicyBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (AllocationPolicy.Builder)this.getAllocationPolicyFieldBuilder().getBuilder();
        }

        @Override
        public AllocationPolicyOrBuilder getAllocationPolicyOrBuilder() {
            if (this.allocationPolicyBuilder_ != null) {
                return (AllocationPolicyOrBuilder)this.allocationPolicyBuilder_.getMessageOrBuilder();
            }
            return this.allocationPolicy_ == null ? AllocationPolicy.getDefaultInstance() : this.allocationPolicy_;
        }

        private SingleFieldBuilderV3<AllocationPolicy, AllocationPolicy.Builder, AllocationPolicyOrBuilder> getAllocationPolicyFieldBuilder() {
            if (this.allocationPolicyBuilder_ == null) {
                this.allocationPolicyBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAllocationPolicy(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.allocationPolicy_ = null;
            }
            return this.allocationPolicyBuilder_;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 0x40;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 0x40;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 0x40;
            return this;
        }

        private void ensureTaskEnvironmentsIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.taskEnvironments_ = new ArrayList<Environment>(this.taskEnvironments_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<Environment> getTaskEnvironmentsList() {
            if (this.taskEnvironmentsBuilder_ == null) {
                return Collections.unmodifiableList(this.taskEnvironments_);
            }
            return this.taskEnvironmentsBuilder_.getMessageList();
        }

        @Override
        public int getTaskEnvironmentsCount() {
            if (this.taskEnvironmentsBuilder_ == null) {
                return this.taskEnvironments_.size();
            }
            return this.taskEnvironmentsBuilder_.getCount();
        }

        @Override
        public Environment getTaskEnvironments(int index) {
            if (this.taskEnvironmentsBuilder_ == null) {
                return this.taskEnvironments_.get(index);
            }
            return (Environment)this.taskEnvironmentsBuilder_.getMessage(index);
        }

        public Builder setTaskEnvironments(int index, Environment value) {
            if (this.taskEnvironmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTaskEnvironmentsIsMutable();
                this.taskEnvironments_.set(index, value);
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setTaskEnvironments(int index, Environment.Builder builderForValue) {
            if (this.taskEnvironmentsBuilder_ == null) {
                this.ensureTaskEnvironmentsIsMutable();
                this.taskEnvironments_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTaskEnvironments(Environment value) {
            if (this.taskEnvironmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTaskEnvironmentsIsMutable();
                this.taskEnvironments_.add(value);
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addTaskEnvironments(int index, Environment value) {
            if (this.taskEnvironmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTaskEnvironmentsIsMutable();
                this.taskEnvironments_.add(index, value);
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addTaskEnvironments(Environment.Builder builderForValue) {
            if (this.taskEnvironmentsBuilder_ == null) {
                this.ensureTaskEnvironmentsIsMutable();
                this.taskEnvironments_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTaskEnvironments(int index, Environment.Builder builderForValue) {
            if (this.taskEnvironmentsBuilder_ == null) {
                this.ensureTaskEnvironmentsIsMutable();
                this.taskEnvironments_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllTaskEnvironments(Iterable<? extends Environment> values) {
            if (this.taskEnvironmentsBuilder_ == null) {
                this.ensureTaskEnvironmentsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.taskEnvironments_);
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearTaskEnvironments() {
            if (this.taskEnvironmentsBuilder_ == null) {
                this.taskEnvironments_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.clear();
            }
            return this;
        }

        public Builder removeTaskEnvironments(int index) {
            if (this.taskEnvironmentsBuilder_ == null) {
                this.ensureTaskEnvironmentsIsMutable();
                this.taskEnvironments_.remove(index);
                this.onChanged();
            } else {
                this.taskEnvironmentsBuilder_.remove(index);
            }
            return this;
        }

        public Environment.Builder getTaskEnvironmentsBuilder(int index) {
            return (Environment.Builder)this.getTaskEnvironmentsFieldBuilder().getBuilder(index);
        }

        @Override
        public EnvironmentOrBuilder getTaskEnvironmentsOrBuilder(int index) {
            if (this.taskEnvironmentsBuilder_ == null) {
                return this.taskEnvironments_.get(index);
            }
            return (EnvironmentOrBuilder)this.taskEnvironmentsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends EnvironmentOrBuilder> getTaskEnvironmentsOrBuilderList() {
            if (this.taskEnvironmentsBuilder_ != null) {
                return this.taskEnvironmentsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.taskEnvironments_);
        }

        public Environment.Builder addTaskEnvironmentsBuilder() {
            return (Environment.Builder)this.getTaskEnvironmentsFieldBuilder().addBuilder((AbstractMessage)Environment.getDefaultInstance());
        }

        public Environment.Builder addTaskEnvironmentsBuilder(int index) {
            return (Environment.Builder)this.getTaskEnvironmentsFieldBuilder().addBuilder(index, (AbstractMessage)Environment.getDefaultInstance());
        }

        public List<Environment.Builder> getTaskEnvironmentsBuilderList() {
            return this.getTaskEnvironmentsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Environment, Environment.Builder, EnvironmentOrBuilder> getTaskEnvironmentsFieldBuilder() {
            if (this.taskEnvironmentsBuilder_ == null) {
                this.taskEnvironmentsBuilder_ = new RepeatedFieldBuilderV3(this.taskEnvironments_, (this.bitField0_ & 0x80) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.taskEnvironments_ = null;
            }
            return this.taskEnvironmentsBuilder_;
        }

        @Override
        public long getTaskCountPerNode() {
            return this.taskCountPerNode_;
        }

        public Builder setTaskCountPerNode(long value) {
            this.taskCountPerNode_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearTaskCountPerNode() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.taskCountPerNode_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getRequireHostsFile() {
            return this.requireHostsFile_;
        }

        public Builder setRequireHostsFile(boolean value) {
            this.requireHostsFile_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearRequireHostsFile() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.requireHostsFile_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getPermissiveSsh() {
            return this.permissiveSsh_;
        }

        public Builder setPermissiveSsh(boolean value) {
            this.permissiveSsh_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearPermissiveSsh() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.permissiveSsh_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)JobProto.internal_static_google_cloud_batch_v1alpha_TaskGroup_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum SchedulingPolicy implements ProtocolMessageEnum
    {
        SCHEDULING_POLICY_UNSPECIFIED(0),
        AS_SOON_AS_POSSIBLE(1),
        UNRECOGNIZED(-1);

        public static final int SCHEDULING_POLICY_UNSPECIFIED_VALUE = 0;
        public static final int AS_SOON_AS_POSSIBLE_VALUE = 1;
        private static final Internal.EnumLiteMap<SchedulingPolicy> internalValueMap;
        private static final SchedulingPolicy[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SchedulingPolicy valueOf(int value) {
            return SchedulingPolicy.forNumber(value);
        }

        public static SchedulingPolicy forNumber(int value) {
            switch (value) {
                case 0: {
                    return SCHEDULING_POLICY_UNSPECIFIED;
                }
                case 1: {
                    return AS_SOON_AS_POSSIBLE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SchedulingPolicy> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)SchedulingPolicy.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SchedulingPolicy.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)TaskGroup.getDescriptor().getEnumTypes().get(0);
        }

        public static SchedulingPolicy valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SchedulingPolicy.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SchedulingPolicy(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<SchedulingPolicy>(){

                public SchedulingPolicy findValueByNumber(int number) {
                    return SchedulingPolicy.forNumber(number);
                }
            };
            VALUES = SchedulingPolicy.values();
        }
    }
}

