/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NFSShareName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NFS_SHARE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/nfsShares/{nfs_share}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String nfsShare;

    @Deprecated
    protected NFSShareName() {
        this.project = null;
        this.location = null;
        this.nfsShare = null;
    }

    private NFSShareName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.nfsShare = (String)Preconditions.checkNotNull((Object)builder.getNfsShare());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNfsShare() {
        return this.nfsShare;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NFSShareName of(String project, String location, String nfsShare) {
        return NFSShareName.newBuilder().setProject(project).setLocation(location).setNfsShare(nfsShare).build();
    }

    public static String format(String project, String location, String nfsShare) {
        return NFSShareName.newBuilder().setProject(project).setLocation(location).setNfsShare(nfsShare).build().toString();
    }

    public static NFSShareName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NFS_SHARE.validatedMatch(formattedString, "NFSShareName.parse: formattedString not in valid format");
        return NFSShareName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("nfs_share"));
    }

    public static List<NFSShareName> parseList(List<String> formattedStrings) {
        ArrayList<NFSShareName> list = new ArrayList<NFSShareName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NFSShareName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NFSShareName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NFSShareName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NFS_SHARE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NFSShareName nFSShareName = this;
            synchronized (nFSShareName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.nfsShare != null) {
                        fieldMapBuilder.put((Object)"nfs_share", (Object)this.nfsShare);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NFS_SHARE.instantiate(new String[]{"project", this.project, "location", this.location, "nfs_share", this.nfsShare});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NFSShareName that = (NFSShareName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.nfsShare, that.nfsShare);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.nfsShare);
    }

    public static class Builder {
        private String project;
        private String location;
        private String nfsShare;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNfsShare() {
            return this.nfsShare;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNfsShare(String nfsShare) {
            this.nfsShare = nfsShare;
            return this;
        }

        private Builder(NFSShareName nFSShareName) {
            this.project = nFSShareName.project;
            this.location = nFSShareName.location;
            this.nfsShare = nFSShareName.nfsShare;
        }

        public NFSShareName build() {
            return new NFSShareName(this);
        }
    }
}

