/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/models/{model}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String model;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModel() {
        return this.model;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ModelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
    }

    public static ModelName of(String project, String location, String model) {
        return ModelName.newBuilder().setProject(project).setLocation(location).setModel(model).build();
    }

    public static String format(String project, String location, String model) {
        return ModelName.newBuilder().setProject(project).setLocation(location).setModel(model).build().toString();
    }

    public static ModelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ModelName.parse: formattedString not in valid format");
        return ModelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model"));
    }

    public static List<ModelName> parseList(List<String> formattedStrings) {
        ArrayList<ModelName> list = new ArrayList<ModelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelName modelName = this;
            synchronized (modelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"model", (Object)this.model);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "model", this.model});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ModelName) {
            ModelName that = (ModelName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.model.equals(that.model);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.model.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String model;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModel() {
            return this.model;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        private Builder() {
        }

        private Builder(ModelName modelName) {
            this.project = modelName.project;
            this.location = modelName.location;
            this.model = modelName.model;
        }

        public ModelName build() {
            return new ModelName(this);
        }
    }
}

