/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.assuredworkloads.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkloadName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_WORKLOAD = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/workloads/{workload}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String workload;

    @Deprecated
    protected WorkloadName() {
        this.organization = null;
        this.location = null;
        this.workload = null;
    }

    private WorkloadName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workload = (String)Preconditions.checkNotNull((Object)builder.getWorkload());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkload() {
        return this.workload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkloadName of(String organization, String location, String workload) {
        return WorkloadName.newBuilder().setOrganization(organization).setLocation(location).setWorkload(workload).build();
    }

    public static String format(String organization, String location, String workload) {
        return WorkloadName.newBuilder().setOrganization(organization).setLocation(location).setWorkload(workload).build().toString();
    }

    public static WorkloadName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_WORKLOAD.validatedMatch(formattedString, "WorkloadName.parse: formattedString not in valid format");
        return WorkloadName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("workload"));
    }

    public static List<WorkloadName> parseList(List<String> formattedStrings) {
        ArrayList<WorkloadName> list = new ArrayList<WorkloadName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkloadName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkloadName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkloadName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_WORKLOAD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkloadName workloadName = this;
            synchronized (workloadName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workload != null) {
                        fieldMapBuilder.put((Object)"workload", (Object)this.workload);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_WORKLOAD.instantiate(new String[]{"organization", this.organization, "location", this.location, "workload", this.workload});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkloadName that = (WorkloadName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.workload, that.workload);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workload);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String workload;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkload() {
            return this.workload;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        private Builder(WorkloadName workloadName) {
            this.organization = workloadName.organization;
            this.location = workloadName.location;
            this.workload = workloadName.workload;
        }

        public WorkloadName build() {
            return new WorkloadName(this);
        }
    }
}

