/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apphub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceProjectAttachmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_PROJECT_ATTACHMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serviceProjectAttachments/{service_project_attachment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serviceProjectAttachment;

    @Deprecated
    protected ServiceProjectAttachmentName() {
        this.project = null;
        this.location = null;
        this.serviceProjectAttachment = null;
    }

    private ServiceProjectAttachmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serviceProjectAttachment = (String)Preconditions.checkNotNull((Object)builder.getServiceProjectAttachment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServiceProjectAttachment() {
        return this.serviceProjectAttachment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceProjectAttachmentName of(String project, String location, String serviceProjectAttachment) {
        return ServiceProjectAttachmentName.newBuilder().setProject(project).setLocation(location).setServiceProjectAttachment(serviceProjectAttachment).build();
    }

    public static String format(String project, String location, String serviceProjectAttachment) {
        return ServiceProjectAttachmentName.newBuilder().setProject(project).setLocation(location).setServiceProjectAttachment(serviceProjectAttachment).build().toString();
    }

    public static ServiceProjectAttachmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_PROJECT_ATTACHMENT.validatedMatch(formattedString, "ServiceProjectAttachmentName.parse: formattedString not in valid format");
        return ServiceProjectAttachmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service_project_attachment"));
    }

    public static List<ServiceProjectAttachmentName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceProjectAttachmentName> list = new ArrayList<ServiceProjectAttachmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceProjectAttachmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceProjectAttachmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceProjectAttachmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_PROJECT_ATTACHMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceProjectAttachmentName serviceProjectAttachmentName = this;
            synchronized (serviceProjectAttachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serviceProjectAttachment != null) {
                        fieldMapBuilder.put((Object)"service_project_attachment", (Object)this.serviceProjectAttachment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_PROJECT_ATTACHMENT.instantiate(new String[]{"project", this.project, "location", this.location, "service_project_attachment", this.serviceProjectAttachment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceProjectAttachmentName that = (ServiceProjectAttachmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serviceProjectAttachment, that.serviceProjectAttachment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serviceProjectAttachment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serviceProjectAttachment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServiceProjectAttachment() {
            return this.serviceProjectAttachment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServiceProjectAttachment(String serviceProjectAttachment) {
            this.serviceProjectAttachment = serviceProjectAttachment;
            return this;
        }

        private Builder(ServiceProjectAttachmentName serviceProjectAttachmentName) {
            this.project = serviceProjectAttachmentName.project;
            this.location = serviceProjectAttachmentName.location;
            this.serviceProjectAttachment = serviceProjectAttachmentName.serviceProjectAttachment;
        }

        public ServiceProjectAttachmentName build() {
            return new ServiceProjectAttachmentName(this);
        }
    }
}

