/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apphub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkloadName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_APPLICATION_WORKLOAD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/applications/{application}/workloads/{workload}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String application;
    private final String workload;

    @Deprecated
    protected WorkloadName() {
        this.project = null;
        this.location = null;
        this.application = null;
        this.workload = null;
    }

    private WorkloadName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.application = (String)Preconditions.checkNotNull((Object)builder.getApplication());
        this.workload = (String)Preconditions.checkNotNull((Object)builder.getWorkload());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApplication() {
        return this.application;
    }

    public String getWorkload() {
        return this.workload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkloadName of(String project, String location, String application, String workload) {
        return WorkloadName.newBuilder().setProject(project).setLocation(location).setApplication(application).setWorkload(workload).build();
    }

    public static String format(String project, String location, String application, String workload) {
        return WorkloadName.newBuilder().setProject(project).setLocation(location).setApplication(application).setWorkload(workload).build().toString();
    }

    public static WorkloadName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_APPLICATION_WORKLOAD.validatedMatch(formattedString, "WorkloadName.parse: formattedString not in valid format");
        return WorkloadName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("application"), (String)matchMap.get("workload"));
    }

    public static List<WorkloadName> parseList(List<String> formattedStrings) {
        ArrayList<WorkloadName> list = new ArrayList<WorkloadName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkloadName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkloadName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkloadName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_APPLICATION_WORKLOAD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkloadName workloadName = this;
            synchronized (workloadName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.application != null) {
                        fieldMapBuilder.put((Object)"application", (Object)this.application);
                    }
                    if (this.workload != null) {
                        fieldMapBuilder.put((Object)"workload", (Object)this.workload);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_APPLICATION_WORKLOAD.instantiate(new String[]{"project", this.project, "location", this.location, "application", this.application, "workload", this.workload});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkloadName that = (WorkloadName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.application, that.application) && Objects.equals(this.workload, that.workload);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.application);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workload);
    }

    public static class Builder {
        private String project;
        private String location;
        private String application;
        private String workload;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApplication() {
            return this.application;
        }

        public String getWorkload() {
            return this.workload;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        public Builder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        private Builder(WorkloadName workloadName) {
            this.project = workloadName.project;
            this.location = workloadName.location;
            this.application = workloadName.application;
            this.workload = workloadName.workload;
        }

        public WorkloadName build() {
            return new WorkloadName(this);
        }
    }
}

