/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb.v1beta;

import com.google.cloud.alloydb.v1beta.DatabaseVersion;
import com.google.cloud.alloydb.v1beta.ResourcesProto;
import com.google.cloud.alloydb.v1beta.SupportedDatabaseFlagOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Int64ValueOrBuilder;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SupportedDatabaseFlag
extends GeneratedMessageV3
implements SupportedDatabaseFlagOrBuilder {
    private static final long serialVersionUID = 0L;
    private int restrictionsCase_ = 0;
    private Object restrictions_;
    public static final int STRING_RESTRICTIONS_FIELD_NUMBER = 7;
    public static final int INTEGER_RESTRICTIONS_FIELD_NUMBER = 8;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int FLAG_NAME_FIELD_NUMBER = 2;
    private volatile Object flagName_ = "";
    public static final int VALUE_TYPE_FIELD_NUMBER = 3;
    private int valueType_ = 0;
    public static final int ACCEPTS_MULTIPLE_VALUES_FIELD_NUMBER = 4;
    private boolean acceptsMultipleValues_ = false;
    public static final int SUPPORTED_DB_VERSIONS_FIELD_NUMBER = 5;
    private List<Integer> supportedDbVersions_;
    private static final Internal.ListAdapter.Converter<Integer, DatabaseVersion> supportedDbVersions_converter_ = new Internal.ListAdapter.Converter<Integer, DatabaseVersion>(){

        public DatabaseVersion convert(Integer from) {
            DatabaseVersion result = DatabaseVersion.forNumber(from);
            return result == null ? DatabaseVersion.UNRECOGNIZED : result;
        }
    };
    private int supportedDbVersionsMemoizedSerializedSize;
    public static final int REQUIRES_DB_RESTART_FIELD_NUMBER = 6;
    private boolean requiresDbRestart_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final SupportedDatabaseFlag DEFAULT_INSTANCE = new SupportedDatabaseFlag();
    private static final Parser<SupportedDatabaseFlag> PARSER = new AbstractParser<SupportedDatabaseFlag>(){

        public SupportedDatabaseFlag parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = SupportedDatabaseFlag.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private SupportedDatabaseFlag(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private SupportedDatabaseFlag() {
        this.name_ = "";
        this.flagName_ = "";
        this.valueType_ = 0;
        this.supportedDbVersions_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new SupportedDatabaseFlag();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_fieldAccessorTable.ensureFieldAccessorsInitialized(SupportedDatabaseFlag.class, Builder.class);
    }

    @Override
    public RestrictionsCase getRestrictionsCase() {
        return RestrictionsCase.forNumber(this.restrictionsCase_);
    }

    @Override
    public boolean hasStringRestrictions() {
        return this.restrictionsCase_ == 7;
    }

    @Override
    public StringRestrictions getStringRestrictions() {
        if (this.restrictionsCase_ == 7) {
            return (StringRestrictions)this.restrictions_;
        }
        return StringRestrictions.getDefaultInstance();
    }

    @Override
    public StringRestrictionsOrBuilder getStringRestrictionsOrBuilder() {
        if (this.restrictionsCase_ == 7) {
            return (StringRestrictions)this.restrictions_;
        }
        return StringRestrictions.getDefaultInstance();
    }

    @Override
    public boolean hasIntegerRestrictions() {
        return this.restrictionsCase_ == 8;
    }

    @Override
    public IntegerRestrictions getIntegerRestrictions() {
        if (this.restrictionsCase_ == 8) {
            return (IntegerRestrictions)this.restrictions_;
        }
        return IntegerRestrictions.getDefaultInstance();
    }

    @Override
    public IntegerRestrictionsOrBuilder getIntegerRestrictionsOrBuilder() {
        if (this.restrictionsCase_ == 8) {
            return (IntegerRestrictions)this.restrictions_;
        }
        return IntegerRestrictions.getDefaultInstance();
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getFlagName() {
        Object ref = this.flagName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.flagName_ = s;
        return s;
    }

    @Override
    public ByteString getFlagNameBytes() {
        Object ref = this.flagName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.flagName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getValueTypeValue() {
        return this.valueType_;
    }

    @Override
    public ValueType getValueType() {
        ValueType result = ValueType.forNumber(this.valueType_);
        return result == null ? ValueType.UNRECOGNIZED : result;
    }

    @Override
    public boolean getAcceptsMultipleValues() {
        return this.acceptsMultipleValues_;
    }

    @Override
    public List<DatabaseVersion> getSupportedDbVersionsList() {
        return new Internal.ListAdapter(this.supportedDbVersions_, supportedDbVersions_converter_);
    }

    @Override
    public int getSupportedDbVersionsCount() {
        return this.supportedDbVersions_.size();
    }

    @Override
    public DatabaseVersion getSupportedDbVersions(int index) {
        return (DatabaseVersion)((Object)supportedDbVersions_converter_.convert((Object)this.supportedDbVersions_.get(index)));
    }

    @Override
    public List<Integer> getSupportedDbVersionsValueList() {
        return this.supportedDbVersions_;
    }

    @Override
    public int getSupportedDbVersionsValue(int index) {
        return this.supportedDbVersions_.get(index);
    }

    @Override
    public boolean getRequiresDbRestart() {
        return this.requiresDbRestart_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.flagName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.flagName_);
        }
        if (this.valueType_ != ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.valueType_);
        }
        if (this.acceptsMultipleValues_) {
            output.writeBool(4, this.acceptsMultipleValues_);
        }
        if (this.getSupportedDbVersionsList().size() > 0) {
            output.writeUInt32NoTag(42);
            output.writeUInt32NoTag(this.supportedDbVersionsMemoizedSerializedSize);
        }
        for (int i = 0; i < this.supportedDbVersions_.size(); ++i) {
            output.writeEnumNoTag(this.supportedDbVersions_.get(i).intValue());
        }
        if (this.requiresDbRestart_) {
            output.writeBool(6, this.requiresDbRestart_);
        }
        if (this.restrictionsCase_ == 7) {
            output.writeMessage(7, (MessageLite)((StringRestrictions)this.restrictions_));
        }
        if (this.restrictionsCase_ == 8) {
            output.writeMessage(8, (MessageLite)((IntegerRestrictions)this.restrictions_));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.flagName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.flagName_);
        }
        if (this.valueType_ != ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.valueType_);
        }
        if (this.acceptsMultipleValues_) {
            size += CodedOutputStream.computeBoolSize((int)4, (boolean)this.acceptsMultipleValues_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.supportedDbVersions_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.supportedDbVersions_.get(i));
        }
        size += dataSize;
        if (!this.getSupportedDbVersionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.supportedDbVersionsMemoizedSerializedSize = dataSize;
        if (this.requiresDbRestart_) {
            size += CodedOutputStream.computeBoolSize((int)6, (boolean)this.requiresDbRestart_);
        }
        if (this.restrictionsCase_ == 7) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((StringRestrictions)this.restrictions_));
        }
        if (this.restrictionsCase_ == 8) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((IntegerRestrictions)this.restrictions_));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SupportedDatabaseFlag)) {
            return super.equals(obj);
        }
        SupportedDatabaseFlag other = (SupportedDatabaseFlag)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getFlagName().equals(other.getFlagName())) {
            return false;
        }
        if (this.valueType_ != other.valueType_) {
            return false;
        }
        if (this.getAcceptsMultipleValues() != other.getAcceptsMultipleValues()) {
            return false;
        }
        if (!this.supportedDbVersions_.equals(other.supportedDbVersions_)) {
            return false;
        }
        if (this.getRequiresDbRestart() != other.getRequiresDbRestart()) {
            return false;
        }
        if (!this.getRestrictionsCase().equals((Object)other.getRestrictionsCase())) {
            return false;
        }
        switch (this.restrictionsCase_) {
            case 7: {
                if (this.getStringRestrictions().equals(other.getStringRestrictions())) break;
                return false;
            }
            case 8: {
                if (this.getIntegerRestrictions().equals(other.getIntegerRestrictions())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + SupportedDatabaseFlag.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getFlagName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.valueType_;
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getAcceptsMultipleValues());
        if (this.getSupportedDbVersionsCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.supportedDbVersions_.hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getRequiresDbRestart());
        switch (this.restrictionsCase_) {
            case 7: {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getStringRestrictions().hashCode();
                break;
            }
            case 8: {
                hash = 37 * hash + 8;
                hash = 53 * hash + this.getIntegerRestrictions().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static SupportedDatabaseFlag parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (SupportedDatabaseFlag)PARSER.parseFrom(data);
    }

    public static SupportedDatabaseFlag parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SupportedDatabaseFlag)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SupportedDatabaseFlag parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (SupportedDatabaseFlag)PARSER.parseFrom(data);
    }

    public static SupportedDatabaseFlag parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SupportedDatabaseFlag)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SupportedDatabaseFlag parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (SupportedDatabaseFlag)PARSER.parseFrom(data);
    }

    public static SupportedDatabaseFlag parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SupportedDatabaseFlag)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SupportedDatabaseFlag parseFrom(InputStream input) throws IOException {
        return (SupportedDatabaseFlag)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static SupportedDatabaseFlag parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SupportedDatabaseFlag)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SupportedDatabaseFlag parseDelimitedFrom(InputStream input) throws IOException {
        return (SupportedDatabaseFlag)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static SupportedDatabaseFlag parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SupportedDatabaseFlag)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SupportedDatabaseFlag parseFrom(CodedInputStream input) throws IOException {
        return (SupportedDatabaseFlag)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static SupportedDatabaseFlag parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SupportedDatabaseFlag)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return SupportedDatabaseFlag.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SupportedDatabaseFlag prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static SupportedDatabaseFlag getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<SupportedDatabaseFlag> parser() {
        return PARSER;
    }

    public Parser<SupportedDatabaseFlag> getParserForType() {
        return PARSER;
    }

    public SupportedDatabaseFlag getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SupportedDatabaseFlagOrBuilder {
        private int restrictionsCase_ = 0;
        private Object restrictions_;
        private int bitField0_;
        private SingleFieldBuilderV3<StringRestrictions, StringRestrictions.Builder, StringRestrictionsOrBuilder> stringRestrictionsBuilder_;
        private SingleFieldBuilderV3<IntegerRestrictions, IntegerRestrictions.Builder, IntegerRestrictionsOrBuilder> integerRestrictionsBuilder_;
        private Object name_ = "";
        private Object flagName_ = "";
        private int valueType_ = 0;
        private boolean acceptsMultipleValues_;
        private List<Integer> supportedDbVersions_ = Collections.emptyList();
        private boolean requiresDbRestart_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_fieldAccessorTable.ensureFieldAccessorsInitialized(SupportedDatabaseFlag.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.stringRestrictionsBuilder_ != null) {
                this.stringRestrictionsBuilder_.clear();
            }
            if (this.integerRestrictionsBuilder_ != null) {
                this.integerRestrictionsBuilder_.clear();
            }
            this.name_ = "";
            this.flagName_ = "";
            this.valueType_ = 0;
            this.acceptsMultipleValues_ = false;
            this.supportedDbVersions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.requiresDbRestart_ = false;
            this.restrictionsCase_ = 0;
            this.restrictions_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_descriptor;
        }

        public SupportedDatabaseFlag getDefaultInstanceForType() {
            return SupportedDatabaseFlag.getDefaultInstance();
        }

        public SupportedDatabaseFlag build() {
            SupportedDatabaseFlag result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public SupportedDatabaseFlag buildPartial() {
            SupportedDatabaseFlag result = new SupportedDatabaseFlag(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(SupportedDatabaseFlag result) {
            if ((this.bitField0_ & 0x40) != 0) {
                this.supportedDbVersions_ = Collections.unmodifiableList(this.supportedDbVersions_);
                this.bitField0_ &= 0xFFFFFFBF;
            }
            result.supportedDbVersions_ = this.supportedDbVersions_;
        }

        private void buildPartial0(SupportedDatabaseFlag result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 4) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.flagName_ = this.flagName_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.valueType_ = this.valueType_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.acceptsMultipleValues_ = this.acceptsMultipleValues_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.requiresDbRestart_ = this.requiresDbRestart_;
            }
        }

        private void buildPartialOneofs(SupportedDatabaseFlag result) {
            result.restrictionsCase_ = this.restrictionsCase_;
            result.restrictions_ = this.restrictions_;
            if (this.restrictionsCase_ == 7 && this.stringRestrictionsBuilder_ != null) {
                result.restrictions_ = this.stringRestrictionsBuilder_.build();
            }
            if (this.restrictionsCase_ == 8 && this.integerRestrictionsBuilder_ != null) {
                result.restrictions_ = this.integerRestrictionsBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof SupportedDatabaseFlag) {
                return this.mergeFrom((SupportedDatabaseFlag)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(SupportedDatabaseFlag other) {
            if (other == SupportedDatabaseFlag.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getFlagName().isEmpty()) {
                this.flagName_ = other.flagName_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.valueType_ != 0) {
                this.setValueTypeValue(other.getValueTypeValue());
            }
            if (other.getAcceptsMultipleValues()) {
                this.setAcceptsMultipleValues(other.getAcceptsMultipleValues());
            }
            if (!other.supportedDbVersions_.isEmpty()) {
                if (this.supportedDbVersions_.isEmpty()) {
                    this.supportedDbVersions_ = other.supportedDbVersions_;
                    this.bitField0_ &= 0xFFFFFFBF;
                } else {
                    this.ensureSupportedDbVersionsIsMutable();
                    this.supportedDbVersions_.addAll(other.supportedDbVersions_);
                }
                this.onChanged();
            }
            if (other.getRequiresDbRestart()) {
                this.setRequiresDbRestart(other.getRequiresDbRestart());
            }
            switch (other.getRestrictionsCase()) {
                case STRING_RESTRICTIONS: {
                    this.mergeStringRestrictions(other.getStringRestrictions());
                    break;
                }
                case INTEGER_RESTRICTIONS: {
                    this.mergeIntegerRestrictions(other.getIntegerRestrictions());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 18: {
                            this.flagName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 24: {
                            this.valueType_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 32: {
                            this.acceptsMultipleValues_ = input.readBool();
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                        case 40: {
                            int tmpRaw = input.readEnum();
                            this.ensureSupportedDbVersionsIsMutable();
                            this.supportedDbVersions_.add(tmpRaw);
                            continue block17;
                        }
                        case 42: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureSupportedDbVersionsIsMutable();
                                this.supportedDbVersions_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block17;
                        }
                        case 48: {
                            this.requiresDbRestart_ = input.readBool();
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getStringRestrictionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.restrictionsCase_ = 7;
                            continue block17;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getIntegerRestrictionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.restrictionsCase_ = 8;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public RestrictionsCase getRestrictionsCase() {
            return RestrictionsCase.forNumber(this.restrictionsCase_);
        }

        public Builder clearRestrictions() {
            this.restrictionsCase_ = 0;
            this.restrictions_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStringRestrictions() {
            return this.restrictionsCase_ == 7;
        }

        @Override
        public StringRestrictions getStringRestrictions() {
            if (this.stringRestrictionsBuilder_ == null) {
                if (this.restrictionsCase_ == 7) {
                    return (StringRestrictions)this.restrictions_;
                }
                return StringRestrictions.getDefaultInstance();
            }
            if (this.restrictionsCase_ == 7) {
                return (StringRestrictions)this.stringRestrictionsBuilder_.getMessage();
            }
            return StringRestrictions.getDefaultInstance();
        }

        public Builder setStringRestrictions(StringRestrictions value) {
            if (this.stringRestrictionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.restrictions_ = value;
                this.onChanged();
            } else {
                this.stringRestrictionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.restrictionsCase_ = 7;
            return this;
        }

        public Builder setStringRestrictions(StringRestrictions.Builder builderForValue) {
            if (this.stringRestrictionsBuilder_ == null) {
                this.restrictions_ = builderForValue.build();
                this.onChanged();
            } else {
                this.stringRestrictionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.restrictionsCase_ = 7;
            return this;
        }

        public Builder mergeStringRestrictions(StringRestrictions value) {
            if (this.stringRestrictionsBuilder_ == null) {
                this.restrictions_ = this.restrictionsCase_ == 7 && this.restrictions_ != StringRestrictions.getDefaultInstance() ? StringRestrictions.newBuilder((StringRestrictions)this.restrictions_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.restrictionsCase_ == 7) {
                this.stringRestrictionsBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.stringRestrictionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.restrictionsCase_ = 7;
            return this;
        }

        public Builder clearStringRestrictions() {
            if (this.stringRestrictionsBuilder_ == null) {
                if (this.restrictionsCase_ == 7) {
                    this.restrictionsCase_ = 0;
                    this.restrictions_ = null;
                    this.onChanged();
                }
            } else {
                if (this.restrictionsCase_ == 7) {
                    this.restrictionsCase_ = 0;
                    this.restrictions_ = null;
                }
                this.stringRestrictionsBuilder_.clear();
            }
            return this;
        }

        public StringRestrictions.Builder getStringRestrictionsBuilder() {
            return (StringRestrictions.Builder)this.getStringRestrictionsFieldBuilder().getBuilder();
        }

        @Override
        public StringRestrictionsOrBuilder getStringRestrictionsOrBuilder() {
            if (this.restrictionsCase_ == 7 && this.stringRestrictionsBuilder_ != null) {
                return (StringRestrictionsOrBuilder)this.stringRestrictionsBuilder_.getMessageOrBuilder();
            }
            if (this.restrictionsCase_ == 7) {
                return (StringRestrictions)this.restrictions_;
            }
            return StringRestrictions.getDefaultInstance();
        }

        private SingleFieldBuilderV3<StringRestrictions, StringRestrictions.Builder, StringRestrictionsOrBuilder> getStringRestrictionsFieldBuilder() {
            if (this.stringRestrictionsBuilder_ == null) {
                if (this.restrictionsCase_ != 7) {
                    this.restrictions_ = StringRestrictions.getDefaultInstance();
                }
                this.stringRestrictionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((StringRestrictions)this.restrictions_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.restrictions_ = null;
            }
            this.restrictionsCase_ = 7;
            this.onChanged();
            return this.stringRestrictionsBuilder_;
        }

        @Override
        public boolean hasIntegerRestrictions() {
            return this.restrictionsCase_ == 8;
        }

        @Override
        public IntegerRestrictions getIntegerRestrictions() {
            if (this.integerRestrictionsBuilder_ == null) {
                if (this.restrictionsCase_ == 8) {
                    return (IntegerRestrictions)this.restrictions_;
                }
                return IntegerRestrictions.getDefaultInstance();
            }
            if (this.restrictionsCase_ == 8) {
                return (IntegerRestrictions)this.integerRestrictionsBuilder_.getMessage();
            }
            return IntegerRestrictions.getDefaultInstance();
        }

        public Builder setIntegerRestrictions(IntegerRestrictions value) {
            if (this.integerRestrictionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.restrictions_ = value;
                this.onChanged();
            } else {
                this.integerRestrictionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.restrictionsCase_ = 8;
            return this;
        }

        public Builder setIntegerRestrictions(IntegerRestrictions.Builder builderForValue) {
            if (this.integerRestrictionsBuilder_ == null) {
                this.restrictions_ = builderForValue.build();
                this.onChanged();
            } else {
                this.integerRestrictionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.restrictionsCase_ = 8;
            return this;
        }

        public Builder mergeIntegerRestrictions(IntegerRestrictions value) {
            if (this.integerRestrictionsBuilder_ == null) {
                this.restrictions_ = this.restrictionsCase_ == 8 && this.restrictions_ != IntegerRestrictions.getDefaultInstance() ? IntegerRestrictions.newBuilder((IntegerRestrictions)this.restrictions_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.restrictionsCase_ == 8) {
                this.integerRestrictionsBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.integerRestrictionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.restrictionsCase_ = 8;
            return this;
        }

        public Builder clearIntegerRestrictions() {
            if (this.integerRestrictionsBuilder_ == null) {
                if (this.restrictionsCase_ == 8) {
                    this.restrictionsCase_ = 0;
                    this.restrictions_ = null;
                    this.onChanged();
                }
            } else {
                if (this.restrictionsCase_ == 8) {
                    this.restrictionsCase_ = 0;
                    this.restrictions_ = null;
                }
                this.integerRestrictionsBuilder_.clear();
            }
            return this;
        }

        public IntegerRestrictions.Builder getIntegerRestrictionsBuilder() {
            return (IntegerRestrictions.Builder)this.getIntegerRestrictionsFieldBuilder().getBuilder();
        }

        @Override
        public IntegerRestrictionsOrBuilder getIntegerRestrictionsOrBuilder() {
            if (this.restrictionsCase_ == 8 && this.integerRestrictionsBuilder_ != null) {
                return (IntegerRestrictionsOrBuilder)this.integerRestrictionsBuilder_.getMessageOrBuilder();
            }
            if (this.restrictionsCase_ == 8) {
                return (IntegerRestrictions)this.restrictions_;
            }
            return IntegerRestrictions.getDefaultInstance();
        }

        private SingleFieldBuilderV3<IntegerRestrictions, IntegerRestrictions.Builder, IntegerRestrictionsOrBuilder> getIntegerRestrictionsFieldBuilder() {
            if (this.integerRestrictionsBuilder_ == null) {
                if (this.restrictionsCase_ != 8) {
                    this.restrictions_ = IntegerRestrictions.getDefaultInstance();
                }
                this.integerRestrictionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((IntegerRestrictions)this.restrictions_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.restrictions_ = null;
            }
            this.restrictionsCase_ = 8;
            this.onChanged();
            return this.integerRestrictionsBuilder_;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = SupportedDatabaseFlag.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SupportedDatabaseFlag.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getFlagName() {
            Object ref = this.flagName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.flagName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFlagNameBytes() {
            Object ref = this.flagName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.flagName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFlagName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.flagName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearFlagName() {
            this.flagName_ = SupportedDatabaseFlag.getDefaultInstance().getFlagName();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setFlagNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SupportedDatabaseFlag.checkByteStringIsUtf8((ByteString)value);
            this.flagName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public int getValueTypeValue() {
            return this.valueType_;
        }

        public Builder setValueTypeValue(int value) {
            this.valueType_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public ValueType getValueType() {
            ValueType result = ValueType.forNumber(this.valueType_);
            return result == null ? ValueType.UNRECOGNIZED : result;
        }

        public Builder setValueType(ValueType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.valueType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearValueType() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.valueType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getAcceptsMultipleValues() {
            return this.acceptsMultipleValues_;
        }

        public Builder setAcceptsMultipleValues(boolean value) {
            this.acceptsMultipleValues_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearAcceptsMultipleValues() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.acceptsMultipleValues_ = false;
            this.onChanged();
            return this;
        }

        private void ensureSupportedDbVersionsIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.supportedDbVersions_ = new ArrayList<Integer>(this.supportedDbVersions_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<DatabaseVersion> getSupportedDbVersionsList() {
            return new Internal.ListAdapter(this.supportedDbVersions_, supportedDbVersions_converter_);
        }

        @Override
        public int getSupportedDbVersionsCount() {
            return this.supportedDbVersions_.size();
        }

        @Override
        public DatabaseVersion getSupportedDbVersions(int index) {
            return (DatabaseVersion)((Object)supportedDbVersions_converter_.convert((Object)this.supportedDbVersions_.get(index)));
        }

        public Builder setSupportedDbVersions(int index, DatabaseVersion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSupportedDbVersionsIsMutable();
            this.supportedDbVersions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addSupportedDbVersions(DatabaseVersion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSupportedDbVersionsIsMutable();
            this.supportedDbVersions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllSupportedDbVersions(Iterable<? extends DatabaseVersion> values) {
            this.ensureSupportedDbVersionsIsMutable();
            for (DatabaseVersion databaseVersion : values) {
                this.supportedDbVersions_.add(databaseVersion.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearSupportedDbVersions() {
            this.supportedDbVersions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getSupportedDbVersionsValueList() {
            return Collections.unmodifiableList(this.supportedDbVersions_);
        }

        @Override
        public int getSupportedDbVersionsValue(int index) {
            return this.supportedDbVersions_.get(index);
        }

        public Builder setSupportedDbVersionsValue(int index, int value) {
            this.ensureSupportedDbVersionsIsMutable();
            this.supportedDbVersions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addSupportedDbVersionsValue(int value) {
            this.ensureSupportedDbVersionsIsMutable();
            this.supportedDbVersions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllSupportedDbVersionsValue(Iterable<Integer> values) {
            this.ensureSupportedDbVersionsIsMutable();
            for (int value : values) {
                this.supportedDbVersions_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean getRequiresDbRestart() {
            return this.requiresDbRestart_;
        }

        public Builder setRequiresDbRestart(boolean value) {
            this.requiresDbRestart_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearRequiresDbRestart() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.requiresDbRestart_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum RestrictionsCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        STRING_RESTRICTIONS(7),
        INTEGER_RESTRICTIONS(8),
        RESTRICTIONS_NOT_SET(0);

        private final int value;

        private RestrictionsCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static RestrictionsCase valueOf(int value) {
            return RestrictionsCase.forNumber(value);
        }

        public static RestrictionsCase forNumber(int value) {
            switch (value) {
                case 7: {
                    return STRING_RESTRICTIONS;
                }
                case 8: {
                    return INTEGER_RESTRICTIONS;
                }
                case 0: {
                    return RESTRICTIONS_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static final class IntegerRestrictions
    extends GeneratedMessageV3
    implements IntegerRestrictionsOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int MIN_VALUE_FIELD_NUMBER = 1;
        private Int64Value minValue_;
        public static final int MAX_VALUE_FIELD_NUMBER = 2;
        private Int64Value maxValue_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final IntegerRestrictions DEFAULT_INSTANCE = new IntegerRestrictions();
        private static final Parser<IntegerRestrictions> PARSER = new AbstractParser<IntegerRestrictions>(){

            public IntegerRestrictions parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = IntegerRestrictions.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private IntegerRestrictions(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private IntegerRestrictions() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new IntegerRestrictions();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_IntegerRestrictions_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_IntegerRestrictions_fieldAccessorTable.ensureFieldAccessorsInitialized(IntegerRestrictions.class, Builder.class);
        }

        @Override
        public boolean hasMinValue() {
            return this.minValue_ != null;
        }

        @Override
        public Int64Value getMinValue() {
            return this.minValue_ == null ? Int64Value.getDefaultInstance() : this.minValue_;
        }

        @Override
        public Int64ValueOrBuilder getMinValueOrBuilder() {
            return this.minValue_ == null ? Int64Value.getDefaultInstance() : this.minValue_;
        }

        @Override
        public boolean hasMaxValue() {
            return this.maxValue_ != null;
        }

        @Override
        public Int64Value getMaxValue() {
            return this.maxValue_ == null ? Int64Value.getDefaultInstance() : this.maxValue_;
        }

        @Override
        public Int64ValueOrBuilder getMaxValueOrBuilder() {
            return this.maxValue_ == null ? Int64Value.getDefaultInstance() : this.maxValue_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.minValue_ != null) {
                output.writeMessage(1, (MessageLite)this.getMinValue());
            }
            if (this.maxValue_ != null) {
                output.writeMessage(2, (MessageLite)this.getMaxValue());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.minValue_ != null) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getMinValue());
            }
            if (this.maxValue_ != null) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getMaxValue());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IntegerRestrictions)) {
                return super.equals(obj);
            }
            IntegerRestrictions other = (IntegerRestrictions)obj;
            if (this.hasMinValue() != other.hasMinValue()) {
                return false;
            }
            if (this.hasMinValue() && !this.getMinValue().equals((Object)other.getMinValue())) {
                return false;
            }
            if (this.hasMaxValue() != other.hasMaxValue()) {
                return false;
            }
            if (this.hasMaxValue() && !this.getMaxValue().equals((Object)other.getMaxValue())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + IntegerRestrictions.getDescriptor().hashCode();
            if (this.hasMinValue()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getMinValue().hashCode();
            }
            if (this.hasMaxValue()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getMaxValue().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static IntegerRestrictions parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (IntegerRestrictions)PARSER.parseFrom(data);
        }

        public static IntegerRestrictions parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (IntegerRestrictions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static IntegerRestrictions parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (IntegerRestrictions)PARSER.parseFrom(data);
        }

        public static IntegerRestrictions parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (IntegerRestrictions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static IntegerRestrictions parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (IntegerRestrictions)PARSER.parseFrom(data);
        }

        public static IntegerRestrictions parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (IntegerRestrictions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static IntegerRestrictions parseFrom(InputStream input) throws IOException {
            return (IntegerRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static IntegerRestrictions parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (IntegerRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static IntegerRestrictions parseDelimitedFrom(InputStream input) throws IOException {
            return (IntegerRestrictions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static IntegerRestrictions parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (IntegerRestrictions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static IntegerRestrictions parseFrom(CodedInputStream input) throws IOException {
            return (IntegerRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static IntegerRestrictions parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (IntegerRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return IntegerRestrictions.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(IntegerRestrictions prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static IntegerRestrictions getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<IntegerRestrictions> parser() {
            return PARSER;
        }

        public Parser<IntegerRestrictions> getParserForType() {
            return PARSER;
        }

        public IntegerRestrictions getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements IntegerRestrictionsOrBuilder {
            private int bitField0_;
            private Int64Value minValue_;
            private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> minValueBuilder_;
            private Int64Value maxValue_;
            private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> maxValueBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_IntegerRestrictions_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_IntegerRestrictions_fieldAccessorTable.ensureFieldAccessorsInitialized(IntegerRestrictions.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.minValue_ = null;
                if (this.minValueBuilder_ != null) {
                    this.minValueBuilder_.dispose();
                    this.minValueBuilder_ = null;
                }
                this.maxValue_ = null;
                if (this.maxValueBuilder_ != null) {
                    this.maxValueBuilder_.dispose();
                    this.maxValueBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_IntegerRestrictions_descriptor;
            }

            public IntegerRestrictions getDefaultInstanceForType() {
                return IntegerRestrictions.getDefaultInstance();
            }

            public IntegerRestrictions build() {
                IntegerRestrictions result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public IntegerRestrictions buildPartial() {
                IntegerRestrictions result = new IntegerRestrictions(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(IntegerRestrictions result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.minValue_ = this.minValueBuilder_ == null ? this.minValue_ : (Int64Value)this.minValueBuilder_.build();
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.maxValue_ = this.maxValueBuilder_ == null ? this.maxValue_ : (Int64Value)this.maxValueBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof IntegerRestrictions) {
                    return this.mergeFrom((IntegerRestrictions)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(IntegerRestrictions other) {
                if (other == IntegerRestrictions.getDefaultInstance()) {
                    return this;
                }
                if (other.hasMinValue()) {
                    this.mergeMinValue(other.getMinValue());
                }
                if (other.hasMaxValue()) {
                    this.mergeMaxValue(other.getMaxValue());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getMinValueFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getMaxValueFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasMinValue() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public Int64Value getMinValue() {
                if (this.minValueBuilder_ == null) {
                    return this.minValue_ == null ? Int64Value.getDefaultInstance() : this.minValue_;
                }
                return (Int64Value)this.minValueBuilder_.getMessage();
            }

            public Builder setMinValue(Int64Value value) {
                if (this.minValueBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.minValue_ = value;
                } else {
                    this.minValueBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder setMinValue(Int64Value.Builder builderForValue) {
                if (this.minValueBuilder_ == null) {
                    this.minValue_ = builderForValue.build();
                } else {
                    this.minValueBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder mergeMinValue(Int64Value value) {
                if (this.minValueBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0 && this.minValue_ != null && this.minValue_ != Int64Value.getDefaultInstance()) {
                        this.getMinValueBuilder().mergeFrom(value);
                    } else {
                        this.minValue_ = value;
                    }
                } else {
                    this.minValueBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearMinValue() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.minValue_ = null;
                if (this.minValueBuilder_ != null) {
                    this.minValueBuilder_.dispose();
                    this.minValueBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Int64Value.Builder getMinValueBuilder() {
                this.bitField0_ |= 1;
                this.onChanged();
                return (Int64Value.Builder)this.getMinValueFieldBuilder().getBuilder();
            }

            @Override
            public Int64ValueOrBuilder getMinValueOrBuilder() {
                if (this.minValueBuilder_ != null) {
                    return (Int64ValueOrBuilder)this.minValueBuilder_.getMessageOrBuilder();
                }
                return this.minValue_ == null ? Int64Value.getDefaultInstance() : this.minValue_;
            }

            private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> getMinValueFieldBuilder() {
                if (this.minValueBuilder_ == null) {
                    this.minValueBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMinValue(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.minValue_ = null;
                }
                return this.minValueBuilder_;
            }

            @Override
            public boolean hasMaxValue() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public Int64Value getMaxValue() {
                if (this.maxValueBuilder_ == null) {
                    return this.maxValue_ == null ? Int64Value.getDefaultInstance() : this.maxValue_;
                }
                return (Int64Value)this.maxValueBuilder_.getMessage();
            }

            public Builder setMaxValue(Int64Value value) {
                if (this.maxValueBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.maxValue_ = value;
                } else {
                    this.maxValueBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setMaxValue(Int64Value.Builder builderForValue) {
                if (this.maxValueBuilder_ == null) {
                    this.maxValue_ = builderForValue.build();
                } else {
                    this.maxValueBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergeMaxValue(Int64Value value) {
                if (this.maxValueBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.maxValue_ != null && this.maxValue_ != Int64Value.getDefaultInstance()) {
                        this.getMaxValueBuilder().mergeFrom(value);
                    } else {
                        this.maxValue_ = value;
                    }
                } else {
                    this.maxValueBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearMaxValue() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.maxValue_ = null;
                if (this.maxValueBuilder_ != null) {
                    this.maxValueBuilder_.dispose();
                    this.maxValueBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Int64Value.Builder getMaxValueBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return (Int64Value.Builder)this.getMaxValueFieldBuilder().getBuilder();
            }

            @Override
            public Int64ValueOrBuilder getMaxValueOrBuilder() {
                if (this.maxValueBuilder_ != null) {
                    return (Int64ValueOrBuilder)this.maxValueBuilder_.getMessageOrBuilder();
                }
                return this.maxValue_ == null ? Int64Value.getDefaultInstance() : this.maxValue_;
            }

            private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> getMaxValueFieldBuilder() {
                if (this.maxValueBuilder_ == null) {
                    this.maxValueBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMaxValue(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.maxValue_ = null;
                }
                return this.maxValueBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface IntegerRestrictionsOrBuilder
    extends MessageOrBuilder {
        public boolean hasMinValue();

        public Int64Value getMinValue();

        public Int64ValueOrBuilder getMinValueOrBuilder();

        public boolean hasMaxValue();

        public Int64Value getMaxValue();

        public Int64ValueOrBuilder getMaxValueOrBuilder();
    }

    public static final class StringRestrictions
    extends GeneratedMessageV3
    implements StringRestrictionsOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int ALLOWED_VALUES_FIELD_NUMBER = 1;
        private LazyStringList allowedValues_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final StringRestrictions DEFAULT_INSTANCE = new StringRestrictions();
        private static final Parser<StringRestrictions> PARSER = new AbstractParser<StringRestrictions>(){

            public StringRestrictions parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = StringRestrictions.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private StringRestrictions(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private StringRestrictions() {
            this.allowedValues_ = LazyStringArrayList.EMPTY;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new StringRestrictions();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_StringRestrictions_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_StringRestrictions_fieldAccessorTable.ensureFieldAccessorsInitialized(StringRestrictions.class, Builder.class);
        }

        public ProtocolStringList getAllowedValuesList() {
            return this.allowedValues_;
        }

        @Override
        public int getAllowedValuesCount() {
            return this.allowedValues_.size();
        }

        @Override
        public String getAllowedValues(int index) {
            return (String)this.allowedValues_.get(index);
        }

        @Override
        public ByteString getAllowedValuesBytes(int index) {
            return this.allowedValues_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            for (int i = 0; i < this.allowedValues_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.allowedValues_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            int dataSize = 0;
            for (int i = 0; i < this.allowedValues_.size(); ++i) {
                dataSize += StringRestrictions.computeStringSizeNoTag((Object)this.allowedValues_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getAllowedValuesList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StringRestrictions)) {
                return super.equals(obj);
            }
            StringRestrictions other = (StringRestrictions)obj;
            if (!this.getAllowedValuesList().equals(other.getAllowedValuesList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + StringRestrictions.getDescriptor().hashCode();
            if (this.getAllowedValuesCount() > 0) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getAllowedValuesList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static StringRestrictions parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (StringRestrictions)PARSER.parseFrom(data);
        }

        public static StringRestrictions parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (StringRestrictions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static StringRestrictions parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (StringRestrictions)PARSER.parseFrom(data);
        }

        public static StringRestrictions parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (StringRestrictions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static StringRestrictions parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (StringRestrictions)PARSER.parseFrom(data);
        }

        public static StringRestrictions parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (StringRestrictions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static StringRestrictions parseFrom(InputStream input) throws IOException {
            return (StringRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static StringRestrictions parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (StringRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static StringRestrictions parseDelimitedFrom(InputStream input) throws IOException {
            return (StringRestrictions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static StringRestrictions parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (StringRestrictions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static StringRestrictions parseFrom(CodedInputStream input) throws IOException {
            return (StringRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static StringRestrictions parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (StringRestrictions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return StringRestrictions.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(StringRestrictions prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static StringRestrictions getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<StringRestrictions> parser() {
            return PARSER;
        }

        public Parser<StringRestrictions> getParserForType() {
            return PARSER;
        }

        public StringRestrictions getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements StringRestrictionsOrBuilder {
            private int bitField0_;
            private LazyStringList allowedValues_ = LazyStringArrayList.EMPTY;

            public static final Descriptors.Descriptor getDescriptor() {
                return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_StringRestrictions_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_StringRestrictions_fieldAccessorTable.ensureFieldAccessorsInitialized(StringRestrictions.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.allowedValues_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFFE;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ResourcesProto.internal_static_google_cloud_alloydb_v1beta_SupportedDatabaseFlag_StringRestrictions_descriptor;
            }

            public StringRestrictions getDefaultInstanceForType() {
                return StringRestrictions.getDefaultInstance();
            }

            public StringRestrictions build() {
                StringRestrictions result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public StringRestrictions buildPartial() {
                StringRestrictions result = new StringRestrictions(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(StringRestrictions result) {
                if ((this.bitField0_ & 1) != 0) {
                    this.allowedValues_ = this.allowedValues_.getUnmodifiableView();
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.allowedValues_ = this.allowedValues_;
            }

            private void buildPartial0(StringRestrictions result) {
                int from_bitField0_ = this.bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof StringRestrictions) {
                    return this.mergeFrom((StringRestrictions)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(StringRestrictions other) {
                if (other == StringRestrictions.getDefaultInstance()) {
                    return this;
                }
                if (!other.allowedValues_.isEmpty()) {
                    if (this.allowedValues_.isEmpty()) {
                        this.allowedValues_ = other.allowedValues_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureAllowedValuesIsMutable();
                        this.allowedValues_.addAll((Collection)other.allowedValues_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                String s = input.readStringRequireUtf8();
                                this.ensureAllowedValuesIsMutable();
                                this.allowedValues_.add((Object)s);
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            private void ensureAllowedValuesIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.allowedValues_ = new LazyStringArrayList(this.allowedValues_);
                    this.bitField0_ |= 1;
                }
            }

            public ProtocolStringList getAllowedValuesList() {
                return this.allowedValues_.getUnmodifiableView();
            }

            @Override
            public int getAllowedValuesCount() {
                return this.allowedValues_.size();
            }

            @Override
            public String getAllowedValues(int index) {
                return (String)this.allowedValues_.get(index);
            }

            @Override
            public ByteString getAllowedValuesBytes(int index) {
                return this.allowedValues_.getByteString(index);
            }

            public Builder setAllowedValues(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAllowedValuesIsMutable();
                this.allowedValues_.set(index, (Object)value);
                this.onChanged();
                return this;
            }

            public Builder addAllowedValues(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAllowedValuesIsMutable();
                this.allowedValues_.add((Object)value);
                this.onChanged();
                return this;
            }

            public Builder addAllAllowedValues(Iterable<String> values) {
                this.ensureAllowedValuesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.allowedValues_);
                this.onChanged();
                return this;
            }

            public Builder clearAllowedValues() {
                this.allowedValues_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder addAllowedValuesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                StringRestrictions.checkByteStringIsUtf8((ByteString)value);
                this.ensureAllowedValuesIsMutable();
                this.allowedValues_.add(value);
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface StringRestrictionsOrBuilder
    extends MessageOrBuilder {
        public List<String> getAllowedValuesList();

        public int getAllowedValuesCount();

        public String getAllowedValues(int var1);

        public ByteString getAllowedValuesBytes(int var1);
    }

    public static enum ValueType implements ProtocolMessageEnum
    {
        VALUE_TYPE_UNSPECIFIED(0),
        STRING(1),
        INTEGER(2),
        FLOAT(3),
        NONE(4),
        UNRECOGNIZED(-1);

        public static final int VALUE_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int STRING_VALUE = 1;
        public static final int INTEGER_VALUE = 2;
        public static final int FLOAT_VALUE = 3;
        public static final int NONE_VALUE = 4;
        private static final Internal.EnumLiteMap<ValueType> internalValueMap;
        private static final ValueType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ValueType valueOf(int value) {
            return ValueType.forNumber(value);
        }

        public static ValueType forNumber(int value) {
            switch (value) {
                case 0: {
                    return VALUE_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return STRING;
                }
                case 2: {
                    return INTEGER;
                }
                case 3: {
                    return FLOAT;
                }
                case 4: {
                    return NONE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ValueType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ValueType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ValueType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)SupportedDatabaseFlag.getDescriptor().getEnumTypes().get(0);
        }

        public static ValueType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ValueType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ValueType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ValueType>(){

                public ValueType findValueByNumber(int number) {
                    return ValueType.forNumber(number);
                }
            };
            VALUES = ValueType.values();
        }
    }
}

