/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SupportedDatabaseFlagName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FLAG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/flags/{flag}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String flag;

    @Deprecated
    protected SupportedDatabaseFlagName() {
        this.project = null;
        this.location = null;
        this.flag = null;
    }

    private SupportedDatabaseFlagName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.flag = (String)Preconditions.checkNotNull((Object)builder.getFlag());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFlag() {
        return this.flag;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SupportedDatabaseFlagName of(String project, String location, String flag) {
        return SupportedDatabaseFlagName.newBuilder().setProject(project).setLocation(location).setFlag(flag).build();
    }

    public static String format(String project, String location, String flag) {
        return SupportedDatabaseFlagName.newBuilder().setProject(project).setLocation(location).setFlag(flag).build().toString();
    }

    public static SupportedDatabaseFlagName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FLAG.validatedMatch(formattedString, "SupportedDatabaseFlagName.parse: formattedString not in valid format");
        return SupportedDatabaseFlagName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("flag"));
    }

    public static List<SupportedDatabaseFlagName> parseList(List<String> formattedStrings) {
        ArrayList<SupportedDatabaseFlagName> list = new ArrayList<SupportedDatabaseFlagName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SupportedDatabaseFlagName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SupportedDatabaseFlagName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SupportedDatabaseFlagName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FLAG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SupportedDatabaseFlagName supportedDatabaseFlagName = this;
            synchronized (supportedDatabaseFlagName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.flag != null) {
                        fieldMapBuilder.put((Object)"flag", (Object)this.flag);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FLAG.instantiate(new String[]{"project", this.project, "location", this.location, "flag", this.flag});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SupportedDatabaseFlagName that = (SupportedDatabaseFlagName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.flag, that.flag);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.flag);
    }

    public static class Builder {
        private String project;
        private String location;
        private String flag;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFlag() {
            return this.flag;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFlag(String flag) {
            this.flag = flag;
            return this;
        }

        private Builder(SupportedDatabaseFlagName supportedDatabaseFlagName) {
            this.project = supportedDatabaseFlagName.project;
            this.location = supportedDatabaseFlagName.location;
            this.flag = supportedDatabaseFlagName.flag;
        }

        public SupportedDatabaseFlagName build() {
            return new SupportedDatabaseFlagName(this);
        }
    }
}

