/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotebookRuntimeTemplateName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NOTEBOOK_RUNTIME_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String notebookRuntimeTemplate;

    @Deprecated
    protected NotebookRuntimeTemplateName() {
        this.project = null;
        this.location = null;
        this.notebookRuntimeTemplate = null;
    }

    private NotebookRuntimeTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notebookRuntimeTemplate = (String)Preconditions.checkNotNull((Object)builder.getNotebookRuntimeTemplate());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNotebookRuntimeTemplate() {
        return this.notebookRuntimeTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotebookRuntimeTemplateName of(String project, String location, String notebookRuntimeTemplate) {
        return NotebookRuntimeTemplateName.newBuilder().setProject(project).setLocation(location).setNotebookRuntimeTemplate(notebookRuntimeTemplate).build();
    }

    public static String format(String project, String location, String notebookRuntimeTemplate) {
        return NotebookRuntimeTemplateName.newBuilder().setProject(project).setLocation(location).setNotebookRuntimeTemplate(notebookRuntimeTemplate).build().toString();
    }

    public static NotebookRuntimeTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NOTEBOOK_RUNTIME_TEMPLATE.validatedMatch(formattedString, "NotebookRuntimeTemplateName.parse: formattedString not in valid format");
        return NotebookRuntimeTemplateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("notebook_runtime_template"));
    }

    public static List<NotebookRuntimeTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<NotebookRuntimeTemplateName> list = new ArrayList<NotebookRuntimeTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotebookRuntimeTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotebookRuntimeTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotebookRuntimeTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NOTEBOOK_RUNTIME_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotebookRuntimeTemplateName notebookRuntimeTemplateName = this;
            synchronized (notebookRuntimeTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.notebookRuntimeTemplate != null) {
                        fieldMapBuilder.put((Object)"notebook_runtime_template", (Object)this.notebookRuntimeTemplate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NOTEBOOK_RUNTIME_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "notebook_runtime_template", this.notebookRuntimeTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotebookRuntimeTemplateName that = (NotebookRuntimeTemplateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.notebookRuntimeTemplate, that.notebookRuntimeTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.notebookRuntimeTemplate);
    }

    public static class Builder {
        private String project;
        private String location;
        private String notebookRuntimeTemplate;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotebookRuntimeTemplate() {
            return this.notebookRuntimeTemplate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNotebookRuntimeTemplate(String notebookRuntimeTemplate) {
            this.notebookRuntimeTemplate = notebookRuntimeTemplate;
            return this;
        }

        private Builder(NotebookRuntimeTemplateName notebookRuntimeTemplateName) {
            this.project = notebookRuntimeTemplateName.project;
            this.location = notebookRuntimeTemplateName.location;
            this.notebookRuntimeTemplate = notebookRuntimeTemplateName.notebookRuntimeTemplate;
        }

        public NotebookRuntimeTemplateName build() {
            return new NotebookRuntimeTemplateName(this);
        }
    }
}

