/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/reasoning_engine.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * ReasoningEngine configurations
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineSpec}
 */
public final class ReasoningEngineSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec)
    ReasoningEngineSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ReasoningEngineSpec.newBuilder() to construct.
  private ReasoningEngineSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReasoningEngineSpec() {
    classMethods_ = java.util.Collections.emptyList();
    agentFramework_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReasoningEngineSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
        .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
        .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.class,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.Builder.class);
  }

  public interface PackageSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pickleObjectGcsUri.
     */
    java.lang.String getPickleObjectGcsUri();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pickleObjectGcsUri.
     */
    com.google.protobuf.ByteString getPickleObjectGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dependencyFilesGcsUri.
     */
    java.lang.String getDependencyFilesGcsUri();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for dependencyFilesGcsUri.
     */
    com.google.protobuf.ByteString getDependencyFilesGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requirementsGcsUri.
     */
    java.lang.String getRequirementsGcsUri();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requirementsGcsUri.
     */
    com.google.protobuf.ByteString getRequirementsGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pythonVersion.
     */
    java.lang.String getPythonVersion();

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pythonVersion.
     */
    com.google.protobuf.ByteString getPythonVersionBytes();
  }

  /**
   *
   *
   * <pre>
   * User provided package spec like pickled object and package requirements.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec}
   */
  public static final class PackageSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec)
      PackageSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PackageSpec.newBuilder() to construct.
    private PackageSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PackageSpec() {
      pickleObjectGcsUri_ = "";
      dependencyFilesGcsUri_ = "";
      requirementsGcsUri_ = "";
      pythonVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PackageSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_PackageSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_PackageSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.class,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.Builder.class);
    }

    public static final int PICKLE_OBJECT_GCS_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pickleObjectGcsUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pickleObjectGcsUri.
     */
    @java.lang.Override
    public java.lang.String getPickleObjectGcsUri() {
      java.lang.Object ref = pickleObjectGcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pickleObjectGcsUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pickleObjectGcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPickleObjectGcsUriBytes() {
      java.lang.Object ref = pickleObjectGcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pickleObjectGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEPENDENCY_FILES_GCS_URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dependencyFilesGcsUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dependencyFilesGcsUri.
     */
    @java.lang.Override
    public java.lang.String getDependencyFilesGcsUri() {
      java.lang.Object ref = dependencyFilesGcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dependencyFilesGcsUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for dependencyFilesGcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDependencyFilesGcsUriBytes() {
      java.lang.Object ref = dependencyFilesGcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dependencyFilesGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REQUIREMENTS_GCS_URI_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object requirementsGcsUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requirementsGcsUri.
     */
    @java.lang.Override
    public java.lang.String getRequirementsGcsUri() {
      java.lang.Object ref = requirementsGcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requirementsGcsUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requirementsGcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRequirementsGcsUriBytes() {
      java.lang.Object ref = requirementsGcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requirementsGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PYTHON_VERSION_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pythonVersion_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pythonVersion.
     */
    @java.lang.Override
    public java.lang.String getPythonVersion() {
      java.lang.Object ref = pythonVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pythonVersion_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pythonVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPythonVersionBytes() {
      java.lang.Object ref = pythonVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pythonVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pickleObjectGcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pickleObjectGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dependencyFilesGcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dependencyFilesGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementsGcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requirementsGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pythonVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pythonVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pickleObjectGcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pickleObjectGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dependencyFilesGcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dependencyFilesGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementsGcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requirementsGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pythonVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pythonVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec other =
          (com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec) obj;

      if (!getPickleObjectGcsUri().equals(other.getPickleObjectGcsUri())) return false;
      if (!getDependencyFilesGcsUri().equals(other.getDependencyFilesGcsUri())) return false;
      if (!getRequirementsGcsUri().equals(other.getRequirementsGcsUri())) return false;
      if (!getPythonVersion().equals(other.getPythonVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PICKLE_OBJECT_GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getPickleObjectGcsUri().hashCode();
      hash = (37 * hash) + DEPENDENCY_FILES_GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getDependencyFilesGcsUri().hashCode();
      hash = (37 * hash) + REQUIREMENTS_GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getRequirementsGcsUri().hashCode();
      hash = (37 * hash) + PYTHON_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getPythonVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * User provided package spec like pickled object and package requirements.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec)
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_PackageSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_PackageSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.class,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pickleObjectGcsUri_ = "";
        dependencyFilesGcsUri_ = "";
        requirementsGcsUri_ = "";
        pythonVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_PackageSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec build() {
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec result =
            new com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pickleObjectGcsUri_ = pickleObjectGcsUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dependencyFilesGcsUri_ = dependencyFilesGcsUri_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.requirementsGcsUri_ = requirementsGcsUri_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.pythonVersion_ = pythonVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
                .getDefaultInstance()) return this;
        if (!other.getPickleObjectGcsUri().isEmpty()) {
          pickleObjectGcsUri_ = other.pickleObjectGcsUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDependencyFilesGcsUri().isEmpty()) {
          dependencyFilesGcsUri_ = other.dependencyFilesGcsUri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getRequirementsGcsUri().isEmpty()) {
          requirementsGcsUri_ = other.requirementsGcsUri_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getPythonVersion().isEmpty()) {
          pythonVersion_ = other.pythonVersion_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  pickleObjectGcsUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  dependencyFilesGcsUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  requirementsGcsUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  pythonVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object pickleObjectGcsUri_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pickleObjectGcsUri.
       */
      public java.lang.String getPickleObjectGcsUri() {
        java.lang.Object ref = pickleObjectGcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pickleObjectGcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for pickleObjectGcsUri.
       */
      public com.google.protobuf.ByteString getPickleObjectGcsUriBytes() {
        java.lang.Object ref = pickleObjectGcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pickleObjectGcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pickleObjectGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setPickleObjectGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pickleObjectGcsUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPickleObjectGcsUri() {
        pickleObjectGcsUri_ = getDefaultInstance().getPickleObjectGcsUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for pickleObjectGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setPickleObjectGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pickleObjectGcsUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object dependencyFilesGcsUri_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The dependencyFilesGcsUri.
       */
      public java.lang.String getDependencyFilesGcsUri() {
        java.lang.Object ref = dependencyFilesGcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dependencyFilesGcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for dependencyFilesGcsUri.
       */
      public com.google.protobuf.ByteString getDependencyFilesGcsUriBytes() {
        java.lang.Object ref = dependencyFilesGcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dependencyFilesGcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The dependencyFilesGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setDependencyFilesGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dependencyFilesGcsUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDependencyFilesGcsUri() {
        dependencyFilesGcsUri_ = getDefaultInstance().getDependencyFilesGcsUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for dependencyFilesGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setDependencyFilesGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dependencyFilesGcsUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object requirementsGcsUri_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The requirementsGcsUri.
       */
      public java.lang.String getRequirementsGcsUri() {
        java.lang.Object ref = requirementsGcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          requirementsGcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for requirementsGcsUri.
       */
      public com.google.protobuf.ByteString getRequirementsGcsUriBytes() {
        java.lang.Object ref = requirementsGcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          requirementsGcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The requirementsGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setRequirementsGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        requirementsGcsUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequirementsGcsUri() {
        requirementsGcsUri_ = getDefaultInstance().getRequirementsGcsUri();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for requirementsGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setRequirementsGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        requirementsGcsUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object pythonVersion_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pythonVersion.
       */
      public java.lang.String getPythonVersion() {
        java.lang.Object ref = pythonVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pythonVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for pythonVersion.
       */
      public com.google.protobuf.ByteString getPythonVersionBytes() {
        java.lang.Object ref = pythonVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pythonVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pythonVersion to set.
       * @return This builder for chaining.
       */
      public Builder setPythonVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pythonVersion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPythonVersion() {
        pythonVersion_ = getDefaultInstance().getPythonVersion();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for pythonVersion to set.
       * @return This builder for chaining.
       */
      public Builder setPythonVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pythonVersion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec)
    private static final com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PackageSpec> PARSER =
        new com.google.protobuf.AbstractParser<PackageSpec>() {
          @java.lang.Override
          public PackageSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PackageSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PackageSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> getEnvList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.EnvVar getEnv(int index);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getEnvCount();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        getEnvOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder getEnvOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.SecretEnvVar> getSecretEnvList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.SecretEnvVar getSecretEnv(int index);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getSecretEnvCount();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder>
        getSecretEnvOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder getSecretEnvOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec}
   */
  public static final class DeploymentSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec)
      DeploymentSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DeploymentSpec.newBuilder() to construct.
    private DeploymentSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentSpec() {
      env_ = java.util.Collections.emptyList();
      secretEnv_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeploymentSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_DeploymentSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_DeploymentSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.class,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.Builder.class);
    }

    public static final int ENV_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> env_;

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> getEnvList() {
      return env_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        getEnvOrBuilderList() {
      return env_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getEnvCount() {
      return env_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EnvVar getEnv(int index) {
      return env_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder getEnvOrBuilder(int index) {
      return env_.get(index);
    }

    public static final int SECRET_ENV_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.SecretEnvVar> secretEnv_;

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.SecretEnvVar> getSecretEnvList() {
      return secretEnv_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder>
        getSecretEnvOrBuilderList() {
      return secretEnv_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getSecretEnvCount() {
      return secretEnv_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SecretEnvVar getSecretEnv(int index) {
      return secretEnv_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder getSecretEnvOrBuilder(
        int index) {
      return secretEnv_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < env_.size(); i++) {
        output.writeMessage(1, env_.get(i));
      }
      for (int i = 0; i < secretEnv_.size(); i++) {
        output.writeMessage(2, secretEnv_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < env_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, env_.get(i));
      }
      for (int i = 0; i < secretEnv_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, secretEnv_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec other =
          (com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec) obj;

      if (!getEnvList().equals(other.getEnvList())) return false;
      if (!getSecretEnvList().equals(other.getSecretEnvList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEnvCount() > 0) {
        hash = (37 * hash) + ENV_FIELD_NUMBER;
        hash = (53 * hash) + getEnvList().hashCode();
      }
      if (getSecretEnvCount() > 0) {
        hash = (37 * hash) + SECRET_ENV_FIELD_NUMBER;
        hash = (53 * hash) + getSecretEnvList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec)
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_DeploymentSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_DeploymentSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.class,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (envBuilder_ == null) {
          env_ = java.util.Collections.emptyList();
        } else {
          env_ = null;
          envBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (secretEnvBuilder_ == null) {
          secretEnv_ = java.util.Collections.emptyList();
        } else {
          secretEnv_ = null;
          secretEnvBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_DeploymentSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec build() {
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec result =
            new com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec result) {
        if (envBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            env_ = java.util.Collections.unmodifiableList(env_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.env_ = env_;
        } else {
          result.env_ = envBuilder_.build();
        }
        if (secretEnvBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            secretEnv_ = java.util.Collections.unmodifiableList(secretEnv_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.secretEnv_ = secretEnv_;
        } else {
          result.secretEnv_ = secretEnvBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
                .getDefaultInstance()) return this;
        if (envBuilder_ == null) {
          if (!other.env_.isEmpty()) {
            if (env_.isEmpty()) {
              env_ = other.env_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEnvIsMutable();
              env_.addAll(other.env_);
            }
            onChanged();
          }
        } else {
          if (!other.env_.isEmpty()) {
            if (envBuilder_.isEmpty()) {
              envBuilder_.dispose();
              envBuilder_ = null;
              env_ = other.env_;
              bitField0_ = (bitField0_ & ~0x00000001);
              envBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEnvFieldBuilder()
                      : null;
            } else {
              envBuilder_.addAllMessages(other.env_);
            }
          }
        }
        if (secretEnvBuilder_ == null) {
          if (!other.secretEnv_.isEmpty()) {
            if (secretEnv_.isEmpty()) {
              secretEnv_ = other.secretEnv_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSecretEnvIsMutable();
              secretEnv_.addAll(other.secretEnv_);
            }
            onChanged();
          }
        } else {
          if (!other.secretEnv_.isEmpty()) {
            if (secretEnvBuilder_.isEmpty()) {
              secretEnvBuilder_.dispose();
              secretEnvBuilder_ = null;
              secretEnv_ = other.secretEnv_;
              bitField0_ = (bitField0_ & ~0x00000002);
              secretEnvBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSecretEnvFieldBuilder()
                      : null;
            } else {
              secretEnvBuilder_.addAllMessages(other.secretEnv_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1beta1.EnvVar m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.EnvVar.parser(), extensionRegistry);
                  if (envBuilder_ == null) {
                    ensureEnvIsMutable();
                    env_.add(m);
                  } else {
                    envBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.aiplatform.v1beta1.SecretEnvVar m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.SecretEnvVar.parser(),
                          extensionRegistry);
                  if (secretEnvBuilder_ == null) {
                    ensureSecretEnvIsMutable();
                    secretEnv_.add(m);
                  } else {
                    secretEnvBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> env_ =
          java.util.Collections.emptyList();

      private void ensureEnvIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          env_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.EnvVar>(env_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.EnvVar,
              com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
              com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
          envBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> getEnvList() {
        if (envBuilder_ == null) {
          return java.util.Collections.unmodifiableList(env_);
        } else {
          return envBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getEnvCount() {
        if (envBuilder_ == null) {
          return env_.size();
        } else {
          return envBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.EnvVar getEnv(int index) {
        if (envBuilder_ == null) {
          return env_.get(index);
        } else {
          return envBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEnv(int index, com.google.cloud.aiplatform.v1beta1.EnvVar value) {
        if (envBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnvIsMutable();
          env_.set(index, value);
          onChanged();
        } else {
          envBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEnv(
          int index, com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.set(index, builderForValue.build());
          onChanged();
        } else {
          envBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(com.google.cloud.aiplatform.v1beta1.EnvVar value) {
        if (envBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnvIsMutable();
          env_.add(value);
          onChanged();
        } else {
          envBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(int index, com.google.cloud.aiplatform.v1beta1.EnvVar value) {
        if (envBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnvIsMutable();
          env_.add(index, value);
          onChanged();
        } else {
          envBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.add(builderForValue.build());
          onChanged();
        } else {
          envBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(
          int index, com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.add(index, builderForValue.build());
          onChanged();
        } else {
          envBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllEnv(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.EnvVar> values) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
          onChanged();
        } else {
          envBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearEnv() {
        if (envBuilder_ == null) {
          env_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          envBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeEnv(int index) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.remove(index);
          onChanged();
        } else {
          envBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder getEnvBuilder(int index) {
        return getEnvFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder getEnvOrBuilder(int index) {
        if (envBuilder_ == null) {
          return env_.get(index);
        } else {
          return envBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
          getEnvOrBuilderList() {
        if (envBuilder_ != null) {
          return envBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(env_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder addEnvBuilder() {
        return getEnvFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1beta1.EnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder addEnvBuilder(int index) {
        return getEnvFieldBuilder()
            .addBuilder(index, com.google.cloud.aiplatform.v1beta1.EnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar.Builder>
          getEnvBuilderList() {
        return getEnvFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.EnvVar,
              com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
              com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
          getEnvFieldBuilder() {
        if (envBuilder_ == null) {
          envBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.EnvVar,
                  com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
                  com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>(
                  env_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          env_ = null;
        }
        return envBuilder_;
      }

      private java.util.List<com.google.cloud.aiplatform.v1beta1.SecretEnvVar> secretEnv_ =
          java.util.Collections.emptyList();

      private void ensureSecretEnvIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          secretEnv_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.SecretEnvVar>(secretEnv_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.SecretEnvVar,
              com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder,
              com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder>
          secretEnvBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.SecretEnvVar> getSecretEnvList() {
        if (secretEnvBuilder_ == null) {
          return java.util.Collections.unmodifiableList(secretEnv_);
        } else {
          return secretEnvBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getSecretEnvCount() {
        if (secretEnvBuilder_ == null) {
          return secretEnv_.size();
        } else {
          return secretEnvBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SecretEnvVar getSecretEnv(int index) {
        if (secretEnvBuilder_ == null) {
          return secretEnv_.get(index);
        } else {
          return secretEnvBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSecretEnv(
          int index, com.google.cloud.aiplatform.v1beta1.SecretEnvVar value) {
        if (secretEnvBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecretEnvIsMutable();
          secretEnv_.set(index, value);
          onChanged();
        } else {
          secretEnvBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSecretEnv(
          int index, com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder builderForValue) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.set(index, builderForValue.build());
          onChanged();
        } else {
          secretEnvBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(com.google.cloud.aiplatform.v1beta1.SecretEnvVar value) {
        if (secretEnvBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecretEnvIsMutable();
          secretEnv_.add(value);
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(
          int index, com.google.cloud.aiplatform.v1beta1.SecretEnvVar value) {
        if (secretEnvBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecretEnvIsMutable();
          secretEnv_.add(index, value);
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(
          com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder builderForValue) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.add(builderForValue.build());
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(
          int index, com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder builderForValue) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.add(index, builderForValue.build());
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllSecretEnv(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.SecretEnvVar> values) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretEnv_);
          onChanged();
        } else {
          secretEnvBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSecretEnv() {
        if (secretEnvBuilder_ == null) {
          secretEnv_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          secretEnvBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeSecretEnv(int index) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.remove(index);
          onChanged();
        } else {
          secretEnvBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder getSecretEnvBuilder(
          int index) {
        return getSecretEnvFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder getSecretEnvOrBuilder(
          int index) {
        if (secretEnvBuilder_ == null) {
          return secretEnv_.get(index);
        } else {
          return secretEnvBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder>
          getSecretEnvOrBuilderList() {
        if (secretEnvBuilder_ != null) {
          return secretEnvBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(secretEnv_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder addSecretEnvBuilder() {
        return getSecretEnvFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1beta1.SecretEnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder addSecretEnvBuilder(
          int index) {
        return getSecretEnvFieldBuilder()
            .addBuilder(
                index, com.google.cloud.aiplatform.v1beta1.SecretEnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder>
          getSecretEnvBuilderList() {
        return getSecretEnvFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.SecretEnvVar,
              com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder,
              com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder>
          getSecretEnvFieldBuilder() {
        if (secretEnvBuilder_ == null) {
          secretEnvBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.SecretEnvVar,
                  com.google.cloud.aiplatform.v1beta1.SecretEnvVar.Builder,
                  com.google.cloud.aiplatform.v1beta1.SecretEnvVarOrBuilder>(
                  secretEnv_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          secretEnv_ = null;
        }
        return secretEnvBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec)
    private static final com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeploymentSpec> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentSpec>() {
          @java.lang.Override
          public DeploymentSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeploymentSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PACKAGE_SPEC_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec packageSpec_;

  /**
   *
   *
   * <pre>
   * Optional. User provided package spec of the ReasoningEngine.
   * Ignored when users directly specify a deployment image through
   * `deployment_spec.first_party_image_override`, but keeping the
   * field_behavior to avoid introducing breaking changes.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the packageSpec field is set.
   */
  @java.lang.Override
  public boolean hasPackageSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. User provided package spec of the ReasoningEngine.
   * Ignored when users directly specify a deployment image through
   * `deployment_spec.first_party_image_override`, but keeping the
   * field_behavior to avoid introducing breaking changes.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The packageSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec getPackageSpec() {
    return packageSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.getDefaultInstance()
        : packageSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional. User provided package spec of the ReasoningEngine.
   * Ignored when users directly specify a deployment image through
   * `deployment_spec.first_party_image_override`, but keeping the
   * field_behavior to avoid introducing breaking changes.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpecOrBuilder
      getPackageSpecOrBuilder() {
    return packageSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.getDefaultInstance()
        : packageSpec_;
  }

  public static final int DEPLOYMENT_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deploymentSpec_;

  /**
   *
   *
   * <pre>
   * Optional. The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deploymentSpec field is set.
   */
  @java.lang.Override
  public boolean hasDeploymentSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deploymentSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
      getDeploymentSpec() {
    return deploymentSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
            .getDefaultInstance()
        : deploymentSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpecOrBuilder
      getDeploymentSpecOrBuilder() {
    return deploymentSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
            .getDefaultInstance()
        : deploymentSpec_;
  }

  public static final int CLASS_METHODS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Struct> classMethods_;

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Struct> getClassMethodsList() {
    return classMethods_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.StructOrBuilder>
      getClassMethodsOrBuilderList() {
    return classMethods_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getClassMethodsCount() {
    return classMethods_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Struct getClassMethods(int index) {
    return classMethods_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getClassMethodsOrBuilder(int index) {
    return classMethods_.get(index);
  }

  public static final int AGENT_FRAMEWORK_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agentFramework_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The OSS agent framework used to develop the agent.
   * Currently supported values: "langchain", "langgraph", "ag2", "custom".
   * </pre>
   *
   * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The agentFramework.
   */
  @java.lang.Override
  public java.lang.String getAgentFramework() {
    java.lang.Object ref = agentFramework_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agentFramework_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The OSS agent framework used to develop the agent.
   * Currently supported values: "langchain", "langgraph", "ag2", "custom".
   * </pre>
   *
   * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for agentFramework.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentFrameworkBytes() {
    java.lang.Object ref = agentFramework_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agentFramework_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getPackageSpec());
    }
    for (int i = 0; i < classMethods_.size(); i++) {
      output.writeMessage(3, classMethods_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getDeploymentSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentFramework_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, agentFramework_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPackageSpec());
    }
    for (int i = 0; i < classMethods_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, classMethods_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDeploymentSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentFramework_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, agentFramework_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec other =
        (com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec) obj;

    if (hasPackageSpec() != other.hasPackageSpec()) return false;
    if (hasPackageSpec()) {
      if (!getPackageSpec().equals(other.getPackageSpec())) return false;
    }
    if (hasDeploymentSpec() != other.hasDeploymentSpec()) return false;
    if (hasDeploymentSpec()) {
      if (!getDeploymentSpec().equals(other.getDeploymentSpec())) return false;
    }
    if (!getClassMethodsList().equals(other.getClassMethodsList())) return false;
    if (!getAgentFramework().equals(other.getAgentFramework())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPackageSpec()) {
      hash = (37 * hash) + PACKAGE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getPackageSpec().hashCode();
    }
    if (hasDeploymentSpec()) {
      hash = (37 * hash) + DEPLOYMENT_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDeploymentSpec().hashCode();
    }
    if (getClassMethodsCount() > 0) {
      hash = (37 * hash) + CLASS_METHODS_FIELD_NUMBER;
      hash = (53 * hash) + getClassMethodsList().hashCode();
    }
    hash = (37 * hash) + AGENT_FRAMEWORK_FIELD_NUMBER;
    hash = (53 * hash) + getAgentFramework().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * ReasoningEngine configurations
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ReasoningEngineSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec)
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.class,
              com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPackageSpecFieldBuilder();
        getDeploymentSpecFieldBuilder();
        getClassMethodsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      packageSpec_ = null;
      if (packageSpecBuilder_ != null) {
        packageSpecBuilder_.dispose();
        packageSpecBuilder_ = null;
      }
      deploymentSpec_ = null;
      if (deploymentSpecBuilder_ != null) {
        deploymentSpecBuilder_.dispose();
        deploymentSpecBuilder_ = null;
      }
      if (classMethodsBuilder_ == null) {
        classMethods_ = java.util.Collections.emptyList();
      } else {
        classMethods_ = null;
        classMethodsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      agentFramework_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1beta1_ReasoningEngineSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec build() {
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec result =
          new com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec result) {
      if (classMethodsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          classMethods_ = java.util.Collections.unmodifiableList(classMethods_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.classMethods_ = classMethods_;
      } else {
        result.classMethods_ = classMethodsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.packageSpec_ =
            packageSpecBuilder_ == null ? packageSpec_ : packageSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deploymentSpec_ =
            deploymentSpecBuilder_ == null ? deploymentSpec_ : deploymentSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.agentFramework_ = agentFramework_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.getDefaultInstance())
        return this;
      if (other.hasPackageSpec()) {
        mergePackageSpec(other.getPackageSpec());
      }
      if (other.hasDeploymentSpec()) {
        mergeDeploymentSpec(other.getDeploymentSpec());
      }
      if (classMethodsBuilder_ == null) {
        if (!other.classMethods_.isEmpty()) {
          if (classMethods_.isEmpty()) {
            classMethods_ = other.classMethods_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureClassMethodsIsMutable();
            classMethods_.addAll(other.classMethods_);
          }
          onChanged();
        }
      } else {
        if (!other.classMethods_.isEmpty()) {
          if (classMethodsBuilder_.isEmpty()) {
            classMethodsBuilder_.dispose();
            classMethodsBuilder_ = null;
            classMethods_ = other.classMethods_;
            bitField0_ = (bitField0_ & ~0x00000004);
            classMethodsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getClassMethodsFieldBuilder()
                    : null;
          } else {
            classMethodsBuilder_.addAllMessages(other.classMethods_);
          }
        }
      }
      if (!other.getAgentFramework().isEmpty()) {
        agentFramework_ = other.agentFramework_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getPackageSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.Struct m =
                    input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
                if (classMethodsBuilder_ == null) {
                  ensureClassMethodsIsMutable();
                  classMethods_.add(m);
                } else {
                  classMethodsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDeploymentSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 42:
              {
                agentFramework_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec packageSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpecOrBuilder>
        packageSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the packageSpec field is set.
     */
    public boolean hasPackageSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The packageSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec getPackageSpec() {
      if (packageSpecBuilder_ == null) {
        return packageSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
                .getDefaultInstance()
            : packageSpec_;
      } else {
        return packageSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPackageSpec(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec value) {
      if (packageSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        packageSpec_ = value;
      } else {
        packageSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPackageSpec(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.Builder
            builderForValue) {
      if (packageSpecBuilder_ == null) {
        packageSpec_ = builderForValue.build();
      } else {
        packageSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePackageSpec(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec value) {
      if (packageSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && packageSpec_ != null
            && packageSpec_
                != com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
                    .getDefaultInstance()) {
          getPackageSpecBuilder().mergeFrom(value);
        } else {
          packageSpec_ = value;
        }
      } else {
        packageSpecBuilder_.mergeFrom(value);
      }
      if (packageSpec_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPackageSpec() {
      bitField0_ = (bitField0_ & ~0x00000001);
      packageSpec_ = null;
      if (packageSpecBuilder_ != null) {
        packageSpecBuilder_.dispose();
        packageSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.Builder
        getPackageSpecBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPackageSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpecOrBuilder
        getPackageSpecOrBuilder() {
      if (packageSpecBuilder_ != null) {
        return packageSpecBuilder_.getMessageOrBuilder();
      } else {
        return packageSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
                .getDefaultInstance()
            : packageSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpecOrBuilder>
        getPackageSpecFieldBuilder() {
      if (packageSpecBuilder_ == null) {
        packageSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpecOrBuilder>(
                getPackageSpec(), getParentForChildren(), isClean());
        packageSpec_ = null;
      }
      return packageSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deploymentSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpecOrBuilder>
        deploymentSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deploymentSpec field is set.
     */
    public boolean hasDeploymentSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deploymentSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
        getDeploymentSpec() {
      if (deploymentSpecBuilder_ == null) {
        return deploymentSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
                .getDefaultInstance()
            : deploymentSpec_;
      } else {
        return deploymentSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeploymentSpec(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec value) {
      if (deploymentSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentSpec_ = value;
      } else {
        deploymentSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeploymentSpec(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.Builder
            builderForValue) {
      if (deploymentSpecBuilder_ == null) {
        deploymentSpec_ = builderForValue.build();
      } else {
        deploymentSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDeploymentSpec(
        com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec value) {
      if (deploymentSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && deploymentSpec_ != null
            && deploymentSpec_
                != com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
                    .getDefaultInstance()) {
          getDeploymentSpecBuilder().mergeFrom(value);
        } else {
          deploymentSpec_ = value;
        }
      } else {
        deploymentSpecBuilder_.mergeFrom(value);
      }
      if (deploymentSpec_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDeploymentSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      deploymentSpec_ = null;
      if (deploymentSpecBuilder_ != null) {
        deploymentSpecBuilder_.dispose();
        deploymentSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.Builder
        getDeploymentSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDeploymentSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpecOrBuilder
        getDeploymentSpecOrBuilder() {
      if (deploymentSpecBuilder_ != null) {
        return deploymentSpecBuilder_.getMessageOrBuilder();
      } else {
        return deploymentSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
                .getDefaultInstance()
            : deploymentSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpecOrBuilder>
        getDeploymentSpecFieldBuilder() {
      if (deploymentSpecBuilder_ == null) {
        deploymentSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpecOrBuilder>(
                getDeploymentSpec(), getParentForChildren(), isClean());
        deploymentSpec_ = null;
      }
      return deploymentSpecBuilder_;
    }

    private java.util.List<com.google.protobuf.Struct> classMethods_ =
        java.util.Collections.emptyList();

    private void ensureClassMethodsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        classMethods_ = new java.util.ArrayList<com.google.protobuf.Struct>(classMethods_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        classMethodsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.protobuf.Struct> getClassMethodsList() {
      if (classMethodsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(classMethods_);
      } else {
        return classMethodsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getClassMethodsCount() {
      if (classMethodsBuilder_ == null) {
        return classMethods_.size();
      } else {
        return classMethodsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct getClassMethods(int index) {
      if (classMethodsBuilder_ == null) {
        return classMethods_.get(index);
      } else {
        return classMethodsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClassMethods(int index, com.google.protobuf.Struct value) {
      if (classMethodsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassMethodsIsMutable();
        classMethods_.set(index, value);
        onChanged();
      } else {
        classMethodsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClassMethods(int index, com.google.protobuf.Struct.Builder builderForValue) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.set(index, builderForValue.build());
        onChanged();
      } else {
        classMethodsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(com.google.protobuf.Struct value) {
      if (classMethodsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassMethodsIsMutable();
        classMethods_.add(value);
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(int index, com.google.protobuf.Struct value) {
      if (classMethodsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassMethodsIsMutable();
        classMethods_.add(index, value);
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(com.google.protobuf.Struct.Builder builderForValue) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.add(builderForValue.build());
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(int index, com.google.protobuf.Struct.Builder builderForValue) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.add(index, builderForValue.build());
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllClassMethods(
        java.lang.Iterable<? extends com.google.protobuf.Struct> values) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, classMethods_);
        onChanged();
      } else {
        classMethodsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearClassMethods() {
      if (classMethodsBuilder_ == null) {
        classMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        classMethodsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeClassMethods(int index) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.remove(index);
        onChanged();
      } else {
        classMethodsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getClassMethodsBuilder(int index) {
      return getClassMethodsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getClassMethodsOrBuilder(int index) {
      if (classMethodsBuilder_ == null) {
        return classMethods_.get(index);
      } else {
        return classMethodsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.protobuf.StructOrBuilder>
        getClassMethodsOrBuilderList() {
      if (classMethodsBuilder_ != null) {
        return classMethodsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(classMethods_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder addClassMethodsBuilder() {
      return getClassMethodsFieldBuilder()
          .addBuilder(com.google.protobuf.Struct.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder addClassMethodsBuilder(int index) {
      return getClassMethodsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Struct.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.protobuf.Struct.Builder> getClassMethodsBuilderList() {
      return getClassMethodsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getClassMethodsFieldBuilder() {
      if (classMethodsBuilder_ == null) {
        classMethodsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                classMethods_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        classMethods_ = null;
      }
      return classMethodsBuilder_;
    }

    private java.lang.Object agentFramework_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "langchain", "langgraph", "ag2", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentFramework.
     */
    public java.lang.String getAgentFramework() {
      java.lang.Object ref = agentFramework_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentFramework_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "langchain", "langgraph", "ag2", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentFramework.
     */
    public com.google.protobuf.ByteString getAgentFrameworkBytes() {
      java.lang.Object ref = agentFramework_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentFramework_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "langchain", "langgraph", "ag2", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The agentFramework to set.
     * @return This builder for chaining.
     */
    public Builder setAgentFramework(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agentFramework_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "langchain", "langgraph", "ag2", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentFramework() {
      agentFramework_ = getDefaultInstance().getAgentFramework();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "langchain", "langgraph", "ag2", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for agentFramework to set.
     * @return This builder for chaining.
     */
    public Builder setAgentFrameworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agentFramework_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ReasoningEngineSpec)
  private static final com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReasoningEngineSpec> PARSER =
      new com.google.protobuf.AbstractParser<ReasoningEngineSpec>() {
        @java.lang.Override
        public ReasoningEngineSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReasoningEngineSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReasoningEngineSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ReasoningEngineSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
