/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/dataset_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Format for Gemini examples used for Vertex Multimodal datasets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GeminiExample}
 */
public final class GeminiExample extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GeminiExample)
    GeminiExampleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GeminiExample.newBuilder() to construct.
  private GeminiExample(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GeminiExample() {
    model_ = "";
    contents_ = java.util.Collections.emptyList();
    cachedContent_ = "";
    tools_ = java.util.Collections.emptyList();
    safetySettings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GeminiExample();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GeminiExample_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GeminiExample_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GeminiExample.class,
            com.google.cloud.aiplatform.v1beta1.GeminiExample.Builder.class);
  }

  private int bitField0_;
  public static final int MODEL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The fully qualified name of the publisher model or tuned model
   * endpoint to use.
   *
   * Publisher model format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   *
   * Tuned model endpoint format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string model = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The fully qualified name of the publisher model or tuned model
   * endpoint to use.
   *
   * Publisher model format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   *
   * Tuned model endpoint format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string model = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> contents_;

  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn
   * queries, this is a repeated field that contains conversation history +
   * latest request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getContentsList() {
    return contents_;
  }

  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn
   * queries, this is a repeated field that contains conversation history +
   * latest request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
      getContentsOrBuilderList() {
    return contents_;
  }

  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn
   * queries, this is a repeated field that contains conversation history +
   * latest request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getContentsCount() {
    return contents_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn
   * queries, this is a repeated field that contains conversation history +
   * latest request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getContents(int index) {
    return contents_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn
   * queries, this is a repeated field that contains conversation history +
   * latest request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentsOrBuilder(int index) {
    return contents_.get(index);
  }

  public static final int SYSTEM_INSTRUCTION_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.Content systemInstruction_;

  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be
   * in a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the systemInstruction field is set.
   */
  @java.lang.Override
  public boolean hasSystemInstruction() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be
   * in a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The systemInstruction.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getSystemInstruction() {
    return systemInstruction_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : systemInstruction_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be
   * in a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getSystemInstructionOrBuilder() {
    return systemInstruction_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : systemInstruction_;
  }

  public static final int CACHED_CONTENT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cachedContent_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The name of the cached content used as context to serve the
   * prediction. Note: only used in explicit caching, where users can have
   * control over caching (e.g. what content to cache) and enjoy guaranteed cost
   * savings. Format:
   * `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
   * </pre>
   *
   * <code>
   * string cached_content = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The cachedContent.
   */
  @java.lang.Override
  public java.lang.String getCachedContent() {
    java.lang.Object ref = cachedContent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cachedContent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The name of the cached content used as context to serve the
   * prediction. Note: only used in explicit caching, where users can have
   * control over caching (e.g. what content to cache) and enjoy guaranteed cost
   * savings. Format:
   * `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
   * </pre>
   *
   * <code>
   * string cached_content = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for cachedContent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCachedContentBytes() {
    java.lang.Object ref = cachedContent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cachedContent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOOLS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> tools_;

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> getToolsList() {
    return tools_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
      getToolsOrBuilderList() {
    return tools_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getToolsCount() {
    return tools_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tool getTools(int index) {
    return tools_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolOrBuilder getToolsOrBuilder(int index) {
    return tools_.get(index);
  }

  public static final int TOOL_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.ToolConfig toolConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Tool config. This config is shared for all tools provided in the
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the toolConfig field is set.
   */
  @java.lang.Override
  public boolean hasToolConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool config. This config is shared for all tools provided in the
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The toolConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolConfig getToolConfig() {
    return toolConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
        : toolConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool config. This config is shared for all tools provided in the
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder getToolConfigOrBuilder() {
    return toolConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
        : toolConfig_;
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_GeminiExample_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request. It is used
   * for billing and reporting only.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request. It is used
   * for billing and reporting only.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request. It is used
   * for billing and reporting only.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request. It is used
   * for billing and reporting only.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SAFETY_SETTINGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.SafetySetting> safetySettings_;

  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.SafetySetting> getSafetySettingsList() {
    return safetySettings_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SafetySettingOrBuilder>
      getSafetySettingsOrBuilderList() {
    return safetySettings_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSafetySettingsCount() {
    return safetySettings_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SafetySetting getSafetySettings(int index) {
    return safetySettings_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SafetySettingOrBuilder getSafetySettingsOrBuilder(
      int index) {
    return safetySettings_.get(index);
  }

  public static final int GENERATION_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.GenerationConfig generationConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Generation config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the generationConfig field is set.
   */
  @java.lang.Override
  public boolean hasGenerationConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Generation config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The generationConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig getGenerationConfig() {
    return generationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
        : generationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Generation config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder
      getGenerationConfigOrBuilder() {
    return generationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
        : generationConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
    }
    for (int i = 0; i < contents_.size(); i++) {
      output.writeMessage(2, contents_.get(i));
    }
    for (int i = 0; i < safetySettings_.size(); i++) {
      output.writeMessage(3, safetySettings_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getGenerationConfig());
    }
    for (int i = 0; i < tools_.size(); i++) {
      output.writeMessage(6, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getToolConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getSystemInstruction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cachedContent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, cachedContent_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
    }
    for (int i = 0; i < contents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, contents_.get(i));
    }
    for (int i = 0; i < safetySettings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, safetySettings_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGenerationConfig());
    }
    for (int i = 0; i < tools_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getToolConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSystemInstruction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cachedContent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, cachedContent_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GeminiExample)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GeminiExample other =
        (com.google.cloud.aiplatform.v1beta1.GeminiExample) obj;

    if (!getModel().equals(other.getModel())) return false;
    if (!getContentsList().equals(other.getContentsList())) return false;
    if (hasSystemInstruction() != other.hasSystemInstruction()) return false;
    if (hasSystemInstruction()) {
      if (!getSystemInstruction().equals(other.getSystemInstruction())) return false;
    }
    if (!getCachedContent().equals(other.getCachedContent())) return false;
    if (!getToolsList().equals(other.getToolsList())) return false;
    if (hasToolConfig() != other.hasToolConfig()) return false;
    if (hasToolConfig()) {
      if (!getToolConfig().equals(other.getToolConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getSafetySettingsList().equals(other.getSafetySettingsList())) return false;
    if (hasGenerationConfig() != other.hasGenerationConfig()) return false;
    if (hasGenerationConfig()) {
      if (!getGenerationConfig().equals(other.getGenerationConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (getContentsCount() > 0) {
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContentsList().hashCode();
    }
    if (hasSystemInstruction()) {
      hash = (37 * hash) + SYSTEM_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getSystemInstruction().hashCode();
    }
    hash = (37 * hash) + CACHED_CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getCachedContent().hashCode();
    if (getToolsCount() > 0) {
      hash = (37 * hash) + TOOLS_FIELD_NUMBER;
      hash = (53 * hash) + getToolsList().hashCode();
    }
    if (hasToolConfig()) {
      hash = (37 * hash) + TOOL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getToolConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getSafetySettingsCount() > 0) {
      hash = (37 * hash) + SAFETY_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSafetySettingsList().hashCode();
    }
    if (hasGenerationConfig()) {
      hash = (37 * hash) + GENERATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGenerationConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.GeminiExample prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Format for Gemini examples used for Vertex Multimodal datasets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GeminiExample}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GeminiExample)
      com.google.cloud.aiplatform.v1beta1.GeminiExampleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GeminiExample_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GeminiExample_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GeminiExample.class,
              com.google.cloud.aiplatform.v1beta1.GeminiExample.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GeminiExample.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContentsFieldBuilder();
        getSystemInstructionFieldBuilder();
        getToolsFieldBuilder();
        getToolConfigFieldBuilder();
        getSafetySettingsFieldBuilder();
        getGenerationConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      model_ = "";
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
      } else {
        contents_ = null;
        contentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      cachedContent_ = "";
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
      } else {
        tools_ = null;
        toolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      toolConfig_ = null;
      if (toolConfigBuilder_ != null) {
        toolConfigBuilder_.dispose();
        toolConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (safetySettingsBuilder_ == null) {
        safetySettings_ = java.util.Collections.emptyList();
      } else {
        safetySettings_ = null;
        safetySettingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      generationConfig_ = null;
      if (generationConfigBuilder_ != null) {
        generationConfigBuilder_.dispose();
        generationConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GeminiExample_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiExample getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GeminiExample.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiExample build() {
      com.google.cloud.aiplatform.v1beta1.GeminiExample result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GeminiExample buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GeminiExample result =
          new com.google.cloud.aiplatform.v1beta1.GeminiExample(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.GeminiExample result) {
      if (contentsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          contents_ = java.util.Collections.unmodifiableList(contents_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.contents_ = contents_;
      } else {
        result.contents_ = contentsBuilder_.build();
      }
      if (toolsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          tools_ = java.util.Collections.unmodifiableList(tools_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.tools_ = tools_;
      } else {
        result.tools_ = toolsBuilder_.build();
      }
      if (safetySettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          safetySettings_ = java.util.Collections.unmodifiableList(safetySettings_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.safetySettings_ = safetySettings_;
      } else {
        result.safetySettings_ = safetySettingsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.GeminiExample result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.model_ = model_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.systemInstruction_ =
            systemInstructionBuilder_ == null
                ? systemInstruction_
                : systemInstructionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cachedContent_ = cachedContent_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.toolConfig_ = toolConfigBuilder_ == null ? toolConfig_ : toolConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.generationConfig_ =
            generationConfigBuilder_ == null ? generationConfig_ : generationConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GeminiExample) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GeminiExample) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GeminiExample other) {
      if (other == com.google.cloud.aiplatform.v1beta1.GeminiExample.getDefaultInstance())
        return this;
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (contentsBuilder_ == null) {
        if (!other.contents_.isEmpty()) {
          if (contents_.isEmpty()) {
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureContentsIsMutable();
            contents_.addAll(other.contents_);
          }
          onChanged();
        }
      } else {
        if (!other.contents_.isEmpty()) {
          if (contentsBuilder_.isEmpty()) {
            contentsBuilder_.dispose();
            contentsBuilder_ = null;
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000002);
            contentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentsFieldBuilder()
                    : null;
          } else {
            contentsBuilder_.addAllMessages(other.contents_);
          }
        }
      }
      if (other.hasSystemInstruction()) {
        mergeSystemInstruction(other.getSystemInstruction());
      }
      if (!other.getCachedContent().isEmpty()) {
        cachedContent_ = other.cachedContent_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (toolsBuilder_ == null) {
        if (!other.tools_.isEmpty()) {
          if (tools_.isEmpty()) {
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureToolsIsMutable();
            tools_.addAll(other.tools_);
          }
          onChanged();
        }
      } else {
        if (!other.tools_.isEmpty()) {
          if (toolsBuilder_.isEmpty()) {
            toolsBuilder_.dispose();
            toolsBuilder_ = null;
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000010);
            toolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getToolsFieldBuilder()
                    : null;
          } else {
            toolsBuilder_.addAllMessages(other.tools_);
          }
        }
      }
      if (other.hasToolConfig()) {
        mergeToolConfig(other.getToolConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (safetySettingsBuilder_ == null) {
        if (!other.safetySettings_.isEmpty()) {
          if (safetySettings_.isEmpty()) {
            safetySettings_ = other.safetySettings_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureSafetySettingsIsMutable();
            safetySettings_.addAll(other.safetySettings_);
          }
          onChanged();
        }
      } else {
        if (!other.safetySettings_.isEmpty()) {
          if (safetySettingsBuilder_.isEmpty()) {
            safetySettingsBuilder_.dispose();
            safetySettingsBuilder_ = null;
            safetySettings_ = other.safetySettings_;
            bitField0_ = (bitField0_ & ~0x00000080);
            safetySettingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSafetySettingsFieldBuilder()
                    : null;
          } else {
            safetySettingsBuilder_.addAllMessages(other.safetySettings_);
          }
        }
      }
      if (other.hasGenerationConfig()) {
        mergeGenerationConfig(other.getGenerationConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.Content m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Content.parser(), extensionRegistry);
                if (contentsBuilder_ == null) {
                  ensureContentsIsMutable();
                  contents_.add(m);
                } else {
                  contentsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.SafetySetting m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.SafetySetting.parser(),
                        extensionRegistry);
                if (safetySettingsBuilder_ == null) {
                  ensureSafetySettingsIsMutable();
                  safetySettings_.add(m);
                } else {
                  safetySettingsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGenerationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 34
            case 50:
              {
                com.google.cloud.aiplatform.v1beta1.Tool m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Tool.parser(), extensionRegistry);
                if (toolsBuilder_ == null) {
                  ensureToolsIsMutable();
                  tools_.add(m);
                } else {
                  toolsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getToolConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getSystemInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            case 74:
              {
                cachedContent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object model_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> contents_ =
        java.util.Collections.emptyList();

    private void ensureContentsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        contents_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Content>(contents_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        contentsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getContentsList() {
      if (contentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contents_);
      } else {
        return contentsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getContentsCount() {
      if (contentsBuilder_ == null) {
        return contents_.size();
      } else {
        return contentsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content getContents(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setContents(int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.set(index, value);
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setContents(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(index, value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(
        com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllContents(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Content> values) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contents_);
        onChanged();
      } else {
        contentsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearContents() {
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        contentsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeContents(int index) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.remove(index);
        onChanged();
      } else {
        contentsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getContentsBuilder(int index) {
      return getContentsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentsOrBuilder(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getContentsOrBuilderList() {
      if (contentsBuilder_ != null) {
        return contentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contents_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addContentsBuilder() {
      return getContentsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addContentsBuilder(int index) {
      return getContentsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn
     * queries, this is a repeated field that contains conversation history +
     * latest request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content.Builder>
        getContentsBuilderList() {
      return getContentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getContentsFieldBuilder() {
      if (contentsBuilder_ == null) {
        contentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                contents_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        contents_ = null;
      }
      return contentsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.Content systemInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        systemInstructionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the systemInstruction field is set.
     */
    public boolean hasSystemInstruction() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The systemInstruction.
     */
    public com.google.cloud.aiplatform.v1beta1.Content getSystemInstruction() {
      if (systemInstructionBuilder_ == null) {
        return systemInstruction_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : systemInstruction_;
      } else {
        return systemInstructionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSystemInstruction(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemInstruction_ = value;
      } else {
        systemInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSystemInstruction(
        com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (systemInstructionBuilder_ == null) {
        systemInstruction_ = builderForValue.build();
      } else {
        systemInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSystemInstruction(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && systemInstruction_ != null
            && systemInstruction_
                != com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()) {
          getSystemInstructionBuilder().mergeFrom(value);
        } else {
          systemInstruction_ = value;
        }
      } else {
        systemInstructionBuilder_.mergeFrom(value);
      }
      if (systemInstruction_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSystemInstruction() {
      bitField0_ = (bitField0_ & ~0x00000004);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getSystemInstructionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSystemInstructionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getSystemInstructionOrBuilder() {
      if (systemInstructionBuilder_ != null) {
        return systemInstructionBuilder_.getMessageOrBuilder();
      } else {
        return systemInstruction_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : systemInstruction_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be
     * in a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getSystemInstructionFieldBuilder() {
      if (systemInstructionBuilder_ == null) {
        systemInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                getSystemInstruction(), getParentForChildren(), isClean());
        systemInstruction_ = null;
      }
      return systemInstructionBuilder_;
    }

    private java.lang.Object cachedContent_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the cached content used as context to serve the
     * prediction. Note: only used in explicit caching, where users can have
     * control over caching (e.g. what content to cache) and enjoy guaranteed cost
     * savings. Format:
     * `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
     * </pre>
     *
     * <code>
     * string cached_content = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The cachedContent.
     */
    public java.lang.String getCachedContent() {
      java.lang.Object ref = cachedContent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cachedContent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the cached content used as context to serve the
     * prediction. Note: only used in explicit caching, where users can have
     * control over caching (e.g. what content to cache) and enjoy guaranteed cost
     * savings. Format:
     * `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
     * </pre>
     *
     * <code>
     * string cached_content = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for cachedContent.
     */
    public com.google.protobuf.ByteString getCachedContentBytes() {
      java.lang.Object ref = cachedContent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cachedContent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the cached content used as context to serve the
     * prediction. Note: only used in explicit caching, where users can have
     * control over caching (e.g. what content to cache) and enjoy guaranteed cost
     * savings. Format:
     * `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
     * </pre>
     *
     * <code>
     * string cached_content = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The cachedContent to set.
     * @return This builder for chaining.
     */
    public Builder setCachedContent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cachedContent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the cached content used as context to serve the
     * prediction. Note: only used in explicit caching, where users can have
     * control over caching (e.g. what content to cache) and enjoy guaranteed cost
     * savings. Format:
     * `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
     * </pre>
     *
     * <code>
     * string cached_content = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCachedContent() {
      cachedContent_ = getDefaultInstance().getCachedContent();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the cached content used as context to serve the
     * prediction. Note: only used in explicit caching, where users can have
     * control over caching (e.g. what content to cache) and enjoy guaranteed cost
     * savings. Format:
     * `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
     * </pre>
     *
     * <code>
     * string cached_content = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for cachedContent to set.
     * @return This builder for chaining.
     */
    public Builder setCachedContentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cachedContent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> tools_ =
        java.util.Collections.emptyList();

    private void ensureToolsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        tools_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Tool>(tools_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tool,
            com.google.cloud.aiplatform.v1beta1.Tool.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        toolsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> getToolsList() {
      if (toolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tools_);
      } else {
        return toolsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getToolsCount() {
      if (toolsBuilder_ == null) {
        return tools_.size();
      } else {
        return toolsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool getTools(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTools(int index, com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.set(index, value);
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTools(
        int index, com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.set(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(int index, com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(index, value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(
        int index, com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllTools(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Tool> values) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tools_);
        onChanged();
      } else {
        toolsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTools() {
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        toolsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeTools(int index) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.remove(index);
        onChanged();
      } else {
        toolsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder getToolsBuilder(int index) {
      return getToolsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolOrBuilder getToolsOrBuilder(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        getToolsOrBuilderList() {
      if (toolsBuilder_ != null) {
        return toolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tools_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder addToolsBuilder() {
      return getToolsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder addToolsBuilder(int index) {
      return getToolsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool.Builder> getToolsBuilderList() {
      return getToolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tool,
            com.google.cloud.aiplatform.v1beta1.Tool.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        getToolsFieldBuilder() {
      if (toolsBuilder_ == null) {
        toolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Tool,
                com.google.cloud.aiplatform.v1beta1.Tool.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>(
                tools_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        tools_ = null;
      }
      return toolsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ToolConfig toolConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolConfig,
            com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder>
        toolConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the toolConfig field is set.
     */
    public boolean hasToolConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The toolConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ToolConfig getToolConfig() {
      if (toolConfigBuilder_ == null) {
        return toolConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
            : toolConfig_;
      } else {
        return toolConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolConfig(com.google.cloud.aiplatform.v1beta1.ToolConfig value) {
      if (toolConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        toolConfig_ = value;
      } else {
        toolConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolConfig(
        com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder builderForValue) {
      if (toolConfigBuilder_ == null) {
        toolConfig_ = builderForValue.build();
      } else {
        toolConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeToolConfig(com.google.cloud.aiplatform.v1beta1.ToolConfig value) {
      if (toolConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && toolConfig_ != null
            && toolConfig_ != com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()) {
          getToolConfigBuilder().mergeFrom(value);
        } else {
          toolConfig_ = value;
        }
      } else {
        toolConfigBuilder_.mergeFrom(value);
      }
      if (toolConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearToolConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      toolConfig_ = null;
      if (toolConfigBuilder_ != null) {
        toolConfigBuilder_.dispose();
        toolConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder getToolConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getToolConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder getToolConfigOrBuilder() {
      if (toolConfigBuilder_ != null) {
        return toolConfigBuilder_.getMessageOrBuilder();
      } else {
        return toolConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ToolConfig.getDefaultInstance()
            : toolConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolConfig,
            com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder>
        getToolConfigFieldBuilder() {
      if (toolConfigBuilder_ == null) {
        toolConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ToolConfig,
                com.google.cloud.aiplatform.v1beta1.ToolConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolConfigOrBuilder>(
                getToolConfig(), getParentForChildren(), isClean());
        toolConfig_ = null;
      }
      return toolConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request. It is used
     * for billing and reporting only.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are
     * allowed. Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request. It is used
     * for billing and reporting only.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are
     * allowed. Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request. It is used
     * for billing and reporting only.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are
     * allowed. Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request. It is used
     * for billing and reporting only.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are
     * allowed. Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request. It is used
     * for billing and reporting only.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are
     * allowed. Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request. It is used
     * for billing and reporting only.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are
     * allowed. Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request. It is used
     * for billing and reporting only.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are
     * allowed. Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.SafetySetting> safetySettings_ =
        java.util.Collections.emptyList();

    private void ensureSafetySettingsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        safetySettings_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.SafetySetting>(
                safetySettings_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SafetySetting,
            com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder,
            com.google.cloud.aiplatform.v1beta1.SafetySettingOrBuilder>
        safetySettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.SafetySetting>
        getSafetySettingsList() {
      if (safetySettingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(safetySettings_);
      } else {
        return safetySettingsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSafetySettingsCount() {
      if (safetySettingsBuilder_ == null) {
        return safetySettings_.size();
      } else {
        return safetySettingsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SafetySetting getSafetySettings(int index) {
      if (safetySettingsBuilder_ == null) {
        return safetySettings_.get(index);
      } else {
        return safetySettingsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSafetySettings(
        int index, com.google.cloud.aiplatform.v1beta1.SafetySetting value) {
      if (safetySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetySettingsIsMutable();
        safetySettings_.set(index, value);
        onChanged();
      } else {
        safetySettingsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSafetySettings(
        int index, com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder builderForValue) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.set(index, builderForValue.build());
        onChanged();
      } else {
        safetySettingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(com.google.cloud.aiplatform.v1beta1.SafetySetting value) {
      if (safetySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetySettingsIsMutable();
        safetySettings_.add(value);
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(
        int index, com.google.cloud.aiplatform.v1beta1.SafetySetting value) {
      if (safetySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetySettingsIsMutable();
        safetySettings_.add(index, value);
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(
        com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder builderForValue) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.add(builderForValue.build());
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(
        int index, com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder builderForValue) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.add(index, builderForValue.build());
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSafetySettings(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.SafetySetting> values) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, safetySettings_);
        onChanged();
      } else {
        safetySettingsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSafetySettings() {
      if (safetySettingsBuilder_ == null) {
        safetySettings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        safetySettingsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSafetySettings(int index) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.remove(index);
        onChanged();
      } else {
        safetySettingsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder getSafetySettingsBuilder(
        int index) {
      return getSafetySettingsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SafetySettingOrBuilder getSafetySettingsOrBuilder(
        int index) {
      if (safetySettingsBuilder_ == null) {
        return safetySettings_.get(index);
      } else {
        return safetySettingsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SafetySettingOrBuilder>
        getSafetySettingsOrBuilderList() {
      if (safetySettingsBuilder_ != null) {
        return safetySettingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(safetySettings_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder addSafetySettingsBuilder() {
      return getSafetySettingsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.SafetySetting.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder addSafetySettingsBuilder(
        int index) {
      return getSafetySettingsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.SafetySetting.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder>
        getSafetySettingsBuilderList() {
      return getSafetySettingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SafetySetting,
            com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder,
            com.google.cloud.aiplatform.v1beta1.SafetySettingOrBuilder>
        getSafetySettingsFieldBuilder() {
      if (safetySettingsBuilder_ == null) {
        safetySettingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SafetySetting,
                com.google.cloud.aiplatform.v1beta1.SafetySetting.Builder,
                com.google.cloud.aiplatform.v1beta1.SafetySettingOrBuilder>(
                safetySettings_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        safetySettings_ = null;
      }
      return safetySettingsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GenerationConfig generationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder>
        generationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the generationConfig field is set.
     */
    public boolean hasGenerationConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The generationConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig getGenerationConfig() {
      if (generationConfigBuilder_ == null) {
        return generationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
            : generationConfig_;
      } else {
        return generationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGenerationConfig(com.google.cloud.aiplatform.v1beta1.GenerationConfig value) {
      if (generationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generationConfig_ = value;
      } else {
        generationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGenerationConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder builderForValue) {
      if (generationConfigBuilder_ == null) {
        generationConfig_ = builderForValue.build();
      } else {
        generationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGenerationConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig value) {
      if (generationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && generationConfig_ != null
            && generationConfig_
                != com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()) {
          getGenerationConfigBuilder().mergeFrom(value);
        } else {
          generationConfig_ = value;
        }
      } else {
        generationConfigBuilder_.mergeFrom(value);
      }
      if (generationConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGenerationConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      generationConfig_ = null;
      if (generationConfigBuilder_ != null) {
        generationConfigBuilder_.dispose();
        generationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder
        getGenerationConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getGenerationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder
        getGenerationConfigOrBuilder() {
      if (generationConfigBuilder_ != null) {
        return generationConfigBuilder_.getMessageOrBuilder();
      } else {
        return generationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
            : generationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder>
        getGenerationConfigFieldBuilder() {
      if (generationConfigBuilder_ == null) {
        generationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerationConfig,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder>(
                getGenerationConfig(), getParentForChildren(), isClean());
        generationConfig_ = null;
      }
      return generationConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GeminiExample)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GeminiExample)
  private static final com.google.cloud.aiplatform.v1beta1.GeminiExample DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GeminiExample();
  }

  public static com.google.cloud.aiplatform.v1beta1.GeminiExample getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GeminiExample> PARSER =
      new com.google.protobuf.AbstractParser<GeminiExample>() {
        @java.lang.Override
        public GeminiExample parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GeminiExample> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GeminiExample> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GeminiExample getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
