/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/featurestore_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A destination location for Feature values and format.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureValueDestination}
 */
public final class FeatureValueDestination extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureValueDestination)
    FeatureValueDestinationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FeatureValueDestination.newBuilder() to construct.
  private FeatureValueDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureValueDestination() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureValueDestination();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureValueDestination_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureValueDestination_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeatureValueDestination.class,
            com.google.cloud.aiplatform.v1beta1.FeatureValueDestination.Builder.class);
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIGQUERY_DESTINATION(1),
    TFRECORD_DESTINATION(2),
    CSV_DESTINATION(3),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return BIGQUERY_DESTINATION;
        case 2:
          return TFRECORD_DESTINATION;
        case 3:
          return CSV_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int BIGQUERY_DESTINATION_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Output in BigQuery format.
   * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
   * in
   * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
   * must refer to a table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
   *
   * @return Whether the bigqueryDestination field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDestination() {
    return destinationCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Output in BigQuery format.
   * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
   * in
   * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
   * must refer to a table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
   *
   * @return The bigqueryDestination.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Output in BigQuery format.
   * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
   * in
   * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
   * must refer to a table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
      getBigqueryDestinationOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }

  public static final int TFRECORD_DESTINATION_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Output in TFRecord format.
   *
   * Below are the mapping from Feature value type
   * in Featurestore to Feature value type in TFRecord:
   *
   *     Value type in Featurestore                 | Value type in TFRecord
   *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
   *     INT64, INT64_ARRAY                         | INT64_LIST
   *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
   *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
   *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
   *
   * @return Whether the tfrecordDestination field is set.
   */
  @java.lang.Override
  public boolean hasTfrecordDestination() {
    return destinationCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Output in TFRecord format.
   *
   * Below are the mapping from Feature value type
   * in Featurestore to Feature value type in TFRecord:
   *
   *     Value type in Featurestore                 | Value type in TFRecord
   *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
   *     INT64, INT64_ARRAY                         | INT64_LIST
   *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
   *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
   *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
   *
   * @return The tfrecordDestination.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TFRecordDestination getTfrecordDestination() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.TFRecordDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Output in TFRecord format.
   *
   * Below are the mapping from Feature value type
   * in Featurestore to Feature value type in TFRecord:
   *
   *     Value type in Featurestore                 | Value type in TFRecord
   *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
   *     INT64, INT64_ARRAY                         | INT64_LIST
   *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
   *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
   *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TFRecordDestinationOrBuilder
      getTfrecordDestinationOrBuilder() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.TFRecordDestination.getDefaultInstance();
  }

  public static final int CSV_DESTINATION_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Output in CSV format. Array Feature value types are not allowed in CSV
   * format.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
   *
   * @return Whether the csvDestination field is set.
   */
  @java.lang.Override
  public boolean hasCsvDestination() {
    return destinationCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Output in CSV format. Array Feature value types are not allowed in CSV
   * format.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
   *
   * @return The csvDestination.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CsvDestination getCsvDestination() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.CsvDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Output in CSV format. Array Feature value types are not allowed in CSV
   * format.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CsvDestinationOrBuilder getCsvDestinationOrBuilder() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.CsvDestination.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
    }
    if (destinationCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_);
    }
    if (destinationCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
    }
    if (destinationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_);
    }
    if (destinationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureValueDestination)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeatureValueDestination other =
        (com.google.cloud.aiplatform.v1beta1.FeatureValueDestination) obj;

    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getBigqueryDestination().equals(other.getBigqueryDestination())) return false;
        break;
      case 2:
        if (!getTfrecordDestination().equals(other.getTfrecordDestination())) return false;
        break;
      case 3:
        if (!getCsvDestination().equals(other.getCsvDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + BIGQUERY_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryDestination().hashCode();
        break;
      case 2:
        hash = (37 * hash) + TFRECORD_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getTfrecordDestination().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CSV_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getCsvDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FeatureValueDestination prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A destination location for Feature values and format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureValueDestination}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureValueDestination)
      com.google.cloud.aiplatform.v1beta1.FeatureValueDestinationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureValueDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureValueDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureValueDestination.class,
              com.google.cloud.aiplatform.v1beta1.FeatureValueDestination.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeatureValueDestination.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigqueryDestinationBuilder_ != null) {
        bigqueryDestinationBuilder_.clear();
      }
      if (tfrecordDestinationBuilder_ != null) {
        tfrecordDestinationBuilder_.clear();
      }
      if (csvDestinationBuilder_ != null) {
        csvDestinationBuilder_.clear();
      }
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureValueDestination_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureValueDestination getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureValueDestination.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureValueDestination build() {
      com.google.cloud.aiplatform.v1beta1.FeatureValueDestination result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureValueDestination buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeatureValueDestination result =
          new com.google.cloud.aiplatform.v1beta1.FeatureValueDestination(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureValueDestination result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.FeatureValueDestination result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
      if (destinationCase_ == 1 && bigqueryDestinationBuilder_ != null) {
        result.destination_ = bigqueryDestinationBuilder_.build();
      }
      if (destinationCase_ == 2 && tfrecordDestinationBuilder_ != null) {
        result.destination_ = tfrecordDestinationBuilder_.build();
      }
      if (destinationCase_ == 3 && csvDestinationBuilder_ != null) {
        result.destination_ = csvDestinationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureValueDestination) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureValueDestination) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureValueDestination other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FeatureValueDestination.getDefaultInstance())
        return this;
      switch (other.getDestinationCase()) {
        case BIGQUERY_DESTINATION:
          {
            mergeBigqueryDestination(other.getBigqueryDestination());
            break;
          }
        case TFRECORD_DESTINATION:
          {
            mergeTfrecordDestination(other.getTfrecordDestination());
            break;
          }
        case CSV_DESTINATION:
          {
            mergeCsvDestination(other.getCsvDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getBigqueryDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getTfrecordDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCsvDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        bigqueryDestinationBuilder_;

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDestination() {
      return destinationCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     *
     * @return The bigqueryDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return bigqueryDestinationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     */
    public Builder setBigqueryDestination(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        bigqueryDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     */
    public Builder setBigqueryDestination(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder builderForValue) {
      if (bigqueryDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     */
    public Builder mergeBigqueryDestination(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_
                != com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          bigqueryDestinationBuilder_.mergeFrom(value);
        } else {
          bigqueryDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     */
    public Builder clearBigqueryDestination() {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        bigqueryDestinationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder
        getBigqueryDestinationBuilder() {
      return getBigqueryDestinationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder() {
      if ((destinationCase_ == 1) && (bigqueryDestinationBuilder_ != null)) {
        return bigqueryDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output in BigQuery format.
     * [BigQueryDestination.output_uri][google.cloud.aiplatform.v1beta1.BigQueryDestination.output_uri]
     * in
     * [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1beta1.FeatureValueDestination.bigquery_destination]
     * must refer to a table.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        getBigqueryDestinationFieldBuilder() {
      if (bigqueryDestinationBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
        bigqueryDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      return bigqueryDestinationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TFRecordDestination,
            com.google.cloud.aiplatform.v1beta1.TFRecordDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.TFRecordDestinationOrBuilder>
        tfrecordDestinationBuilder_;

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     *
     * @return Whether the tfrecordDestination field is set.
     */
    @java.lang.Override
    public boolean hasTfrecordDestination() {
      return destinationCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     *
     * @return The tfrecordDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.TFRecordDestination getTfrecordDestination() {
      if (tfrecordDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.TFRecordDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 2) {
          return tfrecordDestinationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.TFRecordDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     */
    public Builder setTfrecordDestination(
        com.google.cloud.aiplatform.v1beta1.TFRecordDestination value) {
      if (tfrecordDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        tfrecordDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     */
    public Builder setTfrecordDestination(
        com.google.cloud.aiplatform.v1beta1.TFRecordDestination.Builder builderForValue) {
      if (tfrecordDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        tfrecordDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     */
    public Builder mergeTfrecordDestination(
        com.google.cloud.aiplatform.v1beta1.TFRecordDestination value) {
      if (tfrecordDestinationBuilder_ == null) {
        if (destinationCase_ == 2
            && destination_
                != com.google.cloud.aiplatform.v1beta1.TFRecordDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.TFRecordDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 2) {
          tfrecordDestinationBuilder_.mergeFrom(value);
        } else {
          tfrecordDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     */
    public Builder clearTfrecordDestination() {
      if (tfrecordDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
        }
        tfrecordDestinationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.TFRecordDestination.Builder
        getTfrecordDestinationBuilder() {
      return getTfrecordDestinationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.TFRecordDestinationOrBuilder
        getTfrecordDestinationOrBuilder() {
      if ((destinationCase_ == 2) && (tfrecordDestinationBuilder_ != null)) {
        return tfrecordDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.TFRecordDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output in TFRecord format.
     *
     * Below are the mapping from Feature value type
     * in Featurestore to Feature value type in TFRecord:
     *
     *     Value type in Featurestore                 | Value type in TFRecord
     *     DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
     *     INT64, INT64_ARRAY                         | INT64_LIST
     *     STRING, STRING_ARRAY, BYTES                | BYTES_LIST
     *     true -&gt; byte_string("true"), false -&gt; byte_string("false")
     *     BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TFRecordDestination tfrecord_destination = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TFRecordDestination,
            com.google.cloud.aiplatform.v1beta1.TFRecordDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.TFRecordDestinationOrBuilder>
        getTfrecordDestinationFieldBuilder() {
      if (tfrecordDestinationBuilder_ == null) {
        if (!(destinationCase_ == 2)) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.TFRecordDestination.getDefaultInstance();
        }
        tfrecordDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.TFRecordDestination,
                com.google.cloud.aiplatform.v1beta1.TFRecordDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.TFRecordDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.TFRecordDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 2;
      onChanged();
      return tfrecordDestinationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CsvDestination,
            com.google.cloud.aiplatform.v1beta1.CsvDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.CsvDestinationOrBuilder>
        csvDestinationBuilder_;

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     *
     * @return Whether the csvDestination field is set.
     */
    @java.lang.Override
    public boolean hasCsvDestination() {
      return destinationCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     *
     * @return The csvDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CsvDestination getCsvDestination() {
      if (csvDestinationBuilder_ == null) {
        if (destinationCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.CsvDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 3) {
          return csvDestinationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.CsvDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     */
    public Builder setCsvDestination(com.google.cloud.aiplatform.v1beta1.CsvDestination value) {
      if (csvDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        csvDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     */
    public Builder setCsvDestination(
        com.google.cloud.aiplatform.v1beta1.CsvDestination.Builder builderForValue) {
      if (csvDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        csvDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     */
    public Builder mergeCsvDestination(com.google.cloud.aiplatform.v1beta1.CsvDestination value) {
      if (csvDestinationBuilder_ == null) {
        if (destinationCase_ == 3
            && destination_
                != com.google.cloud.aiplatform.v1beta1.CsvDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.CsvDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 3) {
          csvDestinationBuilder_.mergeFrom(value);
        } else {
          csvDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     */
    public Builder clearCsvDestination() {
      if (csvDestinationBuilder_ == null) {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
        }
        csvDestinationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.CsvDestination.Builder getCsvDestinationBuilder() {
      return getCsvDestinationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CsvDestinationOrBuilder
        getCsvDestinationOrBuilder() {
      if ((destinationCase_ == 3) && (csvDestinationBuilder_ != null)) {
        return csvDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.CsvDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output in CSV format. Array Feature value types are not allowed in CSV
     * format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.CsvDestination csv_destination = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CsvDestination,
            com.google.cloud.aiplatform.v1beta1.CsvDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.CsvDestinationOrBuilder>
        getCsvDestinationFieldBuilder() {
      if (csvDestinationBuilder_ == null) {
        if (!(destinationCase_ == 3)) {
          destination_ = com.google.cloud.aiplatform.v1beta1.CsvDestination.getDefaultInstance();
        }
        csvDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CsvDestination,
                com.google.cloud.aiplatform.v1beta1.CsvDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.CsvDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.CsvDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 3;
      onChanged();
      return csvDestinationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureValueDestination)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureValueDestination)
  private static final com.google.cloud.aiplatform.v1beta1.FeatureValueDestination DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureValueDestination();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureValueDestination getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureValueDestination> PARSER =
      new com.google.protobuf.AbstractParser<FeatureValueDestination>() {
        @java.lang.Override
        public FeatureValueDestination parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureValueDestination> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureValueDestination> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureValueDestination getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
