/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/example_store_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A single example to upload or read from the Example Store.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Example}
 */
public final class Example extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Example)
    ExampleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Example.newBuilder() to construct.
  private Example(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Example() {
    displayName_ = "";
    exampleId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Example();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_Example_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_Example_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Example.class,
            com.google.cloud.aiplatform.v1beta1.Example.Builder.class);
  }

  private int bitField0_;
  private int exampleTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object exampleType_;

  public enum ExampleTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STORED_CONTENTS_EXAMPLE(6),
    EXAMPLETYPE_NOT_SET(0);
    private final int value;

    private ExampleTypeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExampleTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExampleTypeCase forNumber(int value) {
      switch (value) {
        case 6:
          return STORED_CONTENTS_EXAMPLE;
        case 0:
          return EXAMPLETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExampleTypeCase getExampleTypeCase() {
    return ExampleTypeCase.forNumber(exampleTypeCase_);
  }

  public static final int STORED_CONTENTS_EXAMPLE_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * An example of chat history and its expected outcome to be used with
   * GenerateContent.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
   * </code>
   *
   * @return Whether the storedContentsExample field is set.
   */
  @java.lang.Override
  public boolean hasStoredContentsExample() {
    return exampleTypeCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * An example of chat history and its expected outcome to be used with
   * GenerateContent.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
   * </code>
   *
   * @return The storedContentsExample.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StoredContentsExample getStoredContentsExample() {
    if (exampleTypeCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_;
    }
    return com.google.cloud.aiplatform.v1beta1.StoredContentsExample.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * An example of chat history and its expected outcome to be used with
   * GenerateContent.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StoredContentsExampleOrBuilder
      getStoredContentsExampleOrBuilder() {
    if (exampleTypeCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_;
    }
    return com.google.cloud.aiplatform.v1beta1.StoredContentsExample.getDefaultInstance();
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The display name for Example.
   * </pre>
   *
   * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The display name for Example.
   * </pre>
   *
   * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXAMPLE_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object exampleId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Unique identifier of an example. If not specified when
   * upserting new examples, the example_id will be generated.
   * </pre>
   *
   * <code>
   * string example_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The exampleId.
   */
  @java.lang.Override
  public java.lang.String getExampleId() {
    java.lang.Object ref = exampleId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      exampleId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Unique identifier of an example. If not specified when
   * upserting new examples, the example_id will be generated.
   * </pre>
   *
   * <code>
   * string example_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for exampleId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExampleIdBytes() {
    java.lang.Object ref = exampleId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      exampleId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Example was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Example was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Example was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, exampleId_);
    }
    if (exampleTypeCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, exampleId_);
    }
    if (exampleTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Example)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Example other =
        (com.google.cloud.aiplatform.v1beta1.Example) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getExampleId().equals(other.getExampleId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getExampleTypeCase().equals(other.getExampleTypeCase())) return false;
    switch (exampleTypeCase_) {
      case 6:
        if (!getStoredContentsExample().equals(other.getStoredContentsExample())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + EXAMPLE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getExampleId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    switch (exampleTypeCase_) {
      case 6:
        hash = (37 * hash) + STORED_CONTENTS_EXAMPLE_FIELD_NUMBER;
        hash = (53 * hash) + getStoredContentsExample().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Example parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Example prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A single example to upload or read from the Example Store.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Example}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Example)
      com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Example_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Example_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Example.class,
              com.google.cloud.aiplatform.v1beta1.Example.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Example.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (storedContentsExampleBuilder_ != null) {
        storedContentsExampleBuilder_.clear();
      }
      displayName_ = "";
      exampleId_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      exampleTypeCase_ = 0;
      exampleType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Example_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Example getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Example.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Example build() {
      com.google.cloud.aiplatform.v1beta1.Example result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Example buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Example result =
          new com.google.cloud.aiplatform.v1beta1.Example(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Example result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.exampleId_ = exampleId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.Example result) {
      result.exampleTypeCase_ = exampleTypeCase_;
      result.exampleType_ = this.exampleType_;
      if (exampleTypeCase_ == 6 && storedContentsExampleBuilder_ != null) {
        result.exampleType_ = storedContentsExampleBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Example) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Example) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Example other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Example.getDefaultInstance()) return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getExampleId().isEmpty()) {
        exampleId_ = other.exampleId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      switch (other.getExampleTypeCase()) {
        case STORED_CONTENTS_EXAMPLE:
          {
            mergeStoredContentsExample(other.getStoredContentsExample());
            break;
          }
        case EXAMPLETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 34:
              {
                exampleId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getStoredContentsExampleFieldBuilder().getBuilder(), extensionRegistry);
                exampleTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int exampleTypeCase_ = 0;
    private java.lang.Object exampleType_;

    public ExampleTypeCase getExampleTypeCase() {
      return ExampleTypeCase.forNumber(exampleTypeCase_);
    }

    public Builder clearExampleType() {
      exampleTypeCase_ = 0;
      exampleType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StoredContentsExample,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExample.Builder,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleOrBuilder>
        storedContentsExampleBuilder_;

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     *
     * @return Whether the storedContentsExample field is set.
     */
    @java.lang.Override
    public boolean hasStoredContentsExample() {
      return exampleTypeCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     *
     * @return The storedContentsExample.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StoredContentsExample getStoredContentsExample() {
      if (storedContentsExampleBuilder_ == null) {
        if (exampleTypeCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_;
        }
        return com.google.cloud.aiplatform.v1beta1.StoredContentsExample.getDefaultInstance();
      } else {
        if (exampleTypeCase_ == 6) {
          return storedContentsExampleBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.StoredContentsExample.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     */
    public Builder setStoredContentsExample(
        com.google.cloud.aiplatform.v1beta1.StoredContentsExample value) {
      if (storedContentsExampleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        exampleType_ = value;
        onChanged();
      } else {
        storedContentsExampleBuilder_.setMessage(value);
      }
      exampleTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     */
    public Builder setStoredContentsExample(
        com.google.cloud.aiplatform.v1beta1.StoredContentsExample.Builder builderForValue) {
      if (storedContentsExampleBuilder_ == null) {
        exampleType_ = builderForValue.build();
        onChanged();
      } else {
        storedContentsExampleBuilder_.setMessage(builderForValue.build());
      }
      exampleTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     */
    public Builder mergeStoredContentsExample(
        com.google.cloud.aiplatform.v1beta1.StoredContentsExample value) {
      if (storedContentsExampleBuilder_ == null) {
        if (exampleTypeCase_ == 6
            && exampleType_
                != com.google.cloud.aiplatform.v1beta1.StoredContentsExample.getDefaultInstance()) {
          exampleType_ =
              com.google.cloud.aiplatform.v1beta1.StoredContentsExample.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          exampleType_ = value;
        }
        onChanged();
      } else {
        if (exampleTypeCase_ == 6) {
          storedContentsExampleBuilder_.mergeFrom(value);
        } else {
          storedContentsExampleBuilder_.setMessage(value);
        }
      }
      exampleTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     */
    public Builder clearStoredContentsExample() {
      if (storedContentsExampleBuilder_ == null) {
        if (exampleTypeCase_ == 6) {
          exampleTypeCase_ = 0;
          exampleType_ = null;
          onChanged();
        }
      } else {
        if (exampleTypeCase_ == 6) {
          exampleTypeCase_ = 0;
          exampleType_ = null;
        }
        storedContentsExampleBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StoredContentsExample.Builder
        getStoredContentsExampleBuilder() {
      return getStoredContentsExampleFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StoredContentsExampleOrBuilder
        getStoredContentsExampleOrBuilder() {
      if ((exampleTypeCase_ == 6) && (storedContentsExampleBuilder_ != null)) {
        return storedContentsExampleBuilder_.getMessageOrBuilder();
      } else {
        if (exampleTypeCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_;
        }
        return com.google.cloud.aiplatform.v1beta1.StoredContentsExample.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An example of chat history and its expected outcome to be used with
     * GenerateContent.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StoredContentsExample stored_contents_example = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StoredContentsExample,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExample.Builder,
            com.google.cloud.aiplatform.v1beta1.StoredContentsExampleOrBuilder>
        getStoredContentsExampleFieldBuilder() {
      if (storedContentsExampleBuilder_ == null) {
        if (!(exampleTypeCase_ == 6)) {
          exampleType_ =
              com.google.cloud.aiplatform.v1beta1.StoredContentsExample.getDefaultInstance();
        }
        storedContentsExampleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StoredContentsExample,
                com.google.cloud.aiplatform.v1beta1.StoredContentsExample.Builder,
                com.google.cloud.aiplatform.v1beta1.StoredContentsExampleOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.StoredContentsExample) exampleType_,
                getParentForChildren(),
                isClean());
        exampleType_ = null;
      }
      exampleTypeCase_ = 6;
      onChanged();
      return storedContentsExampleBuilder_;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The display name for Example.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name for Example.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name for Example.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name for Example.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name for Example.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object exampleId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Unique identifier of an example. If not specified when
     * upserting new examples, the example_id will be generated.
     * </pre>
     *
     * <code>
     * string example_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The exampleId.
     */
    public java.lang.String getExampleId() {
      java.lang.Object ref = exampleId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exampleId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Unique identifier of an example. If not specified when
     * upserting new examples, the example_id will be generated.
     * </pre>
     *
     * <code>
     * string example_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for exampleId.
     */
    public com.google.protobuf.ByteString getExampleIdBytes() {
      java.lang.Object ref = exampleId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        exampleId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Unique identifier of an example. If not specified when
     * upserting new examples, the example_id will be generated.
     * </pre>
     *
     * <code>
     * string example_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The exampleId to set.
     * @return This builder for chaining.
     */
    public Builder setExampleId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      exampleId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Unique identifier of an example. If not specified when
     * upserting new examples, the example_id will be generated.
     * </pre>
     *
     * <code>
     * string example_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleId() {
      exampleId_ = getDefaultInstance().getExampleId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Unique identifier of an example. If not specified when
     * upserting new examples, the example_id will be generated.
     * </pre>
     *
     * <code>
     * string example_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for exampleId to set.
     * @return This builder for chaining.
     */
    public Builder setExampleIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      exampleId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Example was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Example)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Example)
  private static final com.google.cloud.aiplatform.v1beta1.Example DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Example();
  }

  public static com.google.cloud.aiplatform.v1beta1.Example getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Example> PARSER =
      new com.google.protobuf.AbstractParser<Example>() {
        @java.lang.Override
        public Example parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Example> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Example> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Example getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
