/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.UploadModelRequest}
 */
public final class UploadModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.UploadModelRequest)
    UploadModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UploadModelRequest.newBuilder() to construct.
  private UploadModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UploadModelRequest() {
    parent_ = "";
    parentModel_ = "";
    modelId_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UploadModelRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_UploadModelRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_UploadModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.UploadModelRequest.class,
            com.google.cloud.aiplatform.v1beta1.UploadModelRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location into which to upload the Model.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location into which to upload the Model.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_MODEL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentModel_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the model into which to upload the version.
   * Only specify this field when uploading a new version.
   * </pre>
   *
   * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The parentModel.
   */
  @java.lang.Override
  public java.lang.String getParentModel() {
    java.lang.Object ref = parentModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentModel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the model into which to upload the version.
   * Only specify this field when uploading a new version.
   * </pre>
   *
   * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for parentModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentModelBytes() {
    java.lang.Object ref = parentModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The ID to use for the uploaded Model, which will become the final
   * component of the model resource name.
   *
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The modelId.
   */
  @java.lang.Override
  public java.lang.String getModelId() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The ID to use for the uploaded Model, which will become the final
   * component of the model resource name.
   *
   * This value may be up to 63 characters, and valid characters are
   * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
   * </pre>
   *
   * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for modelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelIdBytes() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.Model model_;
  /**
   *
   *
   * <pre>
   * Required. The Model to create.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the model field is set.
   */
  @java.lang.Override
  public boolean hasModel() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The Model to create.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The model.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Model getModel() {
    return model_ == null ? com.google.cloud.aiplatform.v1beta1.Model.getDefaultInstance() : model_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Model to create.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelOrBuilder getModelOrBuilder() {
    return model_ == null ? com.google.cloud.aiplatform.v1beta1.Model.getDefaultInstance() : model_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The user-provided custom service account to use to do the model
   * upload. If empty, [Vertex AI Service
   * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
   * will be used to access resources needed to upload the model. This account
   * must belong to the target project where the model is uploaded to, i.e., the
   * project specified in the `parent` field of this request and have necessary
   * read permissions (to Google Cloud Storage, Artifact Registry, etc.).
   * </pre>
   *
   * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The user-provided custom service account to use to do the model
   * upload. If empty, [Vertex AI Service
   * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
   * will be used to access resources needed to upload the model. This account
   * must belong to the target project where the model is uploaded to, i.e., the
   * project specified in the `parent` field of this request and have necessary
   * read permissions (to Google Cloud Storage, Artifact Registry, etc.).
   * </pre>
   *
   * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getModel());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parentModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, serviceAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getModel());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, parentModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, serviceAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.UploadModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.UploadModelRequest other =
        (com.google.cloud.aiplatform.v1beta1.UploadModelRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getParentModel().equals(other.getParentModel())) return false;
    if (!getModelId().equals(other.getModelId())) return false;
    if (hasModel() != other.hasModel()) return false;
    if (hasModel()) {
      if (!getModel().equals(other.getModel())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PARENT_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getParentModel().hashCode();
    hash = (37 * hash) + MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelId().hashCode();
    if (hasModel()) {
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.UploadModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.UploadModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.UploadModelRequest)
      com.google.cloud.aiplatform.v1beta1.UploadModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_UploadModelRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_UploadModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.UploadModelRequest.class,
              com.google.cloud.aiplatform.v1beta1.UploadModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.UploadModelRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getModelFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      parentModel_ = "";
      modelId_ = "";
      model_ = null;
      if (modelBuilder_ != null) {
        modelBuilder_.dispose();
        modelBuilder_ = null;
      }
      serviceAccount_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_UploadModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.UploadModelRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.UploadModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.UploadModelRequest build() {
      com.google.cloud.aiplatform.v1beta1.UploadModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.UploadModelRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.UploadModelRequest result =
          new com.google.cloud.aiplatform.v1beta1.UploadModelRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.UploadModelRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parentModel_ = parentModel_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modelId_ = modelId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.model_ = modelBuilder_ == null ? model_ : modelBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.UploadModelRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.UploadModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.UploadModelRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.UploadModelRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getParentModel().isEmpty()) {
        parentModel_ = other.parentModel_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getModelId().isEmpty()) {
        modelId_ = other.modelId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasModel()) {
        mergeModel(other.getModel());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getModelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 34:
              {
                parentModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 42:
              {
                modelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to upload the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to upload the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to upload the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to upload the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location into which to upload the Model.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object parentModel_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the model into which to upload the version.
     * Only specify this field when uploading a new version.
     * </pre>
     *
     * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The parentModel.
     */
    public java.lang.String getParentModel() {
      java.lang.Object ref = parentModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the model into which to upload the version.
     * Only specify this field when uploading a new version.
     * </pre>
     *
     * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for parentModel.
     */
    public com.google.protobuf.ByteString getParentModelBytes() {
      java.lang.Object ref = parentModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the model into which to upload the version.
     * Only specify this field when uploading a new version.
     * </pre>
     *
     * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The parentModel to set.
     * @return This builder for chaining.
     */
    public Builder setParentModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentModel_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the model into which to upload the version.
     * Only specify this field when uploading a new version.
     * </pre>
     *
     * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentModel() {
      parentModel_ = getDefaultInstance().getParentModel();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the model into which to upload the version.
     * Only specify this field when uploading a new version.
     * </pre>
     *
     * <code>string parent_model = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for parentModel to set.
     * @return This builder for chaining.
     */
    public Builder setParentModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentModel_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object modelId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelId.
     */
    public java.lang.String getModelId() {
      java.lang.Object ref = modelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelId.
     */
    public com.google.protobuf.ByteString getModelIdBytes() {
      java.lang.Object ref = modelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelId() {
      modelId_ = getDefaultInstance().getModelId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID to use for the uploaded Model, which will become the final
     * component of the model resource name.
     *
     * This value may be up to 63 characters, and valid characters are
     * `[a-z0-9_-]`. The first character cannot be a number or hyphen.
     * </pre>
     *
     * <code>string model_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.Model model_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Model,
            com.google.cloud.aiplatform.v1beta1.Model.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelOrBuilder>
        modelBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the model field is set.
     */
    public boolean hasModel() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The model.
     */
    public com.google.cloud.aiplatform.v1beta1.Model getModel() {
      if (modelBuilder_ == null) {
        return model_ == null
            ? com.google.cloud.aiplatform.v1beta1.Model.getDefaultInstance()
            : model_;
      } else {
        return modelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModel(com.google.cloud.aiplatform.v1beta1.Model value) {
      if (modelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
      } else {
        modelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModel(com.google.cloud.aiplatform.v1beta1.Model.Builder builderForValue) {
      if (modelBuilder_ == null) {
        model_ = builderForValue.build();
      } else {
        modelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeModel(com.google.cloud.aiplatform.v1beta1.Model value) {
      if (modelBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && model_ != null
            && model_ != com.google.cloud.aiplatform.v1beta1.Model.getDefaultInstance()) {
          getModelBuilder().mergeFrom(value);
        } else {
          model_ = value;
        }
      } else {
        modelBuilder_.mergeFrom(value);
      }
      if (model_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearModel() {
      bitField0_ = (bitField0_ & ~0x00000008);
      model_ = null;
      if (modelBuilder_ != null) {
        modelBuilder_.dispose();
        modelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Model.Builder getModelBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getModelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelOrBuilder getModelOrBuilder() {
      if (modelBuilder_ != null) {
        return modelBuilder_.getMessageOrBuilder();
      } else {
        return model_ == null
            ? com.google.cloud.aiplatform.v1beta1.Model.getDefaultInstance()
            : model_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Model to create.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Model model = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Model,
            com.google.cloud.aiplatform.v1beta1.Model.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelOrBuilder>
        getModelFieldBuilder() {
      if (modelBuilder_ == null) {
        modelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Model,
                com.google.cloud.aiplatform.v1beta1.Model.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelOrBuilder>(
                getModel(), getParentForChildren(), isClean());
        model_ = null;
      }
      return modelBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The user-provided custom service account to use to do the model
     * upload. If empty, [Vertex AI Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * will be used to access resources needed to upload the model. This account
     * must belong to the target project where the model is uploaded to, i.e., the
     * project specified in the `parent` field of this request and have necessary
     * read permissions (to Google Cloud Storage, Artifact Registry, etc.).
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-provided custom service account to use to do the model
     * upload. If empty, [Vertex AI Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * will be used to access resources needed to upload the model. This account
     * must belong to the target project where the model is uploaded to, i.e., the
     * project specified in the `parent` field of this request and have necessary
     * read permissions (to Google Cloud Storage, Artifact Registry, etc.).
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-provided custom service account to use to do the model
     * upload. If empty, [Vertex AI Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * will be used to access resources needed to upload the model. This account
     * must belong to the target project where the model is uploaded to, i.e., the
     * project specified in the `parent` field of this request and have necessary
     * read permissions (to Google Cloud Storage, Artifact Registry, etc.).
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-provided custom service account to use to do the model
     * upload. If empty, [Vertex AI Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * will be used to access resources needed to upload the model. This account
     * must belong to the target project where the model is uploaded to, i.e., the
     * project specified in the `parent` field of this request and have necessary
     * read permissions (to Google Cloud Storage, Artifact Registry, etc.).
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-provided custom service account to use to do the model
     * upload. If empty, [Vertex AI Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * will be used to access resources needed to upload the model. This account
     * must belong to the target project where the model is uploaded to, i.e., the
     * project specified in the `parent` field of this request and have necessary
     * read permissions (to Google Cloud Storage, Artifact Registry, etc.).
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.UploadModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.UploadModelRequest)
  private static final com.google.cloud.aiplatform.v1beta1.UploadModelRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.UploadModelRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.UploadModelRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UploadModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<UploadModelRequest>() {
        @java.lang.Override
        public UploadModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UploadModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UploadModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.UploadModelRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
