/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/notebook_execution_job.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

public interface NotebookExecutionJobOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NotebookExecutionJob)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The Dataform Repository pointing to a single file notebook repository.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
   * </code>
   *
   * @return Whether the dataformRepositorySource field is set.
   */
  boolean hasDataformRepositorySource();
  /**
   *
   *
   * <pre>
   * The Dataform Repository pointing to a single file notebook repository.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
   * </code>
   *
   * @return The dataformRepositorySource.
   */
  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
      getDataformRepositorySource();
  /**
   *
   *
   * <pre>
   * The Dataform Repository pointing to a single file notebook repository.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySourceOrBuilder
      getDataformRepositorySourceOrBuilder();

  /**
   *
   *
   * <pre>
   * The Cloud Storage url pointing to the ipynb file. Format:
   * `gs://bucket/notebook_file.ipynb`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
   * </code>
   *
   * @return Whether the gcsNotebookSource field is set.
   */
  boolean hasGcsNotebookSource();
  /**
   *
   *
   * <pre>
   * The Cloud Storage url pointing to the ipynb file. Format:
   * `gs://bucket/notebook_file.ipynb`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
   * </code>
   *
   * @return The gcsNotebookSource.
   */
  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource getGcsNotebookSource();
  /**
   *
   *
   * <pre>
   * The Cloud Storage url pointing to the ipynb file. Format:
   * `gs://bucket/notebook_file.ipynb`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSourceOrBuilder
      getGcsNotebookSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * The contents of an input notebook file.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
   * </code>
   *
   * @return Whether the directNotebookSource field is set.
   */
  boolean hasDirectNotebookSource();
  /**
   *
   *
   * <pre>
   * The contents of an input notebook file.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
   * </code>
   *
   * @return The directNotebookSource.
   */
  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
      getDirectNotebookSource();
  /**
   *
   *
   * <pre>
   * The contents of an input notebook file.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSourceOrBuilder
      getDirectNotebookSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * The NotebookRuntimeTemplate to source compute configuration from.
   * </pre>
   *
   * <code>
   * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the notebookRuntimeTemplateResourceName field is set.
   */
  boolean hasNotebookRuntimeTemplateResourceName();
  /**
   *
   *
   * <pre>
   * The NotebookRuntimeTemplate to source compute configuration from.
   * </pre>
   *
   * <code>
   * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The notebookRuntimeTemplateResourceName.
   */
  java.lang.String getNotebookRuntimeTemplateResourceName();
  /**
   *
   *
   * <pre>
   * The NotebookRuntimeTemplate to source compute configuration from.
   * </pre>
   *
   * <code>
   * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for notebookRuntimeTemplateResourceName.
   */
  com.google.protobuf.ByteString getNotebookRuntimeTemplateResourceNameBytes();

  /**
   *
   *
   * <pre>
   * The Cloud Storage location to upload the result to. Format:
   * `gs://bucket-name`
   * </pre>
   *
   * <code>string gcs_output_uri = 8;</code>
   *
   * @return Whether the gcsOutputUri field is set.
   */
  boolean hasGcsOutputUri();
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to upload the result to. Format:
   * `gs://bucket-name`
   * </pre>
   *
   * <code>string gcs_output_uri = 8;</code>
   *
   * @return The gcsOutputUri.
   */
  java.lang.String getGcsOutputUri();
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to upload the result to. Format:
   * `gs://bucket-name`
   * </pre>
   *
   * <code>string gcs_output_uri = 8;</code>
   *
   * @return The bytes for gcsOutputUri.
   */
  com.google.protobuf.ByteString getGcsOutputUriBytes();

  /**
   *
   *
   * <pre>
   * The user email to run the execution as. Only supported by Colab runtimes.
   * </pre>
   *
   * <code>string execution_user = 9;</code>
   *
   * @return Whether the executionUser field is set.
   */
  boolean hasExecutionUser();
  /**
   *
   *
   * <pre>
   * The user email to run the execution as. Only supported by Colab runtimes.
   * </pre>
   *
   * <code>string execution_user = 9;</code>
   *
   * @return The executionUser.
   */
  java.lang.String getExecutionUser();
  /**
   *
   *
   * <pre>
   * The user email to run the execution as. Only supported by Colab runtimes.
   * </pre>
   *
   * <code>string execution_user = 9;</code>
   *
   * @return The bytes for executionUser.
   */
  com.google.protobuf.ByteString getExecutionUserBytes();

  /**
   *
   *
   * <pre>
   * The service account to run the execution as.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return Whether the serviceAccount field is set.
   */
  boolean hasServiceAccount();
  /**
   *
   *
   * <pre>
   * The service account to run the execution as.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return The serviceAccount.
   */
  java.lang.String getServiceAccount();
  /**
   *
   *
   * <pre>
   * The service account to run the execution as.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return The bytes for serviceAccount.
   */
  com.google.protobuf.ByteString getServiceAccountBytes();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of this NotebookExecutionJob. Format:
   * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of this NotebookExecutionJob. Format:
   * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The display name of the NotebookExecutionJob. The name can be up to 128
   * characters long and can consist of any UTF-8 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * The display name of the NotebookExecutionJob. The name can be up to 128
   * characters long and can consist of any UTF-8 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Max running time of the execution job in seconds (default 86400s / 24 hrs).
   * </pre>
   *
   * <code>.google.protobuf.Duration execution_timeout = 5;</code>
   *
   * @return Whether the executionTimeout field is set.
   */
  boolean hasExecutionTimeout();
  /**
   *
   *
   * <pre>
   * Max running time of the execution job in seconds (default 86400s / 24 hrs).
   * </pre>
   *
   * <code>.google.protobuf.Duration execution_timeout = 5;</code>
   *
   * @return The executionTimeout.
   */
  com.google.protobuf.Duration getExecutionTimeout();
  /**
   *
   *
   * <pre>
   * Max running time of the execution job in seconds (default 86400s / 24 hrs).
   * </pre>
   *
   * <code>.google.protobuf.Duration execution_timeout = 5;</code>
   */
  com.google.protobuf.DurationOrBuilder getExecutionTimeoutOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The Schedule resource name if this job is triggered by one.
   * Format:
   * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
   * </pre>
   *
   * <code>
   * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The scheduleResourceName.
   */
  java.lang.String getScheduleResourceName();
  /**
   *
   *
   * <pre>
   * Output only. The Schedule resource name if this job is triggered by one.
   * Format:
   * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
   * </pre>
   *
   * <code>
   * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for scheduleResourceName.
   */
  com.google.protobuf.ByteString getScheduleResourceNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The state of the NotebookExecutionJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for jobState.
   */
  int getJobStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The state of the NotebookExecutionJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The jobState.
   */
  com.google.cloud.aiplatform.v1beta1.JobState getJobState();

  /**
   *
   *
   * <pre>
   * Output only. Populated when the NotebookExecutionJob is completed. When
   * there is an error during notebook execution, the error details are
   * populated.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();
  /**
   *
   *
   * <pre>
   * Output only. Populated when the NotebookExecutionJob is completed. When
   * there is an error during notebook execution, the error details are
   * populated.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The status.
   */
  com.google.rpc.Status getStatus();
  /**
   *
   *
   * <pre>
   * Output only. Populated when the NotebookExecutionJob is completed. When
   * there is an error during notebook execution, the error details are
   * populated.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  com.google.rpc.StatusOrBuilder getStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook execution job.
   * This field is auto-populated if the
   * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  boolean hasEncryptionSpec();
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook execution job.
   * This field is auto-populated if the
   * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
   *
   * @return The encryptionSpec.
   */
  com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec();
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook execution job.
   * This field is auto-populated if the
   * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
   */
  com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder();

  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.NotebookSourceCase
      getNotebookSourceCase();

  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.EnvironmentSpecCase
      getEnvironmentSpecCase();

  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.ExecutionSinkCase getExecutionSinkCase();

  com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.ExecutionIdentityCase
      getExecutionIdentityCase();
}
