/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/nas_job.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a uCAIP NasJob output.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobOutput}
 */
public final class NasJobOutput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NasJobOutput)
    NasJobOutputOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NasJobOutput.newBuilder() to construct.
  private NasJobOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NasJobOutput() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NasJobOutput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.NasJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.NasJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.class,
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.Builder.class);
  }

  public interface MultiTrialJobOutputOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> getSearchTrialsList();
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.NasTrial getSearchTrials(int index);
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getSearchTrialsCount();
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
        getSearchTrialsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder getSearchTrialsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> getTrainTrialsList();
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.NasTrial getTrainTrials(int index);
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getTrainTrialsCount();
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
        getTrainTrialsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder getTrainTrialsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The output of a multi-trial Neural Architecture Search (NAS) jobs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput}
   */
  public static final class MultiTrialJobOutput extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput)
      MultiTrialJobOutputOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MultiTrialJobOutput.newBuilder() to construct.
    private MultiTrialJobOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MultiTrialJobOutput() {
      searchTrials_ = java.util.Collections.emptyList();
      trainTrials_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MultiTrialJobOutput();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_MultiTrialJobOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_MultiTrialJobOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.class,
              com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.Builder.class);
    }

    public static final int SEARCH_TRIALS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> searchTrials_;
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> getSearchTrialsList() {
      return searchTrials_;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
        getSearchTrialsOrBuilderList() {
      return searchTrials_;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getSearchTrialsCount() {
      return searchTrials_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasTrial getSearchTrials(int index) {
      return searchTrials_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of search stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder getSearchTrialsOrBuilder(
        int index) {
      return searchTrials_.get(index);
    }

    public static final int TRAIN_TRIALS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> trainTrials_;
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> getTrainTrialsList() {
      return trainTrials_;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
        getTrainTrialsOrBuilderList() {
      return trainTrials_;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getTrainTrialsCount() {
      return trainTrials_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasTrial getTrainTrials(int index) {
      return trainTrials_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of NasTrials that were started as part of train stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder getTrainTrialsOrBuilder(
        int index) {
      return trainTrials_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < searchTrials_.size(); i++) {
        output.writeMessage(1, searchTrials_.get(i));
      }
      for (int i = 0; i < trainTrials_.size(); i++) {
        output.writeMessage(2, trainTrials_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < searchTrials_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, searchTrials_.get(i));
      }
      for (int i = 0; i < trainTrials_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, trainTrials_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput other =
          (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) obj;

      if (!getSearchTrialsList().equals(other.getSearchTrialsList())) return false;
      if (!getTrainTrialsList().equals(other.getTrainTrialsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSearchTrialsCount() > 0) {
        hash = (37 * hash) + SEARCH_TRIALS_FIELD_NUMBER;
        hash = (53 * hash) + getSearchTrialsList().hashCode();
      }
      if (getTrainTrialsCount() > 0) {
        hash = (37 * hash) + TRAIN_TRIALS_FIELD_NUMBER;
        hash = (53 * hash) + getTrainTrialsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The output of a multi-trial Neural Architecture Search (NAS) jobs.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput)
        com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_MultiTrialJobOutput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_MultiTrialJobOutput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.class,
                com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (searchTrialsBuilder_ == null) {
          searchTrials_ = java.util.Collections.emptyList();
        } else {
          searchTrials_ = null;
          searchTrialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (trainTrialsBuilder_ == null) {
          trainTrials_ = java.util.Collections.emptyList();
        } else {
          trainTrials_ = null;
          trainTrialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_MultiTrialJobOutput_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput build() {
        com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput result =
            new com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput result) {
        if (searchTrialsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            searchTrials_ = java.util.Collections.unmodifiableList(searchTrials_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.searchTrials_ = searchTrials_;
        } else {
          result.searchTrials_ = searchTrialsBuilder_.build();
        }
        if (trainTrialsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            trainTrials_ = java.util.Collections.unmodifiableList(trainTrials_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.trainTrials_ = trainTrials_;
        } else {
          result.trainTrials_ = trainTrialsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
                .getDefaultInstance()) return this;
        if (searchTrialsBuilder_ == null) {
          if (!other.searchTrials_.isEmpty()) {
            if (searchTrials_.isEmpty()) {
              searchTrials_ = other.searchTrials_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSearchTrialsIsMutable();
              searchTrials_.addAll(other.searchTrials_);
            }
            onChanged();
          }
        } else {
          if (!other.searchTrials_.isEmpty()) {
            if (searchTrialsBuilder_.isEmpty()) {
              searchTrialsBuilder_.dispose();
              searchTrialsBuilder_ = null;
              searchTrials_ = other.searchTrials_;
              bitField0_ = (bitField0_ & ~0x00000001);
              searchTrialsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSearchTrialsFieldBuilder()
                      : null;
            } else {
              searchTrialsBuilder_.addAllMessages(other.searchTrials_);
            }
          }
        }
        if (trainTrialsBuilder_ == null) {
          if (!other.trainTrials_.isEmpty()) {
            if (trainTrials_.isEmpty()) {
              trainTrials_ = other.trainTrials_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTrainTrialsIsMutable();
              trainTrials_.addAll(other.trainTrials_);
            }
            onChanged();
          }
        } else {
          if (!other.trainTrials_.isEmpty()) {
            if (trainTrialsBuilder_.isEmpty()) {
              trainTrialsBuilder_.dispose();
              trainTrialsBuilder_ = null;
              trainTrials_ = other.trainTrials_;
              bitField0_ = (bitField0_ & ~0x00000002);
              trainTrialsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTrainTrialsFieldBuilder()
                      : null;
            } else {
              trainTrialsBuilder_.addAllMessages(other.trainTrials_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1beta1.NasTrial m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.NasTrial.parser(), extensionRegistry);
                  if (searchTrialsBuilder_ == null) {
                    ensureSearchTrialsIsMutable();
                    searchTrials_.add(m);
                  } else {
                    searchTrialsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.aiplatform.v1beta1.NasTrial m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.NasTrial.parser(), extensionRegistry);
                  if (trainTrialsBuilder_ == null) {
                    ensureTrainTrialsIsMutable();
                    trainTrials_.add(m);
                  } else {
                    trainTrialsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> searchTrials_ =
          java.util.Collections.emptyList();

      private void ensureSearchTrialsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          searchTrials_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.NasTrial>(searchTrials_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasTrial,
              com.google.cloud.aiplatform.v1beta1.NasTrial.Builder,
              com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
          searchTrialsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> getSearchTrialsList() {
        if (searchTrialsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(searchTrials_);
        } else {
          return searchTrialsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getSearchTrialsCount() {
        if (searchTrialsBuilder_ == null) {
          return searchTrials_.size();
        } else {
          return searchTrialsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial getSearchTrials(int index) {
        if (searchTrialsBuilder_ == null) {
          return searchTrials_.get(index);
        } else {
          return searchTrialsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSearchTrials(
          int index, com.google.cloud.aiplatform.v1beta1.NasTrial value) {
        if (searchTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSearchTrialsIsMutable();
          searchTrials_.set(index, value);
          onChanged();
        } else {
          searchTrialsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSearchTrials(
          int index, com.google.cloud.aiplatform.v1beta1.NasTrial.Builder builderForValue) {
        if (searchTrialsBuilder_ == null) {
          ensureSearchTrialsIsMutable();
          searchTrials_.set(index, builderForValue.build());
          onChanged();
        } else {
          searchTrialsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSearchTrials(com.google.cloud.aiplatform.v1beta1.NasTrial value) {
        if (searchTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSearchTrialsIsMutable();
          searchTrials_.add(value);
          onChanged();
        } else {
          searchTrialsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSearchTrials(
          int index, com.google.cloud.aiplatform.v1beta1.NasTrial value) {
        if (searchTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSearchTrialsIsMutable();
          searchTrials_.add(index, value);
          onChanged();
        } else {
          searchTrialsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSearchTrials(
          com.google.cloud.aiplatform.v1beta1.NasTrial.Builder builderForValue) {
        if (searchTrialsBuilder_ == null) {
          ensureSearchTrialsIsMutable();
          searchTrials_.add(builderForValue.build());
          onChanged();
        } else {
          searchTrialsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSearchTrials(
          int index, com.google.cloud.aiplatform.v1beta1.NasTrial.Builder builderForValue) {
        if (searchTrialsBuilder_ == null) {
          ensureSearchTrialsIsMutable();
          searchTrials_.add(index, builderForValue.build());
          onChanged();
        } else {
          searchTrialsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllSearchTrials(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.NasTrial> values) {
        if (searchTrialsBuilder_ == null) {
          ensureSearchTrialsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, searchTrials_);
          onChanged();
        } else {
          searchTrialsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearSearchTrials() {
        if (searchTrialsBuilder_ == null) {
          searchTrials_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          searchTrialsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeSearchTrials(int index) {
        if (searchTrialsBuilder_ == null) {
          ensureSearchTrialsIsMutable();
          searchTrials_.remove(index);
          onChanged();
        } else {
          searchTrialsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial.Builder getSearchTrialsBuilder(
          int index) {
        return getSearchTrialsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder getSearchTrialsOrBuilder(
          int index) {
        if (searchTrialsBuilder_ == null) {
          return searchTrials_.get(index);
        } else {
          return searchTrialsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
          getSearchTrialsOrBuilderList() {
        if (searchTrialsBuilder_ != null) {
          return searchTrialsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(searchTrials_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial.Builder addSearchTrialsBuilder() {
        return getSearchTrialsFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1beta1.NasTrial.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial.Builder addSearchTrialsBuilder(
          int index) {
        return getSearchTrialsFieldBuilder()
            .addBuilder(index, com.google.cloud.aiplatform.v1beta1.NasTrial.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of search stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial search_trials = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial.Builder>
          getSearchTrialsBuilderList() {
        return getSearchTrialsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasTrial,
              com.google.cloud.aiplatform.v1beta1.NasTrial.Builder,
              com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
          getSearchTrialsFieldBuilder() {
        if (searchTrialsBuilder_ == null) {
          searchTrialsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.NasTrial,
                  com.google.cloud.aiplatform.v1beta1.NasTrial.Builder,
                  com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>(
                  searchTrials_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          searchTrials_ = null;
        }
        return searchTrialsBuilder_;
      }

      private java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> trainTrials_ =
          java.util.Collections.emptyList();

      private void ensureTrainTrialsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          trainTrials_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.NasTrial>(trainTrials_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasTrial,
              com.google.cloud.aiplatform.v1beta1.NasTrial.Builder,
              com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
          trainTrialsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial> getTrainTrialsList() {
        if (trainTrialsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(trainTrials_);
        } else {
          return trainTrialsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getTrainTrialsCount() {
        if (trainTrialsBuilder_ == null) {
          return trainTrials_.size();
        } else {
          return trainTrialsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial getTrainTrials(int index) {
        if (trainTrialsBuilder_ == null) {
          return trainTrials_.get(index);
        } else {
          return trainTrialsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTrainTrials(int index, com.google.cloud.aiplatform.v1beta1.NasTrial value) {
        if (trainTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTrainTrialsIsMutable();
          trainTrials_.set(index, value);
          onChanged();
        } else {
          trainTrialsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTrainTrials(
          int index, com.google.cloud.aiplatform.v1beta1.NasTrial.Builder builderForValue) {
        if (trainTrialsBuilder_ == null) {
          ensureTrainTrialsIsMutable();
          trainTrials_.set(index, builderForValue.build());
          onChanged();
        } else {
          trainTrialsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addTrainTrials(com.google.cloud.aiplatform.v1beta1.NasTrial value) {
        if (trainTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTrainTrialsIsMutable();
          trainTrials_.add(value);
          onChanged();
        } else {
          trainTrialsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addTrainTrials(int index, com.google.cloud.aiplatform.v1beta1.NasTrial value) {
        if (trainTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTrainTrialsIsMutable();
          trainTrials_.add(index, value);
          onChanged();
        } else {
          trainTrialsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addTrainTrials(
          com.google.cloud.aiplatform.v1beta1.NasTrial.Builder builderForValue) {
        if (trainTrialsBuilder_ == null) {
          ensureTrainTrialsIsMutable();
          trainTrials_.add(builderForValue.build());
          onChanged();
        } else {
          trainTrialsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addTrainTrials(
          int index, com.google.cloud.aiplatform.v1beta1.NasTrial.Builder builderForValue) {
        if (trainTrialsBuilder_ == null) {
          ensureTrainTrialsIsMutable();
          trainTrials_.add(index, builderForValue.build());
          onChanged();
        } else {
          trainTrialsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllTrainTrials(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.NasTrial> values) {
        if (trainTrialsBuilder_ == null) {
          ensureTrainTrialsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, trainTrials_);
          onChanged();
        } else {
          trainTrialsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearTrainTrials() {
        if (trainTrialsBuilder_ == null) {
          trainTrials_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          trainTrialsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeTrainTrials(int index) {
        if (trainTrialsBuilder_ == null) {
          ensureTrainTrialsIsMutable();
          trainTrials_.remove(index);
          onChanged();
        } else {
          trainTrialsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial.Builder getTrainTrialsBuilder(int index) {
        return getTrainTrialsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder getTrainTrialsOrBuilder(
          int index) {
        if (trainTrialsBuilder_ == null) {
          return trainTrials_.get(index);
        } else {
          return trainTrialsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
          getTrainTrialsOrBuilderList() {
        if (trainTrialsBuilder_ != null) {
          return trainTrialsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(trainTrials_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial.Builder addTrainTrialsBuilder() {
        return getTrainTrialsFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1beta1.NasTrial.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasTrial.Builder addTrainTrialsBuilder(int index) {
        return getTrainTrialsFieldBuilder()
            .addBuilder(index, com.google.cloud.aiplatform.v1beta1.NasTrial.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. List of NasTrials that were started as part of train stage.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.NasTrial train_trials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.NasTrial.Builder>
          getTrainTrialsBuilderList() {
        return getTrainTrialsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasTrial,
              com.google.cloud.aiplatform.v1beta1.NasTrial.Builder,
              com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>
          getTrainTrialsFieldBuilder() {
        if (trainTrialsBuilder_ == null) {
          trainTrialsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.NasTrial,
                  com.google.cloud.aiplatform.v1beta1.NasTrial.Builder,
                  com.google.cloud.aiplatform.v1beta1.NasTrialOrBuilder>(
                  trainTrials_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          trainTrials_ = null;
        }
        return trainTrialsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput)
    private static final com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput();
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MultiTrialJobOutput> PARSER =
        new com.google.protobuf.AbstractParser<MultiTrialJobOutput>() {
          @java.lang.Override
          public MultiTrialJobOutput parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MultiTrialJobOutput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MultiTrialJobOutput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int outputCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object output_;

  public enum OutputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MULTI_TRIAL_JOB_OUTPUT(1),
    OUTPUT_NOT_SET(0);
    private final int value;

    private OutputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OutputCase valueOf(int value) {
      return forNumber(value);
    }

    public static OutputCase forNumber(int value) {
      switch (value) {
        case 1:
          return MULTI_TRIAL_JOB_OUTPUT;
        case 0:
          return OUTPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OutputCase getOutputCase() {
    return OutputCase.forNumber(outputCase_);
  }

  public static final int MULTI_TRIAL_JOB_OUTPUT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Output only. The output of this multi-trial Neural Architecture Search
   * (NAS) job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the multiTrialJobOutput field is set.
   */
  @java.lang.Override
  public boolean hasMultiTrialJobOutput() {
    return outputCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Output only. The output of this multi-trial Neural Architecture Search
   * (NAS) job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The multiTrialJobOutput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
      getMultiTrialJobOutput() {
    if (outputCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) output_;
    }
    return com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. The output of this multi-trial Neural Architecture Search
   * (NAS) job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutputOrBuilder
      getMultiTrialJobOutputOrBuilder() {
    if (outputCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) output_;
    }
    return com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (outputCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) output_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (outputCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) output_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NasJobOutput)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.NasJobOutput other =
        (com.google.cloud.aiplatform.v1beta1.NasJobOutput) obj;

    if (!getOutputCase().equals(other.getOutputCase())) return false;
    switch (outputCase_) {
      case 1:
        if (!getMultiTrialJobOutput().equals(other.getMultiTrialJobOutput())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (outputCase_) {
      case 1:
        hash = (37 * hash) + MULTI_TRIAL_JOB_OUTPUT_FIELD_NUMBER;
        hash = (53 * hash) + getMultiTrialJobOutput().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.NasJobOutput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a uCAIP NasJob output.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobOutput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NasJobOutput)
      com.google.cloud.aiplatform.v1beta1.NasJobOutputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NasJobOutput.class,
              com.google.cloud.aiplatform.v1beta1.NasJobOutput.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.NasJobOutput.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (multiTrialJobOutputBuilder_ != null) {
        multiTrialJobOutputBuilder_.clear();
      }
      outputCase_ = 0;
      output_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobOutput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobOutput getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.NasJobOutput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobOutput build() {
      com.google.cloud.aiplatform.v1beta1.NasJobOutput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobOutput buildPartial() {
      com.google.cloud.aiplatform.v1beta1.NasJobOutput result =
          new com.google.cloud.aiplatform.v1beta1.NasJobOutput(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.NasJobOutput result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.NasJobOutput result) {
      result.outputCase_ = outputCase_;
      result.output_ = this.output_;
      if (outputCase_ == 1 && multiTrialJobOutputBuilder_ != null) {
        result.output_ = multiTrialJobOutputBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.NasJobOutput) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.NasJobOutput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.NasJobOutput other) {
      if (other == com.google.cloud.aiplatform.v1beta1.NasJobOutput.getDefaultInstance())
        return this;
      switch (other.getOutputCase()) {
        case MULTI_TRIAL_JOB_OUTPUT:
          {
            mergeMultiTrialJobOutput(other.getMultiTrialJobOutput());
            break;
          }
        case OUTPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getMultiTrialJobOutputFieldBuilder().getBuilder(), extensionRegistry);
                outputCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int outputCase_ = 0;
    private java.lang.Object output_;

    public OutputCase getOutputCase() {
      return OutputCase.forNumber(outputCase_);
    }

    public Builder clearOutput() {
      outputCase_ = 0;
      output_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput,
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.Builder,
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutputOrBuilder>
        multiTrialJobOutputBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the multiTrialJobOutput field is set.
     */
    @java.lang.Override
    public boolean hasMultiTrialJobOutput() {
      return outputCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The multiTrialJobOutput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
        getMultiTrialJobOutput() {
      if (multiTrialJobOutputBuilder_ == null) {
        if (outputCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) output_;
        }
        return com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
            .getDefaultInstance();
      } else {
        if (outputCase_ == 1) {
          return multiTrialJobOutputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMultiTrialJobOutput(
        com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput value) {
      if (multiTrialJobOutputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        output_ = value;
        onChanged();
      } else {
        multiTrialJobOutputBuilder_.setMessage(value);
      }
      outputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMultiTrialJobOutput(
        com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.Builder
            builderForValue) {
      if (multiTrialJobOutputBuilder_ == null) {
        output_ = builderForValue.build();
        onChanged();
      } else {
        multiTrialJobOutputBuilder_.setMessage(builderForValue.build());
      }
      outputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMultiTrialJobOutput(
        com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput value) {
      if (multiTrialJobOutputBuilder_ == null) {
        if (outputCase_ == 1
            && output_
                != com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
                    .getDefaultInstance()) {
          output_ =
              com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput)
                          output_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          output_ = value;
        }
        onChanged();
      } else {
        if (outputCase_ == 1) {
          multiTrialJobOutputBuilder_.mergeFrom(value);
        } else {
          multiTrialJobOutputBuilder_.setMessage(value);
        }
      }
      outputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMultiTrialJobOutput() {
      if (multiTrialJobOutputBuilder_ == null) {
        if (outputCase_ == 1) {
          outputCase_ = 0;
          output_ = null;
          onChanged();
        }
      } else {
        if (outputCase_ == 1) {
          outputCase_ = 0;
          output_ = null;
        }
        multiTrialJobOutputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.Builder
        getMultiTrialJobOutputBuilder() {
      return getMultiTrialJobOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutputOrBuilder
        getMultiTrialJobOutputOrBuilder() {
      if ((outputCase_ == 1) && (multiTrialJobOutputBuilder_ != null)) {
        return multiTrialJobOutputBuilder_.getMessageOrBuilder();
      } else {
        if (outputCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) output_;
        }
        return com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The output of this multi-trial Neural Architecture Search
     * (NAS) job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput multi_trial_job_output = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput,
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.Builder,
            com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutputOrBuilder>
        getMultiTrialJobOutputFieldBuilder() {
      if (multiTrialJobOutputBuilder_ == null) {
        if (!(outputCase_ == 1)) {
          output_ =
              com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
                  .getDefaultInstance();
        }
        multiTrialJobOutputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput,
                com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.Builder,
                com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput) output_,
                getParentForChildren(),
                isClean());
        output_ = null;
      }
      outputCase_ = 1;
      onChanged();
      return multiTrialJobOutputBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NasJobOutput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NasJobOutput)
  private static final com.google.cloud.aiplatform.v1beta1.NasJobOutput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NasJobOutput();
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobOutput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NasJobOutput> PARSER =
      new com.google.protobuf.AbstractParser<NasJobOutput>() {
        @java.lang.Override
        public NasJobOutput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NasJobOutput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NasJobOutput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NasJobOutput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
