/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitor.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

public interface ModelMonitoringSchemaOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringSchema)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Feature names of the model. Vertex AI will try to match the features from
   * your dataset as follows:
   *  * For 'csv' files, the header names are required, and we will extract the
   *    corresponding feature values when the header names align with the
   *    feature names.
   *  * For 'jsonl' files, we will extract the corresponding feature values if
   *    the key names match the feature names.
   *    Note: Nested features are not supported, so please ensure your features
   *    are flattened. Ensure the feature values are scalar or an array of
   *    scalars.
   *  * For 'bigquery' dataset, we will extract the corresponding feature values
   *    if the column names match the feature names.
   *    Note: The column type can be a scalar or an array of scalars. STRUCT or
   *    JSON types are not supported. You may use SQL queries to select or
   *    aggregate the relevant features from your original table. However,
   *    ensure that the 'schema' of the query results meets our requirements.
   *  * For the Vertex AI Endpoint Request Response Logging table or Vertex AI
   *    Batch Prediction Job results. If the
   *    [instance_type][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.instance_type]
   *    is an array, ensure that the sequence in
   *    [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields]
   *    matches the order of features in the prediction instance. We will match
   *    the feature with the array in the order specified in [feature_fields].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema feature_fields = 1;
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema>
      getFeatureFieldsList();
  /**
   *
   *
   * <pre>
   * Feature names of the model. Vertex AI will try to match the features from
   * your dataset as follows:
   *  * For 'csv' files, the header names are required, and we will extract the
   *    corresponding feature values when the header names align with the
   *    feature names.
   *  * For 'jsonl' files, we will extract the corresponding feature values if
   *    the key names match the feature names.
   *    Note: Nested features are not supported, so please ensure your features
   *    are flattened. Ensure the feature values are scalar or an array of
   *    scalars.
   *  * For 'bigquery' dataset, we will extract the corresponding feature values
   *    if the column names match the feature names.
   *    Note: The column type can be a scalar or an array of scalars. STRUCT or
   *    JSON types are not supported. You may use SQL queries to select or
   *    aggregate the relevant features from your original table. However,
   *    ensure that the 'schema' of the query results meets our requirements.
   *  * For the Vertex AI Endpoint Request Response Logging table or Vertex AI
   *    Batch Prediction Job results. If the
   *    [instance_type][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.instance_type]
   *    is an array, ensure that the sequence in
   *    [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields]
   *    matches the order of features in the prediction instance. We will match
   *    the feature with the array in the order specified in [feature_fields].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema feature_fields = 1;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema getFeatureFields(int index);
  /**
   *
   *
   * <pre>
   * Feature names of the model. Vertex AI will try to match the features from
   * your dataset as follows:
   *  * For 'csv' files, the header names are required, and we will extract the
   *    corresponding feature values when the header names align with the
   *    feature names.
   *  * For 'jsonl' files, we will extract the corresponding feature values if
   *    the key names match the feature names.
   *    Note: Nested features are not supported, so please ensure your features
   *    are flattened. Ensure the feature values are scalar or an array of
   *    scalars.
   *  * For 'bigquery' dataset, we will extract the corresponding feature values
   *    if the column names match the feature names.
   *    Note: The column type can be a scalar or an array of scalars. STRUCT or
   *    JSON types are not supported. You may use SQL queries to select or
   *    aggregate the relevant features from your original table. However,
   *    ensure that the 'schema' of the query results meets our requirements.
   *  * For the Vertex AI Endpoint Request Response Logging table or Vertex AI
   *    Batch Prediction Job results. If the
   *    [instance_type][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.instance_type]
   *    is an array, ensure that the sequence in
   *    [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields]
   *    matches the order of features in the prediction instance. We will match
   *    the feature with the array in the order specified in [feature_fields].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema feature_fields = 1;
   * </code>
   */
  int getFeatureFieldsCount();
  /**
   *
   *
   * <pre>
   * Feature names of the model. Vertex AI will try to match the features from
   * your dataset as follows:
   *  * For 'csv' files, the header names are required, and we will extract the
   *    corresponding feature values when the header names align with the
   *    feature names.
   *  * For 'jsonl' files, we will extract the corresponding feature values if
   *    the key names match the feature names.
   *    Note: Nested features are not supported, so please ensure your features
   *    are flattened. Ensure the feature values are scalar or an array of
   *    scalars.
   *  * For 'bigquery' dataset, we will extract the corresponding feature values
   *    if the column names match the feature names.
   *    Note: The column type can be a scalar or an array of scalars. STRUCT or
   *    JSON types are not supported. You may use SQL queries to select or
   *    aggregate the relevant features from your original table. However,
   *    ensure that the 'schema' of the query results meets our requirements.
   *  * For the Vertex AI Endpoint Request Response Logging table or Vertex AI
   *    Batch Prediction Job results. If the
   *    [instance_type][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.instance_type]
   *    is an array, ensure that the sequence in
   *    [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields]
   *    matches the order of features in the prediction instance. We will match
   *    the feature with the array in the order specified in [feature_fields].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema feature_fields = 1;
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchemaOrBuilder>
      getFeatureFieldsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Feature names of the model. Vertex AI will try to match the features from
   * your dataset as follows:
   *  * For 'csv' files, the header names are required, and we will extract the
   *    corresponding feature values when the header names align with the
   *    feature names.
   *  * For 'jsonl' files, we will extract the corresponding feature values if
   *    the key names match the feature names.
   *    Note: Nested features are not supported, so please ensure your features
   *    are flattened. Ensure the feature values are scalar or an array of
   *    scalars.
   *  * For 'bigquery' dataset, we will extract the corresponding feature values
   *    if the column names match the feature names.
   *    Note: The column type can be a scalar or an array of scalars. STRUCT or
   *    JSON types are not supported. You may use SQL queries to select or
   *    aggregate the relevant features from your original table. However,
   *    ensure that the 'schema' of the query results meets our requirements.
   *  * For the Vertex AI Endpoint Request Response Logging table or Vertex AI
   *    Batch Prediction Job results. If the
   *    [instance_type][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.instance_type]
   *    is an array, ensure that the sequence in
   *    [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields]
   *    matches the order of features in the prediction instance. We will match
   *    the feature with the array in the order specified in [feature_fields].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema feature_fields = 1;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchemaOrBuilder
      getFeatureFieldsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Prediction output names of the model. The requirements are the same as the
   * [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields].
   * For AutoML Tables, the prediction output name presented in schema will be:
   * `predicted_{target_column}`, the `target_column` is the one you specified
   * when you train the model.
   * For Prediction output drift analysis:
   *  * AutoML Classification, the distribution of the argmax label will be
   *    analyzed.
   *  * AutoML Regression, the distribution of the value will be analyzed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema prediction_fields = 2;
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema>
      getPredictionFieldsList();
  /**
   *
   *
   * <pre>
   * Prediction output names of the model. The requirements are the same as the
   * [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields].
   * For AutoML Tables, the prediction output name presented in schema will be:
   * `predicted_{target_column}`, the `target_column` is the one you specified
   * when you train the model.
   * For Prediction output drift analysis:
   *  * AutoML Classification, the distribution of the argmax label will be
   *    analyzed.
   *  * AutoML Regression, the distribution of the value will be analyzed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema prediction_fields = 2;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema getPredictionFields(
      int index);
  /**
   *
   *
   * <pre>
   * Prediction output names of the model. The requirements are the same as the
   * [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields].
   * For AutoML Tables, the prediction output name presented in schema will be:
   * `predicted_{target_column}`, the `target_column` is the one you specified
   * when you train the model.
   * For Prediction output drift analysis:
   *  * AutoML Classification, the distribution of the argmax label will be
   *    analyzed.
   *  * AutoML Regression, the distribution of the value will be analyzed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema prediction_fields = 2;
   * </code>
   */
  int getPredictionFieldsCount();
  /**
   *
   *
   * <pre>
   * Prediction output names of the model. The requirements are the same as the
   * [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields].
   * For AutoML Tables, the prediction output name presented in schema will be:
   * `predicted_{target_column}`, the `target_column` is the one you specified
   * when you train the model.
   * For Prediction output drift analysis:
   *  * AutoML Classification, the distribution of the argmax label will be
   *    analyzed.
   *  * AutoML Regression, the distribution of the value will be analyzed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema prediction_fields = 2;
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchemaOrBuilder>
      getPredictionFieldsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Prediction output names of the model. The requirements are the same as the
   * [feature_fields][google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.feature_fields].
   * For AutoML Tables, the prediction output name presented in schema will be:
   * `predicted_{target_column}`, the `target_column` is the one you specified
   * when you train the model.
   * For Prediction output drift analysis:
   *  * AutoML Classification, the distribution of the argmax label will be
   *    analyzed.
   *  * AutoML Regression, the distribution of the value will be analyzed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema prediction_fields = 2;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchemaOrBuilder
      getPredictionFieldsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Target /ground truth names of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema ground_truth_fields = 3;
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema>
      getGroundTruthFieldsList();
  /**
   *
   *
   * <pre>
   * Target /ground truth names of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema ground_truth_fields = 3;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema getGroundTruthFields(
      int index);
  /**
   *
   *
   * <pre>
   * Target /ground truth names of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema ground_truth_fields = 3;
   * </code>
   */
  int getGroundTruthFieldsCount();
  /**
   *
   *
   * <pre>
   * Target /ground truth names of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema ground_truth_fields = 3;
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchemaOrBuilder>
      getGroundTruthFieldsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Target /ground truth names of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchema ground_truth_fields = 3;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.FieldSchemaOrBuilder
      getGroundTruthFieldsOrBuilder(int index);
}
