/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Config for importing RagFiles.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportRagFilesConfig}
 */
public final class ImportRagFilesConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
    ImportRagFilesConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportRagFilesConfig.newBuilder() to construct.
  private ImportRagFilesConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportRagFilesConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportRagFilesConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.class,
            com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.Builder.class);
  }

  private int bitField0_;
  private int importSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object importSource_;

  public enum ImportSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(2),
    GOOGLE_DRIVE_SOURCE(3),
    SLACK_SOURCE(6),
    JIRA_SOURCE(7),
    IMPORTSOURCE_NOT_SET(0);
    private final int value;

    private ImportSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static ImportSourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_SOURCE;
        case 3:
          return GOOGLE_DRIVE_SOURCE;
        case 6:
          return SLACK_SOURCE;
        case 7:
          return JIRA_SOURCE;
        case 0:
          return IMPORTSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ImportSourceCase getImportSourceCase() {
    return ImportSourceCase.forNumber(importSourceCase_);
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return importSourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
    if (importSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (importSourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  public static final int GOOGLE_DRIVE_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   *
   * @return Whether the googleDriveSource field is set.
   */
  @java.lang.Override
  public boolean hasGoogleDriveSource() {
    return importSourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   *
   * @return The googleDriveSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveSource() {
    if (importSourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
      getGoogleDriveSourceOrBuilder() {
    if (importSourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  public static final int SLACK_SOURCE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   *
   * @return Whether the slackSource field is set.
   */
  @java.lang.Override
  public boolean hasSlackSource() {
    return importSourceCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   *
   * @return The slackSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SlackSource getSlackSource() {
    if (importSourceCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder getSlackSourceOrBuilder() {
    if (importSourceCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
  }

  public static final int JIRA_SOURCE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   *
   * @return Whether the jiraSource field is set.
   */
  @java.lang.Override
  public boolean hasJiraSource() {
    return importSourceCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   *
   * @return The jiraSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSource getJiraSource() {
    if (importSourceCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder getJiraSourceOrBuilder() {
    if (importSourceCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
  }

  public static final int RAG_FILE_CHUNKING_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig ragFileChunkingConfig_;
  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
   * </code>
   *
   * @return Whether the ragFileChunkingConfig field is set.
   */
  @java.lang.Override
  public boolean hasRagFileChunkingConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
   * </code>
   *
   * @return The ragFileChunkingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig getRagFileChunkingConfig() {
    return ragFileChunkingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
        : ragFileChunkingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder
      getRagFileChunkingConfigOrBuilder() {
    return ragFileChunkingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
        : ragFileChunkingConfig_;
  }

  public static final int RAG_FILE_PARSING_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig ragFileParsingConfig_;
  /**
   *
   *
   * <pre>
   * Specifies the parsing config for RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;</code>
   *
   * @return Whether the ragFileParsingConfig field is set.
   */
  @java.lang.Override
  public boolean hasRagFileParsingConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the parsing config for RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;</code>
   *
   * @return The ragFileParsingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig getRagFileParsingConfig() {
    return ragFileParsingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
        : ragFileParsingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the parsing config for RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder
      getRagFileParsingConfigOrBuilder() {
    return ragFileParsingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
        : ragFileParsingConfig_;
  }

  public static final int MAX_EMBEDDING_REQUESTS_PER_MIN_FIELD_NUMBER = 5;
  private int maxEmbeddingRequestsPerMin_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The max number of queries per minute that this job is allowed to
   * make to the embedding model specified on the corpus. This value is specific
   * to this job and not shared across other import jobs. Consult the Quotas
   * page on the project to set an appropriate value here.
   * If unspecified, a default value of 1,000 QPM would be used.
   * </pre>
   *
   * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maxEmbeddingRequestsPerMin.
   */
  @java.lang.Override
  public int getMaxEmbeddingRequestsPerMin() {
    return maxEmbeddingRequestsPerMin_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (importSourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_);
    }
    if (importSourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getRagFileChunkingConfig());
    }
    if (maxEmbeddingRequestsPerMin_ != 0) {
      output.writeInt32(5, maxEmbeddingRequestsPerMin_);
    }
    if (importSourceCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_);
    }
    if (importSourceCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getRagFileParsingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (importSourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_);
    }
    if (importSourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRagFileChunkingConfig());
    }
    if (maxEmbeddingRequestsPerMin_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxEmbeddingRequestsPerMin_);
    }
    if (importSourceCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_);
    }
    if (importSourceCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRagFileParsingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig other =
        (com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig) obj;

    if (hasRagFileChunkingConfig() != other.hasRagFileChunkingConfig()) return false;
    if (hasRagFileChunkingConfig()) {
      if (!getRagFileChunkingConfig().equals(other.getRagFileChunkingConfig())) return false;
    }
    if (hasRagFileParsingConfig() != other.hasRagFileParsingConfig()) return false;
    if (hasRagFileParsingConfig()) {
      if (!getRagFileParsingConfig().equals(other.getRagFileParsingConfig())) return false;
    }
    if (getMaxEmbeddingRequestsPerMin() != other.getMaxEmbeddingRequestsPerMin()) return false;
    if (!getImportSourceCase().equals(other.getImportSourceCase())) return false;
    switch (importSourceCase_) {
      case 2:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 3:
        if (!getGoogleDriveSource().equals(other.getGoogleDriveSource())) return false;
        break;
      case 6:
        if (!getSlackSource().equals(other.getSlackSource())) return false;
        break;
      case 7:
        if (!getJiraSource().equals(other.getJiraSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRagFileChunkingConfig()) {
      hash = (37 * hash) + RAG_FILE_CHUNKING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRagFileChunkingConfig().hashCode();
    }
    if (hasRagFileParsingConfig()) {
      hash = (37 * hash) + RAG_FILE_PARSING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRagFileParsingConfig().hashCode();
    }
    hash = (37 * hash) + MAX_EMBEDDING_REQUESTS_PER_MIN_FIELD_NUMBER;
    hash = (53 * hash) + getMaxEmbeddingRequestsPerMin();
    switch (importSourceCase_) {
      case 2:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GOOGLE_DRIVE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleDriveSource().hashCode();
        break;
      case 6:
        hash = (37 * hash) + SLACK_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSlackSource().hashCode();
        break;
      case 7:
        hash = (37 * hash) + JIRA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getJiraSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config for importing RagFiles.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportRagFilesConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.class,
              com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRagFileChunkingConfigFieldBuilder();
        getRagFileParsingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (googleDriveSourceBuilder_ != null) {
        googleDriveSourceBuilder_.clear();
      }
      if (slackSourceBuilder_ != null) {
        slackSourceBuilder_.clear();
      }
      if (jiraSourceBuilder_ != null) {
        jiraSourceBuilder_.clear();
      }
      ragFileChunkingConfig_ = null;
      if (ragFileChunkingConfigBuilder_ != null) {
        ragFileChunkingConfigBuilder_.dispose();
        ragFileChunkingConfigBuilder_ = null;
      }
      ragFileParsingConfig_ = null;
      if (ragFileParsingConfigBuilder_ != null) {
        ragFileParsingConfigBuilder_.dispose();
        ragFileParsingConfigBuilder_ = null;
      }
      maxEmbeddingRequestsPerMin_ = 0;
      importSourceCase_ = 0;
      importSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportRagFilesConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig build() {
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result =
          new com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ragFileChunkingConfig_ =
            ragFileChunkingConfigBuilder_ == null
                ? ragFileChunkingConfig_
                : ragFileChunkingConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ragFileParsingConfig_ =
            ragFileParsingConfigBuilder_ == null
                ? ragFileParsingConfig_
                : ragFileParsingConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.maxEmbeddingRequestsPerMin_ = maxEmbeddingRequestsPerMin_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig result) {
      result.importSourceCase_ = importSourceCase_;
      result.importSource_ = this.importSource_;
      if (importSourceCase_ == 2 && gcsSourceBuilder_ != null) {
        result.importSource_ = gcsSourceBuilder_.build();
      }
      if (importSourceCase_ == 3 && googleDriveSourceBuilder_ != null) {
        result.importSource_ = googleDriveSourceBuilder_.build();
      }
      if (importSourceCase_ == 6 && slackSourceBuilder_ != null) {
        result.importSource_ = slackSourceBuilder_.build();
      }
      if (importSourceCase_ == 7 && jiraSourceBuilder_ != null) {
        result.importSource_ = jiraSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.getDefaultInstance())
        return this;
      if (other.hasRagFileChunkingConfig()) {
        mergeRagFileChunkingConfig(other.getRagFileChunkingConfig());
      }
      if (other.hasRagFileParsingConfig()) {
        mergeRagFileParsingConfig(other.getRagFileParsingConfig());
      }
      if (other.getMaxEmbeddingRequestsPerMin() != 0) {
        setMaxEmbeddingRequestsPerMin(other.getMaxEmbeddingRequestsPerMin());
      }
      switch (other.getImportSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case GOOGLE_DRIVE_SOURCE:
          {
            mergeGoogleDriveSource(other.getGoogleDriveSource());
            break;
          }
        case SLACK_SOURCE:
          {
            mergeSlackSource(other.getSlackSource());
            break;
          }
        case JIRA_SOURCE:
          {
            mergeJiraSource(other.getJiraSource());
            break;
          }
        case IMPORTSOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getGoogleDriveSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getRagFileChunkingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                maxEmbeddingRequestsPerMin_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getSlackSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getJiraSourceFieldBuilder().getBuilder(), extensionRegistry);
                importSourceCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getRagFileParsingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int importSourceCase_ = 0;
    private java.lang.Object importSource_;

    public ImportSourceCase getImportSourceCase() {
      return ImportSourceCase.forNumber(importSourceCase_);
    }

    public Builder clearImportSource() {
      importSourceCase_ = 0;
      importSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return importSourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (importSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 2) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder setGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (importSourceCase_ == 2
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 2) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (importSourceCase_ == 2) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 2) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((importSourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(importSourceCase_ == 2)) {
          importSource_ = com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsSource,
                com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 2;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        googleDriveSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     *
     * @return Whether the googleDriveSource field is set.
     */
    @java.lang.Override
    public boolean hasGoogleDriveSource() {
      return importSourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     *
     * @return The googleDriveSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveSource() {
      if (googleDriveSourceBuilder_ == null) {
        if (importSourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 3) {
          return googleDriveSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder setGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        googleDriveSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder setGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder builderForValue) {
      if (googleDriveSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        googleDriveSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder mergeGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveSourceBuilder_ == null) {
        if (importSourceCase_ == 3
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 3) {
          googleDriveSourceBuilder_.mergeFrom(value);
        } else {
          googleDriveSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public Builder clearGoogleDriveSource() {
      if (googleDriveSourceBuilder_ == null) {
        if (importSourceCase_ == 3) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 3) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        googleDriveSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder
        getGoogleDriveSourceBuilder() {
      return getGoogleDriveSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
        getGoogleDriveSourceOrBuilder() {
      if ((importSourceCase_ == 3) && (googleDriveSourceBuilder_ != null)) {
        return googleDriveSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        getGoogleDriveSourceFieldBuilder() {
      if (googleDriveSourceBuilder_ == null) {
        if (!(importSourceCase_ == 3)) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
        }
        googleDriveSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 3;
      onChanged();
      return googleDriveSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SlackSource,
            com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>
        slackSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     *
     * @return Whether the slackSource field is set.
     */
    @java.lang.Override
    public boolean hasSlackSource() {
      return importSourceCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     *
     * @return The slackSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SlackSource getSlackSource() {
      if (slackSourceBuilder_ == null) {
        if (importSourceCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 6) {
          return slackSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder setSlackSource(com.google.cloud.aiplatform.v1beta1.SlackSource value) {
      if (slackSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        slackSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder setSlackSource(
        com.google.cloud.aiplatform.v1beta1.SlackSource.Builder builderForValue) {
      if (slackSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        slackSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder mergeSlackSource(com.google.cloud.aiplatform.v1beta1.SlackSource value) {
      if (slackSourceBuilder_ == null) {
        if (importSourceCase_ == 6
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.SlackSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 6) {
          slackSourceBuilder_.mergeFrom(value);
        } else {
          slackSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public Builder clearSlackSource() {
      if (slackSourceBuilder_ == null) {
        if (importSourceCase_ == 6) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 6) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        slackSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SlackSource.Builder getSlackSourceBuilder() {
      return getSlackSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder getSlackSourceOrBuilder() {
      if ((importSourceCase_ == 6) && (slackSourceBuilder_ != null)) {
        return slackSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Slack channels with their corresponding access tokens.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SlackSource,
            com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>
        getSlackSourceFieldBuilder() {
      if (slackSourceBuilder_ == null) {
        if (!(importSourceCase_ == 6)) {
          importSource_ = com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
        }
        slackSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SlackSource,
                com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
                com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SlackSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 6;
      onChanged();
      return slackSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource,
            com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>
        jiraSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     *
     * @return Whether the jiraSource field is set.
     */
    @java.lang.Override
    public boolean hasJiraSource() {
      return importSourceCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     *
     * @return The jiraSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSource getJiraSource() {
      if (jiraSourceBuilder_ == null) {
        if (importSourceCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      } else {
        if (importSourceCase_ == 7) {
          return jiraSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder setJiraSource(com.google.cloud.aiplatform.v1beta1.JiraSource value) {
      if (jiraSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importSource_ = value;
        onChanged();
      } else {
        jiraSourceBuilder_.setMessage(value);
      }
      importSourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder setJiraSource(
        com.google.cloud.aiplatform.v1beta1.JiraSource.Builder builderForValue) {
      if (jiraSourceBuilder_ == null) {
        importSource_ = builderForValue.build();
        onChanged();
      } else {
        jiraSourceBuilder_.setMessage(builderForValue.build());
      }
      importSourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder mergeJiraSource(com.google.cloud.aiplatform.v1beta1.JiraSource value) {
      if (jiraSourceBuilder_ == null) {
        if (importSourceCase_ == 7
            && importSource_
                != com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance()) {
          importSource_ =
              com.google.cloud.aiplatform.v1beta1.JiraSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          importSource_ = value;
        }
        onChanged();
      } else {
        if (importSourceCase_ == 7) {
          jiraSourceBuilder_.mergeFrom(value);
        } else {
          jiraSourceBuilder_.setMessage(value);
        }
      }
      importSourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public Builder clearJiraSource() {
      if (jiraSourceBuilder_ == null) {
        if (importSourceCase_ == 7) {
          importSourceCase_ = 0;
          importSource_ = null;
          onChanged();
        }
      } else {
        if (importSourceCase_ == 7) {
          importSourceCase_ = 0;
          importSource_ = null;
        }
        jiraSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.Builder getJiraSourceBuilder() {
      return getJiraSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder getJiraSourceOrBuilder() {
      if ((importSourceCase_ == 7) && (jiraSourceBuilder_ != null)) {
        return jiraSourceBuilder_.getMessageOrBuilder();
      } else {
        if (importSourceCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Jira queries with their corresponding authentication.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource,
            com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>
        getJiraSourceFieldBuilder() {
      if (jiraSourceBuilder_ == null) {
        if (!(importSourceCase_ == 7)) {
          importSource_ = com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
        }
        jiraSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.JiraSource,
                com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
                com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.JiraSource) importSource_,
                getParentForChildren(),
                isClean());
        importSource_ = null;
      }
      importSourceCase_ = 7;
      onChanged();
      return jiraSourceBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig ragFileChunkingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder>
        ragFileChunkingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     *
     * @return Whether the ragFileChunkingConfig field is set.
     */
    public boolean hasRagFileChunkingConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     *
     * @return The ragFileChunkingConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig getRagFileChunkingConfig() {
      if (ragFileChunkingConfigBuilder_ == null) {
        return ragFileChunkingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
            : ragFileChunkingConfig_;
      } else {
        return ragFileChunkingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     */
    public Builder setRagFileChunkingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig value) {
      if (ragFileChunkingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileChunkingConfig_ = value;
      } else {
        ragFileChunkingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     */
    public Builder setRagFileChunkingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder builderForValue) {
      if (ragFileChunkingConfigBuilder_ == null) {
        ragFileChunkingConfig_ = builderForValue.build();
      } else {
        ragFileChunkingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     */
    public Builder mergeRagFileChunkingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig value) {
      if (ragFileChunkingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && ragFileChunkingConfig_ != null
            && ragFileChunkingConfig_
                != com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()) {
          getRagFileChunkingConfigBuilder().mergeFrom(value);
        } else {
          ragFileChunkingConfig_ = value;
        }
      } else {
        ragFileChunkingConfigBuilder_.mergeFrom(value);
      }
      if (ragFileChunkingConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     */
    public Builder clearRagFileChunkingConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ragFileChunkingConfig_ = null;
      if (ragFileChunkingConfigBuilder_ != null) {
        ragFileChunkingConfigBuilder_.dispose();
        ragFileChunkingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder
        getRagFileChunkingConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRagFileChunkingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder
        getRagFileChunkingConfigOrBuilder() {
      if (ragFileChunkingConfigBuilder_ != null) {
        return ragFileChunkingConfigBuilder_.getMessageOrBuilder();
      } else {
        return ragFileChunkingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.getDefaultInstance()
            : ragFileChunkingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the size and overlap of chunks after importing RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder>
        getRagFileChunkingConfigFieldBuilder() {
      if (ragFileChunkingConfigBuilder_ == null) {
        ragFileChunkingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig,
                com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder>(
                getRagFileChunkingConfig(), getParentForChildren(), isClean());
        ragFileChunkingConfig_ = null;
      }
      return ragFileChunkingConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig ragFileParsingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder>
        ragFileParsingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     *
     * @return Whether the ragFileParsingConfig field is set.
     */
    public boolean hasRagFileParsingConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     *
     * @return The ragFileParsingConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig getRagFileParsingConfig() {
      if (ragFileParsingConfigBuilder_ == null) {
        return ragFileParsingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
            : ragFileParsingConfig_;
      } else {
        return ragFileParsingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     */
    public Builder setRagFileParsingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig value) {
      if (ragFileParsingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileParsingConfig_ = value;
      } else {
        ragFileParsingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     */
    public Builder setRagFileParsingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder builderForValue) {
      if (ragFileParsingConfigBuilder_ == null) {
        ragFileParsingConfig_ = builderForValue.build();
      } else {
        ragFileParsingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     */
    public Builder mergeRagFileParsingConfig(
        com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig value) {
      if (ragFileParsingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && ragFileParsingConfig_ != null
            && ragFileParsingConfig_
                != com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()) {
          getRagFileParsingConfigBuilder().mergeFrom(value);
        } else {
          ragFileParsingConfig_ = value;
        }
      } else {
        ragFileParsingConfigBuilder_.mergeFrom(value);
      }
      if (ragFileParsingConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     */
    public Builder clearRagFileParsingConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ragFileParsingConfig_ = null;
      if (ragFileParsingConfigBuilder_ != null) {
        ragFileParsingConfigBuilder_.dispose();
        ragFileParsingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder
        getRagFileParsingConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRagFileParsingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder
        getRagFileParsingConfigOrBuilder() {
      if (ragFileParsingConfigBuilder_ != null) {
        return ragFileParsingConfigBuilder_.getMessageOrBuilder();
      } else {
        return ragFileParsingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.getDefaultInstance()
            : ragFileParsingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the parsing config for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder>
        getRagFileParsingConfigFieldBuilder() {
      if (ragFileParsingConfigBuilder_ == null) {
        ragFileParsingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig,
                com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder>(
                getRagFileParsingConfig(), getParentForChildren(), isClean());
        ragFileParsingConfig_ = null;
      }
      return ragFileParsingConfigBuilder_;
    }

    private int maxEmbeddingRequestsPerMin_;
    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     * </pre>
     *
     * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maxEmbeddingRequestsPerMin.
     */
    @java.lang.Override
    public int getMaxEmbeddingRequestsPerMin() {
      return maxEmbeddingRequestsPerMin_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     * </pre>
     *
     * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The maxEmbeddingRequestsPerMin to set.
     * @return This builder for chaining.
     */
    public Builder setMaxEmbeddingRequestsPerMin(int value) {

      maxEmbeddingRequestsPerMin_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     * </pre>
     *
     * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxEmbeddingRequestsPerMin() {
      bitField0_ = (bitField0_ & ~0x00000040);
      maxEmbeddingRequestsPerMin_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
  private static final com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportRagFilesConfig> PARSER =
      new com.google.protobuf.AbstractParser<ImportRagFilesConfig>() {
        @java.lang.Override
        public ImportRagFilesConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportRagFilesConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportRagFilesConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
