/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Distribution computed over a tuning dataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.DatasetDistribution}
 */
public final class DatasetDistribution extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DatasetDistribution)
    DatasetDistributionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DatasetDistribution.newBuilder() to construct.
  private DatasetDistribution(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DatasetDistribution() {
    buckets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DatasetDistribution();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.class,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder.class);
  }

  public interface DistributionBucketOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Number of values in the bucket.
     * </pre>
     *
     * <code>int64 count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count.
     */
    long getCount();

    /**
     *
     *
     * <pre>
     * Output only. Left bound of the bucket.
     * </pre>
     *
     * <code>double left = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The left.
     */
    double getLeft();

    /**
     *
     *
     * <pre>
     * Output only. Right bound of the bucket.
     * </pre>
     *
     * <code>double right = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The right.
     */
    double getRight();
  }
  /**
   *
   *
   * <pre>
   * Dataset bucket used to create a histogram for the distribution given a
   * population of values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket}
   */
  public static final class DistributionBucket extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket)
      DistributionBucketOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DistributionBucket.newBuilder() to construct.
    private DistributionBucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DistributionBucket() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DistributionBucket();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_DistributionBucket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_DistributionBucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.class,
              com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
                  .class);
    }

    public static final int COUNT_FIELD_NUMBER = 1;
    private long count_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. Number of values in the bucket.
     * </pre>
     *
     * <code>int64 count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public long getCount() {
      return count_;
    }

    public static final int LEFT_FIELD_NUMBER = 2;
    private double left_ = 0D;
    /**
     *
     *
     * <pre>
     * Output only. Left bound of the bucket.
     * </pre>
     *
     * <code>double left = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The left.
     */
    @java.lang.Override
    public double getLeft() {
      return left_;
    }

    public static final int RIGHT_FIELD_NUMBER = 3;
    private double right_ = 0D;
    /**
     *
     *
     * <pre>
     * Output only. Right bound of the bucket.
     * </pre>
     *
     * <code>double right = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The right.
     */
    @java.lang.Override
    public double getRight() {
      return right_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (count_ != 0L) {
        output.writeInt64(1, count_);
      }
      if (java.lang.Double.doubleToRawLongBits(left_) != 0) {
        output.writeDouble(2, left_);
      }
      if (java.lang.Double.doubleToRawLongBits(right_) != 0) {
        output.writeDouble(3, right_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (count_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, count_);
      }
      if (java.lang.Double.doubleToRawLongBits(left_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, left_);
      }
      if (java.lang.Double.doubleToRawLongBits(right_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, right_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket other =
          (com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket) obj;

      if (getCount() != other.getCount()) return false;
      if (java.lang.Double.doubleToLongBits(getLeft())
          != java.lang.Double.doubleToLongBits(other.getLeft())) return false;
      if (java.lang.Double.doubleToLongBits(getRight())
          != java.lang.Double.doubleToLongBits(other.getRight())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
      hash = (37 * hash) + LEFT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getLeft()));
      hash = (37 * hash) + RIGHT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getRight()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Dataset bucket used to create a histogram for the distribution given a
     * population of values.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket)
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucketOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.TuningJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_DistributionBucket_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.TuningJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_DistributionBucket_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.class,
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        count_ = 0L;
        left_ = 0D;
        right_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.TuningJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_DistributionBucket_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket build() {
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket result =
            new com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.count_ = count_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.left_ = left_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.right_ = right_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
                .getDefaultInstance()) return this;
        if (other.getCount() != 0L) {
          setCount(other.getCount());
        }
        if (other.getLeft() != 0D) {
          setLeft(other.getLeft());
        }
        if (other.getRight() != 0D) {
          setRight(other.getRight());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  count_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 17:
                {
                  left_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 25:
                {
                  right_ = input.readDouble();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 25
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long count_;
      /**
       *
       *
       * <pre>
       * Output only. Number of values in the bucket.
       * </pre>
       *
       * <code>int64 count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of values in the bucket.
       * </pre>
       *
       * <code>int64 count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(long value) {

        count_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of values in the bucket.
       * </pre>
       *
       * <code>int64 count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        count_ = 0L;
        onChanged();
        return this;
      }

      private double left_;
      /**
       *
       *
       * <pre>
       * Output only. Left bound of the bucket.
       * </pre>
       *
       * <code>double left = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The left.
       */
      @java.lang.Override
      public double getLeft() {
        return left_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Left bound of the bucket.
       * </pre>
       *
       * <code>double left = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The left to set.
       * @return This builder for chaining.
       */
      public Builder setLeft(double value) {

        left_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Left bound of the bucket.
       * </pre>
       *
       * <code>double left = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLeft() {
        bitField0_ = (bitField0_ & ~0x00000002);
        left_ = 0D;
        onChanged();
        return this;
      }

      private double right_;
      /**
       *
       *
       * <pre>
       * Output only. Right bound of the bucket.
       * </pre>
       *
       * <code>double right = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The right.
       */
      @java.lang.Override
      public double getRight() {
        return right_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Right bound of the bucket.
       * </pre>
       *
       * <code>double right = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The right to set.
       * @return This builder for chaining.
       */
      public Builder setRight(double value) {

        right_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Right bound of the bucket.
       * </pre>
       *
       * <code>double right = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRight() {
        bitField0_ = (bitField0_ & ~0x00000004);
        right_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket)
    private static final com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket();
    }

    public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DistributionBucket> PARSER =
        new com.google.protobuf.AbstractParser<DistributionBucket>() {
          @java.lang.Override
          public DistributionBucket parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DistributionBucket> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DistributionBucket> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SUM_FIELD_NUMBER = 1;
  private double sum_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. Sum of a given population of values.
   * </pre>
   *
   * <code>double sum = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sum.
   */
  @java.lang.Override
  public double getSum() {
    return sum_;
  }

  public static final int MIN_FIELD_NUMBER = 2;
  private double min_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The minimum of the population values.
   * </pre>
   *
   * <code>double min = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The min.
   */
  @java.lang.Override
  public double getMin() {
    return min_;
  }

  public static final int MAX_FIELD_NUMBER = 3;
  private double max_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The maximum of the population values.
   * </pre>
   *
   * <code>double max = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The max.
   */
  @java.lang.Override
  public double getMax() {
    return max_;
  }

  public static final int MEAN_FIELD_NUMBER = 4;
  private double mean_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The arithmetic mean of the values in the population.
   * </pre>
   *
   * <code>double mean = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The mean.
   */
  @java.lang.Override
  public double getMean() {
    return mean_;
  }

  public static final int MEDIAN_FIELD_NUMBER = 5;
  private double median_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The median of the values in the population.
   * </pre>
   *
   * <code>double median = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The median.
   */
  @java.lang.Override
  public double getMedian() {
    return median_;
  }

  public static final int P5_FIELD_NUMBER = 6;
  private double p5_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The 5th percentile of the values in the population.
   * </pre>
   *
   * <code>double p5 = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The p5.
   */
  @java.lang.Override
  public double getP5() {
    return p5_;
  }

  public static final int P95_FIELD_NUMBER = 7;
  private double p95_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The 95th percentile of the values in the population.
   * </pre>
   *
   * <code>double p95 = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The p95.
   */
  @java.lang.Override
  public double getP95() {
    return p95_;
  }

  public static final int BUCKETS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket>
      buckets_;
  /**
   *
   *
   * <pre>
   * Output only. Defines the histogram bucket.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket>
      getBucketsList() {
    return buckets_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Defines the histogram bucket.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucketOrBuilder>
      getBucketsOrBuilderList() {
    return buckets_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Defines the histogram bucket.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getBucketsCount() {
    return buckets_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Defines the histogram bucket.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket getBuckets(
      int index) {
    return buckets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Defines the histogram bucket.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucketOrBuilder
      getBucketsOrBuilder(int index) {
    return buckets_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Double.doubleToRawLongBits(sum_) != 0) {
      output.writeDouble(1, sum_);
    }
    if (java.lang.Double.doubleToRawLongBits(min_) != 0) {
      output.writeDouble(2, min_);
    }
    if (java.lang.Double.doubleToRawLongBits(max_) != 0) {
      output.writeDouble(3, max_);
    }
    if (java.lang.Double.doubleToRawLongBits(mean_) != 0) {
      output.writeDouble(4, mean_);
    }
    if (java.lang.Double.doubleToRawLongBits(median_) != 0) {
      output.writeDouble(5, median_);
    }
    if (java.lang.Double.doubleToRawLongBits(p5_) != 0) {
      output.writeDouble(6, p5_);
    }
    if (java.lang.Double.doubleToRawLongBits(p95_) != 0) {
      output.writeDouble(7, p95_);
    }
    for (int i = 0; i < buckets_.size(); i++) {
      output.writeMessage(8, buckets_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Double.doubleToRawLongBits(sum_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, sum_);
    }
    if (java.lang.Double.doubleToRawLongBits(min_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, min_);
    }
    if (java.lang.Double.doubleToRawLongBits(max_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, max_);
    }
    if (java.lang.Double.doubleToRawLongBits(mean_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, mean_);
    }
    if (java.lang.Double.doubleToRawLongBits(median_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, median_);
    }
    if (java.lang.Double.doubleToRawLongBits(p5_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, p5_);
    }
    if (java.lang.Double.doubleToRawLongBits(p95_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(7, p95_);
    }
    for (int i = 0; i < buckets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, buckets_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DatasetDistribution)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.DatasetDistribution other =
        (com.google.cloud.aiplatform.v1beta1.DatasetDistribution) obj;

    if (java.lang.Double.doubleToLongBits(getSum())
        != java.lang.Double.doubleToLongBits(other.getSum())) return false;
    if (java.lang.Double.doubleToLongBits(getMin())
        != java.lang.Double.doubleToLongBits(other.getMin())) return false;
    if (java.lang.Double.doubleToLongBits(getMax())
        != java.lang.Double.doubleToLongBits(other.getMax())) return false;
    if (java.lang.Double.doubleToLongBits(getMean())
        != java.lang.Double.doubleToLongBits(other.getMean())) return false;
    if (java.lang.Double.doubleToLongBits(getMedian())
        != java.lang.Double.doubleToLongBits(other.getMedian())) return false;
    if (java.lang.Double.doubleToLongBits(getP5())
        != java.lang.Double.doubleToLongBits(other.getP5())) return false;
    if (java.lang.Double.doubleToLongBits(getP95())
        != java.lang.Double.doubleToLongBits(other.getP95())) return false;
    if (!getBucketsList().equals(other.getBucketsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SUM_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getSum()));
    hash = (37 * hash) + MIN_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMin()));
    hash = (37 * hash) + MAX_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMax()));
    hash = (37 * hash) + MEAN_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMean()));
    hash = (37 * hash) + MEDIAN_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMedian()));
    hash = (37 * hash) + P5_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getP5()));
    hash = (37 * hash) + P95_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getP95()));
    if (getBucketsCount() > 0) {
      hash = (37 * hash) + BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.DatasetDistribution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Distribution computed over a tuning dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DatasetDistribution}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DatasetDistribution)
      com.google.cloud.aiplatform.v1beta1.DatasetDistributionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DatasetDistribution.class,
              com.google.cloud.aiplatform.v1beta1.DatasetDistribution.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.DatasetDistribution.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sum_ = 0D;
      min_ = 0D;
      max_ = 0D;
      mean_ = 0D;
      median_ = 0D;
      p5_ = 0D;
      p95_ = 0D;
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
      } else {
        buckets_ = null;
        bucketsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_DatasetDistribution_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution build() {
      com.google.cloud.aiplatform.v1beta1.DatasetDistribution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution buildPartial() {
      com.google.cloud.aiplatform.v1beta1.DatasetDistribution result =
          new com.google.cloud.aiplatform.v1beta1.DatasetDistribution(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution result) {
      if (bucketsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          buckets_ = java.util.Collections.unmodifiableList(buckets_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.buckets_ = buckets_;
      } else {
        result.buckets_ = bucketsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.DatasetDistribution result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.sum_ = sum_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.min_ = min_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.max_ = max_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mean_ = mean_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.median_ = median_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.p5_ = p5_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.p95_ = p95_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.DatasetDistribution) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.DatasetDistribution) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.DatasetDistribution other) {
      if (other == com.google.cloud.aiplatform.v1beta1.DatasetDistribution.getDefaultInstance())
        return this;
      if (other.getSum() != 0D) {
        setSum(other.getSum());
      }
      if (other.getMin() != 0D) {
        setMin(other.getMin());
      }
      if (other.getMax() != 0D) {
        setMax(other.getMax());
      }
      if (other.getMean() != 0D) {
        setMean(other.getMean());
      }
      if (other.getMedian() != 0D) {
        setMedian(other.getMedian());
      }
      if (other.getP5() != 0D) {
        setP5(other.getP5());
      }
      if (other.getP95() != 0D) {
        setP95(other.getP95());
      }
      if (bucketsBuilder_ == null) {
        if (!other.buckets_.isEmpty()) {
          if (buckets_.isEmpty()) {
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureBucketsIsMutable();
            buckets_.addAll(other.buckets_);
          }
          onChanged();
        }
      } else {
        if (!other.buckets_.isEmpty()) {
          if (bucketsBuilder_.isEmpty()) {
            bucketsBuilder_.dispose();
            bucketsBuilder_ = null;
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000080);
            bucketsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBucketsFieldBuilder()
                    : null;
          } else {
            bucketsBuilder_.addAllMessages(other.buckets_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                sum_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
            case 17:
              {
                min_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case 17
            case 25:
              {
                max_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 33:
              {
                mean_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 33
            case 41:
              {
                median_ = input.readDouble();
                bitField0_ |= 0x00000010;
                break;
              } // case 41
            case 49:
              {
                p5_ = input.readDouble();
                bitField0_ |= 0x00000020;
                break;
              } // case 49
            case 57:
              {
                p95_ = input.readDouble();
                bitField0_ |= 0x00000040;
                break;
              } // case 57
            case 66:
              {
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
                            .parser(),
                        extensionRegistry);
                if (bucketsBuilder_ == null) {
                  ensureBucketsIsMutable();
                  buckets_.add(m);
                } else {
                  bucketsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private double sum_;
    /**
     *
     *
     * <pre>
     * Output only. Sum of a given population of values.
     * </pre>
     *
     * <code>double sum = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sum.
     */
    @java.lang.Override
    public double getSum() {
      return sum_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sum of a given population of values.
     * </pre>
     *
     * <code>double sum = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The sum to set.
     * @return This builder for chaining.
     */
    public Builder setSum(double value) {

      sum_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sum of a given population of values.
     * </pre>
     *
     * <code>double sum = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSum() {
      bitField0_ = (bitField0_ & ~0x00000001);
      sum_ = 0D;
      onChanged();
      return this;
    }

    private double min_;
    /**
     *
     *
     * <pre>
     * Output only. The minimum of the population values.
     * </pre>
     *
     * <code>double min = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The min.
     */
    @java.lang.Override
    public double getMin() {
      return min_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The minimum of the population values.
     * </pre>
     *
     * <code>double min = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The min to set.
     * @return This builder for chaining.
     */
    public Builder setMin(double value) {

      min_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The minimum of the population values.
     * </pre>
     *
     * <code>double min = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMin() {
      bitField0_ = (bitField0_ & ~0x00000002);
      min_ = 0D;
      onChanged();
      return this;
    }

    private double max_;
    /**
     *
     *
     * <pre>
     * Output only. The maximum of the population values.
     * </pre>
     *
     * <code>double max = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The max.
     */
    @java.lang.Override
    public double getMax() {
      return max_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The maximum of the population values.
     * </pre>
     *
     * <code>double max = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The max to set.
     * @return This builder for chaining.
     */
    public Builder setMax(double value) {

      max_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The maximum of the population values.
     * </pre>
     *
     * <code>double max = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMax() {
      bitField0_ = (bitField0_ & ~0x00000004);
      max_ = 0D;
      onChanged();
      return this;
    }

    private double mean_;
    /**
     *
     *
     * <pre>
     * Output only. The arithmetic mean of the values in the population.
     * </pre>
     *
     * <code>double mean = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The mean.
     */
    @java.lang.Override
    public double getMean() {
      return mean_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The arithmetic mean of the values in the population.
     * </pre>
     *
     * <code>double mean = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The mean to set.
     * @return This builder for chaining.
     */
    public Builder setMean(double value) {

      mean_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The arithmetic mean of the values in the population.
     * </pre>
     *
     * <code>double mean = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMean() {
      bitField0_ = (bitField0_ & ~0x00000008);
      mean_ = 0D;
      onChanged();
      return this;
    }

    private double median_;
    /**
     *
     *
     * <pre>
     * Output only. The median of the values in the population.
     * </pre>
     *
     * <code>double median = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The median.
     */
    @java.lang.Override
    public double getMedian() {
      return median_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The median of the values in the population.
     * </pre>
     *
     * <code>double median = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The median to set.
     * @return This builder for chaining.
     */
    public Builder setMedian(double value) {

      median_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The median of the values in the population.
     * </pre>
     *
     * <code>double median = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMedian() {
      bitField0_ = (bitField0_ & ~0x00000010);
      median_ = 0D;
      onChanged();
      return this;
    }

    private double p5_;
    /**
     *
     *
     * <pre>
     * Output only. The 5th percentile of the values in the population.
     * </pre>
     *
     * <code>double p5 = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The p5.
     */
    @java.lang.Override
    public double getP5() {
      return p5_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 5th percentile of the values in the population.
     * </pre>
     *
     * <code>double p5 = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The p5 to set.
     * @return This builder for chaining.
     */
    public Builder setP5(double value) {

      p5_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 5th percentile of the values in the population.
     * </pre>
     *
     * <code>double p5 = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearP5() {
      bitField0_ = (bitField0_ & ~0x00000020);
      p5_ = 0D;
      onChanged();
      return this;
    }

    private double p95_;
    /**
     *
     *
     * <pre>
     * Output only. The 95th percentile of the values in the population.
     * </pre>
     *
     * <code>double p95 = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The p95.
     */
    @java.lang.Override
    public double getP95() {
      return p95_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 95th percentile of the values in the population.
     * </pre>
     *
     * <code>double p95 = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The p95 to set.
     * @return This builder for chaining.
     */
    public Builder setP95(double value) {

      p95_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 95th percentile of the values in the population.
     * </pre>
     *
     * <code>double p95 = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearP95() {
      bitField0_ = (bitField0_ & ~0x00000040);
      p95_ = 0D;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket>
        buckets_ = java.util.Collections.emptyList();

    private void ensureBucketsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        buckets_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket>(
                buckets_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucketOrBuilder>
        bucketsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket>
        getBucketsList() {
      if (bucketsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(buckets_);
      } else {
        return bucketsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getBucketsCount() {
      if (bucketsBuilder_ == null) {
        return buckets_.size();
      } else {
        return bucketsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket getBuckets(
        int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);
      } else {
        return bucketsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBuckets(
        int index,
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.set(index, value);
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBuckets(
        int index,
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
            builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.set(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBuckets(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBuckets(
        int index,
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(index, value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBuckets(
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
            builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBuckets(
        int index,
        com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
            builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllBuckets(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket>
            values) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buckets_);
        onChanged();
      } else {
        bucketsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearBuckets() {
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        bucketsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeBuckets(int index) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.remove(index);
        onChanged();
      } else {
        bucketsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
        getBucketsBuilder(int index) {
      return getBucketsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucketOrBuilder
        getBucketsOrBuilder(int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);
      } else {
        return bucketsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucketOrBuilder>
        getBucketsOrBuilderList() {
      if (bucketsBuilder_ != null) {
        return bucketsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(buckets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
        addBucketsBuilder() {
      return getBucketsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder
        addBucketsBuilder(int index) {
      return getBucketsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Defines the histogram bucket.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket buckets = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder>
        getBucketsBuilderList() {
      return getBucketsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder,
            com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucketOrBuilder>
        getBucketsFieldBuilder() {
      if (bucketsBuilder_ == null) {
        bucketsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket,
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket.Builder,
                com.google.cloud.aiplatform.v1beta1.DatasetDistribution
                    .DistributionBucketOrBuilder>(
                buckets_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        buckets_ = null;
      }
      return bucketsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DatasetDistribution)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DatasetDistribution)
  private static final com.google.cloud.aiplatform.v1beta1.DatasetDistribution DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DatasetDistribution();
  }

  public static com.google.cloud.aiplatform.v1beta1.DatasetDistribution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DatasetDistribution> PARSER =
      new com.google.protobuf.AbstractParser<DatasetDistribution>() {
        @java.lang.Override
        public DatasetDistribution parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DatasetDistribution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DatasetDistribution> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DatasetDistribution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
