/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/custom_job.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents the spec of a CustomJob.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.CustomJobSpec}
 */
public final class CustomJobSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.CustomJobSpec)
    CustomJobSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomJobSpec.newBuilder() to construct.
  private CustomJobSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomJobSpec() {
    persistentResourceId_ = "";
    workerPoolSpecs_ = java.util.Collections.emptyList();
    serviceAccount_ = "";
    network_ = "";
    reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    protectedArtifactLocationId_ = "";
    tensorboard_ = "";
    experiment_ = "";
    experimentRun_ = "";
    models_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomJobSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.class,
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder.class);
  }

  private int bitField0_;
  public static final int PERSISTENT_RESOURCE_ID_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object persistentResourceId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The ID of the PersistentResource in the same Project and Location
   * which to run
   *
   * If this is specified, the job will be run on existing machines held by the
   * PersistentResource instead of on-demand short-live machines.
   * The network and CMEK configs on the job should be consistent with those on
   * the PersistentResource, otherwise, the job will be rejected.
   * </pre>
   *
   * <code>
   * string persistent_resource_id = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The persistentResourceId.
   */
  @java.lang.Override
  public java.lang.String getPersistentResourceId() {
    java.lang.Object ref = persistentResourceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      persistentResourceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The ID of the PersistentResource in the same Project and Location
   * which to run
   *
   * If this is specified, the job will be run on existing machines held by the
   * PersistentResource instead of on-demand short-live machines.
   * The network and CMEK configs on the job should be consistent with those on
   * the PersistentResource, otherwise, the job will be rejected.
   * </pre>
   *
   * <code>
   * string persistent_resource_id = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for persistentResourceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPersistentResourceIdBytes() {
    java.lang.Object ref = persistentResourceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      persistentResourceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKER_POOL_SPECS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec> workerPoolSpecs_;
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker
   * image. All worker pools except the first one are optional and can be
   * skipped by providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec>
      getWorkerPoolSpecsList() {
    return workerPoolSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker
   * image. All worker pools except the first one are optional and can be
   * skipped by providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
      getWorkerPoolSpecsOrBuilderList() {
    return workerPoolSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker
   * image. All worker pools except the first one are optional and can be
   * skipped by providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getWorkerPoolSpecsCount() {
    return workerPoolSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker
   * image. All worker pools except the first one are optional and can be
   * skipped by providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec getWorkerPoolSpecs(int index) {
    return workerPoolSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker
   * image. All worker pools except the first one are optional and can be
   * skipped by providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder getWorkerPoolSpecsOrBuilder(
      int index) {
    return workerPoolSpecs_.get(index);
  }

  public static final int SCHEDULING_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.Scheduling scheduling_;
  /**
   *
   *
   * <pre>
   * Scheduling options for a CustomJob.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
   *
   * @return Whether the scheduling field is set.
   */
  @java.lang.Override
  public boolean hasScheduling() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Scheduling options for a CustomJob.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
   *
   * @return The scheduling.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Scheduling getScheduling() {
    return scheduling_ == null
        ? com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()
        : scheduling_;
  }
  /**
   *
   *
   * <pre>
   * Scheduling options for a CustomJob.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder getSchedulingOrBuilder() {
    return scheduling_ == null
        ? com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()
        : scheduling_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the service account for workload run-as account.
   * Users submitting jobs must have act-as permission on this run-as account.
   * If unspecified, the [Vertex AI Custom Code Service
   * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
   * for the CustomJob's project is used.
   * </pre>
   *
   * <code>string service_account = 4;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the service account for workload run-as account.
   * Users submitting jobs must have act-as permission on this run-as account.
   * If unspecified, the [Vertex AI Custom Code Service
   * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
   * for the CustomJob's project is used.
   * </pre>
   *
   * <code>string service_account = 4;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
   * should be peered. For example, `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * To specify this field, you must have already [configured VPC Network
   * Peering for Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
   *
   * If this field is left unspecified, the job is not peered with any network.
   * </pre>
   *
   * <code>
   * string network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
   * should be peered. For example, `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * To specify this field, you must have already [configured VPC Network
   * Peering for Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
   *
   * If this field is left unspecified, the job is not peered with any network.
   * </pre>
   *
   * <code>
   * string network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVED_IP_RANGES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   *
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the reservedIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
    return reservedIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   *
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of reservedIpRanges.
   */
  public int getReservedIpRangesCount() {
    return reservedIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   *
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The reservedIpRanges at the given index.
   */
  public java.lang.String getReservedIpRanges(int index) {
    return reservedIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   *
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the reservedIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
    return reservedIpRanges_.getByteString(index);
  }

  public static final int BASE_OUTPUT_DIRECTORY_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.GcsDestination baseOutputDirectory_;
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to store the output of this CustomJob or
   * HyperparameterTuningJob. For HyperparameterTuningJob,
   * the baseOutputDirectory of
   * each child CustomJob backing a Trial is set to a subdirectory of name
   * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
   * HyperparameterTuningJob's baseOutputDirectory.
   *
   * The following Vertex AI environment variables will be passed to
   * containers or python modules when this field is set:
   *
   *   For CustomJob:
   *
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
   *
   *   For CustomJob backing a Trial of HyperparameterTuningJob:
   *
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
   *
   * @return Whether the baseOutputDirectory field is set.
   */
  @java.lang.Override
  public boolean hasBaseOutputDirectory() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to store the output of this CustomJob or
   * HyperparameterTuningJob. For HyperparameterTuningJob,
   * the baseOutputDirectory of
   * each child CustomJob backing a Trial is set to a subdirectory of name
   * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
   * HyperparameterTuningJob's baseOutputDirectory.
   *
   * The following Vertex AI environment variables will be passed to
   * containers or python modules when this field is set:
   *
   *   For CustomJob:
   *
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
   *
   *   For CustomJob backing a Trial of HyperparameterTuningJob:
   *
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
   *
   * @return The baseOutputDirectory.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getBaseOutputDirectory() {
    return baseOutputDirectory_ == null
        ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
        : baseOutputDirectory_;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to store the output of this CustomJob or
   * HyperparameterTuningJob. For HyperparameterTuningJob,
   * the baseOutputDirectory of
   * each child CustomJob backing a Trial is set to a subdirectory of name
   * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
   * HyperparameterTuningJob's baseOutputDirectory.
   *
   * The following Vertex AI environment variables will be passed to
   * containers or python modules when this field is set:
   *
   *   For CustomJob:
   *
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
   *
   *   For CustomJob backing a Trial of HyperparameterTuningJob:
   *
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
      getBaseOutputDirectoryOrBuilder() {
    return baseOutputDirectory_ == null
        ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
        : baseOutputDirectory_;
  }

  public static final int PROTECTED_ARTIFACT_LOCATION_ID_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protectedArtifactLocationId_ = "";
  /**
   *
   *
   * <pre>
   * The ID of the location to store protected artifacts. e.g. us-central1.
   * Populate only when the location is different than CustomJob location.
   * List of supported locations:
   * https://cloud.google.com/vertex-ai/docs/general/locations
   * </pre>
   *
   * <code>string protected_artifact_location_id = 19;</code>
   *
   * @return The protectedArtifactLocationId.
   */
  @java.lang.Override
  public java.lang.String getProtectedArtifactLocationId() {
    java.lang.Object ref = protectedArtifactLocationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protectedArtifactLocationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the location to store protected artifacts. e.g. us-central1.
   * Populate only when the location is different than CustomJob location.
   * List of supported locations:
   * https://cloud.google.com/vertex-ai/docs/general/locations
   * </pre>
   *
   * <code>string protected_artifact_location_id = 19;</code>
   *
   * @return The bytes for protectedArtifactLocationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtectedArtifactLocationIdBytes() {
    java.lang.Object ref = protectedArtifactLocationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protectedArtifactLocationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TENSORBOARD_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tensorboard_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of a Vertex AI
   * [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to
   * which this CustomJob will upload Tensorboard logs. Format:
   * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
   * </pre>
   *
   * <code>
   * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tensorboard.
   */
  @java.lang.Override
  public java.lang.String getTensorboard() {
    java.lang.Object ref = tensorboard_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tensorboard_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of a Vertex AI
   * [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to
   * which this CustomJob will upload Tensorboard logs. Format:
   * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
   * </pre>
   *
   * <code>
   * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tensorboard.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTensorboardBytes() {
    java.lang.Object ref = tensorboard_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tensorboard_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_WEB_ACCESS_FIELD_NUMBER = 10;
  private boolean enableWebAccess_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether you want Vertex AI to enable [interactive shell
   * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
   * to training containers.
   *
   * If set to `true`, you can access interactive shells at the URIs given
   * by
   * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
   * or
   * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
   * (within
   * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
   * </pre>
   *
   * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableWebAccess.
   */
  @java.lang.Override
  public boolean getEnableWebAccess() {
    return enableWebAccess_;
  }

  public static final int ENABLE_DASHBOARD_ACCESS_FIELD_NUMBER = 16;
  private boolean enableDashboardAccess_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether you want Vertex AI to enable access to the customized
   * dashboard in training chief container.
   *
   * If set to `true`, you can access the dashboard at the URIs given
   * by
   * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
   * or
   * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
   * (within
   * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
   * </pre>
   *
   * <code>bool enable_dashboard_access = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableDashboardAccess.
   */
  @java.lang.Override
  public boolean getEnableDashboardAccess() {
    return enableDashboardAccess_;
  }

  public static final int EXPERIMENT_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object experiment_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Experiment associated with this job.
   * Format:
   * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
   * </pre>
   *
   * <code>
   * string experiment = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The experiment.
   */
  @java.lang.Override
  public java.lang.String getExperiment() {
    java.lang.Object ref = experiment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      experiment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Experiment associated with this job.
   * Format:
   * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
   * </pre>
   *
   * <code>
   * string experiment = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for experiment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExperimentBytes() {
    java.lang.Object ref = experiment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      experiment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPERIMENT_RUN_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object experimentRun_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Experiment Run associated with this job.
   * Format:
   * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
   * </pre>
   *
   * <code>
   * string experiment_run = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The experimentRun.
   */
  @java.lang.Override
  public java.lang.String getExperimentRun() {
    java.lang.Object ref = experimentRun_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      experimentRun_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Experiment Run associated with this job.
   * Format:
   * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
   * </pre>
   *
   * <code>
   * string experiment_run = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for experimentRun.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExperimentRunBytes() {
    java.lang.Object ref = experimentRun_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      experimentRun_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODELS_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList models_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The name of the Model resources for which to generate a mapping
   * to artifact URIs. Applicable only to some of the Google-provided custom
   * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
   *
   * In order to retrieve a specific version of the model, also provide
   * the version ID or version alias.
   *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * If no version ID or alias is specified, the "default" version will be
   * returned. The "default" version alias is created for the first version of
   * the model, and can be moved to other versions later on. There will be
   * exactly one default version.
   * </pre>
   *
   * <code>
   * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the models.
   */
  public com.google.protobuf.ProtocolStringList getModelsList() {
    return models_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the Model resources for which to generate a mapping
   * to artifact URIs. Applicable only to some of the Google-provided custom
   * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
   *
   * In order to retrieve a specific version of the model, also provide
   * the version ID or version alias.
   *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * If no version ID or alias is specified, the "default" version will be
   * returned. The "default" version alias is created for the first version of
   * the model, and can be moved to other versions later on. There will be
   * exactly one default version.
   * </pre>
   *
   * <code>
   * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of models.
   */
  public int getModelsCount() {
    return models_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the Model resources for which to generate a mapping
   * to artifact URIs. Applicable only to some of the Google-provided custom
   * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
   *
   * In order to retrieve a specific version of the model, also provide
   * the version ID or version alias.
   *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * If no version ID or alias is specified, the "default" version will be
   * returned. The "default" version alias is created for the first version of
   * the model, and can be moved to other versions later on. There will be
   * exactly one default version.
   * </pre>
   *
   * <code>
   * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The models at the given index.
   */
  public java.lang.String getModels(int index) {
    return models_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the Model resources for which to generate a mapping
   * to artifact URIs. Applicable only to some of the Google-provided custom
   * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
   *
   * In order to retrieve a specific version of the model, also provide
   * the version ID or version alias.
   *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * If no version ID or alias is specified, the "default" version will be
   * returned. The "default" version alias is created for the first version of
   * the model, and can be moved to other versions later on. There will be
   * exactly one default version.
   * </pre>
   *
   * <code>
   * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the models at the given index.
   */
  public com.google.protobuf.ByteString getModelsBytes(int index) {
    return models_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < workerPoolSpecs_.size(); i++) {
      output.writeMessage(1, workerPoolSpecs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getScheduling());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, network_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getBaseOutputDirectory());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboard_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, tensorboard_);
    }
    if (enableWebAccess_ != false) {
      output.writeBool(10, enableWebAccess_);
    }
    for (int i = 0; i < reservedIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, reservedIpRanges_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(persistentResourceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, persistentResourceId_);
    }
    if (enableDashboardAccess_ != false) {
      output.writeBool(16, enableDashboardAccess_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experiment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, experiment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experimentRun_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, experimentRun_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protectedArtifactLocationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, protectedArtifactLocationId_);
    }
    for (int i = 0; i < models_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, models_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < workerPoolSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, workerPoolSpecs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getScheduling());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, network_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getBaseOutputDirectory());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboard_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, tensorboard_);
    }
    if (enableWebAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, enableWebAccess_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reservedIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(reservedIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReservedIpRangesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(persistentResourceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, persistentResourceId_);
    }
    if (enableDashboardAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, enableDashboardAccess_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experiment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, experiment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experimentRun_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, experimentRun_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protectedArtifactLocationId_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              19, protectedArtifactLocationId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < models_.size(); i++) {
        dataSize += computeStringSizeNoTag(models_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getModelsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.CustomJobSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.CustomJobSpec other =
        (com.google.cloud.aiplatform.v1beta1.CustomJobSpec) obj;

    if (!getPersistentResourceId().equals(other.getPersistentResourceId())) return false;
    if (!getWorkerPoolSpecsList().equals(other.getWorkerPoolSpecsList())) return false;
    if (hasScheduling() != other.hasScheduling()) return false;
    if (hasScheduling()) {
      if (!getScheduling().equals(other.getScheduling())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getReservedIpRangesList().equals(other.getReservedIpRangesList())) return false;
    if (hasBaseOutputDirectory() != other.hasBaseOutputDirectory()) return false;
    if (hasBaseOutputDirectory()) {
      if (!getBaseOutputDirectory().equals(other.getBaseOutputDirectory())) return false;
    }
    if (!getProtectedArtifactLocationId().equals(other.getProtectedArtifactLocationId()))
      return false;
    if (!getTensorboard().equals(other.getTensorboard())) return false;
    if (getEnableWebAccess() != other.getEnableWebAccess()) return false;
    if (getEnableDashboardAccess() != other.getEnableDashboardAccess()) return false;
    if (!getExperiment().equals(other.getExperiment())) return false;
    if (!getExperimentRun().equals(other.getExperimentRun())) return false;
    if (!getModelsList().equals(other.getModelsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PERSISTENT_RESOURCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPersistentResourceId().hashCode();
    if (getWorkerPoolSpecsCount() > 0) {
      hash = (37 * hash) + WORKER_POOL_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerPoolSpecsList().hashCode();
    }
    if (hasScheduling()) {
      hash = (37 * hash) + SCHEDULING_FIELD_NUMBER;
      hash = (53 * hash) + getScheduling().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    if (getReservedIpRangesCount() > 0) {
      hash = (37 * hash) + RESERVED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getReservedIpRangesList().hashCode();
    }
    if (hasBaseOutputDirectory()) {
      hash = (37 * hash) + BASE_OUTPUT_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getBaseOutputDirectory().hashCode();
    }
    hash = (37 * hash) + PROTECTED_ARTIFACT_LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProtectedArtifactLocationId().hashCode();
    hash = (37 * hash) + TENSORBOARD_FIELD_NUMBER;
    hash = (53 * hash) + getTensorboard().hashCode();
    hash = (37 * hash) + ENABLE_WEB_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableWebAccess());
    hash = (37 * hash) + ENABLE_DASHBOARD_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableDashboardAccess());
    hash = (37 * hash) + EXPERIMENT_FIELD_NUMBER;
    hash = (53 * hash) + getExperiment().hashCode();
    hash = (37 * hash) + EXPERIMENT_RUN_FIELD_NUMBER;
    hash = (53 * hash) + getExperimentRun().hashCode();
    if (getModelsCount() > 0) {
      hash = (37 * hash) + MODELS_FIELD_NUMBER;
      hash = (53 * hash) + getModelsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.CustomJobSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the spec of a CustomJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.CustomJobSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.CustomJobSpec)
      com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.CustomJobSpec.class,
              com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.CustomJobSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWorkerPoolSpecsFieldBuilder();
        getSchedulingFieldBuilder();
        getBaseOutputDirectoryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      persistentResourceId_ = "";
      if (workerPoolSpecsBuilder_ == null) {
        workerPoolSpecs_ = java.util.Collections.emptyList();
      } else {
        workerPoolSpecs_ = null;
        workerPoolSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      serviceAccount_ = "";
      network_ = "";
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      baseOutputDirectory_ = null;
      if (baseOutputDirectoryBuilder_ != null) {
        baseOutputDirectoryBuilder_.dispose();
        baseOutputDirectoryBuilder_ = null;
      }
      protectedArtifactLocationId_ = "";
      tensorboard_ = "";
      enableWebAccess_ = false;
      enableDashboardAccess_ = false;
      experiment_ = "";
      experimentRun_ = "";
      models_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec build() {
      com.google.cloud.aiplatform.v1beta1.CustomJobSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.CustomJobSpec result =
          new com.google.cloud.aiplatform.v1beta1.CustomJobSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.CustomJobSpec result) {
      if (workerPoolSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          workerPoolSpecs_ = java.util.Collections.unmodifiableList(workerPoolSpecs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.workerPoolSpecs_ = workerPoolSpecs_;
      } else {
        result.workerPoolSpecs_ = workerPoolSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.CustomJobSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.persistentResourceId_ = persistentResourceId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.scheduling_ = schedulingBuilder_ == null ? scheduling_ : schedulingBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        reservedIpRanges_.makeImmutable();
        result.reservedIpRanges_ = reservedIpRanges_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.baseOutputDirectory_ =
            baseOutputDirectoryBuilder_ == null
                ? baseOutputDirectory_
                : baseOutputDirectoryBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.protectedArtifactLocationId_ = protectedArtifactLocationId_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.tensorboard_ = tensorboard_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.enableWebAccess_ = enableWebAccess_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.enableDashboardAccess_ = enableDashboardAccess_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.experiment_ = experiment_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.experimentRun_ = experimentRun_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        models_.makeImmutable();
        result.models_ = models_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.CustomJobSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.CustomJobSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.CustomJobSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance())
        return this;
      if (!other.getPersistentResourceId().isEmpty()) {
        persistentResourceId_ = other.persistentResourceId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (workerPoolSpecsBuilder_ == null) {
        if (!other.workerPoolSpecs_.isEmpty()) {
          if (workerPoolSpecs_.isEmpty()) {
            workerPoolSpecs_ = other.workerPoolSpecs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureWorkerPoolSpecsIsMutable();
            workerPoolSpecs_.addAll(other.workerPoolSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.workerPoolSpecs_.isEmpty()) {
          if (workerPoolSpecsBuilder_.isEmpty()) {
            workerPoolSpecsBuilder_.dispose();
            workerPoolSpecsBuilder_ = null;
            workerPoolSpecs_ = other.workerPoolSpecs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            workerPoolSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWorkerPoolSpecsFieldBuilder()
                    : null;
          } else {
            workerPoolSpecsBuilder_.addAllMessages(other.workerPoolSpecs_);
          }
        }
      }
      if (other.hasScheduling()) {
        mergeScheduling(other.getScheduling());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.reservedIpRanges_.isEmpty()) {
        if (reservedIpRanges_.isEmpty()) {
          reservedIpRanges_ = other.reservedIpRanges_;
          bitField0_ |= 0x00000020;
        } else {
          ensureReservedIpRangesIsMutable();
          reservedIpRanges_.addAll(other.reservedIpRanges_);
        }
        onChanged();
      }
      if (other.hasBaseOutputDirectory()) {
        mergeBaseOutputDirectory(other.getBaseOutputDirectory());
      }
      if (!other.getProtectedArtifactLocationId().isEmpty()) {
        protectedArtifactLocationId_ = other.protectedArtifactLocationId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getTensorboard().isEmpty()) {
        tensorboard_ = other.tensorboard_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.getEnableWebAccess() != false) {
        setEnableWebAccess(other.getEnableWebAccess());
      }
      if (other.getEnableDashboardAccess() != false) {
        setEnableDashboardAccess(other.getEnableDashboardAccess());
      }
      if (!other.getExperiment().isEmpty()) {
        experiment_ = other.experiment_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getExperimentRun().isEmpty()) {
        experimentRun_ = other.experimentRun_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.models_.isEmpty()) {
        if (models_.isEmpty()) {
          models_ = other.models_;
          bitField0_ |= 0x00002000;
        } else {
          ensureModelsIsMutable();
          models_.addAll(other.models_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.parser(),
                        extensionRegistry);
                if (workerPoolSpecsBuilder_ == null) {
                  ensureWorkerPoolSpecsIsMutable();
                  workerPoolSpecs_.add(m);
                } else {
                  workerPoolSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getSchedulingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getBaseOutputDirectoryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                tensorboard_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 80:
              {
                enableWebAccess_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReservedIpRangesIsMutable();
                reservedIpRanges_.add(s);
                break;
              } // case 106
            case 114:
              {
                persistentResourceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 114
            case 128:
              {
                enableDashboardAccess_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 128
            case 138:
              {
                experiment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 138
            case 146:
              {
                experimentRun_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 146
            case 154:
              {
                protectedArtifactLocationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 154
            case 162:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureModelsIsMutable();
                models_.add(s);
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object persistentResourceId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The ID of the PersistentResource in the same Project and Location
     * which to run
     *
     * If this is specified, the job will be run on existing machines held by the
     * PersistentResource instead of on-demand short-live machines.
     * The network and CMEK configs on the job should be consistent with those on
     * the PersistentResource, otherwise, the job will be rejected.
     * </pre>
     *
     * <code>
     * string persistent_resource_id = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The persistentResourceId.
     */
    public java.lang.String getPersistentResourceId() {
      java.lang.Object ref = persistentResourceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        persistentResourceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the PersistentResource in the same Project and Location
     * which to run
     *
     * If this is specified, the job will be run on existing machines held by the
     * PersistentResource instead of on-demand short-live machines.
     * The network and CMEK configs on the job should be consistent with those on
     * the PersistentResource, otherwise, the job will be rejected.
     * </pre>
     *
     * <code>
     * string persistent_resource_id = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for persistentResourceId.
     */
    public com.google.protobuf.ByteString getPersistentResourceIdBytes() {
      java.lang.Object ref = persistentResourceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        persistentResourceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the PersistentResource in the same Project and Location
     * which to run
     *
     * If this is specified, the job will be run on existing machines held by the
     * PersistentResource instead of on-demand short-live machines.
     * The network and CMEK configs on the job should be consistent with those on
     * the PersistentResource, otherwise, the job will be rejected.
     * </pre>
     *
     * <code>
     * string persistent_resource_id = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The persistentResourceId to set.
     * @return This builder for chaining.
     */
    public Builder setPersistentResourceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      persistentResourceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the PersistentResource in the same Project and Location
     * which to run
     *
     * If this is specified, the job will be run on existing machines held by the
     * PersistentResource instead of on-demand short-live machines.
     * The network and CMEK configs on the job should be consistent with those on
     * the PersistentResource, otherwise, the job will be rejected.
     * </pre>
     *
     * <code>
     * string persistent_resource_id = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPersistentResourceId() {
      persistentResourceId_ = getDefaultInstance().getPersistentResourceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the PersistentResource in the same Project and Location
     * which to run
     *
     * If this is specified, the job will be run on existing machines held by the
     * PersistentResource instead of on-demand short-live machines.
     * The network and CMEK configs on the job should be consistent with those on
     * the PersistentResource, otherwise, the job will be rejected.
     * </pre>
     *
     * <code>
     * string persistent_resource_id = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for persistentResourceId to set.
     * @return This builder for chaining.
     */
    public Builder setPersistentResourceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      persistentResourceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec> workerPoolSpecs_ =
        java.util.Collections.emptyList();

    private void ensureWorkerPoolSpecsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        workerPoolSpecs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec>(
                workerPoolSpecs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
        workerPoolSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec>
        getWorkerPoolSpecsList() {
      if (workerPoolSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(workerPoolSpecs_);
      } else {
        return workerPoolSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getWorkerPoolSpecsCount() {
      if (workerPoolSpecsBuilder_ == null) {
        return workerPoolSpecs_.size();
      } else {
        return workerPoolSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec getWorkerPoolSpecs(int index) {
      if (workerPoolSpecsBuilder_ == null) {
        return workerPoolSpecs_.get(index);
      } else {
        return workerPoolSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec value) {
      if (workerPoolSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.set(index, value);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder builderForValue) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        workerPoolSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec value) {
      if (workerPoolSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(value);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec value) {
      if (workerPoolSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(index, value);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(
        com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder builderForValue) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder builderForValue) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllWorkerPoolSpecs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec> values) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, workerPoolSpecs_);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearWorkerPoolSpecs() {
      if (workerPoolSpecsBuilder_ == null) {
        workerPoolSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeWorkerPoolSpecs(int index) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.remove(index);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder getWorkerPoolSpecsBuilder(
        int index) {
      return getWorkerPoolSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder getWorkerPoolSpecsOrBuilder(
        int index) {
      if (workerPoolSpecsBuilder_ == null) {
        return workerPoolSpecs_.get(index);
      } else {
        return workerPoolSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
        getWorkerPoolSpecsOrBuilderList() {
      if (workerPoolSpecsBuilder_ != null) {
        return workerPoolSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(workerPoolSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder addWorkerPoolSpecsBuilder() {
      return getWorkerPoolSpecsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder addWorkerPoolSpecsBuilder(
        int index) {
      return getWorkerPoolSpecsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker
     * image. All worker pools except the first one are optional and can be
     * skipped by providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder>
        getWorkerPoolSpecsBuilderList() {
      return getWorkerPoolSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
        getWorkerPoolSpecsFieldBuilder() {
      if (workerPoolSpecsBuilder_ == null) {
        workerPoolSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec,
                com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>(
                workerPoolSpecs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        workerPoolSpecs_ = null;
      }
      return workerPoolSpecsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.Scheduling scheduling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Scheduling,
            com.google.cloud.aiplatform.v1beta1.Scheduling.Builder,
            com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder>
        schedulingBuilder_;
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     *
     * @return Whether the scheduling field is set.
     */
    public boolean hasScheduling() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     *
     * @return The scheduling.
     */
    public com.google.cloud.aiplatform.v1beta1.Scheduling getScheduling() {
      if (schedulingBuilder_ == null) {
        return scheduling_ == null
            ? com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()
            : scheduling_;
      } else {
        return schedulingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder setScheduling(com.google.cloud.aiplatform.v1beta1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduling_ = value;
      } else {
        schedulingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder setScheduling(
        com.google.cloud.aiplatform.v1beta1.Scheduling.Builder builderForValue) {
      if (schedulingBuilder_ == null) {
        scheduling_ = builderForValue.build();
      } else {
        schedulingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder mergeScheduling(com.google.cloud.aiplatform.v1beta1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && scheduling_ != null
            && scheduling_ != com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()) {
          getSchedulingBuilder().mergeFrom(value);
        } else {
          scheduling_ = value;
        }
      } else {
        schedulingBuilder_.mergeFrom(value);
      }
      if (scheduling_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder clearScheduling() {
      bitField0_ = (bitField0_ & ~0x00000004);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Scheduling.Builder getSchedulingBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSchedulingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder getSchedulingOrBuilder() {
      if (schedulingBuilder_ != null) {
        return schedulingBuilder_.getMessageOrBuilder();
      } else {
        return scheduling_ == null
            ? com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()
            : scheduling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Scheduling,
            com.google.cloud.aiplatform.v1beta1.Scheduling.Builder,
            com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder>
        getSchedulingFieldBuilder() {
      if (schedulingBuilder_ == null) {
        schedulingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Scheduling,
                com.google.cloud.aiplatform.v1beta1.Scheduling.Builder,
                com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder>(
                getScheduling(), getParentForChildren(), isClean());
        scheduling_ = null;
      }
      return schedulingBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>
     * string network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>
     * string network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>
     * string network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>
     * string network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>
     * string network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReservedIpRangesIsMutable() {
      if (!reservedIpRanges_.isModifiable()) {
        reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList(reservedIpRanges_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the reservedIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
      reservedIpRanges_.makeImmutable();
      return reservedIpRanges_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of reservedIpRanges.
     */
    public int getReservedIpRangesCount() {
      return reservedIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The reservedIpRanges at the given index.
     */
    public java.lang.String getReservedIpRanges(int index) {
      return reservedIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reservedIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
      return reservedIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The reservedIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllReservedIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureReservedIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservedIpRanges_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRanges() {
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     *
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.GcsDestination baseOutputDirectory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        baseOutputDirectoryBuilder_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     *
     * @return Whether the baseOutputDirectory field is set.
     */
    public boolean hasBaseOutputDirectory() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     *
     * @return The baseOutputDirectory.
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getBaseOutputDirectory() {
      if (baseOutputDirectoryBuilder_ == null) {
        return baseOutputDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : baseOutputDirectory_;
      } else {
        return baseOutputDirectoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder setBaseOutputDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (baseOutputDirectoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        baseOutputDirectory_ = value;
      } else {
        baseOutputDirectoryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder setBaseOutputDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (baseOutputDirectoryBuilder_ == null) {
        baseOutputDirectory_ = builderForValue.build();
      } else {
        baseOutputDirectoryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder mergeBaseOutputDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (baseOutputDirectoryBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && baseOutputDirectory_ != null
            && baseOutputDirectory_
                != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
          getBaseOutputDirectoryBuilder().mergeFrom(value);
        } else {
          baseOutputDirectory_ = value;
        }
      } else {
        baseOutputDirectoryBuilder_.mergeFrom(value);
      }
      if (baseOutputDirectory_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder clearBaseOutputDirectory() {
      bitField0_ = (bitField0_ & ~0x00000040);
      baseOutputDirectory_ = null;
      if (baseOutputDirectoryBuilder_ != null) {
        baseOutputDirectoryBuilder_.dispose();
        baseOutputDirectoryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder
        getBaseOutputDirectoryBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getBaseOutputDirectoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getBaseOutputDirectoryOrBuilder() {
      if (baseOutputDirectoryBuilder_ != null) {
        return baseOutputDirectoryBuilder_.getMessageOrBuilder();
      } else {
        return baseOutputDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : baseOutputDirectory_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent
     * HyperparameterTuningJob's baseOutputDirectory.
     *
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *
     *   For CustomJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getBaseOutputDirectoryFieldBuilder() {
      if (baseOutputDirectoryBuilder_ == null) {
        baseOutputDirectoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                getBaseOutputDirectory(), getParentForChildren(), isClean());
        baseOutputDirectory_ = null;
      }
      return baseOutputDirectoryBuilder_;
    }

    private java.lang.Object protectedArtifactLocationId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the location to store protected artifacts. e.g. us-central1.
     * Populate only when the location is different than CustomJob location.
     * List of supported locations:
     * https://cloud.google.com/vertex-ai/docs/general/locations
     * </pre>
     *
     * <code>string protected_artifact_location_id = 19;</code>
     *
     * @return The protectedArtifactLocationId.
     */
    public java.lang.String getProtectedArtifactLocationId() {
      java.lang.Object ref = protectedArtifactLocationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protectedArtifactLocationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the location to store protected artifacts. e.g. us-central1.
     * Populate only when the location is different than CustomJob location.
     * List of supported locations:
     * https://cloud.google.com/vertex-ai/docs/general/locations
     * </pre>
     *
     * <code>string protected_artifact_location_id = 19;</code>
     *
     * @return The bytes for protectedArtifactLocationId.
     */
    public com.google.protobuf.ByteString getProtectedArtifactLocationIdBytes() {
      java.lang.Object ref = protectedArtifactLocationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protectedArtifactLocationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the location to store protected artifacts. e.g. us-central1.
     * Populate only when the location is different than CustomJob location.
     * List of supported locations:
     * https://cloud.google.com/vertex-ai/docs/general/locations
     * </pre>
     *
     * <code>string protected_artifact_location_id = 19;</code>
     *
     * @param value The protectedArtifactLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setProtectedArtifactLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protectedArtifactLocationId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the location to store protected artifacts. e.g. us-central1.
     * Populate only when the location is different than CustomJob location.
     * List of supported locations:
     * https://cloud.google.com/vertex-ai/docs/general/locations
     * </pre>
     *
     * <code>string protected_artifact_location_id = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectedArtifactLocationId() {
      protectedArtifactLocationId_ = getDefaultInstance().getProtectedArtifactLocationId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the location to store protected artifacts. e.g. us-central1.
     * Populate only when the location is different than CustomJob location.
     * List of supported locations:
     * https://cloud.google.com/vertex-ai/docs/general/locations
     * </pre>
     *
     * <code>string protected_artifact_location_id = 19;</code>
     *
     * @param value The bytes for protectedArtifactLocationId to set.
     * @return This builder for chaining.
     */
    public Builder setProtectedArtifactLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protectedArtifactLocationId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object tensorboard_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI
     * [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to
     * which this CustomJob will upload Tensorboard logs. Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tensorboard.
     */
    public java.lang.String getTensorboard() {
      java.lang.Object ref = tensorboard_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tensorboard_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI
     * [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to
     * which this CustomJob will upload Tensorboard logs. Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tensorboard.
     */
    public com.google.protobuf.ByteString getTensorboardBytes() {
      java.lang.Object ref = tensorboard_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tensorboard_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI
     * [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to
     * which this CustomJob will upload Tensorboard logs. Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tensorboard to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboard(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tensorboard_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI
     * [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to
     * which this CustomJob will upload Tensorboard logs. Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTensorboard() {
      tensorboard_ = getDefaultInstance().getTensorboard();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI
     * [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to
     * which this CustomJob will upload Tensorboard logs. Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tensorboard to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboardBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tensorboard_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private boolean enableWebAccess_;
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable [interactive shell
     * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * to training containers.
     *
     * If set to `true`, you can access interactive shells at the URIs given
     * by
     * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
     * or
     * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
     * (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableWebAccess.
     */
    @java.lang.Override
    public boolean getEnableWebAccess() {
      return enableWebAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable [interactive shell
     * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * to training containers.
     *
     * If set to `true`, you can access interactive shells at the URIs given
     * by
     * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
     * or
     * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
     * (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableWebAccess to set.
     * @return This builder for chaining.
     */
    public Builder setEnableWebAccess(boolean value) {

      enableWebAccess_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable [interactive shell
     * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * to training containers.
     *
     * If set to `true`, you can access interactive shells at the URIs given
     * by
     * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
     * or
     * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
     * (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableWebAccess() {
      bitField0_ = (bitField0_ & ~0x00000200);
      enableWebAccess_ = false;
      onChanged();
      return this;
    }

    private boolean enableDashboardAccess_;
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable access to the customized
     * dashboard in training chief container.
     *
     * If set to `true`, you can access the dashboard at the URIs given
     * by
     * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
     * or
     * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
     * (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_dashboard_access = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableDashboardAccess.
     */
    @java.lang.Override
    public boolean getEnableDashboardAccess() {
      return enableDashboardAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable access to the customized
     * dashboard in training chief container.
     *
     * If set to `true`, you can access the dashboard at the URIs given
     * by
     * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
     * or
     * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
     * (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_dashboard_access = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableDashboardAccess to set.
     * @return This builder for chaining.
     */
    public Builder setEnableDashboardAccess(boolean value) {

      enableDashboardAccess_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable access to the customized
     * dashboard in training chief container.
     *
     * If set to `true`, you can access the dashboard at the URIs given
     * by
     * [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris]
     * or
     * [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris]
     * (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_dashboard_access = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableDashboardAccess() {
      bitField0_ = (bitField0_ & ~0x00000400);
      enableDashboardAccess_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object experiment_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Experiment associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
     * </pre>
     *
     * <code>
     * string experiment = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The experiment.
     */
    public java.lang.String getExperiment() {
      java.lang.Object ref = experiment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        experiment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
     * </pre>
     *
     * <code>
     * string experiment = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for experiment.
     */
    public com.google.protobuf.ByteString getExperimentBytes() {
      java.lang.Object ref = experiment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        experiment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
     * </pre>
     *
     * <code>
     * string experiment = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The experiment to set.
     * @return This builder for chaining.
     */
    public Builder setExperiment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      experiment_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
     * </pre>
     *
     * <code>
     * string experiment = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExperiment() {
      experiment_ = getDefaultInstance().getExperiment();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
     * </pre>
     *
     * <code>
     * string experiment = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for experiment to set.
     * @return This builder for chaining.
     */
    public Builder setExperimentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      experiment_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object experimentRun_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Experiment Run associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
     * </pre>
     *
     * <code>
     * string experiment_run = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The experimentRun.
     */
    public java.lang.String getExperimentRun() {
      java.lang.Object ref = experimentRun_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        experimentRun_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment Run associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
     * </pre>
     *
     * <code>
     * string experiment_run = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for experimentRun.
     */
    public com.google.protobuf.ByteString getExperimentRunBytes() {
      java.lang.Object ref = experimentRun_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        experimentRun_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment Run associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
     * </pre>
     *
     * <code>
     * string experiment_run = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The experimentRun to set.
     * @return This builder for chaining.
     */
    public Builder setExperimentRun(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      experimentRun_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment Run associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
     * </pre>
     *
     * <code>
     * string experiment_run = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExperimentRun() {
      experimentRun_ = getDefaultInstance().getExperimentRun();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Experiment Run associated with this job.
     * Format:
     * `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
     * </pre>
     *
     * <code>
     * string experiment_run = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for experimentRun to set.
     * @return This builder for chaining.
     */
    public Builder setExperimentRunBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      experimentRun_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList models_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureModelsIsMutable() {
      if (!models_.isModifiable()) {
        models_ = new com.google.protobuf.LazyStringArrayList(models_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the models.
     */
    public com.google.protobuf.ProtocolStringList getModelsList() {
      models_.makeImmutable();
      return models_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of models.
     */
    public int getModelsCount() {
      return models_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The models at the given index.
     */
    public java.lang.String getModels(int index) {
      return models_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the models at the given index.
     */
    public com.google.protobuf.ByteString getModelsBytes(int index) {
      return models_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The models to set.
     * @return This builder for chaining.
     */
    public Builder setModels(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureModelsIsMutable();
      models_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The models to add.
     * @return This builder for chaining.
     */
    public Builder addModels(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureModelsIsMutable();
      models_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The models to add.
     * @return This builder for chaining.
     */
    public Builder addAllModels(java.lang.Iterable<java.lang.String> values) {
      ensureModelsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, models_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModels() {
      models_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Model resources for which to generate a mapping
     * to artifact URIs. Applicable only to some of the Google-provided custom
     * jobs. Format: `projects/{project}/locations/{location}/models/{model}`
     *
     * In order to retrieve a specific version of the model, also provide
     * the version ID or version alias.
     *   Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * If no version ID or alias is specified, the "default" version will be
     * returned. The "default" version alias is created for the first version of
     * the model, and can be moved to other versions later on. There will be
     * exactly one default version.
     * </pre>
     *
     * <code>
     * repeated string models = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the models to add.
     * @return This builder for chaining.
     */
    public Builder addModelsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureModelsIsMutable();
      models_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.CustomJobSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.CustomJobSpec)
  private static final com.google.cloud.aiplatform.v1beta1.CustomJobSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.CustomJobSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomJobSpec> PARSER =
      new com.google.protobuf.AbstractParser<CustomJobSpec>() {
        @java.lang.Override
        public CustomJobSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomJobSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomJobSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
