/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/batch_prediction_job.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A job that uses a
 * [Model][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model] to produce
 * predictions on multiple [input
 * instances][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
 * If predictions for significant portion of the instances fail, the job may
 * finish without attempting predictions for all remaining instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob}
 */
public final class BatchPredictionJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
    BatchPredictionJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchPredictionJob.newBuilder() to construct.
  private BatchPredictionJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchPredictionJob() {
    name_ = "";
    displayName_ = "";
    model_ = "";
    modelVersionId_ = "";
    serviceAccount_ = "";
    state_ = 0;
    partialFailures_ = java.util.Collections.emptyList();
    modelMonitoringStatsAnomalies_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchPredictionJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 19:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.class,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.Builder.class);
  }

  public interface InputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    boolean hasGcsSource();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    boolean hasBigquerySource();
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return The bigquerySource.
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource();
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder getBigquerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instancesFormat.
     */
    java.lang.String getInstancesFormat();
    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instancesFormat.
     */
    com.google.protobuf.ByteString getInstancesFormatBytes();

    com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.SourceCase getSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Configures the input to
   * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
   * See
   * [Model.supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats]
   * for Model's supported input formats, and how instances should be expressed
   * via any of them.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig}
   */
  public static final class InputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
      InputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InputConfig.newBuilder() to construct.
    private InputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InputConfig() {
      instancesFormat_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InputConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder.class);
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_SOURCE(2),
      BIGQUERY_SOURCE(3),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 2:
            return GCS_SOURCE;
          case 3:
            return BIGQUERY_SOURCE;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
    }

    public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
    }

    public static final int INSTANCES_FORMAT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object instancesFormat_ = "";
    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instancesFormat.
     */
    @java.lang.Override
    public java.lang.String getInstancesFormat() {
      java.lang.Object ref = instancesFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instancesFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instancesFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInstancesFormatBytes() {
      java.lang.Object ref = instancesFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instancesFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instancesFormat_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instancesFormat_);
      }
      if (sourceCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.GcsSource) source_);
      }
      if (sourceCase_ == 3) {
        output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instancesFormat_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instancesFormat_);
      }
      if (sourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.aiplatform.v1beta1.GcsSource) source_);
      }
      if (sourceCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig other =
          (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig) obj;

      if (!getInstancesFormat().equals(other.getInstancesFormat())) return false;
      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 2:
          if (!getGcsSource().equals(other.getGcsSource())) return false;
          break;
        case 3:
          if (!getBigquerySource().equals(other.getBigquerySource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INSTANCES_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesFormat().hashCode();
      switch (sourceCase_) {
        case 2:
          hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGcsSource().hashCode();
          break;
        case 3:
          hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getBigquerySource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configures the input to
     * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
     * See
     * [Model.supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats]
     * for Model's supported input formats, and how instances should be expressed
     * via any of them.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.class,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gcsSourceBuilder_ != null) {
          gcsSourceBuilder_.clear();
        }
        if (bigquerySourceBuilder_ != null) {
          bigquerySourceBuilder_.clear();
        }
        instancesFormat_ = "";
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig build() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig result =
            new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.instancesFormat_ = instancesFormat_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 2 && gcsSourceBuilder_ != null) {
          result.source_ = gcsSourceBuilder_.build();
        }
        if (sourceCase_ == 3 && bigquerySourceBuilder_ != null) {
          result.source_ = bigquerySourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
                .getDefaultInstance()) return this;
        if (!other.getInstancesFormat().isEmpty()) {
          instancesFormat_ = other.instancesFormat_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getSourceCase()) {
          case GCS_SOURCE:
            {
              mergeGcsSource(other.getGcsSource());
              break;
            }
          case BIGQUERY_SOURCE:
            {
              mergeBigquerySource(other.getBigquerySource());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  instancesFormat_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getBigquerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsSource,
              com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
          gcsSourceBuilder_;
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       *
       * @return Whether the gcsSource field is set.
       */
      @java.lang.Override
      public boolean hasGcsSource() {
        return sourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       *
       * @return The gcsSource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 2) {
            return gcsSourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder setGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder setGcsSource(
          com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
        if (gcsSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder mergeGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 2
              && source_ != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.GcsSource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 2) {
            gcsSourceBuilder_.mergeFrom(value);
          } else {
            gcsSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder clearGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
          }
          gcsSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsSourceBuilder() {
        return getGcsSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
        if ((sourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
          return gcsSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsSource,
              com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
          getGcsSourceFieldBuilder() {
        if (gcsSourceBuilder_ == null) {
          if (!(sourceCase_ == 2)) {
            source_ = com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
          }
          gcsSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GcsSource,
                  com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                  com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.GcsSource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 2;
        onChanged();
        return gcsSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          bigquerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       *
       * @return Whether the bigquerySource field is set.
       */
      @java.lang.Override
      public boolean hasBigquerySource() {
        return sourceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       *
       * @return The bigquerySource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        } else {
          if (sourceCase_ == 3) {
            return bigquerySourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder setBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder setBigquerySource(
          com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder builderForValue) {
        if (bigquerySourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder mergeBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 3
              && source_
                  != com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.BigQuerySource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 3) {
            bigquerySourceBuilder_.mergeFrom(value);
          } else {
            bigquerySourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder clearBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
          }
          bigquerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder getBigquerySourceBuilder() {
        return getBigquerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
          getBigquerySourceOrBuilder() {
        if ((sourceCase_ == 3) && (bigquerySourceBuilder_ != null)) {
          return bigquerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          getBigquerySourceFieldBuilder() {
        if (bigquerySourceBuilder_ == null) {
          if (!(sourceCase_ == 3)) {
            source_ = com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
          }
          bigquerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 3;
        onChanged();
        return bigquerySourceBuilder_;
      }

      private java.lang.Object instancesFormat_ = "";
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The instancesFormat.
       */
      public java.lang.String getInstancesFormat() {
        java.lang.Object ref = instancesFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          instancesFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for instancesFormat.
       */
      public com.google.protobuf.ByteString getInstancesFormatBytes() {
        java.lang.Object ref = instancesFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          instancesFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The instancesFormat to set.
       * @return This builder for chaining.
       */
      public Builder setInstancesFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        instancesFormat_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstancesFormat() {
        instancesFormat_ = getDefaultInstance().getInstancesFormat();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for instancesFormat to set.
       * @return This builder for chaining.
       */
      public Builder setInstancesFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        instancesFormat_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
    private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InputConfig> PARSER =
        new com.google.protobuf.AbstractParser<InputConfig>() {
          @java.lang.Override
          public InputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstanceConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The format of the instance that the Model accepts. Vertex AI will
     * convert compatible
     * [batch prediction input instance
     * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
     * to the specified format.
     *
     * Supported values are:
     *
     * * `object`: Each input is converted to JSON object format.
     *     * For `bigquery`, each row is converted to an object.
     *     * For `jsonl`, each line of the JSONL input must be an object.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * * `array`: Each input is converted to JSON array format.
     *     * For `bigquery`, each row is converted to an array. The order
     *       of columns is determined by the BigQuery column order, unless
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       is populated.
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * For `jsonl`, if each line of the JSONL input is an object,
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * If not specified, Vertex AI converts the batch prediction input as
     * follows:
     *
     *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
     *    order of columns is the same as defined in the file or table, unless
     *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *    is populated.
     *  * For `jsonl`, the prediction instance format is determined by
     *    each line of the input.
     *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
     *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the record.
     *  * For `file-list`, each file in the list will be converted to an
     *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the file.
     * </pre>
     *
     * <code>string instance_type = 1;</code>
     *
     * @return The instanceType.
     */
    java.lang.String getInstanceType();
    /**
     *
     *
     * <pre>
     * The format of the instance that the Model accepts. Vertex AI will
     * convert compatible
     * [batch prediction input instance
     * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
     * to the specified format.
     *
     * Supported values are:
     *
     * * `object`: Each input is converted to JSON object format.
     *     * For `bigquery`, each row is converted to an object.
     *     * For `jsonl`, each line of the JSONL input must be an object.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * * `array`: Each input is converted to JSON array format.
     *     * For `bigquery`, each row is converted to an array. The order
     *       of columns is determined by the BigQuery column order, unless
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       is populated.
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * For `jsonl`, if each line of the JSONL input is an object,
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * If not specified, Vertex AI converts the batch prediction input as
     * follows:
     *
     *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
     *    order of columns is the same as defined in the file or table, unless
     *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *    is populated.
     *  * For `jsonl`, the prediction instance format is determined by
     *    each line of the input.
     *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
     *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the record.
     *  * For `file-list`, each file in the list will be converted to an
     *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the file.
     * </pre>
     *
     * <code>string instance_type = 1;</code>
     *
     * @return The bytes for instanceType.
     */
    com.google.protobuf.ByteString getInstanceTypeBytes();

    /**
     *
     *
     * <pre>
     * The name of the field that is considered as a key.
     *
     * The values identified by the key field is not included in the transformed
     * instances that is sent to the Model. This is similar to
     * specifying this name of the field in
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
     * In addition, the batch prediction output will not include the instances.
     * Instead the output will only include the value of the key field, in a
     * field named `key` in the output:
     *
     *  * For `jsonl` output format, the output will have a `key` field
     *    instead of the `instance` field.
     *  * For `csv`/`bigquery` output format, the output will have have a `key`
     *    column instead of the instance feature columns.
     *
     * The input must be JSONL with objects at each line, CSV, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>string key_field = 2;</code>
     *
     * @return The keyField.
     */
    java.lang.String getKeyField();
    /**
     *
     *
     * <pre>
     * The name of the field that is considered as a key.
     *
     * The values identified by the key field is not included in the transformed
     * instances that is sent to the Model. This is similar to
     * specifying this name of the field in
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
     * In addition, the batch prediction output will not include the instances.
     * Instead the output will only include the value of the key field, in a
     * field named `key` in the output:
     *
     *  * For `jsonl` output format, the output will have a `key` field
     *    instead of the `instance` field.
     *  * For `csv`/`bigquery` output format, the output will have have a `key`
     *    column instead of the instance feature columns.
     *
     * The input must be JSONL with objects at each line, CSV, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>string key_field = 2;</code>
     *
     * @return The bytes for keyField.
     */
    com.google.protobuf.ByteString getKeyFieldBytes();

    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @return A list containing the includedFields.
     */
    java.util.List<java.lang.String> getIncludedFieldsList();
    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @return The count of includedFields.
     */
    int getIncludedFieldsCount();
    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The includedFields at the given index.
     */
    java.lang.String getIncludedFields(int index);
    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includedFields at the given index.
     */
    com.google.protobuf.ByteString getIncludedFieldsBytes(int index);

    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @return A list containing the excludedFields.
     */
    java.util.List<java.lang.String> getExcludedFieldsList();
    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @return The count of excludedFields.
     */
    int getExcludedFieldsCount();
    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The excludedFields at the given index.
     */
    java.lang.String getExcludedFields(int index);
    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedFields at the given index.
     */
    com.google.protobuf.ByteString getExcludedFieldsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration defining how to transform batch prediction input instances to
   * the instances that the Model accepts.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig}
   */
  public static final class InstanceConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig)
      InstanceConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InstanceConfig.newBuilder() to construct.
    private InstanceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstanceConfig() {
      instanceType_ = "";
      keyField_ = "";
      includedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      excludedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstanceConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InstanceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InstanceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.Builder.class);
    }

    public static final int INSTANCE_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object instanceType_ = "";
    /**
     *
     *
     * <pre>
     * The format of the instance that the Model accepts. Vertex AI will
     * convert compatible
     * [batch prediction input instance
     * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
     * to the specified format.
     *
     * Supported values are:
     *
     * * `object`: Each input is converted to JSON object format.
     *     * For `bigquery`, each row is converted to an object.
     *     * For `jsonl`, each line of the JSONL input must be an object.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * * `array`: Each input is converted to JSON array format.
     *     * For `bigquery`, each row is converted to an array. The order
     *       of columns is determined by the BigQuery column order, unless
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       is populated.
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * For `jsonl`, if each line of the JSONL input is an object,
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * If not specified, Vertex AI converts the batch prediction input as
     * follows:
     *
     *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
     *    order of columns is the same as defined in the file or table, unless
     *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *    is populated.
     *  * For `jsonl`, the prediction instance format is determined by
     *    each line of the input.
     *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
     *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the record.
     *  * For `file-list`, each file in the list will be converted to an
     *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the file.
     * </pre>
     *
     * <code>string instance_type = 1;</code>
     *
     * @return The instanceType.
     */
    @java.lang.Override
    public java.lang.String getInstanceType() {
      java.lang.Object ref = instanceType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The format of the instance that the Model accepts. Vertex AI will
     * convert compatible
     * [batch prediction input instance
     * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
     * to the specified format.
     *
     * Supported values are:
     *
     * * `object`: Each input is converted to JSON object format.
     *     * For `bigquery`, each row is converted to an object.
     *     * For `jsonl`, each line of the JSONL input must be an object.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * * `array`: Each input is converted to JSON array format.
     *     * For `bigquery`, each row is converted to an array. The order
     *       of columns is determined by the BigQuery column order, unless
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       is populated.
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * For `jsonl`, if each line of the JSONL input is an object,
     *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *       must be populated for specifying field orders.
     *     * Does not apply to `csv`, `file-list`, `tf-record`, or
     *       `tf-record-gzip`.
     *
     * If not specified, Vertex AI converts the batch prediction input as
     * follows:
     *
     *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
     *    order of columns is the same as defined in the file or table, unless
     *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     *    is populated.
     *  * For `jsonl`, the prediction instance format is determined by
     *    each line of the input.
     *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
     *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the record.
     *  * For `file-list`, each file in the list will be converted to an
     *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
     *    the Base64-encoded string of the content of the file.
     * </pre>
     *
     * <code>string instance_type = 1;</code>
     *
     * @return The bytes for instanceType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInstanceTypeBytes() {
      java.lang.Object ref = instanceType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KEY_FIELD_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object keyField_ = "";
    /**
     *
     *
     * <pre>
     * The name of the field that is considered as a key.
     *
     * The values identified by the key field is not included in the transformed
     * instances that is sent to the Model. This is similar to
     * specifying this name of the field in
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
     * In addition, the batch prediction output will not include the instances.
     * Instead the output will only include the value of the key field, in a
     * field named `key` in the output:
     *
     *  * For `jsonl` output format, the output will have a `key` field
     *    instead of the `instance` field.
     *  * For `csv`/`bigquery` output format, the output will have have a `key`
     *    column instead of the instance feature columns.
     *
     * The input must be JSONL with objects at each line, CSV, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>string key_field = 2;</code>
     *
     * @return The keyField.
     */
    @java.lang.Override
    public java.lang.String getKeyField() {
      java.lang.Object ref = keyField_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyField_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the field that is considered as a key.
     *
     * The values identified by the key field is not included in the transformed
     * instances that is sent to the Model. This is similar to
     * specifying this name of the field in
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
     * In addition, the batch prediction output will not include the instances.
     * Instead the output will only include the value of the key field, in a
     * field named `key` in the output:
     *
     *  * For `jsonl` output format, the output will have a `key` field
     *    instead of the `instance` field.
     *  * For `csv`/`bigquery` output format, the output will have have a `key`
     *    column instead of the instance feature columns.
     *
     * The input must be JSONL with objects at each line, CSV, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>string key_field = 2;</code>
     *
     * @return The bytes for keyField.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyFieldBytes() {
      java.lang.Object ref = keyField_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INCLUDED_FIELDS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList includedFields_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @return A list containing the includedFields.
     */
    public com.google.protobuf.ProtocolStringList getIncludedFieldsList() {
      return includedFields_;
    }
    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @return The count of includedFields.
     */
    public int getIncludedFieldsCount() {
      return includedFields_.size();
    }
    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The includedFields at the given index.
     */
    public java.lang.String getIncludedFields(int index) {
      return includedFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Fields that will be included in the prediction instance that is
     * sent to the Model.
     *
     * If
     * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
     * is `array`, the order of field names in included_fields also determines
     * the order of the values in the array.
     *
     * When included_fields is populated,
     * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string included_fields = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includedFields at the given index.
     */
    public com.google.protobuf.ByteString getIncludedFieldsBytes(int index) {
      return includedFields_.getByteString(index);
    }

    public static final int EXCLUDED_FIELDS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludedFields_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @return A list containing the excludedFields.
     */
    public com.google.protobuf.ProtocolStringList getExcludedFieldsList() {
      return excludedFields_;
    }
    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @return The count of excludedFields.
     */
    public int getExcludedFieldsCount() {
      return excludedFields_.size();
    }
    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The excludedFields at the given index.
     */
    public java.lang.String getExcludedFields(int index) {
      return excludedFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Fields that will be excluded in the prediction instance that is
     * sent to the Model.
     *
     * Excluded will be attached to the batch prediction output if
     * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
     * is not specified.
     *
     * When excluded_fields is populated,
     * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
     * must be empty.
     *
     * The input must be JSONL with objects at each line, BigQuery
     * or TfRecord.
     * </pre>
     *
     * <code>repeated string excluded_fields = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedFields at the given index.
     */
    public com.google.protobuf.ByteString getExcludedFieldsBytes(int index) {
      return excludedFields_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyField_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, keyField_);
      }
      for (int i = 0; i < includedFields_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, includedFields_.getRaw(i));
      }
      for (int i = 0; i < excludedFields_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, excludedFields_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyField_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, keyField_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < includedFields_.size(); i++) {
          dataSize += computeStringSizeNoTag(includedFields_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getIncludedFieldsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludedFields_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludedFields_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludedFieldsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig other =
          (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig) obj;

      if (!getInstanceType().equals(other.getInstanceType())) return false;
      if (!getKeyField().equals(other.getKeyField())) return false;
      if (!getIncludedFieldsList().equals(other.getIncludedFieldsList())) return false;
      if (!getExcludedFieldsList().equals(other.getExcludedFieldsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INSTANCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceType().hashCode();
      hash = (37 * hash) + KEY_FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getKeyField().hashCode();
      if (getIncludedFieldsCount() > 0) {
        hash = (37 * hash) + INCLUDED_FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getIncludedFieldsList().hashCode();
      }
      if (getExcludedFieldsCount() > 0) {
        hash = (37 * hash) + EXCLUDED_FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getExcludedFieldsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration defining how to transform batch prediction input instances to
     * the instances that the Model accepts.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig)
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InstanceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InstanceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.class,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        instanceType_ = "";
        keyField_ = "";
        includedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
        excludedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InstanceConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig build() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig result =
            new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.instanceType_ = instanceType_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.keyField_ = keyField_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          includedFields_.makeImmutable();
          result.includedFields_ = includedFields_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          excludedFields_.makeImmutable();
          result.excludedFields_ = excludedFields_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
                .getDefaultInstance()) return this;
        if (!other.getInstanceType().isEmpty()) {
          instanceType_ = other.instanceType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getKeyField().isEmpty()) {
          keyField_ = other.keyField_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.includedFields_.isEmpty()) {
          if (includedFields_.isEmpty()) {
            includedFields_ = other.includedFields_;
            bitField0_ |= 0x00000004;
          } else {
            ensureIncludedFieldsIsMutable();
            includedFields_.addAll(other.includedFields_);
          }
          onChanged();
        }
        if (!other.excludedFields_.isEmpty()) {
          if (excludedFields_.isEmpty()) {
            excludedFields_ = other.excludedFields_;
            bitField0_ |= 0x00000008;
          } else {
            ensureExcludedFieldsIsMutable();
            excludedFields_.addAll(other.excludedFields_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  instanceType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  keyField_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureIncludedFieldsIsMutable();
                  includedFields_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludedFieldsIsMutable();
                  excludedFields_.add(s);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object instanceType_ = "";
      /**
       *
       *
       * <pre>
       * The format of the instance that the Model accepts. Vertex AI will
       * convert compatible
       * [batch prediction input instance
       * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
       * to the specified format.
       *
       * Supported values are:
       *
       * * `object`: Each input is converted to JSON object format.
       *     * For `bigquery`, each row is converted to an object.
       *     * For `jsonl`, each line of the JSONL input must be an object.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * * `array`: Each input is converted to JSON array format.
       *     * For `bigquery`, each row is converted to an array. The order
       *       of columns is determined by the BigQuery column order, unless
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       is populated.
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * For `jsonl`, if each line of the JSONL input is an object,
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * If not specified, Vertex AI converts the batch prediction input as
       * follows:
       *
       *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
       *    order of columns is the same as defined in the file or table, unless
       *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *    is populated.
       *  * For `jsonl`, the prediction instance format is determined by
       *    each line of the input.
       *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
       *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the record.
       *  * For `file-list`, each file in the list will be converted to an
       *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the file.
       * </pre>
       *
       * <code>string instance_type = 1;</code>
       *
       * @return The instanceType.
       */
      public java.lang.String getInstanceType() {
        java.lang.Object ref = instanceType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          instanceType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The format of the instance that the Model accepts. Vertex AI will
       * convert compatible
       * [batch prediction input instance
       * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
       * to the specified format.
       *
       * Supported values are:
       *
       * * `object`: Each input is converted to JSON object format.
       *     * For `bigquery`, each row is converted to an object.
       *     * For `jsonl`, each line of the JSONL input must be an object.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * * `array`: Each input is converted to JSON array format.
       *     * For `bigquery`, each row is converted to an array. The order
       *       of columns is determined by the BigQuery column order, unless
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       is populated.
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * For `jsonl`, if each line of the JSONL input is an object,
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * If not specified, Vertex AI converts the batch prediction input as
       * follows:
       *
       *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
       *    order of columns is the same as defined in the file or table, unless
       *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *    is populated.
       *  * For `jsonl`, the prediction instance format is determined by
       *    each line of the input.
       *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
       *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the record.
       *  * For `file-list`, each file in the list will be converted to an
       *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the file.
       * </pre>
       *
       * <code>string instance_type = 1;</code>
       *
       * @return The bytes for instanceType.
       */
      public com.google.protobuf.ByteString getInstanceTypeBytes() {
        java.lang.Object ref = instanceType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          instanceType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The format of the instance that the Model accepts. Vertex AI will
       * convert compatible
       * [batch prediction input instance
       * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
       * to the specified format.
       *
       * Supported values are:
       *
       * * `object`: Each input is converted to JSON object format.
       *     * For `bigquery`, each row is converted to an object.
       *     * For `jsonl`, each line of the JSONL input must be an object.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * * `array`: Each input is converted to JSON array format.
       *     * For `bigquery`, each row is converted to an array. The order
       *       of columns is determined by the BigQuery column order, unless
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       is populated.
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * For `jsonl`, if each line of the JSONL input is an object,
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * If not specified, Vertex AI converts the batch prediction input as
       * follows:
       *
       *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
       *    order of columns is the same as defined in the file or table, unless
       *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *    is populated.
       *  * For `jsonl`, the prediction instance format is determined by
       *    each line of the input.
       *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
       *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the record.
       *  * For `file-list`, each file in the list will be converted to an
       *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the file.
       * </pre>
       *
       * <code>string instance_type = 1;</code>
       *
       * @param value The instanceType to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The format of the instance that the Model accepts. Vertex AI will
       * convert compatible
       * [batch prediction input instance
       * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
       * to the specified format.
       *
       * Supported values are:
       *
       * * `object`: Each input is converted to JSON object format.
       *     * For `bigquery`, each row is converted to an object.
       *     * For `jsonl`, each line of the JSONL input must be an object.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * * `array`: Each input is converted to JSON array format.
       *     * For `bigquery`, each row is converted to an array. The order
       *       of columns is determined by the BigQuery column order, unless
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       is populated.
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * For `jsonl`, if each line of the JSONL input is an object,
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * If not specified, Vertex AI converts the batch prediction input as
       * follows:
       *
       *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
       *    order of columns is the same as defined in the file or table, unless
       *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *    is populated.
       *  * For `jsonl`, the prediction instance format is determined by
       *    each line of the input.
       *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
       *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the record.
       *  * For `file-list`, each file in the list will be converted to an
       *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the file.
       * </pre>
       *
       * <code>string instance_type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstanceType() {
        instanceType_ = getDefaultInstance().getInstanceType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The format of the instance that the Model accepts. Vertex AI will
       * convert compatible
       * [batch prediction input instance
       * formats][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.instances_format]
       * to the specified format.
       *
       * Supported values are:
       *
       * * `object`: Each input is converted to JSON object format.
       *     * For `bigquery`, each row is converted to an object.
       *     * For `jsonl`, each line of the JSONL input must be an object.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * * `array`: Each input is converted to JSON array format.
       *     * For `bigquery`, each row is converted to an array. The order
       *       of columns is determined by the BigQuery column order, unless
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       is populated.
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * For `jsonl`, if each line of the JSONL input is an object,
       *       [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *       must be populated for specifying field orders.
       *     * Does not apply to `csv`, `file-list`, `tf-record`, or
       *       `tf-record-gzip`.
       *
       * If not specified, Vertex AI converts the batch prediction input as
       * follows:
       *
       *  * For `bigquery` and `csv`, the behavior is the same as `array`. The
       *    order of columns is the same as defined in the file or table, unless
       *    [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       *    is populated.
       *  * For `jsonl`, the prediction instance format is determined by
       *    each line of the input.
       *  * For `tf-record`/`tf-record-gzip`, each record will be converted to
       *    an object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the record.
       *  * For `file-list`, each file in the list will be converted to an
       *    object in the format of `{"b64": &lt;value&gt;}`, where `&lt;value&gt;` is
       *    the Base64-encoded string of the content of the file.
       * </pre>
       *
       * <code>string instance_type = 1;</code>
       *
       * @param value The bytes for instanceType to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        instanceType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object keyField_ = "";
      /**
       *
       *
       * <pre>
       * The name of the field that is considered as a key.
       *
       * The values identified by the key field is not included in the transformed
       * instances that is sent to the Model. This is similar to
       * specifying this name of the field in
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
       * In addition, the batch prediction output will not include the instances.
       * Instead the output will only include the value of the key field, in a
       * field named `key` in the output:
       *
       *  * For `jsonl` output format, the output will have a `key` field
       *    instead of the `instance` field.
       *  * For `csv`/`bigquery` output format, the output will have have a `key`
       *    column instead of the instance feature columns.
       *
       * The input must be JSONL with objects at each line, CSV, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>string key_field = 2;</code>
       *
       * @return The keyField.
       */
      public java.lang.String getKeyField() {
        java.lang.Object ref = keyField_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          keyField_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the field that is considered as a key.
       *
       * The values identified by the key field is not included in the transformed
       * instances that is sent to the Model. This is similar to
       * specifying this name of the field in
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
       * In addition, the batch prediction output will not include the instances.
       * Instead the output will only include the value of the key field, in a
       * field named `key` in the output:
       *
       *  * For `jsonl` output format, the output will have a `key` field
       *    instead of the `instance` field.
       *  * For `csv`/`bigquery` output format, the output will have have a `key`
       *    column instead of the instance feature columns.
       *
       * The input must be JSONL with objects at each line, CSV, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>string key_field = 2;</code>
       *
       * @return The bytes for keyField.
       */
      public com.google.protobuf.ByteString getKeyFieldBytes() {
        java.lang.Object ref = keyField_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          keyField_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the field that is considered as a key.
       *
       * The values identified by the key field is not included in the transformed
       * instances that is sent to the Model. This is similar to
       * specifying this name of the field in
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
       * In addition, the batch prediction output will not include the instances.
       * Instead the output will only include the value of the key field, in a
       * field named `key` in the output:
       *
       *  * For `jsonl` output format, the output will have a `key` field
       *    instead of the `instance` field.
       *  * For `csv`/`bigquery` output format, the output will have have a `key`
       *    column instead of the instance feature columns.
       *
       * The input must be JSONL with objects at each line, CSV, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>string key_field = 2;</code>
       *
       * @param value The keyField to set.
       * @return This builder for chaining.
       */
      public Builder setKeyField(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        keyField_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the field that is considered as a key.
       *
       * The values identified by the key field is not included in the transformed
       * instances that is sent to the Model. This is similar to
       * specifying this name of the field in
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
       * In addition, the batch prediction output will not include the instances.
       * Instead the output will only include the value of the key field, in a
       * field named `key` in the output:
       *
       *  * For `jsonl` output format, the output will have a `key` field
       *    instead of the `instance` field.
       *  * For `csv`/`bigquery` output format, the output will have have a `key`
       *    column instead of the instance feature columns.
       *
       * The input must be JSONL with objects at each line, CSV, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>string key_field = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKeyField() {
        keyField_ = getDefaultInstance().getKeyField();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the field that is considered as a key.
       *
       * The values identified by the key field is not included in the transformed
       * instances that is sent to the Model. This is similar to
       * specifying this name of the field in
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields].
       * In addition, the batch prediction output will not include the instances.
       * Instead the output will only include the value of the key field, in a
       * field named `key` in the output:
       *
       *  * For `jsonl` output format, the output will have a `key` field
       *    instead of the `instance` field.
       *  * For `csv`/`bigquery` output format, the output will have have a `key`
       *    column instead of the instance feature columns.
       *
       * The input must be JSONL with objects at each line, CSV, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>string key_field = 2;</code>
       *
       * @param value The bytes for keyField to set.
       * @return This builder for chaining.
       */
      public Builder setKeyFieldBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        keyField_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList includedFields_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureIncludedFieldsIsMutable() {
        if (!includedFields_.isModifiable()) {
          includedFields_ = new com.google.protobuf.LazyStringArrayList(includedFields_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @return A list containing the includedFields.
       */
      public com.google.protobuf.ProtocolStringList getIncludedFieldsList() {
        includedFields_.makeImmutable();
        return includedFields_;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @return The count of includedFields.
       */
      public int getIncludedFieldsCount() {
        return includedFields_.size();
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The includedFields at the given index.
       */
      public java.lang.String getIncludedFields(int index) {
        return includedFields_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the includedFields at the given index.
       */
      public com.google.protobuf.ByteString getIncludedFieldsBytes(int index) {
        return includedFields_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The includedFields to set.
       * @return This builder for chaining.
       */
      public Builder setIncludedFields(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedFieldsIsMutable();
        includedFields_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @param value The includedFields to add.
       * @return This builder for chaining.
       */
      public Builder addIncludedFields(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedFieldsIsMutable();
        includedFields_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @param values The includedFields to add.
       * @return This builder for chaining.
       */
      public Builder addAllIncludedFields(java.lang.Iterable<java.lang.String> values) {
        ensureIncludedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includedFields_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludedFields() {
        includedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be included in the prediction instance that is
       * sent to the Model.
       *
       * If
       * [instance_type][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.instance_type]
       * is `array`, the order of field names in included_fields also determines
       * the order of the values in the array.
       *
       * When included_fields is populated,
       * [excluded_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.excluded_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string included_fields = 3;</code>
       *
       * @param value The bytes of the includedFields to add.
       * @return This builder for chaining.
       */
      public Builder addIncludedFieldsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureIncludedFieldsIsMutable();
        includedFields_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludedFields_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludedFieldsIsMutable() {
        if (!excludedFields_.isModifiable()) {
          excludedFields_ = new com.google.protobuf.LazyStringArrayList(excludedFields_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @return A list containing the excludedFields.
       */
      public com.google.protobuf.ProtocolStringList getExcludedFieldsList() {
        excludedFields_.makeImmutable();
        return excludedFields_;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @return The count of excludedFields.
       */
      public int getExcludedFieldsCount() {
        return excludedFields_.size();
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The excludedFields at the given index.
       */
      public java.lang.String getExcludedFields(int index) {
        return excludedFields_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludedFields at the given index.
       */
      public com.google.protobuf.ByteString getExcludedFieldsBytes(int index) {
        return excludedFields_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludedFields to set.
       * @return This builder for chaining.
       */
      public Builder setExcludedFields(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFieldsIsMutable();
        excludedFields_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @param value The excludedFields to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedFields(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFieldsIsMutable();
        excludedFields_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @param values The excludedFields to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludedFields(java.lang.Iterable<java.lang.String> values) {
        ensureExcludedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludedFields_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludedFields() {
        excludedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fields that will be excluded in the prediction instance that is
       * sent to the Model.
       *
       * Excluded will be attached to the batch prediction output if
       * [key_field][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.key_field]
       * is not specified.
       *
       * When excluded_fields is populated,
       * [included_fields][google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.included_fields]
       * must be empty.
       *
       * The input must be JSONL with objects at each line, BigQuery
       * or TfRecord.
       * </pre>
       *
       * <code>repeated string excluded_fields = 4;</code>
       *
       * @param value The bytes of the excludedFields to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedFieldsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludedFieldsIsMutable();
        excludedFields_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig)
    private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstanceConfig> PARSER =
        new com.google.protobuf.AbstractParser<InstanceConfig>() {
          @java.lang.Override
          public InstanceConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstanceConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstanceConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OutputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    boolean hasGcsDestination();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return The gcsDestination.
     */
    com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     */
    com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getGcsDestinationOrBuilder();

    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    boolean hasBigqueryDestination();
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return The bigqueryDestination.
     */
    com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination();
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     */
    com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be
     * one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The predictionsFormat.
     */
    java.lang.String getPredictionsFormat();
    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be
     * one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for predictionsFormat.
     */
    com.google.protobuf.ByteString getPredictionsFormatBytes();

    com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.DestinationCase
        getDestinationCase();
  }
  /**
   *
   *
   * <pre>
   * Configures the output of
   * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
   * See
   * [Model.supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats]
   * for supported output formats, and how predictions are expressed via any of
   * them.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig}
   */
  public static final class OutputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
      OutputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputConfig.newBuilder() to construct.
    private OutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputConfig() {
      predictionsFormat_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder.class);
    }

    private int destinationCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object destination_;

    public enum DestinationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_DESTINATION(2),
      BIGQUERY_DESTINATION(3),
      DESTINATION_NOT_SET(0);
      private final int value;

      private DestinationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DestinationCase valueOf(int value) {
        return forNumber(value);
      }

      public static DestinationCase forNumber(int value) {
        switch (value) {
          case 2:
            return GCS_DESTINATION;
          case 3:
            return BIGQUERY_DESTINATION;
          case 0:
            return DESTINATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public static final int GCS_DESTINATION_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
      if (destinationCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
     * and N may equal 0001 and depends on the total number of successfully
     * predicted instances. If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getGcsDestinationOrBuilder() {
      if (destinationCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
    }

    public static final int BIGQUERY_DESTINATION_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDestination() {
      return destinationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return The bigqueryDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
      if (destinationCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both
     * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
     * schemata defined then the tables have columns as follows: The
     * `predictions` table contains instances for which the prediction
     * succeeded, it has columns as per a concatenation of the Model's
     * instance and prediction schemata. The `errors` table contains rows for
     * which the prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder() {
      if (destinationCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
    }

    public static final int PREDICTIONS_FORMAT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object predictionsFormat_ = "";
    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be
     * one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The predictionsFormat.
     */
    @java.lang.Override
    public java.lang.String getPredictionsFormat() {
      java.lang.Object ref = predictionsFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predictionsFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be
     * one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for predictionsFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPredictionsFormatBytes() {
      java.lang.Object ref = predictionsFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predictionsFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predictionsFormat_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, predictionsFormat_);
      }
      if (destinationCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
      }
      if (destinationCase_ == 3) {
        output.writeMessage(
            3, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predictionsFormat_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, predictionsFormat_);
      }
      if (destinationCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
      }
      if (destinationCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig other =
          (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig) obj;

      if (!getPredictionsFormat().equals(other.getPredictionsFormat())) return false;
      if (!getDestinationCase().equals(other.getDestinationCase())) return false;
      switch (destinationCase_) {
        case 2:
          if (!getGcsDestination().equals(other.getGcsDestination())) return false;
          break;
        case 3:
          if (!getBigqueryDestination().equals(other.getBigqueryDestination())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PREDICTIONS_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionsFormat().hashCode();
      switch (destinationCase_) {
        case 2:
          hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
          hash = (53 * hash) + getGcsDestination().hashCode();
          break;
        case 3:
          hash = (37 * hash) + BIGQUERY_DESTINATION_FIELD_NUMBER;
          hash = (53 * hash) + getBigqueryDestination().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configures the output of
     * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
     * See
     * [Model.supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats]
     * for supported output formats, and how predictions are expressed via any of
     * them.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.class,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gcsDestinationBuilder_ != null) {
          gcsDestinationBuilder_.clear();
        }
        if (bigqueryDestinationBuilder_ != null) {
          bigqueryDestinationBuilder_.clear();
        }
        predictionsFormat_ = "";
        destinationCase_ = 0;
        destination_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig build() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig result =
            new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.predictionsFormat_ = predictionsFormat_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig result) {
        result.destinationCase_ = destinationCase_;
        result.destination_ = this.destination_;
        if (destinationCase_ == 2 && gcsDestinationBuilder_ != null) {
          result.destination_ = gcsDestinationBuilder_.build();
        }
        if (destinationCase_ == 3 && bigqueryDestinationBuilder_ != null) {
          result.destination_ = bigqueryDestinationBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
                .getDefaultInstance()) return this;
        if (!other.getPredictionsFormat().isEmpty()) {
          predictionsFormat_ = other.predictionsFormat_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getDestinationCase()) {
          case GCS_DESTINATION:
            {
              mergeGcsDestination(other.getGcsDestination());
              break;
            }
          case BIGQUERY_DESTINATION:
            {
              mergeBigqueryDestination(other.getBigqueryDestination());
              break;
            }
          case DESTINATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  predictionsFormat_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                  destinationCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getBigqueryDestinationFieldBuilder().getBuilder(), extensionRegistry);
                  destinationCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int destinationCase_ = 0;
      private java.lang.Object destination_;

      public DestinationCase getDestinationCase() {
        return DestinationCase.forNumber(destinationCase_);
      }

      public Builder clearDestination() {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsDestination,
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
          gcsDestinationBuilder_;
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       *
       * @return Whether the gcsDestination field is set.
       */
      @java.lang.Override
      public boolean hasGcsDestination() {
        return destinationCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       *
       * @return The gcsDestination.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
        if (gcsDestinationBuilder_ == null) {
          if (destinationCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        } else {
          if (destinationCase_ == 2) {
            return gcsDestinationBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder setGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
        if (gcsDestinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          destination_ = value;
          onChanged();
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
        destinationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder setGcsDestination(
          com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
        if (gcsDestinationBuilder_ == null) {
          destination_ = builderForValue.build();
          onChanged();
        } else {
          gcsDestinationBuilder_.setMessage(builderForValue.build());
        }
        destinationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder mergeGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
        if (gcsDestinationBuilder_ == null) {
          if (destinationCase_ == 2
              && destination_
                  != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
            destination_ =
                com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            destination_ = value;
          }
          onChanged();
        } else {
          if (destinationCase_ == 2) {
            gcsDestinationBuilder_.mergeFrom(value);
          } else {
            gcsDestinationBuilder_.setMessage(value);
          }
        }
        destinationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder clearGcsDestination() {
        if (gcsDestinationBuilder_ == null) {
          if (destinationCase_ == 2) {
            destinationCase_ = 0;
            destination_ = null;
            onChanged();
          }
        } else {
          if (destinationCase_ == 2) {
            destinationCase_ = 0;
            destination_ = null;
          }
          gcsDestinationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder getGcsDestinationBuilder() {
        return getGcsDestinationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
          getGcsDestinationOrBuilder() {
        if ((destinationCase_ == 2) && (gcsDestinationBuilder_ != null)) {
          return gcsDestinationBuilder_.getMessageOrBuilder();
        } else {
          if (destinationCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format],
       * and N may equal 0001 and depends on the total number of successfully
       * predicted instances. If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsDestination,
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
          getGcsDestinationFieldBuilder() {
        if (gcsDestinationBuilder_ == null) {
          if (!(destinationCase_ == 2)) {
            destination_ = com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
          }
          gcsDestinationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GcsDestination,
                  com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                  com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_,
                  getParentForChildren(),
                  isClean());
          destination_ = null;
        }
        destinationCase_ = 2;
        onChanged();
        return gcsDestinationBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
          bigqueryDestinationBuilder_;
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       *
       * @return Whether the bigqueryDestination field is set.
       */
      @java.lang.Override
      public boolean hasBigqueryDestination() {
        return destinationCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       *
       * @return The bigqueryDestination.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
        if (bigqueryDestinationBuilder_ == null) {
          if (destinationCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        } else {
          if (destinationCase_ == 3) {
            return bigqueryDestinationBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder setBigqueryDestination(
          com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
        if (bigqueryDestinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          destination_ = value;
          onChanged();
        } else {
          bigqueryDestinationBuilder_.setMessage(value);
        }
        destinationCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder setBigqueryDestination(
          com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder builderForValue) {
        if (bigqueryDestinationBuilder_ == null) {
          destination_ = builderForValue.build();
          onChanged();
        } else {
          bigqueryDestinationBuilder_.setMessage(builderForValue.build());
        }
        destinationCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder mergeBigqueryDestination(
          com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
        if (bigqueryDestinationBuilder_ == null) {
          if (destinationCase_ == 3
              && destination_
                  != com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance()) {
            destination_ =
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            destination_ = value;
          }
          onChanged();
        } else {
          if (destinationCase_ == 3) {
            bigqueryDestinationBuilder_.mergeFrom(value);
          } else {
            bigqueryDestinationBuilder_.setMessage(value);
          }
        }
        destinationCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder clearBigqueryDestination() {
        if (bigqueryDestinationBuilder_ == null) {
          if (destinationCase_ == 3) {
            destinationCase_ = 0;
            destination_ = null;
            onChanged();
          }
        } else {
          if (destinationCase_ == 3) {
            destinationCase_ = 0;
            destination_ = null;
          }
          bigqueryDestinationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder
          getBigqueryDestinationBuilder() {
        return getBigqueryDestinationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
          getBigqueryDestinationOrBuilder() {
        if ((destinationCase_ == 3) && (bigqueryDestinationBuilder_ != null)) {
          return bigqueryDestinationBuilder_.getMessageOrBuilder();
        } else {
          if (destinationCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both
       * [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and
       * [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri]
       * schemata defined then the tables have columns as follows: The
       * `predictions` table contains instances for which the prediction
       * succeeded, it has columns as per a concatenation of the Model's
       * instance and prediction schemata. The `errors` table contains rows for
       * which the prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
          getBigqueryDestinationFieldBuilder() {
        if (bigqueryDestinationBuilder_ == null) {
          if (!(destinationCase_ == 3)) {
            destination_ =
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
          }
          bigqueryDestinationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_,
                  getParentForChildren(),
                  isClean());
          destination_ = null;
        }
        destinationCase_ = 3;
        onChanged();
        return bigqueryDestinationBuilder_;
      }

      private java.lang.Object predictionsFormat_ = "";
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be
       * one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The predictionsFormat.
       */
      public java.lang.String getPredictionsFormat() {
        java.lang.Object ref = predictionsFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          predictionsFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be
       * one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for predictionsFormat.
       */
      public com.google.protobuf.ByteString getPredictionsFormatBytes() {
        java.lang.Object ref = predictionsFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          predictionsFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be
       * one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The predictionsFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPredictionsFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictionsFormat_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be
       * one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPredictionsFormat() {
        predictionsFormat_ = getDefaultInstance().getPredictionsFormat();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be
       * one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for predictionsFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPredictionsFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        predictionsFormat_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
    private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputConfig> PARSER =
        new com.google.protobuf.AbstractParser<OutputConfig>() {
          @java.lang.Override
          public OutputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OutputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OutputInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into
     * which the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the gcsOutputDirectory field is set.
     */
    boolean hasGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into
     * which the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into
     * which the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();

    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the bigqueryOutputDataset field is set.
     */
    boolean hasBigqueryOutputDataset();
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputDataset.
     */
    java.lang.String getBigqueryOutputDataset();
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputDataset.
     */
    com.google.protobuf.ByteString getBigqueryOutputDatasetBytes();

    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputTable.
     */
    java.lang.String getBigqueryOutputTable();
    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputTable.
     */
    com.google.protobuf.ByteString getBigqueryOutputTableBytes();

    com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.OutputLocationCase
        getOutputLocationCase();
  }
  /**
   *
   *
   * <pre>
   * Further describes this job's output.
   * Supplements
   * [output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo}
   */
  public static final class OutputInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
      OutputInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputInfo.newBuilder() to construct.
    private OutputInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputInfo() {
      bigqueryOutputTable_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder.class);
    }

    private int outputLocationCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object outputLocation_;

    public enum OutputLocationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_OUTPUT_DIRECTORY(1),
      BIGQUERY_OUTPUT_DATASET(2),
      OUTPUTLOCATION_NOT_SET(0);
      private final int value;

      private OutputLocationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OutputLocationCase valueOf(int value) {
        return forNumber(value);
      }

      public static OutputLocationCase forNumber(int value) {
        switch (value) {
          case 1:
            return GCS_OUTPUT_DIRECTORY;
          case 2:
            return BIGQUERY_OUTPUT_DATASET;
          case 0:
            return OUTPUTLOCATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OutputLocationCase getOutputLocationCase() {
      return OutputLocationCase.forNumber(outputLocationCase_);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into
     * which the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the gcsOutputDirectory field is set.
     */
    public boolean hasGcsOutputDirectory() {
      return outputLocationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into
     * which the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gcsOutputDirectory.
     */
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (outputLocationCase_ == 1) {
          outputLocation_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into
     * which the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (outputLocationCase_ == 1) {
          outputLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BIGQUERY_OUTPUT_DATASET_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the bigqueryOutputDataset field is set.
     */
    public boolean hasBigqueryOutputDataset() {
      return outputLocationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputDataset.
     */
    public java.lang.String getBigqueryOutputDataset() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 2) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (outputLocationCase_ == 2) {
          outputLocation_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputDataset.
     */
    public com.google.protobuf.ByteString getBigqueryOutputDatasetBytes() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 2) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (outputLocationCase_ == 2) {
          outputLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BIGQUERY_OUTPUT_TABLE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bigqueryOutputTable_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputTable.
     */
    @java.lang.Override
    public java.lang.String getBigqueryOutputTable() {
      java.lang.Object ref = bigqueryOutputTable_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bigqueryOutputTable_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputTable.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBigqueryOutputTableBytes() {
      java.lang.Object ref = bigqueryOutputTable_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bigqueryOutputTable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (outputLocationCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, outputLocation_);
      }
      if (outputLocationCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, outputLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bigqueryOutputTable_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, bigqueryOutputTable_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (outputLocationCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, outputLocation_);
      }
      if (outputLocationCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, outputLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bigqueryOutputTable_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, bigqueryOutputTable_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo other =
          (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo) obj;

      if (!getBigqueryOutputTable().equals(other.getBigqueryOutputTable())) return false;
      if (!getOutputLocationCase().equals(other.getOutputLocationCase())) return false;
      switch (outputLocationCase_) {
        case 1:
          if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
          break;
        case 2:
          if (!getBigqueryOutputDataset().equals(other.getBigqueryOutputDataset())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BIGQUERY_OUTPUT_TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryOutputTable().hashCode();
      switch (outputLocationCase_) {
        case 1:
          hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
          hash = (53 * hash) + getGcsOutputDirectory().hashCode();
          break;
        case 2:
          hash = (37 * hash) + BIGQUERY_OUTPUT_DATASET_FIELD_NUMBER;
          hash = (53 * hash) + getBigqueryOutputDataset().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Further describes this job's output.
     * Supplements
     * [output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.class,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        bigqueryOutputTable_ = "";
        outputLocationCase_ = 0;
        outputLocation_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo build() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo result =
            new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.bigqueryOutputTable_ = bigqueryOutputTable_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo result) {
        result.outputLocationCase_ = outputLocationCase_;
        result.outputLocation_ = this.outputLocation_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
                .getDefaultInstance()) return this;
        if (!other.getBigqueryOutputTable().isEmpty()) {
          bigqueryOutputTable_ = other.bigqueryOutputTable_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getOutputLocationCase()) {
          case GCS_OUTPUT_DIRECTORY:
            {
              outputLocationCase_ = 1;
              outputLocation_ = other.outputLocation_;
              onChanged();
              break;
            }
          case BIGQUERY_OUTPUT_DATASET:
            {
              outputLocationCase_ = 2;
              outputLocation_ = other.outputLocation_;
              onChanged();
              break;
            }
          case OUTPUTLOCATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  outputLocationCase_ = 1;
                  outputLocation_ = s;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  outputLocationCase_ = 2;
                  outputLocation_ = s;
                  break;
                } // case 18
              case 34:
                {
                  bigqueryOutputTable_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int outputLocationCase_ = 0;
      private java.lang.Object outputLocation_;

      public OutputLocationCase getOutputLocationCase() {
        return OutputLocationCase.forNumber(outputLocationCase_);
      }

      public Builder clearOutputLocation() {
        outputLocationCase_ = 0;
        outputLocation_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into
       * which the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the gcsOutputDirectory field is set.
       */
      @java.lang.Override
      public boolean hasGcsOutputDirectory() {
        return outputLocationCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into
       * which the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The gcsOutputDirectory.
       */
      @java.lang.Override
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (outputLocationCase_ == 1) {
            outputLocation_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into
       * which the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (outputLocationCase_ == 1) {
            outputLocation_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into
       * which the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into
       * which the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {
        if (outputLocationCase_ == 1) {
          outputLocationCase_ = 0;
          outputLocation_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into
       * which the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the bigqueryOutputDataset field is set.
       */
      @java.lang.Override
      public boolean hasBigqueryOutputDataset() {
        return outputLocationCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bigqueryOutputDataset.
       */
      @java.lang.Override
      public java.lang.String getBigqueryOutputDataset() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 2) {
          ref = outputLocation_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (outputLocationCase_ == 2) {
            outputLocation_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bytes for bigqueryOutputDataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBigqueryOutputDatasetBytes() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 2) {
          ref = outputLocation_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (outputLocationCase_ == 2) {
            outputLocation_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bigqueryOutputDataset to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputLocationCase_ = 2;
        outputLocation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBigqueryOutputDataset() {
        if (outputLocationCase_ == 2) {
          outputLocationCase_ = 0;
          outputLocation_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes for bigqueryOutputDataset to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputLocationCase_ = 2;
        outputLocation_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object bigqueryOutputTable_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bigqueryOutputTable.
       */
      public java.lang.String getBigqueryOutputTable() {
        java.lang.Object ref = bigqueryOutputTable_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bigqueryOutputTable_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for bigqueryOutputTable.
       */
      public com.google.protobuf.ByteString getBigqueryOutputTableBytes() {
        java.lang.Object ref = bigqueryOutputTable_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bigqueryOutputTable_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bigqueryOutputTable to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bigqueryOutputTable_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBigqueryOutputTable() {
        bigqueryOutputTable_ = getDefaultInstance().getBigqueryOutputTable();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for bigqueryOutputTable to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bigqueryOutputTable_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
    private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputInfo> PARSER =
        new com.google.protobuf.AbstractParser<OutputInfo>() {
          @java.lang.Override
          public OutputInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OutputInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the BatchPredictionJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the BatchPredictionJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of this BatchPredictionJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of this BatchPredictionJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Model resource that produces the predictions via this job,
   * must share the same ancestor Location.
   * Starting this job has no impact on any existing deployments of the Model
   * and their resources.
   * Exactly one of model and unmanaged_container_model must be set.
   *
   * The model resource name may contain version id or version alias to specify
   * the version.
   *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * if no version is specified, the default version will be deployed.
   *
   * The model resource could also be a publisher model.
   *  Example: `publishers/{publisher}/models/{model}`
   *              or
   *           `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
   * </pre>
   *
   * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Model resource that produces the predictions via this job,
   * must share the same ancestor Location.
   * Starting this job has no impact on any existing deployments of the Model
   * and their resources.
   * Exactly one of model and unmanaged_container_model must be set.
   *
   * The model resource name may contain version id or version alias to specify
   * the version.
   *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * if no version is specified, the default version will be deployed.
   *
   * The model resource could also be a publisher model.
   *  Example: `publishers/{publisher}/models/{model}`
   *              or
   *           `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
   * </pre>
   *
   * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VERSION_ID_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelVersionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the Model that produces the predictions via
   * this job.
   * </pre>
   *
   * <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The modelVersionId.
   */
  @java.lang.Override
  public java.lang.String getModelVersionId() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the Model that produces the predictions via
   * this job.
   * </pre>
   *
   * <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for modelVersionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionIdBytes() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNMANAGED_CONTAINER_MODEL_FIELD_NUMBER = 28;
  private com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanagedContainerModel_;
  /**
   *
   *
   * <pre>
   * Contains model information necessary to perform batch prediction without
   * requiring uploading to model registry.
   * Exactly one of model and unmanaged_container_model must be set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
   * </code>
   *
   * @return Whether the unmanagedContainerModel field is set.
   */
  @java.lang.Override
  public boolean hasUnmanagedContainerModel() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Contains model information necessary to perform batch prediction without
   * requiring uploading to model registry.
   * Exactly one of model and unmanaged_container_model must be set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
   * </code>
   *
   * @return The unmanagedContainerModel.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel getUnmanagedContainerModel() {
    return unmanagedContainerModel_ == null
        ? com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.getDefaultInstance()
        : unmanagedContainerModel_;
  }
  /**
   *
   *
   * <pre>
   * Contains model information necessary to perform batch prediction without
   * requiring uploading to model registry.
   * Exactly one of model and unmanaged_container_model must be set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModelOrBuilder
      getUnmanagedContainerModelOrBuilder() {
    return unmanagedContainerModel_ == null
        ? com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.getDefaultInstance()
        : unmanagedContainerModel_;
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Required. Input configuration of the instances on which predictions are
   * performed. The schema of any single instance may be specified via the
   * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Input configuration of the instances on which predictions are
   * performed. The schema of any single instance may be specified via the
   * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input configuration of the instances on which predictions are
   * performed. The schema of any single instance may be specified via the
   * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder
      getInputConfigOrBuilder() {
    return inputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.getDefaultInstance()
        : inputConfig_;
  }

  public static final int INSTANCE_CONFIG_FIELD_NUMBER = 27;
  private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instanceConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for how to convert batch prediction input instances to the
   * prediction instances that are sent to the Model.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
   * </code>
   *
   * @return Whether the instanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasInstanceConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to convert batch prediction input instances to the
   * prediction instances that are sent to the Model.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
   * </code>
   *
   * @return The instanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig getInstanceConfig() {
    return instanceConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.getDefaultInstance()
        : instanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for how to convert batch prediction input instances to the
   * prediction instances that are sent to the Model.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfigOrBuilder
      getInstanceConfigOrBuilder() {
    return instanceConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.getDefaultInstance()
        : instanceConfig_;
  }

  public static final int MODEL_PARAMETERS_FIELD_NUMBER = 5;
  private com.google.protobuf.Value modelParameters_;
  /**
   *
   *
   * <pre>
   * The parameters that govern the predictions. The schema of the parameters
   * may be specified via the
   * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value model_parameters = 5;</code>
   *
   * @return Whether the modelParameters field is set.
   */
  @java.lang.Override
  public boolean hasModelParameters() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The parameters that govern the predictions. The schema of the parameters
   * may be specified via the
   * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value model_parameters = 5;</code>
   *
   * @return The modelParameters.
   */
  @java.lang.Override
  public com.google.protobuf.Value getModelParameters() {
    return modelParameters_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : modelParameters_;
  }
  /**
   *
   *
   * <pre>
   * The parameters that govern the predictions. The schema of the parameters
   * may be specified via the
   * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value model_parameters = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getModelParametersOrBuilder() {
    return modelParameters_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : modelParameters_;
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * The schema of any single prediction may be specified as a concatenation
   * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
   * and
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * The schema of any single prediction may be specified as a concatenation
   * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
   * and
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * The schema of any single prediction may be specified as a concatenation
   * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
   * and
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicatedResources_;
  /**
   *
   *
   * <pre>
   * The config of resources used by the Model during the batch prediction. If
   * the Model
   * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
   * DEDICATED_RESOURCES this config may be provided (and the job will use these
   * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
   * must be provided.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;</code>
   *
   * @return Whether the dedicatedResources field is set.
   */
  @java.lang.Override
  public boolean hasDedicatedResources() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The config of resources used by the Model during the batch prediction. If
   * the Model
   * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
   * DEDICATED_RESOURCES this config may be provided (and the job will use these
   * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
   * must be provided.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;</code>
   *
   * @return The dedicatedResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources getDedicatedResources() {
    return dedicatedResources_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
        : dedicatedResources_;
  }
  /**
   *
   *
   * <pre>
   * The config of resources used by the Model during the batch prediction. If
   * the Model
   * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
   * DEDICATED_RESOURCES this config may be provided (and the job will use these
   * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
   * must be provided.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder
      getDedicatedResourcesOrBuilder() {
    return dedicatedResources_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
        : dedicatedResources_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The service account that the DeployedModel's container runs as. If not
   * specified, a system generated one will be used, which
   * has minimal permissions and the custom container, if used, may not have
   * enough permission to access other Google Cloud resources.
   *
   * Users deploying the Model must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 29;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account that the DeployedModel's container runs as. If not
   * specified, a system generated one will be used, which
   * has minimal permissions and the custom container, if used, may not have
   * enough permission to access other Google Cloud resources.
   *
   * Users deploying the Model must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 29;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MANUAL_BATCH_TUNING_PARAMETERS_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
      manualBatchTuningParameters_;
  /**
   *
   *
   * <pre>
   * Immutable. Parameters configuring the batch behavior. Currently only
   * applicable when
   * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
   * are used (in other cases Vertex AI does the tuning itself).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the manualBatchTuningParameters field is set.
   */
  @java.lang.Override
  public boolean hasManualBatchTuningParameters() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Immutable. Parameters configuring the batch behavior. Currently only
   * applicable when
   * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
   * are used (in other cases Vertex AI does the tuning itself).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The manualBatchTuningParameters.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
      getManualBatchTuningParameters() {
    return manualBatchTuningParameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.getDefaultInstance()
        : manualBatchTuningParameters_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Parameters configuring the batch behavior. Currently only
   * applicable when
   * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
   * are used (in other cases Vertex AI does the tuning itself).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder
      getManualBatchTuningParametersOrBuilder() {
    return manualBatchTuningParameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.getDefaultInstance()
        : manualBatchTuningParameters_;
  }

  public static final int GENERATE_EXPLANATION_FIELD_NUMBER = 23;
  private boolean generateExplanation_ = false;
  /**
   *
   *
   * <pre>
   * Generate explanation with the batch prediction results.
   *
   * When set to `true`, the batch prediction output changes based on the
   * `predictions_format` field of the
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config]
   * object:
   *
   *  * `bigquery`: output includes a column named `explanation`. The value
   *    is a struct that conforms to the
   *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
   *  * `jsonl`: The JSON objects on each line include an additional entry
   *    keyed `explanation`. The value of the entry is a JSON object that
   *    conforms to the
   *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
   *  * `csv`: Generating explanations for CSV format is not supported.
   *
   * If this field is set to true, either the
   * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
   * or
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
   * must be populated.
   * </pre>
   *
   * <code>bool generate_explanation = 23;</code>
   *
   * @return The generateExplanation.
   */
  @java.lang.Override
  public boolean getGenerateExplanation() {
    return generateExplanation_;
  }

  public static final int EXPLANATION_SPEC_FIELD_NUMBER = 25;
  private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
  /**
   *
   *
   * <pre>
   * Explanation configuration for this BatchPredictionJob. Can be
   * specified only if
   * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
   * is set to `true`.
   *
   * This value overrides the value of
   * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
   * All fields of
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
   * are optional in the request. If a field of the
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
   * object is not populated, the corresponding field of the
   * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
   * object is inherited.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  @java.lang.Override
  public boolean hasExplanationSpec() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this BatchPredictionJob. Can be
   * specified only if
   * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
   * is set to `true`.
   *
   * This value overrides the value of
   * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
   * All fields of
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
   * are optional in the request. If a field of the
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
   * object is not populated, the corresponding field of the
   * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
   * object is inherited.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
   *
   * @return The explanationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this BatchPredictionJob. Can be
   * specified only if
   * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
   * is set to `true`.
   *
   * This value overrides the value of
   * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
   * All fields of
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
   * are optional in the request. If a field of the
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
   * object is not populated, the corresponding field of the
   * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
   * object is inherited.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
      getExplanationSpecOrBuilder() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }

  public static final int OUTPUT_INFO_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo outputInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the outputInfo field is set.
   */
  @java.lang.Override
  public boolean hasOutputInfo() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The outputInfo.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo getOutputInfo() {
    return outputInfo_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.getDefaultInstance()
        : outputInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder
      getOutputInfoOrBuilder() {
    return outputInfo_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.getDefaultInstance()
        : outputInfo_;
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JobState getState() {
    com.google.cloud.aiplatform.v1beta1.JobState result =
        com.google.cloud.aiplatform.v1beta1.JobState.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
  }

  public static final int ERROR_FIELD_NUMBER = 11;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int PARTIAL_FAILURES_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> partialFailures_;
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard Google Cloud error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard Google Cloud error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder>
      getPartialFailuresOrBuilderList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard Google Cloud error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPartialFailuresCount() {
    return partialFailures_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard Google Cloud error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialFailures(int index) {
    return partialFailures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard Google Cloud error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
    return partialFailures_.get(index);
  }

  public static final int RESOURCES_CONSUMED_FIELD_NUMBER = 13;
  private com.google.cloud.aiplatform.v1beta1.ResourcesConsumed resourcesConsumed_;
  /**
   *
   *
   * <pre>
   * Output only. Information about resources that had been consumed by this
   * job. Provided in real time at best effort basis, as well as a final value
   * once the job completes.
   *
   * Note: This field currently may be not populated for batch predictions that
   * use AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the resourcesConsumed field is set.
   */
  @java.lang.Override
  public boolean hasResourcesConsumed() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about resources that had been consumed by this
   * job. Provided in real time at best effort basis, as well as a final value
   * once the job completes.
   *
   * Note: This field currently may be not populated for batch predictions that
   * use AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resourcesConsumed.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcesConsumed getResourcesConsumed() {
    return resourcesConsumed_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()
        : resourcesConsumed_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about resources that had been consumed by this
   * job. Provided in real time at best effort basis, as well as a final value
   * once the job completes.
   *
   * Note: This field currently may be not populated for batch predictions that
   * use AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder
      getResourcesConsumedOrBuilder() {
    return resourcesConsumed_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()
        : resourcesConsumed_;
  }

  public static final int COMPLETION_STATS_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1beta1.CompletionStats completionStats_;
  /**
   *
   *
   * <pre>
   * Output only. Statistics on completed and failed prediction instances.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completionStats field is set.
   */
  @java.lang.Override
  public boolean hasCompletionStats() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics on completed and failed prediction instances.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completionStats.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CompletionStats getCompletionStats() {
    return completionStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()
        : completionStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics on completed and failed prediction instances.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder
      getCompletionStatsOrBuilder() {
    return completionStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()
        : completionStats_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 15;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 16;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob for the first time entered
   * the `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob for the first time entered
   * the `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob for the first time entered
   * the `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob entered any of the following
   * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob entered any of the following
   * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob entered any of the following
   * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 19;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
                .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 24;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a BatchPredictionJob. If this
   * is set, then all resources created by the BatchPredictionJob will be
   * encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a BatchPredictionJob. If this
   * is set, then all resources created by the BatchPredictionJob will be
   * encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a BatchPredictionJob. If this
   * is set, then all resources created by the BatchPredictionJob will be
   * encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int MODEL_MONITORING_CONFIG_FIELD_NUMBER = 26;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig modelMonitoringConfig_;
  /**
   *
   *
   * <pre>
   * Model monitoring config will be used for analysis model behaviors, based on
   * the input and output to the batch prediction job, as well as the provided
   * training dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
   * </code>
   *
   * @return Whether the modelMonitoringConfig field is set.
   */
  @java.lang.Override
  public boolean hasModelMonitoringConfig() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Model monitoring config will be used for analysis model behaviors, based on
   * the input and output to the batch prediction job, as well as the provided
   * training dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
   * </code>
   *
   * @return The modelMonitoringConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig getModelMonitoringConfig() {
    return modelMonitoringConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.getDefaultInstance()
        : modelMonitoringConfig_;
  }
  /**
   *
   *
   * <pre>
   * Model monitoring config will be used for analysis model behaviors, based on
   * the input and output to the batch prediction job, as well as the provided
   * training dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfigOrBuilder
      getModelMonitoringConfigOrBuilder() {
    return modelMonitoringConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.getDefaultInstance()
        : modelMonitoringConfig_;
  }

  public static final int MODEL_MONITORING_STATS_ANOMALIES_FIELD_NUMBER = 31;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies>
      modelMonitoringStatsAnomalies_;
  /**
   *
   *
   * <pre>
   * Get batch prediction job monitoring statistics.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies>
      getModelMonitoringStatsAnomaliesList() {
    return modelMonitoringStatsAnomalies_;
  }
  /**
   *
   *
   * <pre>
   * Get batch prediction job monitoring statistics.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder>
      getModelMonitoringStatsAnomaliesOrBuilderList() {
    return modelMonitoringStatsAnomalies_;
  }
  /**
   *
   *
   * <pre>
   * Get batch prediction job monitoring statistics.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
   * </code>
   */
  @java.lang.Override
  public int getModelMonitoringStatsAnomaliesCount() {
    return modelMonitoringStatsAnomalies_.size();
  }
  /**
   *
   *
   * <pre>
   * Get batch prediction job monitoring statistics.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
      getModelMonitoringStatsAnomalies(int index) {
    return modelMonitoringStatsAnomalies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Get batch prediction job monitoring statistics.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder
      getModelMonitoringStatsAnomaliesOrBuilder(int index) {
    return modelMonitoringStatsAnomalies_.get(index);
  }

  public static final int MODEL_MONITORING_STATUS_FIELD_NUMBER = 32;
  private com.google.rpc.Status modelMonitoringStatus_;
  /**
   *
   *
   * <pre>
   * Output only. The running status of the model monitoring pipeline.
   * </pre>
   *
   * <code>
   * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the modelMonitoringStatus field is set.
   */
  @java.lang.Override
  public boolean hasModelMonitoringStatus() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The running status of the model monitoring pipeline.
   * </pre>
   *
   * <code>
   * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The modelMonitoringStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getModelMonitoringStatus() {
    return modelMonitoringStatus_ == null
        ? com.google.rpc.Status.getDefaultInstance()
        : modelMonitoringStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The running status of the model monitoring pipeline.
   * </pre>
   *
   * <code>
   * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getModelMonitoringStatusOrBuilder() {
    return modelMonitoringStatus_ == null
        ? com.google.rpc.Status.getDefaultInstance()
        : modelMonitoringStatus_;
  }

  public static final int DISABLE_CONTAINER_LOGGING_FIELD_NUMBER = 34;
  private boolean disableContainerLogging_ = false;
  /**
   *
   *
   * <pre>
   * For custom-trained Models and AutoML Tabular Models, the container of the
   * DeployedModel instances will send `stderr` and `stdout` streams to
   * Cloud Logging by default. Please note that the logs incur cost,
   * which are subject to [Cloud Logging
   * pricing](https://cloud.google.com/logging/pricing).
   *
   * User can disable container logging by setting this flag to true.
   * </pre>
   *
   * <code>bool disable_container_logging = 34;</code>
   *
   * @return The disableContainerLogging.
   */
  @java.lang.Override
  public boolean getDisableContainerLogging() {
    return disableContainerLogging_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 36;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 37;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, model_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getInputConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getModelParameters());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(6, getOutputConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(7, getDedicatedResources());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(8, getManualBatchTuningParameters());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(9, getOutputInfo());
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, state_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(11, getError());
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      output.writeMessage(12, partialFailures_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(13, getResourcesConsumed());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(14, getCompletionStats());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(15, getCreateTime());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(16, getStartTime());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(17, getEndTime());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(18, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 19);
    if (generateExplanation_ != false) {
      output.writeBool(23, generateExplanation_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeMessage(24, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(25, getExplanationSpec());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(26, getModelMonitoringConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(27, getInstanceConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(28, getUnmanagedContainerModel());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, modelVersionId_);
    }
    for (int i = 0; i < modelMonitoringStatsAnomalies_.size(); i++) {
      output.writeMessage(31, modelMonitoringStatsAnomalies_.get(i));
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(32, getModelMonitoringStatus());
    }
    if (disableContainerLogging_ != false) {
      output.writeBool(34, disableContainerLogging_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(36, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(37, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, model_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInputConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getModelParameters());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutputConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDedicatedResources());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getManualBatchTuningParameters());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getOutputInfo());
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getError());
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, partialFailures_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getResourcesConsumed());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getCompletionStats());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getCreateTime());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getStartTime());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getEndTime());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, labels__);
    }
    if (generateExplanation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(23, generateExplanation_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getExplanationSpec());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(26, getModelMonitoringConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getInstanceConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, getUnmanagedContainerModel());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(29, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, modelVersionId_);
    }
    for (int i = 0; i < modelMonitoringStatsAnomalies_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              31, modelMonitoringStatsAnomalies_.get(i));
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(32, getModelMonitoringStatus());
    }
    if (disableContainerLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(34, disableContainerLogging_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(36, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(37, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.BatchPredictionJob other =
        (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (!getModelVersionId().equals(other.getModelVersionId())) return false;
    if (hasUnmanagedContainerModel() != other.hasUnmanagedContainerModel()) return false;
    if (hasUnmanagedContainerModel()) {
      if (!getUnmanagedContainerModel().equals(other.getUnmanagedContainerModel())) return false;
    }
    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasInstanceConfig() != other.hasInstanceConfig()) return false;
    if (hasInstanceConfig()) {
      if (!getInstanceConfig().equals(other.getInstanceConfig())) return false;
    }
    if (hasModelParameters() != other.hasModelParameters()) return false;
    if (hasModelParameters()) {
      if (!getModelParameters().equals(other.getModelParameters())) return false;
    }
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (hasDedicatedResources() != other.hasDedicatedResources()) return false;
    if (hasDedicatedResources()) {
      if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (hasManualBatchTuningParameters() != other.hasManualBatchTuningParameters()) return false;
    if (hasManualBatchTuningParameters()) {
      if (!getManualBatchTuningParameters().equals(other.getManualBatchTuningParameters()))
        return false;
    }
    if (getGenerateExplanation() != other.getGenerateExplanation()) return false;
    if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
    if (hasExplanationSpec()) {
      if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
    }
    if (hasOutputInfo() != other.hasOutputInfo()) return false;
    if (hasOutputInfo()) {
      if (!getOutputInfo().equals(other.getOutputInfo())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getPartialFailuresList().equals(other.getPartialFailuresList())) return false;
    if (hasResourcesConsumed() != other.hasResourcesConsumed()) return false;
    if (hasResourcesConsumed()) {
      if (!getResourcesConsumed().equals(other.getResourcesConsumed())) return false;
    }
    if (hasCompletionStats() != other.hasCompletionStats()) return false;
    if (hasCompletionStats()) {
      if (!getCompletionStats().equals(other.getCompletionStats())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (hasModelMonitoringConfig() != other.hasModelMonitoringConfig()) return false;
    if (hasModelMonitoringConfig()) {
      if (!getModelMonitoringConfig().equals(other.getModelMonitoringConfig())) return false;
    }
    if (!getModelMonitoringStatsAnomaliesList()
        .equals(other.getModelMonitoringStatsAnomaliesList())) return false;
    if (hasModelMonitoringStatus() != other.hasModelMonitoringStatus()) return false;
    if (hasModelMonitoringStatus()) {
      if (!getModelMonitoringStatus().equals(other.getModelMonitoringStatus())) return false;
    }
    if (getDisableContainerLogging() != other.getDisableContainerLogging()) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + MODEL_VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersionId().hashCode();
    if (hasUnmanagedContainerModel()) {
      hash = (37 * hash) + UNMANAGED_CONTAINER_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getUnmanagedContainerModel().hashCode();
    }
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasInstanceConfig()) {
      hash = (37 * hash) + INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceConfig().hashCode();
    }
    if (hasModelParameters()) {
      hash = (37 * hash) + MODEL_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getModelParameters().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (hasDedicatedResources()) {
      hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getDedicatedResources().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (hasManualBatchTuningParameters()) {
      hash = (37 * hash) + MANUAL_BATCH_TUNING_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getManualBatchTuningParameters().hashCode();
    }
    hash = (37 * hash) + GENERATE_EXPLANATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGenerateExplanation());
    if (hasExplanationSpec()) {
      hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpec().hashCode();
    }
    if (hasOutputInfo()) {
      hash = (37 * hash) + OUTPUT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOutputInfo().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (getPartialFailuresCount() > 0) {
      hash = (37 * hash) + PARTIAL_FAILURES_FIELD_NUMBER;
      hash = (53 * hash) + getPartialFailuresList().hashCode();
    }
    if (hasResourcesConsumed()) {
      hash = (37 * hash) + RESOURCES_CONSUMED_FIELD_NUMBER;
      hash = (53 * hash) + getResourcesConsumed().hashCode();
    }
    if (hasCompletionStats()) {
      hash = (37 * hash) + COMPLETION_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionStats().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    if (hasModelMonitoringConfig()) {
      hash = (37 * hash) + MODEL_MONITORING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringConfig().hashCode();
    }
    if (getModelMonitoringStatsAnomaliesCount() > 0) {
      hash = (37 * hash) + MODEL_MONITORING_STATS_ANOMALIES_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringStatsAnomaliesList().hashCode();
    }
    if (hasModelMonitoringStatus()) {
      hash = (37 * hash) + MODEL_MONITORING_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringStatus().hashCode();
    }
    hash = (37 * hash) + DISABLE_CONTAINER_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableContainerLogging());
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A job that uses a
   * [Model][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model] to produce
   * predictions on multiple [input
   * instances][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config].
   * If predictions for significant portion of the instances fail, the job may
   * finish without attempting predictions for all remaining instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 19:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 19:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUnmanagedContainerModelFieldBuilder();
        getInputConfigFieldBuilder();
        getInstanceConfigFieldBuilder();
        getModelParametersFieldBuilder();
        getOutputConfigFieldBuilder();
        getDedicatedResourcesFieldBuilder();
        getManualBatchTuningParametersFieldBuilder();
        getExplanationSpecFieldBuilder();
        getOutputInfoFieldBuilder();
        getErrorFieldBuilder();
        getPartialFailuresFieldBuilder();
        getResourcesConsumedFieldBuilder();
        getCompletionStatsFieldBuilder();
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getModelMonitoringConfigFieldBuilder();
        getModelMonitoringStatsAnomaliesFieldBuilder();
        getModelMonitoringStatusFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      model_ = "";
      modelVersionId_ = "";
      unmanagedContainerModel_ = null;
      if (unmanagedContainerModelBuilder_ != null) {
        unmanagedContainerModelBuilder_.dispose();
        unmanagedContainerModelBuilder_ = null;
      }
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      instanceConfig_ = null;
      if (instanceConfigBuilder_ != null) {
        instanceConfigBuilder_.dispose();
        instanceConfigBuilder_ = null;
      }
      modelParameters_ = null;
      if (modelParametersBuilder_ != null) {
        modelParametersBuilder_.dispose();
        modelParametersBuilder_ = null;
      }
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      dedicatedResources_ = null;
      if (dedicatedResourcesBuilder_ != null) {
        dedicatedResourcesBuilder_.dispose();
        dedicatedResourcesBuilder_ = null;
      }
      serviceAccount_ = "";
      manualBatchTuningParameters_ = null;
      if (manualBatchTuningParametersBuilder_ != null) {
        manualBatchTuningParametersBuilder_.dispose();
        manualBatchTuningParametersBuilder_ = null;
      }
      generateExplanation_ = false;
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      outputInfo_ = null;
      if (outputInfoBuilder_ != null) {
        outputInfoBuilder_.dispose();
        outputInfoBuilder_ = null;
      }
      state_ = 0;
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
      } else {
        partialFailures_ = null;
        partialFailuresBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00020000);
      resourcesConsumed_ = null;
      if (resourcesConsumedBuilder_ != null) {
        resourcesConsumedBuilder_.dispose();
        resourcesConsumedBuilder_ = null;
      }
      completionStats_ = null;
      if (completionStatsBuilder_ != null) {
        completionStatsBuilder_.dispose();
        completionStatsBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      modelMonitoringConfig_ = null;
      if (modelMonitoringConfigBuilder_ != null) {
        modelMonitoringConfigBuilder_.dispose();
        modelMonitoringConfigBuilder_ = null;
      }
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        modelMonitoringStatsAnomalies_ = java.util.Collections.emptyList();
      } else {
        modelMonitoringStatsAnomalies_ = null;
        modelMonitoringStatsAnomaliesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x08000000);
      modelMonitoringStatus_ = null;
      if (modelMonitoringStatusBuilder_ != null) {
        modelMonitoringStatusBuilder_.dispose();
        modelMonitoringStatusBuilder_ = null;
      }
      disableContainerLogging_ = false;
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob build() {
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob result =
          new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob result) {
      if (partialFailuresBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)) {
          partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
          bitField0_ = (bitField0_ & ~0x00020000);
        }
        result.partialFailures_ = partialFailures_;
      } else {
        result.partialFailures_ = partialFailuresBuilder_.build();
      }
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)) {
          modelMonitoringStatsAnomalies_ =
              java.util.Collections.unmodifiableList(modelMonitoringStatsAnomalies_);
          bitField0_ = (bitField0_ & ~0x08000000);
        }
        result.modelMonitoringStatsAnomalies_ = modelMonitoringStatsAnomalies_;
      } else {
        result.modelMonitoringStatsAnomalies_ = modelMonitoringStatsAnomaliesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.BatchPredictionJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modelVersionId_ = modelVersionId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.unmanagedContainerModel_ =
            unmanagedContainerModelBuilder_ == null
                ? unmanagedContainerModel_
                : unmanagedContainerModelBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.inputConfig_ =
            inputConfigBuilder_ == null ? inputConfig_ : inputConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.instanceConfig_ =
            instanceConfigBuilder_ == null ? instanceConfig_ : instanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.modelParameters_ =
            modelParametersBuilder_ == null ? modelParameters_ : modelParametersBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.dedicatedResources_ =
            dedicatedResourcesBuilder_ == null
                ? dedicatedResources_
                : dedicatedResourcesBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.manualBatchTuningParameters_ =
            manualBatchTuningParametersBuilder_ == null
                ? manualBatchTuningParameters_
                : manualBatchTuningParametersBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.generateExplanation_ = generateExplanation_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.explanationSpec_ =
            explanationSpecBuilder_ == null ? explanationSpec_ : explanationSpecBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.outputInfo_ = outputInfoBuilder_ == null ? outputInfo_ : outputInfoBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.resourcesConsumed_ =
            resourcesConsumedBuilder_ == null
                ? resourcesConsumed_
                : resourcesConsumedBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.completionStats_ =
            completionStatsBuilder_ == null ? completionStats_ : completionStatsBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.modelMonitoringConfig_ =
            modelMonitoringConfigBuilder_ == null
                ? modelMonitoringConfig_
                : modelMonitoringConfigBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.modelMonitoringStatus_ =
            modelMonitoringStatusBuilder_ == null
                ? modelMonitoringStatus_
                : modelMonitoringStatusBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.disableContainerLogging_ = disableContainerLogging_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.BatchPredictionJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.BatchPredictionJob other) {
      if (other == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getModelVersionId().isEmpty()) {
        modelVersionId_ = other.modelVersionId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasUnmanagedContainerModel()) {
        mergeUnmanagedContainerModel(other.getUnmanagedContainerModel());
      }
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasInstanceConfig()) {
        mergeInstanceConfig(other.getInstanceConfig());
      }
      if (other.hasModelParameters()) {
        mergeModelParameters(other.getModelParameters());
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (other.hasDedicatedResources()) {
        mergeDedicatedResources(other.getDedicatedResources());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasManualBatchTuningParameters()) {
        mergeManualBatchTuningParameters(other.getManualBatchTuningParameters());
      }
      if (other.getGenerateExplanation() != false) {
        setGenerateExplanation(other.getGenerateExplanation());
      }
      if (other.hasExplanationSpec()) {
        mergeExplanationSpec(other.getExplanationSpec());
      }
      if (other.hasOutputInfo()) {
        mergeOutputInfo(other.getOutputInfo());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (partialFailuresBuilder_ == null) {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailures_.isEmpty()) {
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00020000);
          } else {
            ensurePartialFailuresIsMutable();
            partialFailures_.addAll(other.partialFailures_);
          }
          onChanged();
        }
      } else {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailuresBuilder_.isEmpty()) {
            partialFailuresBuilder_.dispose();
            partialFailuresBuilder_ = null;
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00020000);
            partialFailuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialFailuresFieldBuilder()
                    : null;
          } else {
            partialFailuresBuilder_.addAllMessages(other.partialFailures_);
          }
        }
      }
      if (other.hasResourcesConsumed()) {
        mergeResourcesConsumed(other.getResourcesConsumed());
      }
      if (other.hasCompletionStats()) {
        mergeCompletionStats(other.getCompletionStats());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x01000000;
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.hasModelMonitoringConfig()) {
        mergeModelMonitoringConfig(other.getModelMonitoringConfig());
      }
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        if (!other.modelMonitoringStatsAnomalies_.isEmpty()) {
          if (modelMonitoringStatsAnomalies_.isEmpty()) {
            modelMonitoringStatsAnomalies_ = other.modelMonitoringStatsAnomalies_;
            bitField0_ = (bitField0_ & ~0x08000000);
          } else {
            ensureModelMonitoringStatsAnomaliesIsMutable();
            modelMonitoringStatsAnomalies_.addAll(other.modelMonitoringStatsAnomalies_);
          }
          onChanged();
        }
      } else {
        if (!other.modelMonitoringStatsAnomalies_.isEmpty()) {
          if (modelMonitoringStatsAnomaliesBuilder_.isEmpty()) {
            modelMonitoringStatsAnomaliesBuilder_.dispose();
            modelMonitoringStatsAnomaliesBuilder_ = null;
            modelMonitoringStatsAnomalies_ = other.modelMonitoringStatsAnomalies_;
            bitField0_ = (bitField0_ & ~0x08000000);
            modelMonitoringStatsAnomaliesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getModelMonitoringStatsAnomaliesFieldBuilder()
                    : null;
          } else {
            modelMonitoringStatsAnomaliesBuilder_.addAllMessages(
                other.modelMonitoringStatsAnomalies_);
          }
        }
      }
      if (other.hasModelMonitoringStatus()) {
        mergeModelMonitoringStatus(other.getModelMonitoringStatus());
      }
      if (other.getDisableContainerLogging() != false) {
        setDisableContainerLogging(other.getDisableContainerLogging());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getModelParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getDedicatedResourcesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getManualBatchTuningParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getOutputInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 74
            case 80:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 90
            case 98:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (partialFailuresBuilder_ == null) {
                  ensurePartialFailuresIsMutable();
                  partialFailures_.add(m);
                } else {
                  partialFailuresBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getResourcesConsumedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getCompletionStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 146
            case 154:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x01000000;
                break;
              } // case 154
            case 184:
              {
                generateExplanation_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 184
            case 194:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(getExplanationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(
                    getModelMonitoringConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(getInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getUnmanagedContainerModelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 226
            case 234:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 234
            case 242:
              {
                modelVersionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 242
            case 250:
              {
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.parser(),
                        extensionRegistry);
                if (modelMonitoringStatsAnomaliesBuilder_ == null) {
                  ensureModelMonitoringStatsAnomaliesIsMutable();
                  modelMonitoringStatsAnomalies_.add(m);
                } else {
                  modelMonitoringStatsAnomaliesBuilder_.addMessage(m);
                }
                break;
              } // case 250
            case 258:
              {
                input.readMessage(
                    getModelMonitoringStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 258
            case 272:
              {
                disableContainerLogging_ = input.readBool();
                bitField0_ |= 0x20000000;
                break;
              } // case 272
            case 288:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x40000000;
                break;
              } // case 288
            case 296:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x80000000;
                break;
              } // case 296
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * The model resource name may contain version id or version alias to specify
     * the version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     *
     * The model resource could also be a publisher model.
     *  Example: `publishers/{publisher}/models/{model}`
     *              or
     *           `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * The model resource name may contain version id or version alias to specify
     * the version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     *
     * The model resource could also be a publisher model.
     *  Example: `publishers/{publisher}/models/{model}`
     *              or
     *           `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * The model resource name may contain version id or version alias to specify
     * the version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     *
     * The model resource could also be a publisher model.
     *  Example: `publishers/{publisher}/models/{model}`
     *              or
     *           `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * The model resource name may contain version id or version alias to specify
     * the version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     *
     * The model resource could also be a publisher model.
     *  Example: `publishers/{publisher}/models/{model}`
     *              or
     *           `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * The model resource name may contain version id or version alias to specify
     * the version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     *
     * The model resource could also be a publisher model.
     *  Example: `publishers/{publisher}/models/{model}`
     *              or
     *           `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object modelVersionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model that produces the predictions via
     * this job.
     * </pre>
     *
     * <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersionId.
     */
    public java.lang.String getModelVersionId() {
      java.lang.Object ref = modelVersionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model that produces the predictions via
     * this job.
     * </pre>
     *
     * <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersionId.
     */
    public com.google.protobuf.ByteString getModelVersionIdBytes() {
      java.lang.Object ref = modelVersionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model that produces the predictions via
     * this job.
     * </pre>
     *
     * <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelVersionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model that produces the predictions via
     * this job.
     * </pre>
     *
     * <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersionId() {
      modelVersionId_ = getDefaultInstance().getModelVersionId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model that produces the predictions via
     * this job.
     * </pre>
     *
     * <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelVersionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanagedContainerModel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel,
            com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.Builder,
            com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModelOrBuilder>
        unmanagedContainerModelBuilder_;
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     *
     * @return Whether the unmanagedContainerModel field is set.
     */
    public boolean hasUnmanagedContainerModel() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     *
     * @return The unmanagedContainerModel.
     */
    public com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel
        getUnmanagedContainerModel() {
      if (unmanagedContainerModelBuilder_ == null) {
        return unmanagedContainerModel_ == null
            ? com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.getDefaultInstance()
            : unmanagedContainerModel_;
      } else {
        return unmanagedContainerModelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     */
    public Builder setUnmanagedContainerModel(
        com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel value) {
      if (unmanagedContainerModelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        unmanagedContainerModel_ = value;
      } else {
        unmanagedContainerModelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     */
    public Builder setUnmanagedContainerModel(
        com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.Builder builderForValue) {
      if (unmanagedContainerModelBuilder_ == null) {
        unmanagedContainerModel_ = builderForValue.build();
      } else {
        unmanagedContainerModelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     */
    public Builder mergeUnmanagedContainerModel(
        com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel value) {
      if (unmanagedContainerModelBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && unmanagedContainerModel_ != null
            && unmanagedContainerModel_
                != com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel
                    .getDefaultInstance()) {
          getUnmanagedContainerModelBuilder().mergeFrom(value);
        } else {
          unmanagedContainerModel_ = value;
        }
      } else {
        unmanagedContainerModelBuilder_.mergeFrom(value);
      }
      if (unmanagedContainerModel_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     */
    public Builder clearUnmanagedContainerModel() {
      bitField0_ = (bitField0_ & ~0x00000010);
      unmanagedContainerModel_ = null;
      if (unmanagedContainerModelBuilder_ != null) {
        unmanagedContainerModelBuilder_.dispose();
        unmanagedContainerModelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.Builder
        getUnmanagedContainerModelBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUnmanagedContainerModelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModelOrBuilder
        getUnmanagedContainerModelOrBuilder() {
      if (unmanagedContainerModelBuilder_ != null) {
        return unmanagedContainerModelBuilder_.getMessageOrBuilder();
      } else {
        return unmanagedContainerModel_ == null
            ? com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.getDefaultInstance()
            : unmanagedContainerModel_;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.UnmanagedContainerModel unmanaged_container_model = 28;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel,
            com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.Builder,
            com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModelOrBuilder>
        getUnmanagedContainerModelFieldBuilder() {
      if (unmanagedContainerModelBuilder_ == null) {
        unmanagedContainerModelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel,
                com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModel.Builder,
                com.google.cloud.aiplatform.v1beta1.UnmanagedContainerModelOrBuilder>(
                getUnmanagedContainerModel(), getParentForChildren(), isClean());
        unmanagedContainerModel_ = null;
      }
      return unmanagedContainerModelBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
                .getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
      } else {
        inputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder
            builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && inputConfig_ != null
            && inputConfig_
                != com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
                    .getDefaultInstance()) {
          getInputConfigBuilder().mergeFrom(value);
        } else {
          inputConfig_ = value;
        }
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }
      if (inputConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder
        getInputConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder
        getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
                .getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are
     * performed. The schema of any single instance may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfigOrBuilder>
        instanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     *
     * @return Whether the instanceConfig field is set.
     */
    public boolean hasInstanceConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     *
     * @return The instanceConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
        getInstanceConfig() {
      if (instanceConfigBuilder_ == null) {
        return instanceConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
                .getDefaultInstance()
            : instanceConfig_;
      } else {
        return instanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     */
    public Builder setInstanceConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig value) {
      if (instanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceConfig_ = value;
      } else {
        instanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     */
    public Builder setInstanceConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.Builder
            builderForValue) {
      if (instanceConfigBuilder_ == null) {
        instanceConfig_ = builderForValue.build();
      } else {
        instanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     */
    public Builder mergeInstanceConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig value) {
      if (instanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && instanceConfig_ != null
            && instanceConfig_
                != com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
                    .getDefaultInstance()) {
          getInstanceConfigBuilder().mergeFrom(value);
        } else {
          instanceConfig_ = value;
        }
      } else {
        instanceConfigBuilder_.mergeFrom(value);
      }
      if (instanceConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     */
    public Builder clearInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      instanceConfig_ = null;
      if (instanceConfigBuilder_ != null) {
        instanceConfigBuilder_.dispose();
        instanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.Builder
        getInstanceConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfigOrBuilder
        getInstanceConfigOrBuilder() {
      if (instanceConfigBuilder_ != null) {
        return instanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return instanceConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig
                .getDefaultInstance()
            : instanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for how to convert batch prediction input instances to the
     * prediction instances that are sent to the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig instance_config = 27;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfigOrBuilder>
        getInstanceConfigFieldBuilder() {
      if (instanceConfigBuilder_ == null) {
        instanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InstanceConfigOrBuilder>(
                getInstanceConfig(), getParentForChildren(), isClean());
        instanceConfig_ = null;
      }
      return instanceConfigBuilder_;
    }

    private com.google.protobuf.Value modelParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        modelParametersBuilder_;
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     *
     * @return Whether the modelParameters field is set.
     */
    public boolean hasModelParameters() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     *
     * @return The modelParameters.
     */
    public com.google.protobuf.Value getModelParameters() {
      if (modelParametersBuilder_ == null) {
        return modelParameters_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : modelParameters_;
      } else {
        return modelParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder setModelParameters(com.google.protobuf.Value value) {
      if (modelParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelParameters_ = value;
      } else {
        modelParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder setModelParameters(com.google.protobuf.Value.Builder builderForValue) {
      if (modelParametersBuilder_ == null) {
        modelParameters_ = builderForValue.build();
      } else {
        modelParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder mergeModelParameters(com.google.protobuf.Value value) {
      if (modelParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && modelParameters_ != null
            && modelParameters_ != com.google.protobuf.Value.getDefaultInstance()) {
          getModelParametersBuilder().mergeFrom(value);
        } else {
          modelParameters_ = value;
        }
      } else {
        modelParametersBuilder_.mergeFrom(value);
      }
      if (modelParameters_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder clearModelParameters() {
      bitField0_ = (bitField0_ & ~0x00000080);
      modelParameters_ = null;
      if (modelParametersBuilder_ != null) {
        modelParametersBuilder_.dispose();
        modelParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public com.google.protobuf.Value.Builder getModelParametersBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getModelParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public com.google.protobuf.ValueOrBuilder getModelParametersOrBuilder() {
      if (modelParametersBuilder_ != null) {
        return modelParametersBuilder_.getMessageOrBuilder();
      } else {
        return modelParameters_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : modelParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getModelParametersFieldBuilder() {
      if (modelParametersBuilder_ == null) {
        modelParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getModelParameters(), getParentForChildren(), isClean());
        modelParameters_ = null;
      }
      return modelParametersBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
                .getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder
            builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && outputConfig_ != null
            && outputConfig_
                != com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
                    .getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      if (outputConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder
        getOutputConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
                .getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicatedResources_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>
        dedicatedResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    public boolean hasDedicatedResources() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     *
     * @return The dedicatedResources.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources getDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      } else {
        return dedicatedResourcesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dedicatedResources_ = value;
      } else {
        dedicatedResourcesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder builderForValue) {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = builderForValue.build();
      } else {
        dedicatedResourcesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder mergeDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && dedicatedResources_ != null
            && dedicatedResources_
                != com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources
                    .getDefaultInstance()) {
          getDedicatedResourcesBuilder().mergeFrom(value);
        } else {
          dedicatedResources_ = value;
        }
      } else {
        dedicatedResourcesBuilder_.mergeFrom(value);
      }
      if (dedicatedResources_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder clearDedicatedResources() {
      bitField0_ = (bitField0_ & ~0x00000200);
      dedicatedResources_ = null;
      if (dedicatedResourcesBuilder_ != null) {
        dedicatedResourcesBuilder_.dispose();
        dedicatedResourcesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder
        getDedicatedResourcesBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDedicatedResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder() {
      if (dedicatedResourcesBuilder_ != null) {
        return dedicatedResourcesBuilder_.getMessageOrBuilder();
      } else {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model
     * [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>
        getDedicatedResourcesFieldBuilder() {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
                com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>(
                getDedicatedResources(), getParentForChildren(), isClean());
        dedicatedResources_ = null;
      }
      return dedicatedResourcesBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. If not
     * specified, a system generated one will be used, which
     * has minimal permissions and the custom container, if used, may not have
     * enough permission to access other Google Cloud resources.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 29;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. If not
     * specified, a system generated one will be used, which
     * has minimal permissions and the custom container, if used, may not have
     * enough permission to access other Google Cloud resources.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 29;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. If not
     * specified, a system generated one will be used, which
     * has minimal permissions and the custom container, if used, may not have
     * enough permission to access other Google Cloud resources.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 29;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. If not
     * specified, a system generated one will be used, which
     * has minimal permissions and the custom container, if used, may not have
     * enough permission to access other Google Cloud resources.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 29;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. If not
     * specified, a system generated one will be used, which
     * has minimal permissions and the custom container, if used, may not have
     * enough permission to access other Google Cloud resources.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 29;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
        manualBatchTuningParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder>
        manualBatchTuningParametersBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the manualBatchTuningParameters field is set.
     */
    public boolean hasManualBatchTuningParameters() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The manualBatchTuningParameters.
     */
    public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
        getManualBatchTuningParameters() {
      if (manualBatchTuningParametersBuilder_ == null) {
        return manualBatchTuningParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.getDefaultInstance()
            : manualBatchTuningParameters_;
      } else {
        return manualBatchTuningParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setManualBatchTuningParameters(
        com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters value) {
      if (manualBatchTuningParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        manualBatchTuningParameters_ = value;
      } else {
        manualBatchTuningParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setManualBatchTuningParameters(
        com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder builderForValue) {
      if (manualBatchTuningParametersBuilder_ == null) {
        manualBatchTuningParameters_ = builderForValue.build();
      } else {
        manualBatchTuningParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeManualBatchTuningParameters(
        com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters value) {
      if (manualBatchTuningParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && manualBatchTuningParameters_ != null
            && manualBatchTuningParameters_
                != com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
                    .getDefaultInstance()) {
          getManualBatchTuningParametersBuilder().mergeFrom(value);
        } else {
          manualBatchTuningParameters_ = value;
        }
      } else {
        manualBatchTuningParametersBuilder_.mergeFrom(value);
      }
      if (manualBatchTuningParameters_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearManualBatchTuningParameters() {
      bitField0_ = (bitField0_ & ~0x00000800);
      manualBatchTuningParameters_ = null;
      if (manualBatchTuningParametersBuilder_ != null) {
        manualBatchTuningParametersBuilder_.dispose();
        manualBatchTuningParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder
        getManualBatchTuningParametersBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getManualBatchTuningParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder
        getManualBatchTuningParametersOrBuilder() {
      if (manualBatchTuningParametersBuilder_ != null) {
        return manualBatchTuningParametersBuilder_.getMessageOrBuilder();
      } else {
        return manualBatchTuningParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.getDefaultInstance()
            : manualBatchTuningParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only
     * applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources]
     * are used (in other cases Vertex AI does the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder>
        getManualBatchTuningParametersFieldBuilder() {
      if (manualBatchTuningParametersBuilder_ == null) {
        manualBatchTuningParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters,
                com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder,
                com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder>(
                getManualBatchTuningParameters(), getParentForChildren(), isClean());
        manualBatchTuningParameters_ = null;
      }
      return manualBatchTuningParametersBuilder_;
    }

    private boolean generateExplanation_;
    /**
     *
     *
     * <pre>
     * Generate explanation with the batch prediction results.
     *
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config]
     * object:
     *
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the
     *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the
     *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     *
     * If this field is set to true, either the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * or
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * must be populated.
     * </pre>
     *
     * <code>bool generate_explanation = 23;</code>
     *
     * @return The generateExplanation.
     */
    @java.lang.Override
    public boolean getGenerateExplanation() {
      return generateExplanation_;
    }
    /**
     *
     *
     * <pre>
     * Generate explanation with the batch prediction results.
     *
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config]
     * object:
     *
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the
     *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the
     *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     *
     * If this field is set to true, either the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * or
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * must be populated.
     * </pre>
     *
     * <code>bool generate_explanation = 23;</code>
     *
     * @param value The generateExplanation to set.
     * @return This builder for chaining.
     */
    public Builder setGenerateExplanation(boolean value) {

      generateExplanation_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generate explanation with the batch prediction results.
     *
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config]
     * object:
     *
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the
     *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the
     *    [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     *
     * If this field is set to true, either the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * or
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * must be populated.
     * </pre>
     *
     * <code>bool generate_explanation = 23;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGenerateExplanation() {
      bitField0_ = (bitField0_ & ~0x00001000);
      generateExplanation_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        explanationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    public boolean hasExplanationSpec() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     *
     * @return The explanationSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      } else {
        return explanationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder setExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationSpec_ = value;
      } else {
        explanationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder setExplanationSpec(
        com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder builderForValue) {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = builderForValue.build();
      } else {
        explanationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && explanationSpec_ != null
            && explanationSpec_
                != com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()) {
          getExplanationSpecBuilder().mergeFrom(value);
        } else {
          explanationSpec_ = value;
        }
      } else {
        explanationSpecBuilder_.mergeFrom(value);
      }
      if (explanationSpec_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder clearExplanationSpec() {
      bitField0_ = (bitField0_ & ~0x00002000);
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder getExplanationSpecBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getExplanationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
        getExplanationSpecOrBuilder() {
      if (explanationSpecBuilder_ != null) {
        return explanationSpecBuilder_.getMessageOrBuilder();
      } else {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if
     * [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation]
     * is set to `true`.
     *
     * This value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec]
     * object is not populated, the corresponding field of the
     * [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]
     * object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        getExplanationSpecFieldBuilder() {
      if (explanationSpecBuilder_ == null) {
        explanationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>(
                getExplanationSpec(), getParentForChildren(), isClean());
        explanationSpec_ = null;
      }
      return explanationSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo outputInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder>
        outputInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the outputInfo field is set.
     */
    public boolean hasOutputInfo() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The outputInfo.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo getOutputInfo() {
      if (outputInfoBuilder_ == null) {
        return outputInfo_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.getDefaultInstance()
            : outputInfo_;
      } else {
        return outputInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputInfo_ = value;
      } else {
        outputInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder builderForValue) {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = builderForValue.build();
      } else {
        outputInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOutputInfo(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && outputInfo_ != null
            && outputInfo_
                != com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
                    .getDefaultInstance()) {
          getOutputInfoBuilder().mergeFrom(value);
        } else {
          outputInfo_ = value;
        }
      } else {
        outputInfoBuilder_.mergeFrom(value);
      }
      if (outputInfo_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOutputInfo() {
      bitField0_ = (bitField0_ & ~0x00004000);
      outputInfo_ = null;
      if (outputInfoBuilder_ != null) {
        outputInfoBuilder_.dispose();
        outputInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder
        getOutputInfoBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getOutputInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder
        getOutputInfoOrBuilder() {
      if (outputInfoBuilder_ != null) {
        return outputInfoBuilder_.getMessageOrBuilder();
      } else {
        return outputInfo_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.getDefaultInstance()
            : outputInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder>
        getOutputInfoFieldBuilder() {
      if (outputInfoBuilder_ == null) {
        outputInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder>(
                getOutputInfo(), getParentForChildren(), isClean());
        outputInfo_ = null;
      }
      return outputInfoBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JobState getState() {
      com.google.cloud.aiplatform.v1beta1.JobState result =
          com.google.cloud.aiplatform.v1beta1.JobState.forNumber(state_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00008000);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00010000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.util.List<com.google.rpc.Status> partialFailures_ =
        java.util.Collections.emptyList();

    private void ensurePartialFailuresIsMutable() {
      if (!((bitField0_ & 0x00020000) != 0)) {
        partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>(partialFailures_);
        bitField0_ |= 0x00020000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialFailuresBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
      if (partialFailuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialFailures_);
      } else {
        return partialFailuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPartialFailuresCount() {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.size();
      } else {
        return partialFailuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status getPartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPartialFailures(
        java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialFailures_);
        onChanged();
      } else {
        partialFailuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPartialFailures() {
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00020000);
        onChanged();
      } else {
        partialFailuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.remove(index);
        onChanged();
      } else {
        partialFailuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialFailuresOrBuilderList() {
      if (partialFailuresBuilder_ != null) {
        return partialFailuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialFailures_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder() {
      return getPartialFailuresFieldBuilder()
          .addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard Google Cloud error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialFailuresBuilderList() {
      return getPartialFailuresFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialFailuresFieldBuilder() {
      if (partialFailuresBuilder_ == null) {
        partialFailuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialFailures_,
                ((bitField0_ & 0x00020000) != 0),
                getParentForChildren(),
                isClean());
        partialFailures_ = null;
      }
      return partialFailuresBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ResourcesConsumed resourcesConsumed_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder>
        resourcesConsumedBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the resourcesConsumed field is set.
     */
    public boolean hasResourcesConsumed() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The resourcesConsumed.
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcesConsumed getResourcesConsumed() {
      if (resourcesConsumedBuilder_ == null) {
        return resourcesConsumed_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()
            : resourcesConsumed_;
      } else {
        return resourcesConsumedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourcesConsumed(
        com.google.cloud.aiplatform.v1beta1.ResourcesConsumed value) {
      if (resourcesConsumedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourcesConsumed_ = value;
      } else {
        resourcesConsumedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourcesConsumed(
        com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder builderForValue) {
      if (resourcesConsumedBuilder_ == null) {
        resourcesConsumed_ = builderForValue.build();
      } else {
        resourcesConsumedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResourcesConsumed(
        com.google.cloud.aiplatform.v1beta1.ResourcesConsumed value) {
      if (resourcesConsumedBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && resourcesConsumed_ != null
            && resourcesConsumed_
                != com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()) {
          getResourcesConsumedBuilder().mergeFrom(value);
        } else {
          resourcesConsumed_ = value;
        }
      } else {
        resourcesConsumedBuilder_.mergeFrom(value);
      }
      if (resourcesConsumed_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResourcesConsumed() {
      bitField0_ = (bitField0_ & ~0x00040000);
      resourcesConsumed_ = null;
      if (resourcesConsumedBuilder_ != null) {
        resourcesConsumedBuilder_.dispose();
        resourcesConsumedBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder
        getResourcesConsumedBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getResourcesConsumedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder
        getResourcesConsumedOrBuilder() {
      if (resourcesConsumedBuilder_ != null) {
        return resourcesConsumedBuilder_.getMessageOrBuilder();
      } else {
        return resourcesConsumed_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()
            : resourcesConsumed_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this
     * job. Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     *
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder>
        getResourcesConsumedFieldBuilder() {
      if (resourcesConsumedBuilder_ == null) {
        resourcesConsumedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ResourcesConsumed,
                com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder,
                com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder>(
                getResourcesConsumed(), getParentForChildren(), isClean());
        resourcesConsumed_ = null;
      }
      return resourcesConsumedBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.CompletionStats completionStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CompletionStats,
            com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder,
            com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder>
        completionStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the completionStats field is set.
     */
    public boolean hasCompletionStats() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The completionStats.
     */
    public com.google.cloud.aiplatform.v1beta1.CompletionStats getCompletionStats() {
      if (completionStatsBuilder_ == null) {
        return completionStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()
            : completionStats_;
      } else {
        return completionStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionStats(com.google.cloud.aiplatform.v1beta1.CompletionStats value) {
      if (completionStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completionStats_ = value;
      } else {
        completionStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionStats(
        com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder builderForValue) {
      if (completionStatsBuilder_ == null) {
        completionStats_ = builderForValue.build();
      } else {
        completionStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCompletionStats(com.google.cloud.aiplatform.v1beta1.CompletionStats value) {
      if (completionStatsBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && completionStats_ != null
            && completionStats_
                != com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()) {
          getCompletionStatsBuilder().mergeFrom(value);
        } else {
          completionStats_ = value;
        }
      } else {
        completionStatsBuilder_.mergeFrom(value);
      }
      if (completionStats_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCompletionStats() {
      bitField0_ = (bitField0_ & ~0x00080000);
      completionStats_ = null;
      if (completionStatsBuilder_ != null) {
        completionStatsBuilder_.dispose();
        completionStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder getCompletionStatsBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getCompletionStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder
        getCompletionStatsOrBuilder() {
      if (completionStatsBuilder_ != null) {
        return completionStatsBuilder_.getMessageOrBuilder();
      } else {
        return completionStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()
            : completionStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CompletionStats,
            com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder,
            com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder>
        getCompletionStatsFieldBuilder() {
      if (completionStatsBuilder_ == null) {
        completionStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CompletionStats,
                com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder,
                com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder>(
                getCompletionStats(), getParentForChildren(), isClean());
        completionStats_ = null;
      }
      return completionStatsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00100000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00200000);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered
     * the `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00400000);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following
     * states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00800000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x01000000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x01000000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x01000000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x01000000;
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x02000000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig modelMonitoringConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfigOrBuilder>
        modelMonitoringConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     *
     * @return Whether the modelMonitoringConfig field is set.
     */
    public boolean hasModelMonitoringConfig() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     *
     * @return The modelMonitoringConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig getModelMonitoringConfig() {
      if (modelMonitoringConfigBuilder_ == null) {
        return modelMonitoringConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.getDefaultInstance()
            : modelMonitoringConfig_;
      } else {
        return modelMonitoringConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     */
    public Builder setModelMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig value) {
      if (modelMonitoringConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringConfig_ = value;
      } else {
        modelMonitoringConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     */
    public Builder setModelMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.Builder builderForValue) {
      if (modelMonitoringConfigBuilder_ == null) {
        modelMonitoringConfig_ = builderForValue.build();
      } else {
        modelMonitoringConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     */
    public Builder mergeModelMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig value) {
      if (modelMonitoringConfigBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && modelMonitoringConfig_ != null
            && modelMonitoringConfig_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.getDefaultInstance()) {
          getModelMonitoringConfigBuilder().mergeFrom(value);
        } else {
          modelMonitoringConfig_ = value;
        }
      } else {
        modelMonitoringConfigBuilder_.mergeFrom(value);
      }
      if (modelMonitoringConfig_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     */
    public Builder clearModelMonitoringConfig() {
      bitField0_ = (bitField0_ & ~0x04000000);
      modelMonitoringConfig_ = null;
      if (modelMonitoringConfigBuilder_ != null) {
        modelMonitoringConfigBuilder_.dispose();
        modelMonitoringConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.Builder
        getModelMonitoringConfigBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getModelMonitoringConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfigOrBuilder
        getModelMonitoringConfigOrBuilder() {
      if (modelMonitoringConfigBuilder_ != null) {
        return modelMonitoringConfigBuilder_.getMessageOrBuilder();
      } else {
        return modelMonitoringConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.getDefaultInstance()
            : modelMonitoringConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring config will be used for analysis model behaviors, based on
     * the input and output to the batch prediction job, as well as the provided
     * training dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig model_monitoring_config = 26;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfigOrBuilder>
        getModelMonitoringConfigFieldBuilder() {
      if (modelMonitoringConfigBuilder_ == null) {
        modelMonitoringConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfigOrBuilder>(
                getModelMonitoringConfig(), getParentForChildren(), isClean());
        modelMonitoringConfig_ = null;
      }
      return modelMonitoringConfigBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies>
        modelMonitoringStatsAnomalies_ = java.util.Collections.emptyList();

    private void ensureModelMonitoringStatsAnomaliesIsMutable() {
      if (!((bitField0_ & 0x08000000) != 0)) {
        modelMonitoringStatsAnomalies_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies>(
                modelMonitoringStatsAnomalies_);
        bitField0_ |= 0x08000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder>
        modelMonitoringStatsAnomaliesBuilder_;

    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies>
        getModelMonitoringStatsAnomaliesList() {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(modelMonitoringStatsAnomalies_);
      } else {
        return modelMonitoringStatsAnomaliesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public int getModelMonitoringStatsAnomaliesCount() {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        return modelMonitoringStatsAnomalies_.size();
      } else {
        return modelMonitoringStatsAnomaliesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
        getModelMonitoringStatsAnomalies(int index) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        return modelMonitoringStatsAnomalies_.get(index);
      } else {
        return modelMonitoringStatsAnomaliesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder setModelMonitoringStatsAnomalies(
        int index, com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies value) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelMonitoringStatsAnomaliesIsMutable();
        modelMonitoringStatsAnomalies_.set(index, value);
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder setModelMonitoringStatsAnomalies(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder builderForValue) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        ensureModelMonitoringStatsAnomaliesIsMutable();
        modelMonitoringStatsAnomalies_.set(index, builderForValue.build());
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder addModelMonitoringStatsAnomalies(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies value) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelMonitoringStatsAnomaliesIsMutable();
        modelMonitoringStatsAnomalies_.add(value);
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder addModelMonitoringStatsAnomalies(
        int index, com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies value) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelMonitoringStatsAnomaliesIsMutable();
        modelMonitoringStatsAnomalies_.add(index, value);
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder addModelMonitoringStatsAnomalies(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder builderForValue) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        ensureModelMonitoringStatsAnomaliesIsMutable();
        modelMonitoringStatsAnomalies_.add(builderForValue.build());
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder addModelMonitoringStatsAnomalies(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder builderForValue) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        ensureModelMonitoringStatsAnomaliesIsMutable();
        modelMonitoringStatsAnomalies_.add(index, builderForValue.build());
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder addAllModelMonitoringStatsAnomalies(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies>
            values) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        ensureModelMonitoringStatsAnomaliesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, modelMonitoringStatsAnomalies_);
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder clearModelMonitoringStatsAnomalies() {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        modelMonitoringStatsAnomalies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x08000000);
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public Builder removeModelMonitoringStatsAnomalies(int index) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        ensureModelMonitoringStatsAnomaliesIsMutable();
        modelMonitoringStatsAnomalies_.remove(index);
        onChanged();
      } else {
        modelMonitoringStatsAnomaliesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder
        getModelMonitoringStatsAnomaliesBuilder(int index) {
      return getModelMonitoringStatsAnomaliesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder
        getModelMonitoringStatsAnomaliesOrBuilder(int index) {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        return modelMonitoringStatsAnomalies_.get(index);
      } else {
        return modelMonitoringStatsAnomaliesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder>
        getModelMonitoringStatsAnomaliesOrBuilderList() {
      if (modelMonitoringStatsAnomaliesBuilder_ != null) {
        return modelMonitoringStatsAnomaliesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(modelMonitoringStatsAnomalies_);
      }
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder
        addModelMonitoringStatsAnomaliesBuilder() {
      return getModelMonitoringStatsAnomaliesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder
        addModelMonitoringStatsAnomaliesBuilder(int index) {
      return getModelMonitoringStatsAnomaliesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Get batch prediction job monitoring statistics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies model_monitoring_stats_anomalies = 31;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder>
        getModelMonitoringStatsAnomaliesBuilderList() {
      return getModelMonitoringStatsAnomaliesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder>
        getModelMonitoringStatsAnomaliesFieldBuilder() {
      if (modelMonitoringStatsAnomaliesBuilder_ == null) {
        modelMonitoringStatsAnomaliesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomaliesOrBuilder>(
                modelMonitoringStatsAnomalies_,
                ((bitField0_ & 0x08000000) != 0),
                getParentForChildren(),
                isClean());
        modelMonitoringStatsAnomalies_ = null;
      }
      return modelMonitoringStatsAnomaliesBuilder_;
    }

    private com.google.rpc.Status modelMonitoringStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        modelMonitoringStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the modelMonitoringStatus field is set.
     */
    public boolean hasModelMonitoringStatus() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The modelMonitoringStatus.
     */
    public com.google.rpc.Status getModelMonitoringStatus() {
      if (modelMonitoringStatusBuilder_ == null) {
        return modelMonitoringStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : modelMonitoringStatus_;
      } else {
        return modelMonitoringStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setModelMonitoringStatus(com.google.rpc.Status value) {
      if (modelMonitoringStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringStatus_ = value;
      } else {
        modelMonitoringStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setModelMonitoringStatus(com.google.rpc.Status.Builder builderForValue) {
      if (modelMonitoringStatusBuilder_ == null) {
        modelMonitoringStatus_ = builderForValue.build();
      } else {
        modelMonitoringStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeModelMonitoringStatus(com.google.rpc.Status value) {
      if (modelMonitoringStatusBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && modelMonitoringStatus_ != null
            && modelMonitoringStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getModelMonitoringStatusBuilder().mergeFrom(value);
        } else {
          modelMonitoringStatus_ = value;
        }
      } else {
        modelMonitoringStatusBuilder_.mergeFrom(value);
      }
      if (modelMonitoringStatus_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearModelMonitoringStatus() {
      bitField0_ = (bitField0_ & ~0x10000000);
      modelMonitoringStatus_ = null;
      if (modelMonitoringStatusBuilder_ != null) {
        modelMonitoringStatusBuilder_.dispose();
        modelMonitoringStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getModelMonitoringStatusBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getModelMonitoringStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getModelMonitoringStatusOrBuilder() {
      if (modelMonitoringStatusBuilder_ != null) {
        return modelMonitoringStatusBuilder_.getMessageOrBuilder();
      } else {
        return modelMonitoringStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : modelMonitoringStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The running status of the model monitoring pipeline.
     * </pre>
     *
     * <code>
     * .google.rpc.Status model_monitoring_status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getModelMonitoringStatusFieldBuilder() {
      if (modelMonitoringStatusBuilder_ == null) {
        modelMonitoringStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getModelMonitoringStatus(), getParentForChildren(), isClean());
        modelMonitoringStatus_ = null;
      }
      return modelMonitoringStatusBuilder_;
    }

    private boolean disableContainerLogging_;
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Cloud Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging/pricing).
     *
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 34;</code>
     *
     * @return The disableContainerLogging.
     */
    @java.lang.Override
    public boolean getDisableContainerLogging() {
      return disableContainerLogging_;
    }
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Cloud Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging/pricing).
     *
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 34;</code>
     *
     * @param value The disableContainerLogging to set.
     * @return This builder for chaining.
     */
    public Builder setDisableContainerLogging(boolean value) {

      disableContainerLogging_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Cloud Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging/pricing).
     *
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 34;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableContainerLogging() {
      bitField0_ = (bitField0_ & ~0x20000000);
      disableContainerLogging_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x40000000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x80000000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
  private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchPredictionJob> PARSER =
      new com.google.protobuf.AbstractParser<BatchPredictionJob>() {
        @java.lang.Override
        public BatchPredictionJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchPredictionJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchPredictionJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
