/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/data_labeling_job.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Parameters that configure the active learning pipeline. Active learning will
 *  label the data incrementally by several iterations. For every iteration, it
 *  will select a batch of data based on the sampling strategy.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ActiveLearningConfig}
 */
public final class ActiveLearningConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ActiveLearningConfig)
    ActiveLearningConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ActiveLearningConfig.newBuilder() to construct.
  private ActiveLearningConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ActiveLearningConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ActiveLearningConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DataLabelingJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ActiveLearningConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DataLabelingJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ActiveLearningConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig.class,
            com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig.Builder.class);
  }

  private int bitField0_;
  private int humanLabelingBudgetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object humanLabelingBudget_;

  public enum HumanLabelingBudgetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MAX_DATA_ITEM_COUNT(1),
    MAX_DATA_ITEM_PERCENTAGE(2),
    HUMANLABELINGBUDGET_NOT_SET(0);
    private final int value;

    private HumanLabelingBudgetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HumanLabelingBudgetCase valueOf(int value) {
      return forNumber(value);
    }

    public static HumanLabelingBudgetCase forNumber(int value) {
      switch (value) {
        case 1:
          return MAX_DATA_ITEM_COUNT;
        case 2:
          return MAX_DATA_ITEM_PERCENTAGE;
        case 0:
          return HUMANLABELINGBUDGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public HumanLabelingBudgetCase getHumanLabelingBudgetCase() {
    return HumanLabelingBudgetCase.forNumber(humanLabelingBudgetCase_);
  }

  public static final int MAX_DATA_ITEM_COUNT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Max number of human labeled DataItems.
   * </pre>
   *
   * <code>int64 max_data_item_count = 1;</code>
   *
   * @return Whether the maxDataItemCount field is set.
   */
  @java.lang.Override
  public boolean hasMaxDataItemCount() {
    return humanLabelingBudgetCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Max number of human labeled DataItems.
   * </pre>
   *
   * <code>int64 max_data_item_count = 1;</code>
   *
   * @return The maxDataItemCount.
   */
  @java.lang.Override
  public long getMaxDataItemCount() {
    if (humanLabelingBudgetCase_ == 1) {
      return (java.lang.Long) humanLabelingBudget_;
    }
    return 0L;
  }

  public static final int MAX_DATA_ITEM_PERCENTAGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Max percent of total DataItems for human labeling.
   * </pre>
   *
   * <code>int32 max_data_item_percentage = 2;</code>
   *
   * @return Whether the maxDataItemPercentage field is set.
   */
  @java.lang.Override
  public boolean hasMaxDataItemPercentage() {
    return humanLabelingBudgetCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Max percent of total DataItems for human labeling.
   * </pre>
   *
   * <code>int32 max_data_item_percentage = 2;</code>
   *
   * @return The maxDataItemPercentage.
   */
  @java.lang.Override
  public int getMaxDataItemPercentage() {
    if (humanLabelingBudgetCase_ == 2) {
      return (java.lang.Integer) humanLabelingBudget_;
    }
    return 0;
  }

  public static final int SAMPLE_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.SampleConfig sampleConfig_;
  /**
   *
   *
   * <pre>
   * Active learning data sampling config. For every active learning labeling
   * iteration, it will select a batch of data based on the sampling strategy.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
   *
   * @return Whether the sampleConfig field is set.
   */
  @java.lang.Override
  public boolean hasSampleConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Active learning data sampling config. For every active learning labeling
   * iteration, it will select a batch of data based on the sampling strategy.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
   *
   * @return The sampleConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SampleConfig getSampleConfig() {
    return sampleConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.SampleConfig.getDefaultInstance()
        : sampleConfig_;
  }
  /**
   *
   *
   * <pre>
   * Active learning data sampling config. For every active learning labeling
   * iteration, it will select a batch of data based on the sampling strategy.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SampleConfigOrBuilder getSampleConfigOrBuilder() {
    return sampleConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.SampleConfig.getDefaultInstance()
        : sampleConfig_;
  }

  public static final int TRAINING_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.TrainingConfig trainingConfig_;
  /**
   *
   *
   * <pre>
   * CMLE training config. For every active learning labeling iteration, system
   * will train a machine learning model on CMLE. The trained model will be used
   * by data sampling algorithm to select DataItems.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
   *
   * @return Whether the trainingConfig field is set.
   */
  @java.lang.Override
  public boolean hasTrainingConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * CMLE training config. For every active learning labeling iteration, system
   * will train a machine learning model on CMLE. The trained model will be used
   * by data sampling algorithm to select DataItems.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
   *
   * @return The trainingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TrainingConfig getTrainingConfig() {
    return trainingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.TrainingConfig.getDefaultInstance()
        : trainingConfig_;
  }
  /**
   *
   *
   * <pre>
   * CMLE training config. For every active learning labeling iteration, system
   * will train a machine learning model on CMLE. The trained model will be used
   * by data sampling algorithm to select DataItems.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TrainingConfigOrBuilder getTrainingConfigOrBuilder() {
    return trainingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.TrainingConfig.getDefaultInstance()
        : trainingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (humanLabelingBudgetCase_ == 1) {
      output.writeInt64(1, (long) ((java.lang.Long) humanLabelingBudget_));
    }
    if (humanLabelingBudgetCase_ == 2) {
      output.writeInt32(2, (int) ((java.lang.Integer) humanLabelingBudget_));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSampleConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getTrainingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (humanLabelingBudgetCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              1, (long) ((java.lang.Long) humanLabelingBudget_));
    }
    if (humanLabelingBudgetCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              2, (int) ((java.lang.Integer) humanLabelingBudget_));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSampleConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTrainingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig other =
        (com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig) obj;

    if (hasSampleConfig() != other.hasSampleConfig()) return false;
    if (hasSampleConfig()) {
      if (!getSampleConfig().equals(other.getSampleConfig())) return false;
    }
    if (hasTrainingConfig() != other.hasTrainingConfig()) return false;
    if (hasTrainingConfig()) {
      if (!getTrainingConfig().equals(other.getTrainingConfig())) return false;
    }
    if (!getHumanLabelingBudgetCase().equals(other.getHumanLabelingBudgetCase())) return false;
    switch (humanLabelingBudgetCase_) {
      case 1:
        if (getMaxDataItemCount() != other.getMaxDataItemCount()) return false;
        break;
      case 2:
        if (getMaxDataItemPercentage() != other.getMaxDataItemPercentage()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSampleConfig()) {
      hash = (37 * hash) + SAMPLE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSampleConfig().hashCode();
    }
    if (hasTrainingConfig()) {
      hash = (37 * hash) + TRAINING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingConfig().hashCode();
    }
    switch (humanLabelingBudgetCase_) {
      case 1:
        hash = (37 * hash) + MAX_DATA_ITEM_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxDataItemCount());
        break;
      case 2:
        hash = (37 * hash) + MAX_DATA_ITEM_PERCENTAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMaxDataItemPercentage();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters that configure the active learning pipeline. Active learning will
   *  label the data incrementally by several iterations. For every iteration, it
   *  will select a batch of data based on the sampling strategy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ActiveLearningConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ActiveLearningConfig)
      com.google.cloud.aiplatform.v1beta1.ActiveLearningConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DataLabelingJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ActiveLearningConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DataLabelingJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ActiveLearningConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig.class,
              com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSampleConfigFieldBuilder();
        getTrainingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sampleConfig_ = null;
      if (sampleConfigBuilder_ != null) {
        sampleConfigBuilder_.dispose();
        sampleConfigBuilder_ = null;
      }
      trainingConfig_ = null;
      if (trainingConfigBuilder_ != null) {
        trainingConfigBuilder_.dispose();
        trainingConfigBuilder_ = null;
      }
      humanLabelingBudgetCase_ = 0;
      humanLabelingBudget_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DataLabelingJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ActiveLearningConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig build() {
      com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig result =
          new com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sampleConfig_ =
            sampleConfigBuilder_ == null ? sampleConfig_ : sampleConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.trainingConfig_ =
            trainingConfigBuilder_ == null ? trainingConfig_ : trainingConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig result) {
      result.humanLabelingBudgetCase_ = humanLabelingBudgetCase_;
      result.humanLabelingBudget_ = this.humanLabelingBudget_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig.getDefaultInstance())
        return this;
      if (other.hasSampleConfig()) {
        mergeSampleConfig(other.getSampleConfig());
      }
      if (other.hasTrainingConfig()) {
        mergeTrainingConfig(other.getTrainingConfig());
      }
      switch (other.getHumanLabelingBudgetCase()) {
        case MAX_DATA_ITEM_COUNT:
          {
            setMaxDataItemCount(other.getMaxDataItemCount());
            break;
          }
        case MAX_DATA_ITEM_PERCENTAGE:
          {
            setMaxDataItemPercentage(other.getMaxDataItemPercentage());
            break;
          }
        case HUMANLABELINGBUDGET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                humanLabelingBudget_ = input.readInt64();
                humanLabelingBudgetCase_ = 1;
                break;
              } // case 8
            case 16:
              {
                humanLabelingBudget_ = input.readInt32();
                humanLabelingBudgetCase_ = 2;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getSampleConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTrainingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int humanLabelingBudgetCase_ = 0;
    private java.lang.Object humanLabelingBudget_;

    public HumanLabelingBudgetCase getHumanLabelingBudgetCase() {
      return HumanLabelingBudgetCase.forNumber(humanLabelingBudgetCase_);
    }

    public Builder clearHumanLabelingBudget() {
      humanLabelingBudgetCase_ = 0;
      humanLabelingBudget_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Max number of human labeled DataItems.
     * </pre>
     *
     * <code>int64 max_data_item_count = 1;</code>
     *
     * @return Whether the maxDataItemCount field is set.
     */
    public boolean hasMaxDataItemCount() {
      return humanLabelingBudgetCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Max number of human labeled DataItems.
     * </pre>
     *
     * <code>int64 max_data_item_count = 1;</code>
     *
     * @return The maxDataItemCount.
     */
    public long getMaxDataItemCount() {
      if (humanLabelingBudgetCase_ == 1) {
        return (java.lang.Long) humanLabelingBudget_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Max number of human labeled DataItems.
     * </pre>
     *
     * <code>int64 max_data_item_count = 1;</code>
     *
     * @param value The maxDataItemCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDataItemCount(long value) {

      humanLabelingBudgetCase_ = 1;
      humanLabelingBudget_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max number of human labeled DataItems.
     * </pre>
     *
     * <code>int64 max_data_item_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxDataItemCount() {
      if (humanLabelingBudgetCase_ == 1) {
        humanLabelingBudgetCase_ = 0;
        humanLabelingBudget_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Max percent of total DataItems for human labeling.
     * </pre>
     *
     * <code>int32 max_data_item_percentage = 2;</code>
     *
     * @return Whether the maxDataItemPercentage field is set.
     */
    public boolean hasMaxDataItemPercentage() {
      return humanLabelingBudgetCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Max percent of total DataItems for human labeling.
     * </pre>
     *
     * <code>int32 max_data_item_percentage = 2;</code>
     *
     * @return The maxDataItemPercentage.
     */
    public int getMaxDataItemPercentage() {
      if (humanLabelingBudgetCase_ == 2) {
        return (java.lang.Integer) humanLabelingBudget_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Max percent of total DataItems for human labeling.
     * </pre>
     *
     * <code>int32 max_data_item_percentage = 2;</code>
     *
     * @param value The maxDataItemPercentage to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDataItemPercentage(int value) {

      humanLabelingBudgetCase_ = 2;
      humanLabelingBudget_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max percent of total DataItems for human labeling.
     * </pre>
     *
     * <code>int32 max_data_item_percentage = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxDataItemPercentage() {
      if (humanLabelingBudgetCase_ == 2) {
        humanLabelingBudgetCase_ = 0;
        humanLabelingBudget_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.SampleConfig sampleConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SampleConfig,
            com.google.cloud.aiplatform.v1beta1.SampleConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.SampleConfigOrBuilder>
        sampleConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     *
     * @return Whether the sampleConfig field is set.
     */
    public boolean hasSampleConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     *
     * @return The sampleConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.SampleConfig getSampleConfig() {
      if (sampleConfigBuilder_ == null) {
        return sampleConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.SampleConfig.getDefaultInstance()
            : sampleConfig_;
      } else {
        return sampleConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     */
    public Builder setSampleConfig(com.google.cloud.aiplatform.v1beta1.SampleConfig value) {
      if (sampleConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sampleConfig_ = value;
      } else {
        sampleConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     */
    public Builder setSampleConfig(
        com.google.cloud.aiplatform.v1beta1.SampleConfig.Builder builderForValue) {
      if (sampleConfigBuilder_ == null) {
        sampleConfig_ = builderForValue.build();
      } else {
        sampleConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     */
    public Builder mergeSampleConfig(com.google.cloud.aiplatform.v1beta1.SampleConfig value) {
      if (sampleConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && sampleConfig_ != null
            && sampleConfig_
                != com.google.cloud.aiplatform.v1beta1.SampleConfig.getDefaultInstance()) {
          getSampleConfigBuilder().mergeFrom(value);
        } else {
          sampleConfig_ = value;
        }
      } else {
        sampleConfigBuilder_.mergeFrom(value);
      }
      if (sampleConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     */
    public Builder clearSampleConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      sampleConfig_ = null;
      if (sampleConfigBuilder_ != null) {
        sampleConfigBuilder_.dispose();
        sampleConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SampleConfig.Builder getSampleConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSampleConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SampleConfigOrBuilder getSampleConfigOrBuilder() {
      if (sampleConfigBuilder_ != null) {
        return sampleConfigBuilder_.getMessageOrBuilder();
      } else {
        return sampleConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.SampleConfig.getDefaultInstance()
            : sampleConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Active learning data sampling config. For every active learning labeling
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SampleConfig sample_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SampleConfig,
            com.google.cloud.aiplatform.v1beta1.SampleConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.SampleConfigOrBuilder>
        getSampleConfigFieldBuilder() {
      if (sampleConfigBuilder_ == null) {
        sampleConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SampleConfig,
                com.google.cloud.aiplatform.v1beta1.SampleConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.SampleConfigOrBuilder>(
                getSampleConfig(), getParentForChildren(), isClean());
        sampleConfig_ = null;
      }
      return sampleConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.TrainingConfig trainingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TrainingConfig,
            com.google.cloud.aiplatform.v1beta1.TrainingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.TrainingConfigOrBuilder>
        trainingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     *
     * @return Whether the trainingConfig field is set.
     */
    public boolean hasTrainingConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     *
     * @return The trainingConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.TrainingConfig getTrainingConfig() {
      if (trainingConfigBuilder_ == null) {
        return trainingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.TrainingConfig.getDefaultInstance()
            : trainingConfig_;
      } else {
        return trainingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     */
    public Builder setTrainingConfig(com.google.cloud.aiplatform.v1beta1.TrainingConfig value) {
      if (trainingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingConfig_ = value;
      } else {
        trainingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     */
    public Builder setTrainingConfig(
        com.google.cloud.aiplatform.v1beta1.TrainingConfig.Builder builderForValue) {
      if (trainingConfigBuilder_ == null) {
        trainingConfig_ = builderForValue.build();
      } else {
        trainingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     */
    public Builder mergeTrainingConfig(com.google.cloud.aiplatform.v1beta1.TrainingConfig value) {
      if (trainingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && trainingConfig_ != null
            && trainingConfig_
                != com.google.cloud.aiplatform.v1beta1.TrainingConfig.getDefaultInstance()) {
          getTrainingConfigBuilder().mergeFrom(value);
        } else {
          trainingConfig_ = value;
        }
      } else {
        trainingConfigBuilder_.mergeFrom(value);
      }
      if (trainingConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     */
    public Builder clearTrainingConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      trainingConfig_ = null;
      if (trainingConfigBuilder_ != null) {
        trainingConfigBuilder_.dispose();
        trainingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.TrainingConfig.Builder getTrainingConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTrainingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.TrainingConfigOrBuilder
        getTrainingConfigOrBuilder() {
      if (trainingConfigBuilder_ != null) {
        return trainingConfigBuilder_.getMessageOrBuilder();
      } else {
        return trainingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.TrainingConfig.getDefaultInstance()
            : trainingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * CMLE training config. For every active learning labeling iteration, system
     * will train a machine learning model on CMLE. The trained model will be used
     * by data sampling algorithm to select DataItems.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TrainingConfig training_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TrainingConfig,
            com.google.cloud.aiplatform.v1beta1.TrainingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.TrainingConfigOrBuilder>
        getTrainingConfigFieldBuilder() {
      if (trainingConfigBuilder_ == null) {
        trainingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.TrainingConfig,
                com.google.cloud.aiplatform.v1beta1.TrainingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.TrainingConfigOrBuilder>(
                getTrainingConfig(), getParentForChildren(), isClean());
        trainingConfig_ = null;
      }
      return trainingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ActiveLearningConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ActiveLearningConfig)
  private static final com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ActiveLearningConfig> PARSER =
      new com.google.protobuf.AbstractParser<ActiveLearningConfig>() {
        @java.lang.Override
        public ActiveLearningConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ActiveLearningConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ActiveLearningConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ActiveLearningConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
