/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StudyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_STUDY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/studies/{study}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String study;

    @Deprecated
    protected StudyName() {
        this.project = null;
        this.location = null;
        this.study = null;
    }

    private StudyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.study = (String)Preconditions.checkNotNull((Object)builder.getStudy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStudy() {
        return this.study;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static StudyName of(String project, String location, String study) {
        return StudyName.newBuilder().setProject(project).setLocation(location).setStudy(study).build();
    }

    public static String format(String project, String location, String study) {
        return StudyName.newBuilder().setProject(project).setLocation(location).setStudy(study).build().toString();
    }

    public static StudyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_STUDY.validatedMatch(formattedString, "StudyName.parse: formattedString not in valid format");
        return StudyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("study"));
    }

    public static List<StudyName> parseList(List<String> formattedStrings) {
        ArrayList<StudyName> list = new ArrayList<StudyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(StudyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<StudyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (StudyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_STUDY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            StudyName studyName = this;
            synchronized (studyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.study != null) {
                        fieldMapBuilder.put((Object)"study", (Object)this.study);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_STUDY.instantiate(new String[]{"project", this.project, "location", this.location, "study", this.study});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            StudyName that = (StudyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.study, that.study);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.study);
    }

    public static class Builder {
        private String project;
        private String location;
        private String study;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getStudy() {
            return this.study;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setStudy(String study) {
            this.study = study;
            return this;
        }

        private Builder(StudyName studyName) {
            this.project = studyName.project;
            this.location = studyName.location;
            this.study = studyName.study;
        }

        public StudyName build() {
            return new StudyName(this);
        }
    }
}

