/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnnotationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASET_DATA_ITEM_ANNOTATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/datasets/{dataset}/dataItems/{data_item}/annotations/{annotation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataset;
    private final String dataItem;
    private final String annotation;

    @Deprecated
    protected AnnotationName() {
        this.project = null;
        this.location = null;
        this.dataset = null;
        this.dataItem = null;
        this.annotation = null;
    }

    private AnnotationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.dataItem = (String)Preconditions.checkNotNull((Object)builder.getDataItem());
        this.annotation = (String)Preconditions.checkNotNull((Object)builder.getAnnotation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getDataItem() {
        return this.dataItem;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnnotationName of(String project, String location, String dataset, String dataItem, String annotation) {
        return AnnotationName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setDataItem(dataItem).setAnnotation(annotation).build();
    }

    public static String format(String project, String location, String dataset, String dataItem, String annotation) {
        return AnnotationName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setDataItem(dataItem).setAnnotation(annotation).build().toString();
    }

    public static AnnotationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASET_DATA_ITEM_ANNOTATION.validatedMatch(formattedString, "AnnotationName.parse: formattedString not in valid format");
        return AnnotationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset"), (String)matchMap.get("data_item"), (String)matchMap.get("annotation"));
    }

    public static List<AnnotationName> parseList(List<String> formattedStrings) {
        ArrayList<AnnotationName> list = new ArrayList<AnnotationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnnotationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnnotationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnnotationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASET_DATA_ITEM_ANNOTATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnnotationName annotationName = this;
            synchronized (annotationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.dataItem != null) {
                        fieldMapBuilder.put((Object)"data_item", (Object)this.dataItem);
                    }
                    if (this.annotation != null) {
                        fieldMapBuilder.put((Object)"annotation", (Object)this.annotation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASET_DATA_ITEM_ANNOTATION.instantiate(new String[]{"project", this.project, "location", this.location, "dataset", this.dataset, "data_item", this.dataItem, "annotation", this.annotation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AnnotationName that = (AnnotationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.dataItem, that.dataItem) && Objects.equals(this.annotation, that.annotation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataItem);
        h *= 1000003;
        return h ^= Objects.hashCode(this.annotation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataset;
        private String dataItem;
        private String annotation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getDataItem() {
            return this.dataItem;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setDataItem(String dataItem) {
            this.dataItem = dataItem;
            return this;
        }

        public Builder setAnnotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        private Builder(AnnotationName annotationName) {
            this.project = annotationName.project;
            this.location = annotationName.location;
            this.dataset = annotationName.dataset;
            this.dataItem = annotationName.dataItem;
            this.annotation = annotationName.annotation;
        }

        public AnnotationName build() {
            return new AnnotationName(this);
        }
    }
}

