/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContextName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_METADATA_STORE_CONTEXT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String metadataStore;
    private final String context;

    @Deprecated
    protected ContextName() {
        this.project = null;
        this.location = null;
        this.metadataStore = null;
        this.context = null;
    }

    private ContextName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.metadataStore = (String)Preconditions.checkNotNull((Object)builder.getMetadataStore());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMetadataStore() {
        return this.metadataStore;
    }

    public String getContext() {
        return this.context;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContextName of(String project, String location, String metadataStore, String context) {
        return ContextName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setContext(context).build();
    }

    public static String format(String project, String location, String metadataStore, String context) {
        return ContextName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setContext(context).build().toString();
    }

    public static ContextName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_METADATA_STORE_CONTEXT.validatedMatch(formattedString, "ContextName.parse: formattedString not in valid format");
        return ContextName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("metadata_store"), (String)matchMap.get("context"));
    }

    public static List<ContextName> parseList(List<String> formattedStrings) {
        ArrayList<ContextName> list = new ArrayList<ContextName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContextName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContextName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContextName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_METADATA_STORE_CONTEXT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContextName contextName = this;
            synchronized (contextName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.metadataStore != null) {
                        fieldMapBuilder.put((Object)"metadata_store", (Object)this.metadataStore);
                    }
                    if (this.context != null) {
                        fieldMapBuilder.put((Object)"context", (Object)this.context);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_METADATA_STORE_CONTEXT.instantiate(new String[]{"project", this.project, "location", this.location, "metadata_store", this.metadataStore, "context", this.context});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ContextName that = (ContextName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.metadataStore, that.metadataStore) && Objects.equals(this.context, that.context);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.metadataStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.context);
    }

    public static class Builder {
        private String project;
        private String location;
        private String metadataStore;
        private String context;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMetadataStore() {
            return this.metadataStore;
        }

        public String getContext() {
            return this.context;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMetadataStore(String metadataStore) {
            this.metadataStore = metadataStore;
            return this;
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        private Builder(ContextName contextName) {
            this.project = contextName.project;
            this.location = contextName.location;
            this.metadataStore = contextName.metadataStore;
            this.context = contextName.context;
        }

        public ContextName build() {
            return new ContextName(this);
        }
    }
}

